/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.api;

import com.atlan.Atlan;
import com.atlan.cache.RoleCache;
import com.atlan.exception.AtlanException;
import com.atlan.model.admin.AtlanUser;
import com.atlan.model.admin.GroupResponse;
import com.atlan.model.admin.SessionResponse;
import com.atlan.model.admin.UserMinimalResponse;
import com.atlan.model.admin.UserResponse;
import com.atlan.model.core.AtlanObject;
import com.atlan.net.ApiResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public class UsersEndpoint {
    private static final String endpoint = "/api/service/users";

    public static UserResponse getUsers(String filter, String sort, boolean count, int offset, int limit) throws AtlanException {
        if (filter == null) {
            filter = "";
        }
        if (sort == null) {
            sort = "";
        }
        String url = String.format("%s%s?filter=%s&sort=%s&count=%s&offset=%s&limit=%s", Atlan.getBaseUrl(), endpoint, ApiResource.urlEncode(filter), ApiResource.urlEncode(sort), count, offset, limit);
        return ApiResource.request(ApiResource.RequestMethod.GET, url, "", UserResponse.class, null);
    }

    public static UserResponse getUsers(String filter) throws AtlanException {
        if (filter == null) {
            filter = "";
        }
        String url = String.format("%s%s?filter=%s", Atlan.getBaseUrl(), endpoint, ApiResource.urlEncode(filter));
        return ApiResource.request(ApiResource.RequestMethod.GET, url, "", UserResponse.class, null);
    }

    public static UserResponse getAllUsers() throws AtlanException {
        String url = String.format("%s%s", Atlan.getBaseUrl(), endpoint);
        return ApiResource.request(ApiResource.RequestMethod.GET, url, "", UserResponse.class, null);
    }

    public static void createUser(AtlanUser user) throws AtlanException {
        UsersEndpoint.createUsers(List.of(user));
    }

    public static void createUsers(List<AtlanUser> users) throws AtlanException {
        String url = String.format("%s%s", Atlan.getBaseUrl(), endpoint);
        CreateUserRequest.CreateUserRequestBuilder<?, ?> cur = CreateUserRequest.builder();
        for (AtlanUser user : users) {
            String roleName = user.getWorkspaceRole();
            cur.user((CreateUser)((CreateUser.CreateUserBuilder)((CreateUser.CreateUserBuilder)((CreateUser.CreateUserBuilder)CreateUser.builder().email(user.getEmail())).roleName(roleName)).roleId(RoleCache.getIdForName(roleName))).build());
        }
        ApiResource.request(ApiResource.RequestMethod.POST, url, cur.build(), null, null);
    }

    public static UserMinimalResponse updateUser(String id, AtlanUser user) throws AtlanException {
        String url = String.format("%s%s/%s", Atlan.getBaseUrl(), endpoint, id);
        return ApiResource.request(ApiResource.RequestMethod.POST, url, user, UserMinimalResponse.class, null);
    }

    public static void deleteUser(String id) throws AtlanException {
        String url = String.format("%s%s/%s/delete", Atlan.getBaseUrl(), endpoint, id);
        ApiResource.request(ApiResource.RequestMethod.POST, url, "", null, null);
    }

    public static GroupResponse getGroups(String id) throws AtlanException {
        String url = String.format("%s%s/%s/groups", Atlan.getBaseUrl(), endpoint, id);
        return ApiResource.request(ApiResource.RequestMethod.GET, url, "", GroupResponse.class, null);
    }

    public static void addToGroups(String id, List<String> groupIds) throws AtlanException {
        String url = String.format("%s%s/%s/groups", Atlan.getBaseUrl(), endpoint, id);
        AtlanObject atgr = ((AddToGroupsRequest.AddToGroupsRequestBuilder)AddToGroupsRequest.builder().groups(groupIds)).build();
        ApiResource.request(ApiResource.RequestMethod.POST, url, atgr, null, null);
    }

    public static void changeRole(String id, String roleId) throws AtlanException {
        String url = String.format("%s%s/%s/roles/update", Atlan.getBaseUrl(), endpoint, id);
        AtlanObject crr = ((ChangeRoleRequest.ChangeRoleRequestBuilder)ChangeRoleRequest.builder().roleId(roleId)).build();
        ApiResource.request(ApiResource.RequestMethod.POST, url, crr, null, null);
    }

    public static UserMinimalResponse getCurrentUser() throws AtlanException {
        String url = String.format("%s%s/current", Atlan.getBaseUrl(), endpoint);
        return ApiResource.request(ApiResource.RequestMethod.GET, url, "", UserMinimalResponse.class, null);
    }

    public static SessionResponse getSessions(String id) throws AtlanException {
        String url = String.format("%s%s/%s/sessions", Atlan.getBaseUrl(), endpoint, id);
        return ApiResource.request(ApiResource.RequestMethod.GET, url, "", SessionResponse.class, null);
    }

    static final class AddToGroupsRequest
    extends AtlanObject {
        List<String> groups;

        @Generated
        protected AddToGroupsRequest(AddToGroupsRequestBuilder<?, ?> b) {
            super(b);
            this.groups = b.groups;
        }

        @Generated
        public static AddToGroupsRequestBuilder<?, ?> builder() {
            return new AddToGroupsRequestBuilderImpl();
        }

        @Generated
        public List<String> getGroups() {
            return this.groups;
        }

        @Generated
        public void setGroups(List<String> groups) {
            this.groups = groups;
        }

        @Override
        @Generated
        public String toString() {
            return "UsersEndpoint.AddToGroupsRequest(groups=" + this.getGroups() + ")";
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AddToGroupsRequest)) {
                return false;
            }
            AddToGroupsRequest other = (AddToGroupsRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$groups = this.getGroups();
            List<String> other$groups = other.getGroups();
            return !(this$groups == null ? other$groups != null : !((Object)this$groups).equals(other$groups));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AddToGroupsRequest;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $groups = this.getGroups();
            result = result * 59 + ($groups == null ? 43 : ((Object)$groups).hashCode());
            return result;
        }

        @Generated
        private static final class AddToGroupsRequestBuilderImpl
        extends AddToGroupsRequestBuilder<AddToGroupsRequest, AddToGroupsRequestBuilderImpl> {
            @Generated
            private AddToGroupsRequestBuilderImpl() {
            }

            @Override
            @Generated
            protected AddToGroupsRequestBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public AddToGroupsRequest build() {
                return new AddToGroupsRequest(this);
            }
        }

        @Generated
        public static abstract class AddToGroupsRequestBuilder<C extends AddToGroupsRequest, B extends AddToGroupsRequestBuilder<C, B>>
        extends AtlanObject.AtlanObjectBuilder<C, B> {
            @Generated
            private List<String> groups;

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Generated
            public B groups(List<String> groups) {
                this.groups = groups;
                return (B)this.self();
            }

            @Override
            @Generated
            public String toString() {
                return "UsersEndpoint.AddToGroupsRequest.AddToGroupsRequestBuilder(super=" + super.toString() + ", groups=" + this.groups + ")";
            }
        }
    }

    private static final class CreateUser
    extends AtlanObject {
        String email;
        String roleName;
        String roleId;

        @Generated
        protected CreateUser(CreateUserBuilder<?, ?> b) {
            super(b);
            this.email = b.email;
            this.roleName = b.roleName;
            this.roleId = b.roleId;
        }

        @Generated
        public static CreateUserBuilder<?, ?> builder() {
            return new CreateUserBuilderImpl();
        }

        @Generated
        public String getEmail() {
            return this.email;
        }

        @Generated
        public String getRoleName() {
            return this.roleName;
        }

        @Generated
        public String getRoleId() {
            return this.roleId;
        }

        @Generated
        public void setEmail(String email) {
            this.email = email;
        }

        @Generated
        public void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        @Generated
        public void setRoleId(String roleId) {
            this.roleId = roleId;
        }

        @Override
        @Generated
        public String toString() {
            return "UsersEndpoint.CreateUser(email=" + this.getEmail() + ", roleName=" + this.getRoleName() + ", roleId=" + this.getRoleId() + ")";
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CreateUser)) {
                return false;
            }
            CreateUser other = (CreateUser)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$email = this.getEmail();
            String other$email = other.getEmail();
            if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                return false;
            }
            String this$roleName = this.getRoleName();
            String other$roleName = other.getRoleName();
            if (this$roleName == null ? other$roleName != null : !this$roleName.equals(other$roleName)) {
                return false;
            }
            String this$roleId = this.getRoleId();
            String other$roleId = other.getRoleId();
            return !(this$roleId == null ? other$roleId != null : !this$roleId.equals(other$roleId));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CreateUser;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $email = this.getEmail();
            result = result * 59 + ($email == null ? 43 : $email.hashCode());
            String $roleName = this.getRoleName();
            result = result * 59 + ($roleName == null ? 43 : $roleName.hashCode());
            String $roleId = this.getRoleId();
            result = result * 59 + ($roleId == null ? 43 : $roleId.hashCode());
            return result;
        }

        @Generated
        private static final class CreateUserBuilderImpl
        extends CreateUserBuilder<CreateUser, CreateUserBuilderImpl> {
            @Generated
            private CreateUserBuilderImpl() {
            }

            @Override
            @Generated
            protected CreateUserBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public CreateUser build() {
                return new CreateUser(this);
            }
        }

        @Generated
        public static abstract class CreateUserBuilder<C extends CreateUser, B extends CreateUserBuilder<C, B>>
        extends AtlanObject.AtlanObjectBuilder<C, B> {
            @Generated
            private String email;
            @Generated
            private String roleName;
            @Generated
            private String roleId;

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Generated
            public B email(String email) {
                this.email = email;
                return (B)this.self();
            }

            @Generated
            public B roleName(String roleName) {
                this.roleName = roleName;
                return (B)this.self();
            }

            @Generated
            public B roleId(String roleId) {
                this.roleId = roleId;
                return (B)this.self();
            }

            @Override
            @Generated
            public String toString() {
                return "UsersEndpoint.CreateUser.CreateUserBuilder(super=" + super.toString() + ", email=" + this.email + ", roleName=" + this.roleName + ", roleId=" + this.roleId + ")";
            }
        }
    }

    static final class ChangeRoleRequest
    extends AtlanObject {
        String roleId;

        @Generated
        protected ChangeRoleRequest(ChangeRoleRequestBuilder<?, ?> b) {
            super(b);
            this.roleId = b.roleId;
        }

        @Generated
        public static ChangeRoleRequestBuilder<?, ?> builder() {
            return new ChangeRoleRequestBuilderImpl();
        }

        @Generated
        public String getRoleId() {
            return this.roleId;
        }

        @Generated
        public void setRoleId(String roleId) {
            this.roleId = roleId;
        }

        @Override
        @Generated
        public String toString() {
            return "UsersEndpoint.ChangeRoleRequest(roleId=" + this.getRoleId() + ")";
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChangeRoleRequest)) {
                return false;
            }
            ChangeRoleRequest other = (ChangeRoleRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$roleId = this.getRoleId();
            String other$roleId = other.getRoleId();
            return !(this$roleId == null ? other$roleId != null : !this$roleId.equals(other$roleId));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ChangeRoleRequest;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $roleId = this.getRoleId();
            result = result * 59 + ($roleId == null ? 43 : $roleId.hashCode());
            return result;
        }

        @Generated
        private static final class ChangeRoleRequestBuilderImpl
        extends ChangeRoleRequestBuilder<ChangeRoleRequest, ChangeRoleRequestBuilderImpl> {
            @Generated
            private ChangeRoleRequestBuilderImpl() {
            }

            @Override
            @Generated
            protected ChangeRoleRequestBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public ChangeRoleRequest build() {
                return new ChangeRoleRequest(this);
            }
        }

        @Generated
        public static abstract class ChangeRoleRequestBuilder<C extends ChangeRoleRequest, B extends ChangeRoleRequestBuilder<C, B>>
        extends AtlanObject.AtlanObjectBuilder<C, B> {
            @Generated
            private String roleId;

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Generated
            public B roleId(String roleId) {
                this.roleId = roleId;
                return (B)this.self();
            }

            @Override
            @Generated
            public String toString() {
                return "UsersEndpoint.ChangeRoleRequest.ChangeRoleRequestBuilder(super=" + super.toString() + ", roleId=" + this.roleId + ")";
            }
        }
    }

    static final class CreateUserRequest
    extends AtlanObject {
        List<CreateUser> users;

        @Generated
        protected CreateUserRequest(CreateUserRequestBuilder<?, ?> b) {
            super(b);
            List<Object> users;
            switch (b.users == null ? 0 : b.users.size()) {
                case 0: {
                    users = Collections.emptyList();
                    break;
                }
                case 1: {
                    users = Collections.singletonList(b.users.get(0));
                    break;
                }
                default: {
                    users = Collections.unmodifiableList(new ArrayList<CreateUser>(b.users));
                }
            }
            this.users = users;
        }

        @Generated
        public static CreateUserRequestBuilder<?, ?> builder() {
            return new CreateUserRequestBuilderImpl();
        }

        @Generated
        public List<CreateUser> getUsers() {
            return this.users;
        }

        @Generated
        public void setUsers(List<CreateUser> users) {
            this.users = users;
        }

        @Override
        @Generated
        public String toString() {
            return "UsersEndpoint.CreateUserRequest(users=" + this.getUsers() + ")";
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CreateUserRequest)) {
                return false;
            }
            CreateUserRequest other = (CreateUserRequest)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<CreateUser> this$users = this.getUsers();
            List<CreateUser> other$users = other.getUsers();
            return !(this$users == null ? other$users != null : !((Object)this$users).equals(other$users));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CreateUserRequest;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<CreateUser> $users = this.getUsers();
            result = result * 59 + ($users == null ? 43 : ((Object)$users).hashCode());
            return result;
        }

        @Generated
        private static final class CreateUserRequestBuilderImpl
        extends CreateUserRequestBuilder<CreateUserRequest, CreateUserRequestBuilderImpl> {
            @Generated
            private CreateUserRequestBuilderImpl() {
            }

            @Override
            @Generated
            protected CreateUserRequestBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public CreateUserRequest build() {
                return new CreateUserRequest(this);
            }
        }

        @Generated
        public static abstract class CreateUserRequestBuilder<C extends CreateUserRequest, B extends CreateUserRequestBuilder<C, B>>
        extends AtlanObject.AtlanObjectBuilder<C, B> {
            @Generated
            private ArrayList<CreateUser> users;

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Generated
            public B user(CreateUser user) {
                if (this.users == null) {
                    this.users = new ArrayList();
                }
                this.users.add(user);
                return (B)this.self();
            }

            @Generated
            public B users(Collection<? extends CreateUser> users) {
                if (users == null) {
                    throw new NullPointerException("users cannot be null");
                }
                if (this.users == null) {
                    this.users = new ArrayList();
                }
                this.users.addAll(users);
                return (B)this.self();
            }

            @Generated
            public B clearUsers() {
                if (this.users != null) {
                    this.users.clear();
                }
                return (B)this.self();
            }

            @Override
            @Generated
            public String toString() {
                return "UsersEndpoint.CreateUserRequest.CreateUserRequestBuilder(super=" + super.toString() + ", users=" + this.users + ")";
            }
        }
    }
}

