/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.api;

import com.atlan.Atlan;
import com.atlan.exception.AtlanException;
import com.atlan.model.workflow.Workflow;
import com.atlan.model.workflow.WorkflowResponse;
import com.atlan.model.workflow.WorkflowSearchRequest;
import com.atlan.model.workflow.WorkflowSearchResponse;
import com.atlan.net.ApiResource;

public class WorkflowsEndpoint {
    private static final String workflows_endpoint = "/api/service/workflows";
    private static final String workflows_search_endpoint = "/api/service/workflows/indexsearch";
    private static final String runs_endpoint = "/api/service/runs";
    private static final String runs_search_endpoint = "/api/service/runs/indexsearch";

    public static WorkflowResponse run(Workflow workflow) throws AtlanException {
        String url = String.format("%s%s", Atlan.getBaseUrl(), String.format("%s?submit=true", workflows_endpoint));
        return ApiResource.request(ApiResource.RequestMethod.POST, url, workflow, WorkflowResponse.class, null);
    }

    public static void archive(String workflowName) throws AtlanException {
        String url = String.format("%s%s", Atlan.getBaseUrl(), String.format("%s/%s/archive", workflows_endpoint, workflowName));
        ApiResource.request(ApiResource.RequestMethod.POST, url, "", null, null);
    }

    public static WorkflowSearchResponse searchRuns(WorkflowSearchRequest request) throws AtlanException {
        String url = String.format("%s%s", Atlan.getBaseUrl(), runs_search_endpoint);
        return ApiResource.request(ApiResource.RequestMethod.POST, url, request, WorkflowSearchResponse.class, null);
    }

    public static WorkflowSearchResponse search(WorkflowSearchRequest request) throws AtlanException {
        String url = String.format("%s%s", Atlan.getBaseUrl(), workflows_search_endpoint);
        return ApiResource.request(ApiResource.RequestMethod.POST, url, request, WorkflowSearchResponse.class, null);
    }
}

