/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.cache;

import com.atlan.api.TypeDefsEndpoint;
import com.atlan.exception.AtlanException;
import com.atlan.model.enums.AtlanTypeCategory;
import com.atlan.model.typedefs.ClassificationDef;
import com.atlan.model.typedefs.TypeDefResponse;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassificationCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClassificationCache.class);
    private static Map<String, ClassificationDef> cacheById = new ConcurrentHashMap<String, ClassificationDef>();
    private static Map<String, String> mapIdToName = new ConcurrentHashMap<String, String>();
    private static Map<String, String> mapNameToId = new ConcurrentHashMap<String, String>();
    private static Set<String> deletedIds = ConcurrentHashMap.newKeySet();
    private static Set<String> deletedNames = ConcurrentHashMap.newKeySet();

    private static synchronized void refreshCache() throws AtlanException {
        log.debug("Refreshing cache of classifications...");
        TypeDefResponse response = TypeDefsEndpoint.getTypeDefs(AtlanTypeCategory.CLASSIFICATION);
        List<Object> classifications = response != null ? response.getClassificationDefs() : Collections.emptyList();
        cacheById = new ConcurrentHashMap<String, ClassificationDef>();
        mapIdToName = new ConcurrentHashMap<String, String>();
        mapNameToId = new ConcurrentHashMap<String, String>();
        for (ClassificationDef classificationDef : classifications) {
            String typeId = classificationDef.getName();
            cacheById.put(typeId, classificationDef);
            mapIdToName.put(typeId, classificationDef.getDisplayName());
            mapNameToId.put(classificationDef.getDisplayName(), typeId);
        }
    }

    public static String getIdForName(String name) throws AtlanException {
        String cmId = null;
        if (name != null && (cmId = mapNameToId.get(name)) == null && !deletedNames.contains(name)) {
            ClassificationCache.refreshCache();
            cmId = mapNameToId.get(name);
            if (cmId == null) {
                deletedNames.add(name);
            }
        }
        return cmId;
    }

    public static String getNameForId(String id) throws AtlanException {
        String cmName = null;
        if (id != null && (cmName = mapIdToName.get(id)) == null && !deletedIds.contains(id)) {
            ClassificationCache.refreshCache();
            cmName = mapIdToName.get(id);
            if (cmName == null) {
                deletedIds.add(id);
            }
        }
        return cmName;
    }
}

