/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.cache;

import com.atlan.api.TypeDefsEndpoint;
import com.atlan.exception.AtlanException;
import com.atlan.exception.LogicException;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.core.CustomMetadataAttributes;
import com.atlan.model.enums.AtlanTypeCategory;
import com.atlan.model.typedefs.AttributeDef;
import com.atlan.model.typedefs.CustomMetadataDef;
import com.atlan.model.typedefs.TypeDefResponse;
import com.atlan.serde.Removable;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomMetadataCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomMetadataCache.class);
    private static Map<String, CustomMetadataDef> cacheById = new ConcurrentHashMap<String, CustomMetadataDef>();
    private static Map<String, String> mapIdToName = new ConcurrentHashMap<String, String>();
    private static Map<String, String> mapNameToId = new ConcurrentHashMap<String, String>();
    private static Map<String, Map<String, String>> mapAttrIdToName = new ConcurrentHashMap<String, Map<String, String>>();
    private static Map<String, Map<String, String>> mapAttrNameToId = new ConcurrentHashMap<String, Map<String, String>>();
    private static Map<String, String> archivedAttrIds = new ConcurrentHashMap<String, String>();

    public static synchronized void refreshCache() throws AtlanException {
        log.debug("Refreshing cache of custom metadata...");
        TypeDefResponse response = TypeDefsEndpoint.getTypeDefs(AtlanTypeCategory.CUSTOM_METADATA);
        List<Object> customMetadata = response != null ? response.getCustomMetadataDefs() : Collections.emptyList();
        cacheById = new ConcurrentHashMap<String, CustomMetadataDef>();
        mapIdToName = new ConcurrentHashMap<String, String>();
        mapNameToId = new ConcurrentHashMap<String, String>();
        mapAttrIdToName = new ConcurrentHashMap<String, Map<String, String>>();
        mapAttrNameToId = new ConcurrentHashMap<String, Map<String, String>>();
        archivedAttrIds = new ConcurrentHashMap<String, String>();
        for (CustomMetadataDef customMetadataDef : customMetadata) {
            String typeId = customMetadataDef.getName();
            cacheById.put(typeId, customMetadataDef);
            mapIdToName.put(typeId, customMetadataDef.getDisplayName());
            mapNameToId.put(customMetadataDef.getDisplayName(), typeId);
            mapAttrIdToName.put(typeId, new ConcurrentHashMap());
            mapAttrNameToId.put(typeId, new ConcurrentHashMap());
            for (AttributeDef attributeDef : customMetadataDef.getAttributeDefs()) {
                String attrId = attributeDef.getName();
                String attrName = attributeDef.getDisplayName();
                mapAttrIdToName.get(typeId).put(attrId, attrName);
                if (attributeDef.getOptions().getIsArchived().booleanValue()) {
                    archivedAttrIds.put(attrId, attrName);
                    continue;
                }
                String existingId = mapAttrNameToId.get(typeId).put(attributeDef.getDisplayName(), attributeDef.getName());
                if (existingId == null) continue;
                throw new LogicException("Multiple custom attributes with exactly the same name (" + attributeDef.getDisplayName() + ") found for: " + customMetadataDef.getDisplayName(), "ATLAN-JAVA-CLIENT-500-100", 500);
            }
        }
    }

    public static String getIdForName(String name) throws AtlanException {
        String cmId = mapNameToId.get(name);
        if (cmId != null) {
            return cmId;
        }
        CustomMetadataCache.refreshCache();
        return mapNameToId.get(name);
    }

    public static String getNameForId(String id) throws AtlanException {
        String cmName = mapIdToName.get(id);
        if (cmName != null) {
            return cmName;
        }
        CustomMetadataCache.refreshCache();
        return mapIdToName.get(id);
    }

    public static Map<String, List<AttributeDef>> getAllCustomAttributes() throws AtlanException {
        return CustomMetadataCache.getAllCustomAttributes(false);
    }

    public static Map<String, List<AttributeDef>> getAllCustomAttributes(boolean includeDeleted) throws AtlanException {
        return CustomMetadataCache.getAllCustomAttributes(includeDeleted, false);
    }

    public static Map<String, List<AttributeDef>> getAllCustomAttributes(boolean includeDeleted, boolean forceRefresh) throws AtlanException {
        if (cacheById.isEmpty() || forceRefresh) {
            CustomMetadataCache.refreshCache();
        }
        HashMap<String, List<AttributeDef>> map = new HashMap<String, List<AttributeDef>>();
        for (Map.Entry<String, CustomMetadataDef> entry : cacheById.entrySet()) {
            List<AttributeDef> toInclude;
            String typeId = entry.getKey();
            String typeName = CustomMetadataCache.getNameForId(typeId);
            CustomMetadataDef typeDef = entry.getValue();
            List<AttributeDef> attributeDefs = typeDef.getAttributeDefs();
            if (includeDeleted) {
                toInclude = attributeDefs;
            } else {
                toInclude = new ArrayList<AttributeDef>();
                for (AttributeDef attributeDef : attributeDefs) {
                    if (attributeDef.getOptions().getIsArchived().booleanValue()) continue;
                    toInclude.add(attributeDef);
                }
            }
            map.put(typeName, toInclude);
        }
        return Collections.unmodifiableMap(map);
    }

    public static String getAttrIdForName(String setName, String attributeName) throws AtlanException {
        String attrId = null;
        String setId = CustomMetadataCache.getIdForName(setName);
        Map<String, String> subMap = mapAttrNameToId.get(setId);
        if (subMap != null) {
            attrId = subMap.get(attributeName);
        }
        if (attrId != null) {
            return attrId;
        }
        CustomMetadataCache.refreshCache();
        subMap = mapAttrNameToId.get(setId);
        if (subMap != null) {
            return subMap.get(attributeName);
        }
        return null;
    }

    public static Set<String> getAttributesForSearchResults(String setName) throws AtlanException {
        String setId = CustomMetadataCache.getIdForName(setName);
        Set<String> dotNames = CustomMetadataCache._getAttributesForSearchResults(setId);
        if (dotNames != null) {
            return dotNames;
        }
        CustomMetadataCache.refreshCache();
        return CustomMetadataCache._getAttributesForSearchResults(setId);
    }

    private static Set<String> _getAttributesForSearchResults(String setId) {
        Map<String, String> subMap = mapAttrNameToId.get(setId);
        if (subMap != null) {
            Collection<String> attrIds = subMap.values();
            HashSet<String> dotNames = new HashSet<String>();
            for (String attrId : attrIds) {
                dotNames.add(setId + "." + attrId);
            }
            return dotNames;
        }
        return null;
    }

    public static CustomMetadataDef getCustomMetadataDef(String setName) throws AtlanException {
        String setId = CustomMetadataCache.getIdForName(setName);
        return cacheById.get(setId);
    }

    private static String getAttrIdForNameFromSetId(String setId, String attributeName) throws AtlanException {
        String attrId = null;
        Map<String, String> subMap = mapAttrNameToId.get(setId);
        if (subMap != null) {
            attrId = subMap.get(attributeName);
        }
        if (attrId != null) {
            return attrId;
        }
        CustomMetadataCache.refreshCache();
        subMap = mapAttrNameToId.get(setId);
        if (subMap != null) {
            return subMap.get(attributeName);
        }
        return null;
    }

    private static String getAttrNameForIdFromSetId(String setId, String attributeId) throws AtlanException {
        String attrName = null;
        Map<String, String> subMap = mapAttrIdToName.get(setId);
        if (subMap != null) {
            attrName = subMap.get(attributeId);
        }
        if (attrName != null) {
            return attrName;
        }
        CustomMetadataCache.refreshCache();
        subMap = mapAttrIdToName.get(setId);
        if (subMap != null) {
            return subMap.get(attributeId);
        }
        return null;
    }

    public static Map<String, Object> getEmptyAttributes(String customMetadataName) throws AtlanException {
        String cmId = CustomMetadataCache.getIdForName(customMetadataName);
        Map<String, String> attributes = mapAttrNameToId.get(cmId);
        LinkedHashMap<String, Object> empty = new LinkedHashMap<String, Object>();
        for (String attrName : attributes.keySet()) {
            empty.put(attrName, Removable.NULL);
        }
        return empty;
    }

    public static void getBusinessAttributesFromCustomMetadata(Map<String, CustomMetadataAttributes> customMetadata, Map<String, Map<String, Object>> businessAttributes) throws AtlanException {
        if (customMetadata != null) {
            for (Map.Entry<String, CustomMetadataAttributes> entry : customMetadata.entrySet()) {
                String cmName = entry.getKey();
                String cmId = CustomMetadataCache.getIdForName(cmName);
                CustomMetadataAttributes attrs = entry.getValue();
                Map bmAttrs = businessAttributes.getOrDefault(cmId, new LinkedHashMap());
                CustomMetadataCache.getAttributesFromCustomMetadata(cmId, cmName, attrs, bmAttrs);
                businessAttributes.put(cmId, bmAttrs);
            }
        }
    }

    public static void getAttributesFromCustomMetadata(String cmId, String cmName, CustomMetadataAttributes cma, Map<String, Object> attributes) throws AtlanException {
        if (cma.getArchivedAttributes() != null) {
            for (Map.Entry<String, Object> archived : cma.getArchivedAttributes().entrySet()) {
                String archivedAttrName = archived.getKey();
                String archivedAttrId = CustomMetadataCache.getAttrIdForNameFromSetId(cmId, archivedAttrName);
                attributes.put(archivedAttrId, archived.getValue());
            }
        }
        CustomMetadataCache.getIdMapFromNameMap(cmName, cma.getAttributes(), attributes);
    }

    public static void getIdMapFromNameMap(String customMetadataName, Map<String, Object> nameToValue, Map<String, Object> idToValue) throws AtlanException {
        String cmId = CustomMetadataCache.getIdForName(customMetadataName);
        for (Map.Entry<String, Object> entry : nameToValue.entrySet()) {
            String attrName = entry.getKey();
            String cmAttrId = CustomMetadataCache.getAttrIdForNameFromSetId(cmId, attrName);
            idToValue.put(cmAttrId, entry.getValue());
        }
    }

    public static Map<String, CustomMetadataAttributes> getCustomMetadataFromBusinessAttributes(JsonNode businessAttributes) throws AtlanException {
        LinkedHashMap<String, CustomMetadataAttributes> map = new LinkedHashMap<String, CustomMetadataAttributes>();
        Iterator itrCM = businessAttributes.fieldNames();
        while (itrCM.hasNext()) {
            String cmId = (String)itrCM.next();
            String cmName = CustomMetadataCache.getNameForId(cmId);
            JsonNode bmAttrs = businessAttributes.get(cmId);
            CustomMetadataAttributes cma = CustomMetadataCache.getCustomMetadataAttributes(cmId, bmAttrs);
            if (cma.isEmpty()) continue;
            map.put(cmName, cma);
        }
        return map;
    }

    public static CustomMetadataAttributes getCustomMetadataAttributes(String cmId, JsonNode attributes) throws AtlanException {
        CustomMetadataAttributes.CustomMetadataAttributesBuilder<?, ?> builder = CustomMetadataAttributes.builder();
        Iterator itrCMA = attributes.fieldNames();
        while (itrCMA.hasNext()) {
            String attrId = (String)itrCMA.next();
            String cmAttrName = CustomMetadataCache.getAttrNameForIdFromSetId(cmId, attrId);
            JsonNode jsonValue = attributes.get(attrId);
            if (jsonValue.isArray()) {
                HashSet<Object> values = new HashSet<Object>();
                ArrayNode array = (ArrayNode)jsonValue;
                for (JsonNode element : array) {
                    Object primitive = CustomMetadataCache.deserializePrimitive(element);
                    values.add(primitive);
                }
                if (values.isEmpty()) continue;
                if (archivedAttrIds.containsKey(attrId)) {
                    builder.archivedAttribute(cmAttrName, values);
                    continue;
                }
                builder.attribute(cmAttrName, values);
                continue;
            }
            if (jsonValue.isValueNode()) {
                Object primitive = CustomMetadataCache.deserializePrimitive(jsonValue);
                if (archivedAttrIds.containsKey(attrId)) {
                    builder.archivedAttribute(cmAttrName, primitive);
                    continue;
                }
                builder.attribute(cmAttrName, primitive);
                continue;
            }
            throw new LogicException("Unable to deserialize non-primitive custom metadata value: " + jsonValue, "ATLAN-CLIENT-CM-500-002", 500);
        }
        return builder.build();
    }

    public static Map<String, CustomMetadataAttributes> getCustomMetadataFromSearchResult(Map<String, JsonNode> embeddedAttributes) throws AtlanException {
        LinkedHashMap<String, CustomMetadataAttributes> map = new LinkedHashMap<String, CustomMetadataAttributes>();
        LinkedHashMap builderMap = new LinkedHashMap();
        for (Map.Entry<String, JsonNode> entry : embeddedAttributes.entrySet()) {
            String compositeId = entry.getKey();
            int indexOfDot = compositeId.indexOf(".");
            if (indexOfDot <= 0) continue;
            String cmId = compositeId.substring(0, indexOfDot);
            String cmName = CustomMetadataCache.getNameForId(cmId);
            if (!builderMap.containsKey(cmName)) {
                builderMap.put(cmName, CustomMetadataAttributes.builder());
            }
            String attrId = compositeId.substring(indexOfDot + 1);
            String cmAttrName = CustomMetadataCache.getAttrNameForIdFromSetId(cmId, attrId);
            JsonNode jsonValue = entry.getValue();
            if (jsonValue.isArray()) {
                HashSet<Object> values = new HashSet<Object>();
                ArrayNode array = (ArrayNode)jsonValue;
                for (JsonNode element : array) {
                    Object primitive = CustomMetadataCache.deserializePrimitive(element);
                    values.add(primitive);
                }
                if (values.isEmpty()) continue;
                if (archivedAttrIds.containsKey(attrId)) {
                    ((CustomMetadataAttributes.CustomMetadataAttributesBuilder)builderMap.get(cmName)).archivedAttribute(cmAttrName, values);
                    continue;
                }
                ((CustomMetadataAttributes.CustomMetadataAttributesBuilder)builderMap.get(cmName)).attribute(cmAttrName, values);
                continue;
            }
            if (jsonValue.isValueNode()) {
                Object primitive = CustomMetadataCache.deserializePrimitive(jsonValue);
                if (archivedAttrIds.containsKey(attrId)) {
                    ((CustomMetadataAttributes.CustomMetadataAttributesBuilder)builderMap.get(cmName)).archivedAttribute(cmAttrName, primitive);
                    continue;
                }
                ((CustomMetadataAttributes.CustomMetadataAttributesBuilder)builderMap.get(cmName)).attribute(cmAttrName, primitive);
                continue;
            }
            throw new LogicException("Unable to deserialize non-primitive custom metadata value: " + jsonValue, "ATLAN-CLIENT-CM-500-003", 500);
        }
        for (Map.Entry<String, Object> entry : builderMap.entrySet()) {
            String cmName = entry.getKey();
            AtlanObject cma = ((CustomMetadataAttributes.CustomMetadataAttributesBuilder)entry.getValue()).build();
            if (((CustomMetadataAttributes)cma).isEmpty()) continue;
            map.put(cmName, (CustomMetadataAttributes)cma);
        }
        return map;
    }

    private static Object deserializePrimitive(JsonNode jsonValue) throws LogicException {
        if (jsonValue.isValueNode()) {
            if (jsonValue.isTextual()) {
                return jsonValue.asText();
            }
            if (jsonValue.isBoolean()) {
                return jsonValue.asBoolean();
            }
            if (jsonValue.isIntegralNumber()) {
                return jsonValue.asLong();
            }
            if (jsonValue.isFloatingPointNumber()) {
                return jsonValue.asDouble();
            }
            if (jsonValue.isNull()) {
                return null;
            }
            throw new LogicException("Unable to deserialize unrecognized primitive custom metadata value: " + jsonValue, "ATLAN-CLIENT-CM-500-001", 500);
        }
        throw new LogicException("Unable to deserialize non-primitive custom metadata value:" + jsonValue, "ATLAN-CLIENT-CM-500-002", 500);
    }
}

