/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.cache;

import com.atlan.api.RolesEndpoint;
import com.atlan.exception.AtlanException;
import com.atlan.model.admin.AtlanRole;
import com.atlan.model.admin.RoleResponse;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RoleCache.class);
    private static Map<String, AtlanRole> cacheById = new ConcurrentHashMap<String, AtlanRole>();
    private static Map<String, String> mapIdToName = new ConcurrentHashMap<String, String>();
    private static Map<String, String> mapNameToId = new ConcurrentHashMap<String, String>();

    private static synchronized void refreshCache() throws AtlanException {
        log.debug("Refreshing cache of roles...");
        RoleResponse response = RolesEndpoint.getAllRoles();
        List<Object> roles = response != null ? response.getRecords() : Collections.emptyList();
        cacheById = new ConcurrentHashMap<String, AtlanRole>();
        mapIdToName = new ConcurrentHashMap<String, String>();
        mapNameToId = new ConcurrentHashMap<String, String>();
        for (AtlanRole atlanRole : roles) {
            String roleId = atlanRole.getId();
            String roleName = atlanRole.getName();
            cacheById.put(roleId, atlanRole);
            mapIdToName.put(roleId, roleName);
            mapNameToId.put(roleName, roleId);
        }
    }

    public static String getIdForName(String name) throws AtlanException {
        String roleId = mapNameToId.get(name);
        if (roleId != null) {
            return roleId;
        }
        RoleCache.refreshCache();
        return mapNameToId.get(name);
    }

    public static String getNameForId(String id) throws AtlanException {
        String roleName = mapIdToName.get(id);
        if (roleName != null) {
            return roleName;
        }
        RoleCache.refreshCache();
        return mapIdToName.get(id);
    }
}

