/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.admin;

import com.atlan.api.GroupsEndpoint;
import com.atlan.exception.AtlanException;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.admin.GroupResponse;
import com.atlan.model.core.AtlanObject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import lombok.Generated;

@JsonDeserialize(builder=AtlanGroupBuilderImpl.class)
public class AtlanGroup
extends AtlanObject {
    private static final long serialVersionUID = 2L;
    String alias;
    GroupAttributes attributes;
    @JsonIgnore
    String decentralizedRoles;
    String id;
    String name;
    String path;
    @JsonIgnore
    SortedSet<String> personas;
    @JsonIgnore
    SortedSet<String> purposes;
    Long userCount;

    public static AtlanGroupBuilder<?, ?> creator(String alias) {
        return ((AtlanGroupBuilder)AtlanGroup.builder().name(AtlanGroup.generateName(alias))).attributes((GroupAttributes)((GroupAttributes.GroupAttributesBuilder)GroupAttributes.builder().alias(List.of(alias))).build());
    }

    public static AtlanGroupBuilder<?, ?> updater(String id, String path) {
        return ((AtlanGroupBuilder)AtlanGroup.builder().id(id)).path(path);
    }

    public static String generateName(String alias) {
        String internal = alias.toLowerCase();
        return internal.replace(" ", "_");
    }

    public String create() throws AtlanException {
        return GroupsEndpoint.createGroup(this);
    }

    public void update() throws AtlanException {
        if (this.id == null || this.id.length() == 0) {
            throw new InvalidRequestException("An id must be provided to update the group.", "id", "ATLAN_JAVA_CLIENT-400-401", 400, null);
        }
        GroupsEndpoint.updateGroup(this.id, this);
    }

    public static void delete(String id) throws AtlanException {
        GroupsEndpoint.deleteGroup(id);
    }

    public static List<AtlanGroup> retrieveAll() throws AtlanException {
        GroupResponse response = GroupsEndpoint.getAllGroups();
        if (response != null && response.getRecords() != null) {
            return response.getRecords();
        }
        return Collections.emptyList();
    }

    public static List<AtlanGroup> retrieveByName(String alias) throws AtlanException {
        GroupResponse response = GroupsEndpoint.getGroups("{\"$and\":[{\"alias\":{\"$ilike\":\"%" + alias + "%\"}}]}");
        if (response != null && response.getRecords() != null) {
            return response.getRecords();
        }
        return null;
    }

    @Generated
    protected AtlanGroup(AtlanGroupBuilder<?, ?> b) {
        super(b);
        this.alias = b.alias;
        this.attributes = b.attributes;
        this.decentralizedRoles = b.decentralizedRoles;
        this.id = b.id;
        this.name = b.name;
        this.path = b.path;
        this.personas = b.personas;
        this.purposes = b.purposes;
        this.userCount = b.userCount;
    }

    @Generated
    public static AtlanGroupBuilder<?, ?> builder() {
        return new AtlanGroupBuilderImpl();
    }

    @Generated
    public AtlanGroupBuilder<?, ?> toBuilder() {
        return new AtlanGroupBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getAlias() {
        return this.alias;
    }

    @Generated
    public GroupAttributes getAttributes() {
        return this.attributes;
    }

    @Generated
    public String getDecentralizedRoles() {
        return this.decentralizedRoles;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public SortedSet<String> getPersonas() {
        return this.personas;
    }

    @Generated
    public SortedSet<String> getPurposes() {
        return this.purposes;
    }

    @Generated
    public Long getUserCount() {
        return this.userCount;
    }

    @Generated
    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Generated
    public void setAttributes(GroupAttributes attributes) {
        this.attributes = attributes;
    }

    @JsonIgnore
    @Generated
    public void setDecentralizedRoles(String decentralizedRoles) {
        this.decentralizedRoles = decentralizedRoles;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setPath(String path) {
        this.path = path;
    }

    @JsonIgnore
    @Generated
    public void setPersonas(SortedSet<String> personas) {
        this.personas = personas;
    }

    @JsonIgnore
    @Generated
    public void setPurposes(SortedSet<String> purposes) {
        this.purposes = purposes;
    }

    @Generated
    public void setUserCount(Long userCount) {
        this.userCount = userCount;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AtlanGroup)) {
            return false;
        }
        AtlanGroup other = (AtlanGroup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$userCount = this.getUserCount();
        Long other$userCount = other.getUserCount();
        if (this$userCount == null ? other$userCount != null : !((Object)this$userCount).equals(other$userCount)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        GroupAttributes this$attributes = this.getAttributes();
        GroupAttributes other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        String this$decentralizedRoles = this.getDecentralizedRoles();
        String other$decentralizedRoles = other.getDecentralizedRoles();
        if (this$decentralizedRoles == null ? other$decentralizedRoles != null : !this$decentralizedRoles.equals(other$decentralizedRoles)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        SortedSet<String> this$personas = this.getPersonas();
        SortedSet<String> other$personas = other.getPersonas();
        if (this$personas == null ? other$personas != null : !this$personas.equals(other$personas)) {
            return false;
        }
        SortedSet<String> this$purposes = this.getPurposes();
        SortedSet<String> other$purposes = other.getPurposes();
        return !(this$purposes == null ? other$purposes != null : !this$purposes.equals(other$purposes));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AtlanGroup;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $userCount = this.getUserCount();
        result = result * 59 + ($userCount == null ? 43 : ((Object)$userCount).hashCode());
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        GroupAttributes $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        String $decentralizedRoles = this.getDecentralizedRoles();
        result = result * 59 + ($decentralizedRoles == null ? 43 : $decentralizedRoles.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        SortedSet<String> $personas = this.getPersonas();
        result = result * 59 + ($personas == null ? 43 : $personas.hashCode());
        SortedSet<String> $purposes = this.getPurposes();
        result = result * 59 + ($purposes == null ? 43 : $purposes.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class AtlanGroupBuilderImpl
    extends AtlanGroupBuilder<AtlanGroup, AtlanGroupBuilderImpl> {
        @Generated
        private AtlanGroupBuilderImpl() {
        }

        @Override
        @Generated
        protected AtlanGroupBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public AtlanGroup build() {
            return new AtlanGroup(this);
        }
    }

    @Generated
    public static abstract class AtlanGroupBuilder<C extends AtlanGroup, B extends AtlanGroupBuilder<C, B>>
    extends AtlanObject.AtlanObjectBuilder<C, B> {
        @Generated
        private String alias;
        @Generated
        private GroupAttributes attributes;
        @Generated
        private String decentralizedRoles;
        @Generated
        private String id;
        @Generated
        private String name;
        @Generated
        private String path;
        @Generated
        private SortedSet<String> personas;
        @Generated
        private SortedSet<String> purposes;
        @Generated
        private Long userCount;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AtlanGroupBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(AtlanGroup instance, AtlanGroupBuilder<?, ?> b) {
            b.alias(instance.alias);
            b.attributes(instance.attributes);
            b.decentralizedRoles(instance.decentralizedRoles);
            b.id(instance.id);
            b.name(instance.name);
            b.path(instance.path);
            b.personas(instance.personas);
            b.purposes(instance.purposes);
            b.userCount(instance.userCount);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B alias(String alias) {
            this.alias = alias;
            return (B)this.self();
        }

        @Generated
        public B attributes(GroupAttributes attributes) {
            this.attributes = attributes;
            return (B)this.self();
        }

        @JsonIgnore
        @Generated
        public B decentralizedRoles(String decentralizedRoles) {
            this.decentralizedRoles = decentralizedRoles;
            return (B)this.self();
        }

        @Generated
        public B id(String id) {
            this.id = id;
            return (B)this.self();
        }

        @Generated
        public B name(String name) {
            this.name = name;
            return (B)this.self();
        }

        @Generated
        public B path(String path) {
            this.path = path;
            return (B)this.self();
        }

        @JsonIgnore
        @Generated
        public B personas(SortedSet<String> personas) {
            this.personas = personas;
            return (B)this.self();
        }

        @JsonIgnore
        @Generated
        public B purposes(SortedSet<String> purposes) {
            this.purposes = purposes;
            return (B)this.self();
        }

        @Generated
        public B userCount(Long userCount) {
            this.userCount = userCount;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "AtlanGroup.AtlanGroupBuilder(super=" + super.toString() + ", alias=" + this.alias + ", attributes=" + this.attributes + ", decentralizedRoles=" + this.decentralizedRoles + ", id=" + this.id + ", name=" + this.name + ", path=" + this.path + ", personas=" + this.personas + ", purposes=" + this.purposes + ", userCount=" + this.userCount + ")";
        }
    }

    @JsonDeserialize(builder=GroupAttributesBuilderImpl.class)
    public static final class GroupAttributes
    extends AtlanObject {
        private static final long serialVersionUID = 2L;
        List<String> alias;
        List<String> createdAt;
        List<String> createdBy;
        List<String> updatedAt;
        List<String> updatedBy;
        List<String> description;
        List<String> isDefault;
        List<String> channels;

        @Generated
        private static List<String> $default$isDefault() {
            return List.of("false");
        }

        @Generated
        protected GroupAttributes(GroupAttributesBuilder<?, ?> b) {
            super(b);
            this.alias = b.alias;
            this.createdAt = b.createdAt;
            this.createdBy = b.createdBy;
            this.updatedAt = b.updatedAt;
            this.updatedBy = b.updatedBy;
            this.description = b.description;
            this.isDefault = b.isDefault$set ? b.isDefault$value : GroupAttributes.$default$isDefault();
            this.channels = b.channels;
        }

        @Generated
        public static GroupAttributesBuilder<?, ?> builder() {
            return new GroupAttributesBuilderImpl();
        }

        @Generated
        public GroupAttributesBuilder<?, ?> toBuilder() {
            return new GroupAttributesBuilderImpl().$fillValuesFrom(this);
        }

        @Generated
        public List<String> getAlias() {
            return this.alias;
        }

        @Generated
        public List<String> getCreatedAt() {
            return this.createdAt;
        }

        @Generated
        public List<String> getCreatedBy() {
            return this.createdBy;
        }

        @Generated
        public List<String> getUpdatedAt() {
            return this.updatedAt;
        }

        @Generated
        public List<String> getUpdatedBy() {
            return this.updatedBy;
        }

        @Generated
        public List<String> getDescription() {
            return this.description;
        }

        @Generated
        public List<String> getIsDefault() {
            return this.isDefault;
        }

        @Generated
        public List<String> getChannels() {
            return this.channels;
        }

        @Generated
        public void setAlias(List<String> alias) {
            this.alias = alias;
        }

        @Generated
        public void setCreatedAt(List<String> createdAt) {
            this.createdAt = createdAt;
        }

        @Generated
        public void setCreatedBy(List<String> createdBy) {
            this.createdBy = createdBy;
        }

        @Generated
        public void setUpdatedAt(List<String> updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Generated
        public void setUpdatedBy(List<String> updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Generated
        public void setDescription(List<String> description) {
            this.description = description;
        }

        @Generated
        public void setIsDefault(List<String> isDefault) {
            this.isDefault = isDefault;
        }

        @Generated
        public void setChannels(List<String> channels) {
            this.channels = channels;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GroupAttributes)) {
                return false;
            }
            GroupAttributes other = (GroupAttributes)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            List<String> this$alias = this.getAlias();
            List<String> other$alias = other.getAlias();
            if (this$alias == null ? other$alias != null : !((Object)this$alias).equals(other$alias)) {
                return false;
            }
            List<String> this$createdAt = this.getCreatedAt();
            List<String> other$createdAt = other.getCreatedAt();
            if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
                return false;
            }
            List<String> this$createdBy = this.getCreatedBy();
            List<String> other$createdBy = other.getCreatedBy();
            if (this$createdBy == null ? other$createdBy != null : !((Object)this$createdBy).equals(other$createdBy)) {
                return false;
            }
            List<String> this$updatedAt = this.getUpdatedAt();
            List<String> other$updatedAt = other.getUpdatedAt();
            if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
                return false;
            }
            List<String> this$updatedBy = this.getUpdatedBy();
            List<String> other$updatedBy = other.getUpdatedBy();
            if (this$updatedBy == null ? other$updatedBy != null : !((Object)this$updatedBy).equals(other$updatedBy)) {
                return false;
            }
            List<String> this$description = this.getDescription();
            List<String> other$description = other.getDescription();
            if (this$description == null ? other$description != null : !((Object)this$description).equals(other$description)) {
                return false;
            }
            List<String> this$isDefault = this.getIsDefault();
            List<String> other$isDefault = other.getIsDefault();
            if (this$isDefault == null ? other$isDefault != null : !((Object)this$isDefault).equals(other$isDefault)) {
                return false;
            }
            List<String> this$channels = this.getChannels();
            List<String> other$channels = other.getChannels();
            return !(this$channels == null ? other$channels != null : !((Object)this$channels).equals(other$channels));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof GroupAttributes;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            List<String> $alias = this.getAlias();
            result = result * 59 + ($alias == null ? 43 : ((Object)$alias).hashCode());
            List<String> $createdAt = this.getCreatedAt();
            result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
            List<String> $createdBy = this.getCreatedBy();
            result = result * 59 + ($createdBy == null ? 43 : ((Object)$createdBy).hashCode());
            List<String> $updatedAt = this.getUpdatedAt();
            result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
            List<String> $updatedBy = this.getUpdatedBy();
            result = result * 59 + ($updatedBy == null ? 43 : ((Object)$updatedBy).hashCode());
            List<String> $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : ((Object)$description).hashCode());
            List<String> $isDefault = this.getIsDefault();
            result = result * 59 + ($isDefault == null ? 43 : ((Object)$isDefault).hashCode());
            List<String> $channels = this.getChannels();
            result = result * 59 + ($channels == null ? 43 : ((Object)$channels).hashCode());
            return result;
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        static final class GroupAttributesBuilderImpl
        extends GroupAttributesBuilder<GroupAttributes, GroupAttributesBuilderImpl> {
            @Generated
            private GroupAttributesBuilderImpl() {
            }

            @Override
            @Generated
            protected GroupAttributesBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public GroupAttributes build() {
                return new GroupAttributes(this);
            }
        }

        @Generated
        public static abstract class GroupAttributesBuilder<C extends GroupAttributes, B extends GroupAttributesBuilder<C, B>>
        extends AtlanObject.AtlanObjectBuilder<C, B> {
            @Generated
            private List<String> alias;
            @Generated
            private List<String> createdAt;
            @Generated
            private List<String> createdBy;
            @Generated
            private List<String> updatedAt;
            @Generated
            private List<String> updatedBy;
            @Generated
            private List<String> description;
            @Generated
            private boolean isDefault$set;
            @Generated
            private List<String> isDefault$value;
            @Generated
            private List<String> channels;

            @Override
            @Generated
            protected B $fillValuesFrom(C instance) {
                super.$fillValuesFrom(instance);
                GroupAttributesBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return (B)this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(GroupAttributes instance, GroupAttributesBuilder<?, ?> b) {
                b.alias(instance.alias);
                b.createdAt(instance.createdAt);
                b.createdBy(instance.createdBy);
                b.updatedAt(instance.updatedAt);
                b.updatedBy(instance.updatedBy);
                b.description(instance.description);
                b.isDefault(instance.isDefault);
                b.channels(instance.channels);
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Generated
            public B alias(List<String> alias) {
                this.alias = alias;
                return (B)this.self();
            }

            @Generated
            public B createdAt(List<String> createdAt) {
                this.createdAt = createdAt;
                return (B)this.self();
            }

            @Generated
            public B createdBy(List<String> createdBy) {
                this.createdBy = createdBy;
                return (B)this.self();
            }

            @Generated
            public B updatedAt(List<String> updatedAt) {
                this.updatedAt = updatedAt;
                return (B)this.self();
            }

            @Generated
            public B updatedBy(List<String> updatedBy) {
                this.updatedBy = updatedBy;
                return (B)this.self();
            }

            @Generated
            public B description(List<String> description) {
                this.description = description;
                return (B)this.self();
            }

            @Generated
            public B isDefault(List<String> isDefault) {
                this.isDefault$value = isDefault;
                this.isDefault$set = true;
                return (B)this.self();
            }

            @Generated
            public B channels(List<String> channels) {
                this.channels = channels;
                return (B)this.self();
            }

            @Override
            @Generated
            public String toString() {
                return "AtlanGroup.GroupAttributes.GroupAttributesBuilder(super=" + super.toString() + ", alias=" + this.alias + ", createdAt=" + this.createdAt + ", createdBy=" + this.createdBy + ", updatedAt=" + this.updatedAt + ", updatedBy=" + this.updatedBy + ", description=" + this.description + ", isDefault$value=" + this.isDefault$value + ", channels=" + this.channels + ")";
            }
        }
    }
}

