/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.admin;

import com.atlan.api.UsersEndpoint;
import com.atlan.exception.AtlanException;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.admin.GroupResponse;
import com.atlan.model.admin.SessionResponse;
import com.atlan.model.admin.UserMinimalResponse;
import com.atlan.model.admin.UserResponse;
import com.atlan.model.core.AtlanObject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import lombok.Generated;

@JsonDeserialize(builder=AtlanUserBuilderImpl.class)
public class AtlanUser
extends AtlanObject {
    private static final long serialVersionUID = 2L;
    String username;
    String id;
    String workspaceRole;
    String email;
    Boolean emailVerified;
    Boolean enabled;
    String firstName;
    String lastName;
    UserAttributes attributes;
    Long createdTimestamp;
    Long lastLoginTime;
    Long groupCount;
    List<String> defaultRoles;
    List<String> roles;
    @JsonIgnore
    String decentralizedRoles;
    SortedSet<Persona> personas;
    @JsonIgnore
    SortedSet<String> purposes;
    final List<AdminEvent> adminEvents;
    final List<LoginEvent> loginEvents;

    public static AtlanUserBuilder<?, ?> creator(String email, String roleName) {
        return ((AtlanUserBuilder)AtlanUser.builder().email(email)).workspaceRole(roleName);
    }

    public static AtlanUserBuilder<?, ?> updater(String id) {
        return AtlanUser.builder().id(id);
    }

    public void create() throws AtlanException {
        UsersEndpoint.createUser(this);
    }

    public UserMinimalResponse update() throws AtlanException {
        if (this.id == null || this.id.length() == 0) {
            throw new InvalidRequestException("An id must be provided to update the user.", "id", "ATLAN_JAVA_CLIENT-400-402", 400, null);
        }
        return UsersEndpoint.updateUser(this.id, this);
    }

    public static void delete(String id) throws AtlanException {
        UsersEndpoint.deleteUser(id);
    }

    public void addToGroups(List<String> groupIds) throws AtlanException {
        if (this.id == null || this.id.length() == 0) {
            throw new InvalidRequestException("An id must be provided to add the user into groups.", "id", "ATLAN_JAVA_CLIENT-400-403", 400, null);
        }
        UsersEndpoint.addToGroups(this.id, groupIds);
    }

    public GroupResponse fetchGroups() throws AtlanException {
        if (this.id == null || this.id.length() == 0) {
            throw new InvalidRequestException("An id must be provided to retrieve a user's group membership.", "id", "ATLAN_JAVA_CLIENT-400-404", 400, null);
        }
        return UsersEndpoint.getGroups(this.id);
    }

    public static List<AtlanUser> retrieveAll() throws AtlanException {
        UserResponse response = UsersEndpoint.getAllUsers();
        if (response != null && response.getRecords() != null) {
            return response.getRecords();
        }
        return Collections.emptyList();
    }

    public static List<AtlanUser> retrieveByEmail(String email) throws AtlanException {
        UserResponse response = UsersEndpoint.getUsers("{\"email\":{\"$ilike\":\"%" + email + "%\"}}");
        if (response != null && response.getRecords() != null) {
            return response.getRecords();
        }
        return null;
    }

    public static AtlanUser retrieveByUsername(String user) throws AtlanException {
        UserResponse response = UsersEndpoint.getUsers("{\"username\":\"" + user + "\"}");
        if (response != null && response.getRecords() != null) {
            return response.getRecords().get(0);
        }
        return null;
    }

    public UserMinimalResponse activate() throws AtlanException {
        return UsersEndpoint.updateUser(this.id, (AtlanUser)((AtlanUserBuilder)AtlanUser.builder().enabled(true)).build());
    }

    public UserMinimalResponse deactivate() throws AtlanException {
        return UsersEndpoint.updateUser(this.id, (AtlanUser)((AtlanUserBuilder)AtlanUser.builder().enabled(false)).build());
    }

    public void changeRole(String roleId) throws AtlanException {
        UsersEndpoint.changeRole(this.id, roleId);
    }

    public SessionResponse fetchSessions() throws AtlanException {
        return UsersEndpoint.getSessions(this.id);
    }

    @Generated
    protected AtlanUser(AtlanUserBuilder<?, ?> b) {
        super(b);
        this.username = b.username;
        this.id = b.id;
        this.workspaceRole = b.workspaceRole;
        this.email = b.email;
        this.emailVerified = b.emailVerified;
        this.enabled = b.enabled;
        this.firstName = b.firstName;
        this.lastName = b.lastName;
        this.attributes = b.attributes;
        this.createdTimestamp = b.createdTimestamp;
        this.lastLoginTime = b.lastLoginTime;
        this.groupCount = b.groupCount;
        this.defaultRoles = b.defaultRoles;
        this.roles = b.roles;
        this.decentralizedRoles = b.decentralizedRoles;
        this.personas = b.personas;
        this.purposes = b.purposes;
        this.adminEvents = b.adminEvents;
        this.loginEvents = b.loginEvents;
    }

    @Generated
    public static AtlanUserBuilder<?, ?> builder() {
        return new AtlanUserBuilderImpl();
    }

    @Generated
    public AtlanUserBuilder<?, ?> toBuilder() {
        return new AtlanUserBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getWorkspaceRole() {
        return this.workspaceRole;
    }

    @Generated
    public String getEmail() {
        return this.email;
    }

    @Generated
    public Boolean getEmailVerified() {
        return this.emailVerified;
    }

    @Generated
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Generated
    public String getFirstName() {
        return this.firstName;
    }

    @Generated
    public String getLastName() {
        return this.lastName;
    }

    @Generated
    public UserAttributes getAttributes() {
        return this.attributes;
    }

    @Generated
    public Long getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    @Generated
    public Long getLastLoginTime() {
        return this.lastLoginTime;
    }

    @Generated
    public Long getGroupCount() {
        return this.groupCount;
    }

    @Generated
    public List<String> getDefaultRoles() {
        return this.defaultRoles;
    }

    @Generated
    public List<String> getRoles() {
        return this.roles;
    }

    @Generated
    public String getDecentralizedRoles() {
        return this.decentralizedRoles;
    }

    @Generated
    public SortedSet<Persona> getPersonas() {
        return this.personas;
    }

    @Generated
    public SortedSet<String> getPurposes() {
        return this.purposes;
    }

    @Generated
    public List<AdminEvent> getAdminEvents() {
        return this.adminEvents;
    }

    @Generated
    public List<LoginEvent> getLoginEvents() {
        return this.loginEvents;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setWorkspaceRole(String workspaceRole) {
        this.workspaceRole = workspaceRole;
    }

    @Generated
    public void setEmail(String email) {
        this.email = email;
    }

    @Generated
    public void setEmailVerified(Boolean emailVerified) {
        this.emailVerified = emailVerified;
    }

    @Generated
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Generated
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Generated
    public void setAttributes(UserAttributes attributes) {
        this.attributes = attributes;
    }

    @Generated
    public void setCreatedTimestamp(Long createdTimestamp) {
        this.createdTimestamp = createdTimestamp;
    }

    @Generated
    public void setLastLoginTime(Long lastLoginTime) {
        this.lastLoginTime = lastLoginTime;
    }

    @Generated
    public void setGroupCount(Long groupCount) {
        this.groupCount = groupCount;
    }

    @Generated
    public void setDefaultRoles(List<String> defaultRoles) {
        this.defaultRoles = defaultRoles;
    }

    @Generated
    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    @JsonIgnore
    @Generated
    public void setDecentralizedRoles(String decentralizedRoles) {
        this.decentralizedRoles = decentralizedRoles;
    }

    @Generated
    public void setPersonas(SortedSet<Persona> personas) {
        this.personas = personas;
    }

    @JsonIgnore
    @Generated
    public void setPurposes(SortedSet<String> purposes) {
        this.purposes = purposes;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AtlanUser)) {
            return false;
        }
        AtlanUser other = (AtlanUser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$emailVerified = this.getEmailVerified();
        Boolean other$emailVerified = other.getEmailVerified();
        if (this$emailVerified == null ? other$emailVerified != null : !((Object)this$emailVerified).equals(other$emailVerified)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Long this$createdTimestamp = this.getCreatedTimestamp();
        Long other$createdTimestamp = other.getCreatedTimestamp();
        if (this$createdTimestamp == null ? other$createdTimestamp != null : !((Object)this$createdTimestamp).equals(other$createdTimestamp)) {
            return false;
        }
        Long this$lastLoginTime = this.getLastLoginTime();
        Long other$lastLoginTime = other.getLastLoginTime();
        if (this$lastLoginTime == null ? other$lastLoginTime != null : !((Object)this$lastLoginTime).equals(other$lastLoginTime)) {
            return false;
        }
        Long this$groupCount = this.getGroupCount();
        Long other$groupCount = other.getGroupCount();
        if (this$groupCount == null ? other$groupCount != null : !((Object)this$groupCount).equals(other$groupCount)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$workspaceRole = this.getWorkspaceRole();
        String other$workspaceRole = other.getWorkspaceRole();
        if (this$workspaceRole == null ? other$workspaceRole != null : !this$workspaceRole.equals(other$workspaceRole)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$firstName = this.getFirstName();
        String other$firstName = other.getFirstName();
        if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
            return false;
        }
        String this$lastName = this.getLastName();
        String other$lastName = other.getLastName();
        if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) {
            return false;
        }
        UserAttributes this$attributes = this.getAttributes();
        UserAttributes other$attributes = other.getAttributes();
        if (this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes)) {
            return false;
        }
        List<String> this$defaultRoles = this.getDefaultRoles();
        List<String> other$defaultRoles = other.getDefaultRoles();
        if (this$defaultRoles == null ? other$defaultRoles != null : !((Object)this$defaultRoles).equals(other$defaultRoles)) {
            return false;
        }
        List<String> this$roles = this.getRoles();
        List<String> other$roles = other.getRoles();
        if (this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles)) {
            return false;
        }
        String this$decentralizedRoles = this.getDecentralizedRoles();
        String other$decentralizedRoles = other.getDecentralizedRoles();
        if (this$decentralizedRoles == null ? other$decentralizedRoles != null : !this$decentralizedRoles.equals(other$decentralizedRoles)) {
            return false;
        }
        SortedSet<Persona> this$personas = this.getPersonas();
        SortedSet<Persona> other$personas = other.getPersonas();
        if (this$personas == null ? other$personas != null : !this$personas.equals(other$personas)) {
            return false;
        }
        SortedSet<String> this$purposes = this.getPurposes();
        SortedSet<String> other$purposes = other.getPurposes();
        if (this$purposes == null ? other$purposes != null : !this$purposes.equals(other$purposes)) {
            return false;
        }
        List<AdminEvent> this$adminEvents = this.getAdminEvents();
        List<AdminEvent> other$adminEvents = other.getAdminEvents();
        if (this$adminEvents == null ? other$adminEvents != null : !((Object)this$adminEvents).equals(other$adminEvents)) {
            return false;
        }
        List<LoginEvent> this$loginEvents = this.getLoginEvents();
        List<LoginEvent> other$loginEvents = other.getLoginEvents();
        return !(this$loginEvents == null ? other$loginEvents != null : !((Object)this$loginEvents).equals(other$loginEvents));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AtlanUser;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $emailVerified = this.getEmailVerified();
        result = result * 59 + ($emailVerified == null ? 43 : ((Object)$emailVerified).hashCode());
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Long $createdTimestamp = this.getCreatedTimestamp();
        result = result * 59 + ($createdTimestamp == null ? 43 : ((Object)$createdTimestamp).hashCode());
        Long $lastLoginTime = this.getLastLoginTime();
        result = result * 59 + ($lastLoginTime == null ? 43 : ((Object)$lastLoginTime).hashCode());
        Long $groupCount = this.getGroupCount();
        result = result * 59 + ($groupCount == null ? 43 : ((Object)$groupCount).hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $workspaceRole = this.getWorkspaceRole();
        result = result * 59 + ($workspaceRole == null ? 43 : $workspaceRole.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $firstName = this.getFirstName();
        result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
        String $lastName = this.getLastName();
        result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
        UserAttributes $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        List<String> $defaultRoles = this.getDefaultRoles();
        result = result * 59 + ($defaultRoles == null ? 43 : ((Object)$defaultRoles).hashCode());
        List<String> $roles = this.getRoles();
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        String $decentralizedRoles = this.getDecentralizedRoles();
        result = result * 59 + ($decentralizedRoles == null ? 43 : $decentralizedRoles.hashCode());
        SortedSet<Persona> $personas = this.getPersonas();
        result = result * 59 + ($personas == null ? 43 : $personas.hashCode());
        SortedSet<String> $purposes = this.getPurposes();
        result = result * 59 + ($purposes == null ? 43 : $purposes.hashCode());
        List<AdminEvent> $adminEvents = this.getAdminEvents();
        result = result * 59 + ($adminEvents == null ? 43 : ((Object)$adminEvents).hashCode());
        List<LoginEvent> $loginEvents = this.getLoginEvents();
        result = result * 59 + ($loginEvents == null ? 43 : ((Object)$loginEvents).hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class AtlanUserBuilderImpl
    extends AtlanUserBuilder<AtlanUser, AtlanUserBuilderImpl> {
        @Generated
        private AtlanUserBuilderImpl() {
        }

        @Override
        @Generated
        protected AtlanUserBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public AtlanUser build() {
            return new AtlanUser(this);
        }
    }

    @Generated
    public static abstract class AtlanUserBuilder<C extends AtlanUser, B extends AtlanUserBuilder<C, B>>
    extends AtlanObject.AtlanObjectBuilder<C, B> {
        @Generated
        private String username;
        @Generated
        private String id;
        @Generated
        private String workspaceRole;
        @Generated
        private String email;
        @Generated
        private Boolean emailVerified;
        @Generated
        private Boolean enabled;
        @Generated
        private String firstName;
        @Generated
        private String lastName;
        @Generated
        private UserAttributes attributes;
        @Generated
        private Long createdTimestamp;
        @Generated
        private Long lastLoginTime;
        @Generated
        private Long groupCount;
        @Generated
        private List<String> defaultRoles;
        @Generated
        private List<String> roles;
        @Generated
        private String decentralizedRoles;
        @Generated
        private SortedSet<Persona> personas;
        @Generated
        private SortedSet<String> purposes;
        @Generated
        private List<AdminEvent> adminEvents;
        @Generated
        private List<LoginEvent> loginEvents;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AtlanUserBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(AtlanUser instance, AtlanUserBuilder<?, ?> b) {
            b.username(instance.username);
            b.id(instance.id);
            b.workspaceRole(instance.workspaceRole);
            b.email(instance.email);
            b.emailVerified(instance.emailVerified);
            b.enabled(instance.enabled);
            b.firstName(instance.firstName);
            b.lastName(instance.lastName);
            b.attributes(instance.attributes);
            b.createdTimestamp(instance.createdTimestamp);
            b.lastLoginTime(instance.lastLoginTime);
            b.groupCount(instance.groupCount);
            b.defaultRoles(instance.defaultRoles);
            b.roles(instance.roles);
            b.decentralizedRoles(instance.decentralizedRoles);
            b.personas(instance.personas);
            b.purposes(instance.purposes);
            b.adminEvents(instance.adminEvents);
            b.loginEvents(instance.loginEvents);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B username(String username) {
            this.username = username;
            return (B)this.self();
        }

        @Generated
        public B id(String id) {
            this.id = id;
            return (B)this.self();
        }

        @Generated
        public B workspaceRole(String workspaceRole) {
            this.workspaceRole = workspaceRole;
            return (B)this.self();
        }

        @Generated
        public B email(String email) {
            this.email = email;
            return (B)this.self();
        }

        @Generated
        public B emailVerified(Boolean emailVerified) {
            this.emailVerified = emailVerified;
            return (B)this.self();
        }

        @Generated
        public B enabled(Boolean enabled) {
            this.enabled = enabled;
            return (B)this.self();
        }

        @Generated
        public B firstName(String firstName) {
            this.firstName = firstName;
            return (B)this.self();
        }

        @Generated
        public B lastName(String lastName) {
            this.lastName = lastName;
            return (B)this.self();
        }

        @Generated
        public B attributes(UserAttributes attributes) {
            this.attributes = attributes;
            return (B)this.self();
        }

        @Generated
        public B createdTimestamp(Long createdTimestamp) {
            this.createdTimestamp = createdTimestamp;
            return (B)this.self();
        }

        @Generated
        public B lastLoginTime(Long lastLoginTime) {
            this.lastLoginTime = lastLoginTime;
            return (B)this.self();
        }

        @Generated
        public B groupCount(Long groupCount) {
            this.groupCount = groupCount;
            return (B)this.self();
        }

        @Generated
        public B defaultRoles(List<String> defaultRoles) {
            this.defaultRoles = defaultRoles;
            return (B)this.self();
        }

        @Generated
        public B roles(List<String> roles) {
            this.roles = roles;
            return (B)this.self();
        }

        @JsonIgnore
        @Generated
        public B decentralizedRoles(String decentralizedRoles) {
            this.decentralizedRoles = decentralizedRoles;
            return (B)this.self();
        }

        @Generated
        public B personas(SortedSet<Persona> personas) {
            this.personas = personas;
            return (B)this.self();
        }

        @JsonIgnore
        @Generated
        public B purposes(SortedSet<String> purposes) {
            this.purposes = purposes;
            return (B)this.self();
        }

        @Generated
        public B adminEvents(List<AdminEvent> adminEvents) {
            this.adminEvents = adminEvents;
            return (B)this.self();
        }

        @Generated
        public B loginEvents(List<LoginEvent> loginEvents) {
            this.loginEvents = loginEvents;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "AtlanUser.AtlanUserBuilder(super=" + super.toString() + ", username=" + this.username + ", id=" + this.id + ", workspaceRole=" + this.workspaceRole + ", email=" + this.email + ", emailVerified=" + this.emailVerified + ", enabled=" + this.enabled + ", firstName=" + this.firstName + ", lastName=" + this.lastName + ", attributes=" + this.attributes + ", createdTimestamp=" + this.createdTimestamp + ", lastLoginTime=" + this.lastLoginTime + ", groupCount=" + this.groupCount + ", defaultRoles=" + this.defaultRoles + ", roles=" + this.roles + ", decentralizedRoles=" + this.decentralizedRoles + ", personas=" + this.personas + ", purposes=" + this.purposes + ", adminEvents=" + this.adminEvents + ", loginEvents=" + this.loginEvents + ")";
        }
    }

    @JsonDeserialize(builder=AuthDetailsBuilderImpl.class)
    public static final class AuthDetails
    extends AtlanObject {
        private static final long serialVersionUID = 2L;
        String clientId;
        String ipAddress;
        String realmId;
        String userId;

        @Generated
        protected AuthDetails(AuthDetailsBuilder<?, ?> b) {
            super(b);
            this.clientId = b.clientId;
            this.ipAddress = b.ipAddress;
            this.realmId = b.realmId;
            this.userId = b.userId;
        }

        @Generated
        public static AuthDetailsBuilder<?, ?> builder() {
            return new AuthDetailsBuilderImpl();
        }

        @Generated
        public AuthDetailsBuilder<?, ?> toBuilder() {
            return new AuthDetailsBuilderImpl().$fillValuesFrom(this);
        }

        @Generated
        public String getClientId() {
            return this.clientId;
        }

        @Generated
        public String getIpAddress() {
            return this.ipAddress;
        }

        @Generated
        public String getRealmId() {
            return this.realmId;
        }

        @Generated
        public String getUserId() {
            return this.userId;
        }

        @Generated
        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Generated
        public void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Generated
        public void setRealmId(String realmId) {
            this.realmId = realmId;
        }

        @Generated
        public void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AuthDetails)) {
                return false;
            }
            AuthDetails other = (AuthDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$clientId = this.getClientId();
            String other$clientId = other.getClientId();
            if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
                return false;
            }
            String this$ipAddress = this.getIpAddress();
            String other$ipAddress = other.getIpAddress();
            if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
                return false;
            }
            String this$realmId = this.getRealmId();
            String other$realmId = other.getRealmId();
            if (this$realmId == null ? other$realmId != null : !this$realmId.equals(other$realmId)) {
                return false;
            }
            String this$userId = this.getUserId();
            String other$userId = other.getUserId();
            return !(this$userId == null ? other$userId != null : !this$userId.equals(other$userId));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AuthDetails;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $clientId = this.getClientId();
            result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
            String $ipAddress = this.getIpAddress();
            result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
            String $realmId = this.getRealmId();
            result = result * 59 + ($realmId == null ? 43 : $realmId.hashCode());
            String $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
            return result;
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        static final class AuthDetailsBuilderImpl
        extends AuthDetailsBuilder<AuthDetails, AuthDetailsBuilderImpl> {
            @Generated
            private AuthDetailsBuilderImpl() {
            }

            @Override
            @Generated
            protected AuthDetailsBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public AuthDetails build() {
                return new AuthDetails(this);
            }
        }

        @Generated
        public static abstract class AuthDetailsBuilder<C extends AuthDetails, B extends AuthDetailsBuilder<C, B>>
        extends AtlanObject.AtlanObjectBuilder<C, B> {
            @Generated
            private String clientId;
            @Generated
            private String ipAddress;
            @Generated
            private String realmId;
            @Generated
            private String userId;

            @Override
            @Generated
            protected B $fillValuesFrom(C instance) {
                super.$fillValuesFrom(instance);
                AuthDetailsBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return (B)this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(AuthDetails instance, AuthDetailsBuilder<?, ?> b) {
                b.clientId(instance.clientId);
                b.ipAddress(instance.ipAddress);
                b.realmId(instance.realmId);
                b.userId(instance.userId);
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Generated
            public B clientId(String clientId) {
                this.clientId = clientId;
                return (B)this.self();
            }

            @Generated
            public B ipAddress(String ipAddress) {
                this.ipAddress = ipAddress;
                return (B)this.self();
            }

            @Generated
            public B realmId(String realmId) {
                this.realmId = realmId;
                return (B)this.self();
            }

            @Generated
            public B userId(String userId) {
                this.userId = userId;
                return (B)this.self();
            }

            @Override
            @Generated
            public String toString() {
                return "AtlanUser.AuthDetails.AuthDetailsBuilder(super=" + super.toString() + ", clientId=" + this.clientId + ", ipAddress=" + this.ipAddress + ", realmId=" + this.realmId + ", userId=" + this.userId + ")";
            }
        }
    }

    @JsonDeserialize(builder=AdminEventBuilderImpl.class)
    public static final class AdminEvent
    extends AtlanObject {
        private static final long serialVersionUID = 2L;
        String operationType;
        String realmId;
        String representation;
        String resourcePath;
        String resourceType;
        Long time;
        AuthDetails authDetails;

        @Generated
        protected AdminEvent(AdminEventBuilder<?, ?> b) {
            super(b);
            this.operationType = b.operationType;
            this.realmId = b.realmId;
            this.representation = b.representation;
            this.resourcePath = b.resourcePath;
            this.resourceType = b.resourceType;
            this.time = b.time;
            this.authDetails = b.authDetails;
        }

        @Generated
        public static AdminEventBuilder<?, ?> builder() {
            return new AdminEventBuilderImpl();
        }

        @Generated
        public AdminEventBuilder<?, ?> toBuilder() {
            return new AdminEventBuilderImpl().$fillValuesFrom(this);
        }

        @Generated
        public String getOperationType() {
            return this.operationType;
        }

        @Generated
        public String getRealmId() {
            return this.realmId;
        }

        @Generated
        public String getRepresentation() {
            return this.representation;
        }

        @Generated
        public String getResourcePath() {
            return this.resourcePath;
        }

        @Generated
        public String getResourceType() {
            return this.resourceType;
        }

        @Generated
        public Long getTime() {
            return this.time;
        }

        @Generated
        public AuthDetails getAuthDetails() {
            return this.authDetails;
        }

        @Generated
        public void setOperationType(String operationType) {
            this.operationType = operationType;
        }

        @Generated
        public void setRealmId(String realmId) {
            this.realmId = realmId;
        }

        @Generated
        public void setRepresentation(String representation) {
            this.representation = representation;
        }

        @Generated
        public void setResourcePath(String resourcePath) {
            this.resourcePath = resourcePath;
        }

        @Generated
        public void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Generated
        public void setTime(Long time) {
            this.time = time;
        }

        @Generated
        public void setAuthDetails(AuthDetails authDetails) {
            this.authDetails = authDetails;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AdminEvent)) {
                return false;
            }
            AdminEvent other = (AdminEvent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Long this$time = this.getTime();
            Long other$time = other.getTime();
            if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
                return false;
            }
            String this$operationType = this.getOperationType();
            String other$operationType = other.getOperationType();
            if (this$operationType == null ? other$operationType != null : !this$operationType.equals(other$operationType)) {
                return false;
            }
            String this$realmId = this.getRealmId();
            String other$realmId = other.getRealmId();
            if (this$realmId == null ? other$realmId != null : !this$realmId.equals(other$realmId)) {
                return false;
            }
            String this$representation = this.getRepresentation();
            String other$representation = other.getRepresentation();
            if (this$representation == null ? other$representation != null : !this$representation.equals(other$representation)) {
                return false;
            }
            String this$resourcePath = this.getResourcePath();
            String other$resourcePath = other.getResourcePath();
            if (this$resourcePath == null ? other$resourcePath != null : !this$resourcePath.equals(other$resourcePath)) {
                return false;
            }
            String this$resourceType = this.getResourceType();
            String other$resourceType = other.getResourceType();
            if (this$resourceType == null ? other$resourceType != null : !this$resourceType.equals(other$resourceType)) {
                return false;
            }
            AuthDetails this$authDetails = this.getAuthDetails();
            AuthDetails other$authDetails = other.getAuthDetails();
            return !(this$authDetails == null ? other$authDetails != null : !((Object)this$authDetails).equals(other$authDetails));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AdminEvent;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Long $time = this.getTime();
            result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
            String $operationType = this.getOperationType();
            result = result * 59 + ($operationType == null ? 43 : $operationType.hashCode());
            String $realmId = this.getRealmId();
            result = result * 59 + ($realmId == null ? 43 : $realmId.hashCode());
            String $representation = this.getRepresentation();
            result = result * 59 + ($representation == null ? 43 : $representation.hashCode());
            String $resourcePath = this.getResourcePath();
            result = result * 59 + ($resourcePath == null ? 43 : $resourcePath.hashCode());
            String $resourceType = this.getResourceType();
            result = result * 59 + ($resourceType == null ? 43 : $resourceType.hashCode());
            AuthDetails $authDetails = this.getAuthDetails();
            result = result * 59 + ($authDetails == null ? 43 : ((Object)$authDetails).hashCode());
            return result;
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        static final class AdminEventBuilderImpl
        extends AdminEventBuilder<AdminEvent, AdminEventBuilderImpl> {
            @Generated
            private AdminEventBuilderImpl() {
            }

            @Override
            @Generated
            protected AdminEventBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public AdminEvent build() {
                return new AdminEvent(this);
            }
        }

        @Generated
        public static abstract class AdminEventBuilder<C extends AdminEvent, B extends AdminEventBuilder<C, B>>
        extends AtlanObject.AtlanObjectBuilder<C, B> {
            @Generated
            private String operationType;
            @Generated
            private String realmId;
            @Generated
            private String representation;
            @Generated
            private String resourcePath;
            @Generated
            private String resourceType;
            @Generated
            private Long time;
            @Generated
            private AuthDetails authDetails;

            @Override
            @Generated
            protected B $fillValuesFrom(C instance) {
                super.$fillValuesFrom(instance);
                AdminEventBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return (B)this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(AdminEvent instance, AdminEventBuilder<?, ?> b) {
                b.operationType(instance.operationType);
                b.realmId(instance.realmId);
                b.representation(instance.representation);
                b.resourcePath(instance.resourcePath);
                b.resourceType(instance.resourceType);
                b.time(instance.time);
                b.authDetails(instance.authDetails);
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Generated
            public B operationType(String operationType) {
                this.operationType = operationType;
                return (B)this.self();
            }

            @Generated
            public B realmId(String realmId) {
                this.realmId = realmId;
                return (B)this.self();
            }

            @Generated
            public B representation(String representation) {
                this.representation = representation;
                return (B)this.self();
            }

            @Generated
            public B resourcePath(String resourcePath) {
                this.resourcePath = resourcePath;
                return (B)this.self();
            }

            @Generated
            public B resourceType(String resourceType) {
                this.resourceType = resourceType;
                return (B)this.self();
            }

            @Generated
            public B time(Long time) {
                this.time = time;
                return (B)this.self();
            }

            @Generated
            public B authDetails(AuthDetails authDetails) {
                this.authDetails = authDetails;
                return (B)this.self();
            }

            @Override
            @Generated
            public String toString() {
                return "AtlanUser.AdminEvent.AdminEventBuilder(super=" + super.toString() + ", operationType=" + this.operationType + ", realmId=" + this.realmId + ", representation=" + this.representation + ", resourcePath=" + this.resourcePath + ", resourceType=" + this.resourceType + ", time=" + this.time + ", authDetails=" + this.authDetails + ")";
            }
        }
    }

    @JsonDeserialize(builder=PersonaBuilderImpl.class)
    public static final class Persona
    extends AtlanObject
    implements Comparable<Persona> {
        private static final long serialVersionUID = 2L;
        private static final Comparator<String> stringComparator = Comparator.nullsFirst(String::compareTo);
        private static final Comparator<Persona> personaComparator = Comparator.comparing(Persona::getId, stringComparator);
        String id;
        String name;
        String displayName;

        @Override
        public int compareTo(Persona o) {
            return personaComparator.compare(this, o);
        }

        @Generated
        protected Persona(PersonaBuilder<?, ?> b) {
            super(b);
            this.id = b.id;
            this.name = b.name;
            this.displayName = b.displayName;
        }

        @Generated
        public static PersonaBuilder<?, ?> builder() {
            return new PersonaBuilderImpl();
        }

        @Generated
        public PersonaBuilder<?, ?> toBuilder() {
            return new PersonaBuilderImpl().$fillValuesFrom(this);
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getDisplayName() {
            return this.displayName;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Persona)) {
                return false;
            }
            Persona other = (Persona)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$displayName = this.getDisplayName();
            String other$displayName = other.getDisplayName();
            return !(this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Persona;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $displayName = this.getDisplayName();
            result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
            return result;
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        static final class PersonaBuilderImpl
        extends PersonaBuilder<Persona, PersonaBuilderImpl> {
            @Generated
            private PersonaBuilderImpl() {
            }

            @Override
            @Generated
            protected PersonaBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public Persona build() {
                return new Persona(this);
            }
        }

        @Generated
        public static abstract class PersonaBuilder<C extends Persona, B extends PersonaBuilder<C, B>>
        extends AtlanObject.AtlanObjectBuilder<C, B> {
            @Generated
            private String id;
            @Generated
            private String name;
            @Generated
            private String displayName;

            @Override
            @Generated
            protected B $fillValuesFrom(C instance) {
                super.$fillValuesFrom(instance);
                PersonaBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return (B)this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(Persona instance, PersonaBuilder<?, ?> b) {
                b.id(instance.id);
                b.name(instance.name);
                b.displayName(instance.displayName);
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Generated
            public B id(String id) {
                this.id = id;
                return (B)this.self();
            }

            @Generated
            public B name(String name) {
                this.name = name;
                return (B)this.self();
            }

            @Generated
            public B displayName(String displayName) {
                this.displayName = displayName;
                return (B)this.self();
            }

            @Override
            @Generated
            public String toString() {
                return "AtlanUser.Persona.PersonaBuilder(super=" + super.toString() + ", id=" + this.id + ", name=" + this.name + ", displayName=" + this.displayName + ")";
            }
        }
    }

    @JsonDeserialize(builder=LoginEventBuilderImpl.class)
    public static final class LoginEvent
    extends AtlanObject {
        private static final long serialVersionUID = 2L;
        String clientId;
        @JsonIgnore
        String details;
        String ipAddress;
        String realmId;
        String sessionId;
        Long time;
        String type;
        String userId;

        @Generated
        protected LoginEvent(LoginEventBuilder<?, ?> b) {
            super(b);
            this.clientId = b.clientId;
            this.details = b.details;
            this.ipAddress = b.ipAddress;
            this.realmId = b.realmId;
            this.sessionId = b.sessionId;
            this.time = b.time;
            this.type = b.type;
            this.userId = b.userId;
        }

        @Generated
        public static LoginEventBuilder<?, ?> builder() {
            return new LoginEventBuilderImpl();
        }

        @Generated
        public LoginEventBuilder<?, ?> toBuilder() {
            return new LoginEventBuilderImpl().$fillValuesFrom(this);
        }

        @Generated
        public String getClientId() {
            return this.clientId;
        }

        @Generated
        public String getDetails() {
            return this.details;
        }

        @Generated
        public String getIpAddress() {
            return this.ipAddress;
        }

        @Generated
        public String getRealmId() {
            return this.realmId;
        }

        @Generated
        public String getSessionId() {
            return this.sessionId;
        }

        @Generated
        public Long getTime() {
            return this.time;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getUserId() {
            return this.userId;
        }

        @Generated
        public void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @JsonIgnore
        @Generated
        public void setDetails(String details) {
            this.details = details;
        }

        @Generated
        public void setIpAddress(String ipAddress) {
            this.ipAddress = ipAddress;
        }

        @Generated
        public void setRealmId(String realmId) {
            this.realmId = realmId;
        }

        @Generated
        public void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Generated
        public void setTime(Long time) {
            this.time = time;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LoginEvent)) {
                return false;
            }
            LoginEvent other = (LoginEvent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Long this$time = this.getTime();
            Long other$time = other.getTime();
            if (this$time == null ? other$time != null : !((Object)this$time).equals(other$time)) {
                return false;
            }
            String this$clientId = this.getClientId();
            String other$clientId = other.getClientId();
            if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
                return false;
            }
            String this$details = this.getDetails();
            String other$details = other.getDetails();
            if (this$details == null ? other$details != null : !this$details.equals(other$details)) {
                return false;
            }
            String this$ipAddress = this.getIpAddress();
            String other$ipAddress = other.getIpAddress();
            if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
                return false;
            }
            String this$realmId = this.getRealmId();
            String other$realmId = other.getRealmId();
            if (this$realmId == null ? other$realmId != null : !this$realmId.equals(other$realmId)) {
                return false;
            }
            String this$sessionId = this.getSessionId();
            String other$sessionId = other.getSessionId();
            if (this$sessionId == null ? other$sessionId != null : !this$sessionId.equals(other$sessionId)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$userId = this.getUserId();
            String other$userId = other.getUserId();
            return !(this$userId == null ? other$userId != null : !this$userId.equals(other$userId));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LoginEvent;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Long $time = this.getTime();
            result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
            String $clientId = this.getClientId();
            result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
            String $details = this.getDetails();
            result = result * 59 + ($details == null ? 43 : $details.hashCode());
            String $ipAddress = this.getIpAddress();
            result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
            String $realmId = this.getRealmId();
            result = result * 59 + ($realmId == null ? 43 : $realmId.hashCode());
            String $sessionId = this.getSessionId();
            result = result * 59 + ($sessionId == null ? 43 : $sessionId.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
            return result;
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        static final class LoginEventBuilderImpl
        extends LoginEventBuilder<LoginEvent, LoginEventBuilderImpl> {
            @Generated
            private LoginEventBuilderImpl() {
            }

            @Override
            @Generated
            protected LoginEventBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public LoginEvent build() {
                return new LoginEvent(this);
            }
        }

        @Generated
        public static abstract class LoginEventBuilder<C extends LoginEvent, B extends LoginEventBuilder<C, B>>
        extends AtlanObject.AtlanObjectBuilder<C, B> {
            @Generated
            private String clientId;
            @Generated
            private String details;
            @Generated
            private String ipAddress;
            @Generated
            private String realmId;
            @Generated
            private String sessionId;
            @Generated
            private Long time;
            @Generated
            private String type;
            @Generated
            private String userId;

            @Override
            @Generated
            protected B $fillValuesFrom(C instance) {
                super.$fillValuesFrom(instance);
                LoginEventBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return (B)this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(LoginEvent instance, LoginEventBuilder<?, ?> b) {
                b.clientId(instance.clientId);
                b.details(instance.details);
                b.ipAddress(instance.ipAddress);
                b.realmId(instance.realmId);
                b.sessionId(instance.sessionId);
                b.time(instance.time);
                b.type(instance.type);
                b.userId(instance.userId);
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Generated
            public B clientId(String clientId) {
                this.clientId = clientId;
                return (B)this.self();
            }

            @JsonIgnore
            @Generated
            public B details(String details) {
                this.details = details;
                return (B)this.self();
            }

            @Generated
            public B ipAddress(String ipAddress) {
                this.ipAddress = ipAddress;
                return (B)this.self();
            }

            @Generated
            public B realmId(String realmId) {
                this.realmId = realmId;
                return (B)this.self();
            }

            @Generated
            public B sessionId(String sessionId) {
                this.sessionId = sessionId;
                return (B)this.self();
            }

            @Generated
            public B time(Long time) {
                this.time = time;
                return (B)this.self();
            }

            @Generated
            public B type(String type) {
                this.type = type;
                return (B)this.self();
            }

            @Generated
            public B userId(String userId) {
                this.userId = userId;
                return (B)this.self();
            }

            @Override
            @Generated
            public String toString() {
                return "AtlanUser.LoginEvent.LoginEventBuilder(super=" + super.toString() + ", clientId=" + this.clientId + ", details=" + this.details + ", ipAddress=" + this.ipAddress + ", realmId=" + this.realmId + ", sessionId=" + this.sessionId + ", time=" + this.time + ", type=" + this.type + ", userId=" + this.userId + ")";
            }
        }
    }

    @JsonDeserialize(builder=UserAttributesBuilderImpl.class)
    public static final class UserAttributes
    extends AtlanObject {
        private static final long serialVersionUID = 2L;
        List<String> designation;
        List<String> skills;
        List<String> slack;
        List<String> jira;
        List<String> invitedAt;
        List<String> invitedBy;
        List<String> invitedByName;

        @Generated
        protected UserAttributes(UserAttributesBuilder<?, ?> b) {
            super(b);
            this.designation = b.designation;
            this.skills = b.skills;
            this.slack = b.slack;
            this.jira = b.jira;
            this.invitedAt = b.invitedAt;
            this.invitedBy = b.invitedBy;
            this.invitedByName = b.invitedByName;
        }

        @Generated
        public static UserAttributesBuilder<?, ?> builder() {
            return new UserAttributesBuilderImpl();
        }

        @Generated
        public UserAttributesBuilder<?, ?> toBuilder() {
            return new UserAttributesBuilderImpl().$fillValuesFrom(this);
        }

        @Generated
        public List<String> getDesignation() {
            return this.designation;
        }

        @Generated
        public List<String> getSkills() {
            return this.skills;
        }

        @Generated
        public List<String> getSlack() {
            return this.slack;
        }

        @Generated
        public List<String> getJira() {
            return this.jira;
        }

        @Generated
        public List<String> getInvitedAt() {
            return this.invitedAt;
        }

        @Generated
        public List<String> getInvitedBy() {
            return this.invitedBy;
        }

        @Generated
        public List<String> getInvitedByName() {
            return this.invitedByName;
        }

        @Generated
        public void setDesignation(List<String> designation) {
            this.designation = designation;
        }

        @Generated
        public void setSkills(List<String> skills) {
            this.skills = skills;
        }

        @Generated
        public void setSlack(List<String> slack) {
            this.slack = slack;
        }

        @Generated
        public void setJira(List<String> jira) {
            this.jira = jira;
        }

        @Generated
        public void setInvitedAt(List<String> invitedAt) {
            this.invitedAt = invitedAt;
        }

        @Generated
        public void setInvitedBy(List<String> invitedBy) {
            this.invitedBy = invitedBy;
        }

        @Generated
        public void setInvitedByName(List<String> invitedByName) {
            this.invitedByName = invitedByName;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UserAttributes)) {
                return false;
            }
            UserAttributes other = (UserAttributes)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            List<String> this$designation = this.getDesignation();
            List<String> other$designation = other.getDesignation();
            if (this$designation == null ? other$designation != null : !((Object)this$designation).equals(other$designation)) {
                return false;
            }
            List<String> this$skills = this.getSkills();
            List<String> other$skills = other.getSkills();
            if (this$skills == null ? other$skills != null : !((Object)this$skills).equals(other$skills)) {
                return false;
            }
            List<String> this$slack = this.getSlack();
            List<String> other$slack = other.getSlack();
            if (this$slack == null ? other$slack != null : !((Object)this$slack).equals(other$slack)) {
                return false;
            }
            List<String> this$jira = this.getJira();
            List<String> other$jira = other.getJira();
            if (this$jira == null ? other$jira != null : !((Object)this$jira).equals(other$jira)) {
                return false;
            }
            List<String> this$invitedAt = this.getInvitedAt();
            List<String> other$invitedAt = other.getInvitedAt();
            if (this$invitedAt == null ? other$invitedAt != null : !((Object)this$invitedAt).equals(other$invitedAt)) {
                return false;
            }
            List<String> this$invitedBy = this.getInvitedBy();
            List<String> other$invitedBy = other.getInvitedBy();
            if (this$invitedBy == null ? other$invitedBy != null : !((Object)this$invitedBy).equals(other$invitedBy)) {
                return false;
            }
            List<String> this$invitedByName = this.getInvitedByName();
            List<String> other$invitedByName = other.getInvitedByName();
            return !(this$invitedByName == null ? other$invitedByName != null : !((Object)this$invitedByName).equals(other$invitedByName));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof UserAttributes;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            List<String> $designation = this.getDesignation();
            result = result * 59 + ($designation == null ? 43 : ((Object)$designation).hashCode());
            List<String> $skills = this.getSkills();
            result = result * 59 + ($skills == null ? 43 : ((Object)$skills).hashCode());
            List<String> $slack = this.getSlack();
            result = result * 59 + ($slack == null ? 43 : ((Object)$slack).hashCode());
            List<String> $jira = this.getJira();
            result = result * 59 + ($jira == null ? 43 : ((Object)$jira).hashCode());
            List<String> $invitedAt = this.getInvitedAt();
            result = result * 59 + ($invitedAt == null ? 43 : ((Object)$invitedAt).hashCode());
            List<String> $invitedBy = this.getInvitedBy();
            result = result * 59 + ($invitedBy == null ? 43 : ((Object)$invitedBy).hashCode());
            List<String> $invitedByName = this.getInvitedByName();
            result = result * 59 + ($invitedByName == null ? 43 : ((Object)$invitedByName).hashCode());
            return result;
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        static final class UserAttributesBuilderImpl
        extends UserAttributesBuilder<UserAttributes, UserAttributesBuilderImpl> {
            @Generated
            private UserAttributesBuilderImpl() {
            }

            @Override
            @Generated
            protected UserAttributesBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public UserAttributes build() {
                return new UserAttributes(this);
            }
        }

        @Generated
        public static abstract class UserAttributesBuilder<C extends UserAttributes, B extends UserAttributesBuilder<C, B>>
        extends AtlanObject.AtlanObjectBuilder<C, B> {
            @Generated
            private List<String> designation;
            @Generated
            private List<String> skills;
            @Generated
            private List<String> slack;
            @Generated
            private List<String> jira;
            @Generated
            private List<String> invitedAt;
            @Generated
            private List<String> invitedBy;
            @Generated
            private List<String> invitedByName;

            @Override
            @Generated
            protected B $fillValuesFrom(C instance) {
                super.$fillValuesFrom(instance);
                UserAttributesBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return (B)this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(UserAttributes instance, UserAttributesBuilder<?, ?> b) {
                b.designation(instance.designation);
                b.skills(instance.skills);
                b.slack(instance.slack);
                b.jira(instance.jira);
                b.invitedAt(instance.invitedAt);
                b.invitedBy(instance.invitedBy);
                b.invitedByName(instance.invitedByName);
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Generated
            public B designation(List<String> designation) {
                this.designation = designation;
                return (B)this.self();
            }

            @Generated
            public B skills(List<String> skills) {
                this.skills = skills;
                return (B)this.self();
            }

            @Generated
            public B slack(List<String> slack) {
                this.slack = slack;
                return (B)this.self();
            }

            @Generated
            public B jira(List<String> jira) {
                this.jira = jira;
                return (B)this.self();
            }

            @Generated
            public B invitedAt(List<String> invitedAt) {
                this.invitedAt = invitedAt;
                return (B)this.self();
            }

            @Generated
            public B invitedBy(List<String> invitedBy) {
                this.invitedBy = invitedBy;
                return (B)this.self();
            }

            @Generated
            public B invitedByName(List<String> invitedByName) {
                this.invitedByName = invitedByName;
                return (B)this.self();
            }

            @Override
            @Generated
            public String toString() {
                return "AtlanUser.UserAttributes.UserAttributesBuilder(super=" + super.toString() + ", designation=" + this.designation + ", skills=" + this.skills + ", slack=" + this.slack + ", jira=" + this.jira + ", invitedAt=" + this.invitedAt + ", invitedBy=" + this.invitedBy + ", invitedByName=" + this.invitedByName + ")";
            }
        }
    }
}

