/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.admin;

import com.atlan.api.PersonasEndpoint;
import com.atlan.exception.AtlanException;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.admin.AbstractPolicy;
import com.atlan.model.admin.GlossaryPolicy;
import com.atlan.model.admin.PersonaDataPolicy;
import com.atlan.model.admin.PersonaMetadataPolicy;
import com.atlan.model.admin.PersonaResponse;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.enums.AssetSidebarTab;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

@JsonDeserialize(builder=PersonaBuilderImpl.class)
public class Persona
extends AtlanObject {
    private static final long serialVersionUID = 2L;
    String id;
    String name;
    String displayName;
    String description;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    SortedSet<String> groups;
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    SortedSet<String> users;
    SortedSet<String> apikeys;
    String personaType;
    SortedSet<PersonaMetadataPolicy> metadataPolicies;
    SortedSet<PersonaDataPolicy> dataPolicies;
    SortedSet<GlossaryPolicy> glossaryPolicies;
    Boolean enabled;
    final Long createdAt;
    final String createdBy;
    final String updatedAt;
    final String updatedBy;
    final String type;
    final String level;
    String version;
    @JsonIgnore
    String readme;
    @JsonIgnore
    String resources;
    PersonaAttributes attributes;

    public static PersonaBuilder<?, ?> creator(String name) {
        return ((PersonaBuilder)Persona.builder().name(name)).displayName(name);
    }

    public static PersonaBuilder<?, ?> updater(String id, String name) {
        return ((PersonaBuilder)Persona.builder().id(id)).name(name);
    }

    public Persona create() throws AtlanException {
        return PersonasEndpoint.createPersona(this);
    }

    public void update() throws AtlanException {
        if (this.id == null || this.id.length() == 0) {
            throw new InvalidRequestException("An id must be provided to update the persona.", "id", "ATLAN_JAVA_CLIENT-400-501", 400, null);
        }
        PersonasEndpoint.updatePersona(this.id, this);
    }

    public AbstractPolicy addPolicy(AbstractPolicy policy) throws AtlanException {
        if (this.id == null || this.id.length() == 0) {
            throw new InvalidRequestException("An id must be provided to add policies to the persona.", "id", "ATLAN_JAVA_CLIENT-400-502", 400, null);
        }
        return PersonasEndpoint.addPolicyToPersona(this.id, policy);
    }

    public static void delete(String id) throws AtlanException {
        PersonasEndpoint.deletePersona(id);
    }

    public static List<Persona> retrieveAll() throws AtlanException {
        PersonaResponse response = PersonasEndpoint.getAllPersonas();
        if (response != null && response.getRecords() != null) {
            return response.getRecords();
        }
        return Collections.emptyList();
    }

    public static Persona retrieveByName(String displayName) throws AtlanException {
        PersonaResponse response = PersonasEndpoint.getPersonas("{\"displayName\":\"" + displayName + "\"}");
        if (response != null && response.getRecords() != null) {
            return response.getRecords().get(0);
        }
        return null;
    }

    @Generated
    private static String $default$personaType() {
        return "persona";
    }

    @Generated
    protected Persona(PersonaBuilder<?, ?> b) {
        super(b);
        this.id = b.id;
        this.name = b.name;
        this.displayName = b.displayName;
        this.description = b.description;
        SortedSet<String> groups = new TreeSet<String>();
        if (b.groups != null) {
            groups.addAll(b.groups);
        }
        groups = Collections.unmodifiableSortedSet(groups);
        this.groups = groups;
        SortedSet<String> users = new TreeSet<String>();
        if (b.users != null) {
            users.addAll(b.users);
        }
        users = Collections.unmodifiableSortedSet(users);
        this.users = users;
        SortedSet<String> apikeys = new TreeSet<String>();
        if (b.apikeys != null) {
            apikeys.addAll(b.apikeys);
        }
        apikeys = Collections.unmodifiableSortedSet(apikeys);
        this.apikeys = apikeys;
        this.personaType = b.personaType$set ? b.personaType$value : Persona.$default$personaType();
        SortedSet<PersonaMetadataPolicy> metadataPolicies = new TreeSet<PersonaMetadataPolicy>();
        if (b.metadataPolicies != null) {
            metadataPolicies.addAll(b.metadataPolicies);
        }
        metadataPolicies = Collections.unmodifiableSortedSet(metadataPolicies);
        this.metadataPolicies = metadataPolicies;
        SortedSet<PersonaDataPolicy> dataPolicies = new TreeSet<PersonaDataPolicy>();
        if (b.dataPolicies != null) {
            dataPolicies.addAll(b.dataPolicies);
        }
        dataPolicies = Collections.unmodifiableSortedSet(dataPolicies);
        this.dataPolicies = dataPolicies;
        SortedSet<GlossaryPolicy> glossaryPolicies = new TreeSet<GlossaryPolicy>();
        if (b.glossaryPolicies != null) {
            glossaryPolicies.addAll(b.glossaryPolicies);
        }
        glossaryPolicies = Collections.unmodifiableSortedSet(glossaryPolicies);
        this.glossaryPolicies = glossaryPolicies;
        this.enabled = b.enabled;
        this.createdAt = b.createdAt;
        this.createdBy = b.createdBy;
        this.updatedAt = b.updatedAt;
        this.updatedBy = b.updatedBy;
        this.type = b.type;
        this.level = b.level;
        this.version = b.version;
        this.readme = b.readme;
        this.resources = b.resources;
        this.attributes = b.attributes;
    }

    @Generated
    public static PersonaBuilder<?, ?> builder() {
        return new PersonaBuilderImpl();
    }

    @Generated
    public PersonaBuilder<?, ?> toBuilder() {
        return new PersonaBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public SortedSet<String> getGroups() {
        return this.groups;
    }

    @Generated
    public SortedSet<String> getUsers() {
        return this.users;
    }

    @Generated
    public SortedSet<String> getApikeys() {
        return this.apikeys;
    }

    @Generated
    public String getPersonaType() {
        return this.personaType;
    }

    @Generated
    public SortedSet<PersonaMetadataPolicy> getMetadataPolicies() {
        return this.metadataPolicies;
    }

    @Generated
    public SortedSet<PersonaDataPolicy> getDataPolicies() {
        return this.dataPolicies;
    }

    @Generated
    public SortedSet<GlossaryPolicy> getGlossaryPolicies() {
        return this.glossaryPolicies;
    }

    @Generated
    public Boolean getEnabled() {
        return this.enabled;
    }

    @Generated
    public Long getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public String getCreatedBy() {
        return this.createdBy;
    }

    @Generated
    public String getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getLevel() {
        return this.level;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public String getReadme() {
        return this.readme;
    }

    @Generated
    public String getResources() {
        return this.resources;
    }

    @Generated
    public PersonaAttributes getAttributes() {
        return this.attributes;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setGroups(SortedSet<String> groups) {
        this.groups = groups;
    }

    @Generated
    public void setUsers(SortedSet<String> users) {
        this.users = users;
    }

    @Generated
    public void setApikeys(SortedSet<String> apikeys) {
        this.apikeys = apikeys;
    }

    @Generated
    public void setPersonaType(String personaType) {
        this.personaType = personaType;
    }

    @Generated
    public void setMetadataPolicies(SortedSet<PersonaMetadataPolicy> metadataPolicies) {
        this.metadataPolicies = metadataPolicies;
    }

    @Generated
    public void setDataPolicies(SortedSet<PersonaDataPolicy> dataPolicies) {
        this.dataPolicies = dataPolicies;
    }

    @Generated
    public void setGlossaryPolicies(SortedSet<GlossaryPolicy> glossaryPolicies) {
        this.glossaryPolicies = glossaryPolicies;
    }

    @Generated
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setVersion(String version) {
        this.version = version;
    }

    @JsonIgnore
    @Generated
    public void setReadme(String readme) {
        this.readme = readme;
    }

    @JsonIgnore
    @Generated
    public void setResources(String resources) {
        this.resources = resources;
    }

    @Generated
    public void setAttributes(PersonaAttributes attributes) {
        this.attributes = attributes;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Persona)) {
            return false;
        }
        Persona other = (Persona)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Long this$createdAt = this.getCreatedAt();
        Long other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        SortedSet<String> this$groups = this.getGroups();
        SortedSet<String> other$groups = other.getGroups();
        if (this$groups == null ? other$groups != null : !this$groups.equals(other$groups)) {
            return false;
        }
        SortedSet<String> this$users = this.getUsers();
        SortedSet<String> other$users = other.getUsers();
        if (this$users == null ? other$users != null : !this$users.equals(other$users)) {
            return false;
        }
        SortedSet<String> this$apikeys = this.getApikeys();
        SortedSet<String> other$apikeys = other.getApikeys();
        if (this$apikeys == null ? other$apikeys != null : !this$apikeys.equals(other$apikeys)) {
            return false;
        }
        String this$personaType = this.getPersonaType();
        String other$personaType = other.getPersonaType();
        if (this$personaType == null ? other$personaType != null : !this$personaType.equals(other$personaType)) {
            return false;
        }
        SortedSet<PersonaMetadataPolicy> this$metadataPolicies = this.getMetadataPolicies();
        SortedSet<PersonaMetadataPolicy> other$metadataPolicies = other.getMetadataPolicies();
        if (this$metadataPolicies == null ? other$metadataPolicies != null : !this$metadataPolicies.equals(other$metadataPolicies)) {
            return false;
        }
        SortedSet<PersonaDataPolicy> this$dataPolicies = this.getDataPolicies();
        SortedSet<PersonaDataPolicy> other$dataPolicies = other.getDataPolicies();
        if (this$dataPolicies == null ? other$dataPolicies != null : !this$dataPolicies.equals(other$dataPolicies)) {
            return false;
        }
        SortedSet<GlossaryPolicy> this$glossaryPolicies = this.getGlossaryPolicies();
        SortedSet<GlossaryPolicy> other$glossaryPolicies = other.getGlossaryPolicies();
        if (this$glossaryPolicies == null ? other$glossaryPolicies != null : !this$glossaryPolicies.equals(other$glossaryPolicies)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        String this$updatedAt = this.getUpdatedAt();
        String other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !this$updatedAt.equals(other$updatedAt)) {
            return false;
        }
        String this$updatedBy = this.getUpdatedBy();
        String other$updatedBy = other.getUpdatedBy();
        if (this$updatedBy == null ? other$updatedBy != null : !this$updatedBy.equals(other$updatedBy)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$level = this.getLevel();
        String other$level = other.getLevel();
        if (this$level == null ? other$level != null : !this$level.equals(other$level)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$readme = this.getReadme();
        String other$readme = other.getReadme();
        if (this$readme == null ? other$readme != null : !this$readme.equals(other$readme)) {
            return false;
        }
        String this$resources = this.getResources();
        String other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !this$resources.equals(other$resources)) {
            return false;
        }
        PersonaAttributes this$attributes = this.getAttributes();
        PersonaAttributes other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Persona;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Long $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        SortedSet<String> $groups = this.getGroups();
        result = result * 59 + ($groups == null ? 43 : $groups.hashCode());
        SortedSet<String> $users = this.getUsers();
        result = result * 59 + ($users == null ? 43 : $users.hashCode());
        SortedSet<String> $apikeys = this.getApikeys();
        result = result * 59 + ($apikeys == null ? 43 : $apikeys.hashCode());
        String $personaType = this.getPersonaType();
        result = result * 59 + ($personaType == null ? 43 : $personaType.hashCode());
        SortedSet<PersonaMetadataPolicy> $metadataPolicies = this.getMetadataPolicies();
        result = result * 59 + ($metadataPolicies == null ? 43 : $metadataPolicies.hashCode());
        SortedSet<PersonaDataPolicy> $dataPolicies = this.getDataPolicies();
        result = result * 59 + ($dataPolicies == null ? 43 : $dataPolicies.hashCode());
        SortedSet<GlossaryPolicy> $glossaryPolicies = this.getGlossaryPolicies();
        result = result * 59 + ($glossaryPolicies == null ? 43 : $glossaryPolicies.hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        String $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : $updatedAt.hashCode());
        String $updatedBy = this.getUpdatedBy();
        result = result * 59 + ($updatedBy == null ? 43 : $updatedBy.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : $level.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $readme = this.getReadme();
        result = result * 59 + ($readme == null ? 43 : $readme.hashCode());
        String $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : $resources.hashCode());
        PersonaAttributes $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    static final class PersonaBuilderImpl
    extends PersonaBuilder<Persona, PersonaBuilderImpl> {
        @Generated
        private PersonaBuilderImpl() {
        }

        @Override
        @Generated
        protected PersonaBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Persona build() {
            return new Persona(this);
        }
    }

    @Generated
    public static abstract class PersonaBuilder<C extends Persona, B extends PersonaBuilder<C, B>>
    extends AtlanObject.AtlanObjectBuilder<C, B> {
        @Generated
        private String id;
        @Generated
        private String name;
        @Generated
        private String displayName;
        @Generated
        private String description;
        @Generated
        private ArrayList<String> groups;
        @Generated
        private ArrayList<String> users;
        @Generated
        private ArrayList<String> apikeys;
        @Generated
        private boolean personaType$set;
        @Generated
        private String personaType$value;
        @Generated
        private ArrayList<PersonaMetadataPolicy> metadataPolicies;
        @Generated
        private ArrayList<PersonaDataPolicy> dataPolicies;
        @Generated
        private ArrayList<GlossaryPolicy> glossaryPolicies;
        @Generated
        private Boolean enabled;
        @Generated
        private Long createdAt;
        @Generated
        private String createdBy;
        @Generated
        private String updatedAt;
        @Generated
        private String updatedBy;
        @Generated
        private String type;
        @Generated
        private String level;
        @Generated
        private String version;
        @Generated
        private String readme;
        @Generated
        private String resources;
        @Generated
        private PersonaAttributes attributes;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            PersonaBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Persona instance, PersonaBuilder<?, ?> b) {
            b.id(instance.id);
            b.name(instance.name);
            b.displayName(instance.displayName);
            b.description(instance.description);
            b.groups(instance.groups == null ? Collections.emptySortedSet() : instance.groups);
            b.users(instance.users == null ? Collections.emptySortedSet() : instance.users);
            b.apikeys(instance.apikeys == null ? Collections.emptySortedSet() : instance.apikeys);
            b.personaType(instance.personaType);
            b.metadataPolicies(instance.metadataPolicies == null ? Collections.emptySortedSet() : instance.metadataPolicies);
            b.dataPolicies(instance.dataPolicies == null ? Collections.emptySortedSet() : instance.dataPolicies);
            b.glossaryPolicies(instance.glossaryPolicies == null ? Collections.emptySortedSet() : instance.glossaryPolicies);
            b.enabled(instance.enabled);
            b.createdAt(instance.createdAt);
            b.createdBy(instance.createdBy);
            b.updatedAt(instance.updatedAt);
            b.updatedBy(instance.updatedBy);
            b.type(instance.type);
            b.level(instance.level);
            b.version(instance.version);
            b.readme(instance.readme);
            b.resources(instance.resources);
            b.attributes(instance.attributes);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B id(String id) {
            this.id = id;
            return (B)this.self();
        }

        @Generated
        public B name(String name) {
            this.name = name;
            return (B)this.self();
        }

        @Generated
        public B displayName(String displayName) {
            this.displayName = displayName;
            return (B)this.self();
        }

        @Generated
        public B description(String description) {
            this.description = description;
            return (B)this.self();
        }

        @Generated
        public B group(String group) {
            if (this.groups == null) {
                this.groups = new ArrayList();
            }
            this.groups.add(group);
            return (B)this.self();
        }

        @Generated
        public B groups(Collection<? extends String> groups) {
            if (groups == null) {
                throw new NullPointerException("groups cannot be null");
            }
            if (this.groups == null) {
                this.groups = new ArrayList();
            }
            this.groups.addAll(groups);
            return (B)this.self();
        }

        @Generated
        public B clearGroups() {
            if (this.groups != null) {
                this.groups.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B user(String user) {
            if (this.users == null) {
                this.users = new ArrayList();
            }
            this.users.add(user);
            return (B)this.self();
        }

        @Generated
        public B users(Collection<? extends String> users) {
            if (users == null) {
                throw new NullPointerException("users cannot be null");
            }
            if (this.users == null) {
                this.users = new ArrayList();
            }
            this.users.addAll(users);
            return (B)this.self();
        }

        @Generated
        public B clearUsers() {
            if (this.users != null) {
                this.users.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B apikey(String apikey) {
            if (this.apikeys == null) {
                this.apikeys = new ArrayList();
            }
            this.apikeys.add(apikey);
            return (B)this.self();
        }

        @Generated
        public B apikeys(Collection<? extends String> apikeys) {
            if (apikeys == null) {
                throw new NullPointerException("apikeys cannot be null");
            }
            if (this.apikeys == null) {
                this.apikeys = new ArrayList();
            }
            this.apikeys.addAll(apikeys);
            return (B)this.self();
        }

        @Generated
        public B clearApikeys() {
            if (this.apikeys != null) {
                this.apikeys.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B personaType(String personaType) {
            this.personaType$value = personaType;
            this.personaType$set = true;
            return (B)this.self();
        }

        @Generated
        public B metadataPolicy(PersonaMetadataPolicy metadataPolicy) {
            if (this.metadataPolicies == null) {
                this.metadataPolicies = new ArrayList();
            }
            this.metadataPolicies.add(metadataPolicy);
            return (B)this.self();
        }

        @Generated
        public B metadataPolicies(Collection<? extends PersonaMetadataPolicy> metadataPolicies) {
            if (metadataPolicies == null) {
                throw new NullPointerException("metadataPolicies cannot be null");
            }
            if (this.metadataPolicies == null) {
                this.metadataPolicies = new ArrayList();
            }
            this.metadataPolicies.addAll(metadataPolicies);
            return (B)this.self();
        }

        @Generated
        public B clearMetadataPolicies() {
            if (this.metadataPolicies != null) {
                this.metadataPolicies.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dataPolicy(PersonaDataPolicy dataPolicy) {
            if (this.dataPolicies == null) {
                this.dataPolicies = new ArrayList();
            }
            this.dataPolicies.add(dataPolicy);
            return (B)this.self();
        }

        @Generated
        public B dataPolicies(Collection<? extends PersonaDataPolicy> dataPolicies) {
            if (dataPolicies == null) {
                throw new NullPointerException("dataPolicies cannot be null");
            }
            if (this.dataPolicies == null) {
                this.dataPolicies = new ArrayList();
            }
            this.dataPolicies.addAll(dataPolicies);
            return (B)this.self();
        }

        @Generated
        public B clearDataPolicies() {
            if (this.dataPolicies != null) {
                this.dataPolicies.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B glossaryPolicy(GlossaryPolicy glossaryPolicy) {
            if (this.glossaryPolicies == null) {
                this.glossaryPolicies = new ArrayList();
            }
            this.glossaryPolicies.add(glossaryPolicy);
            return (B)this.self();
        }

        @Generated
        public B glossaryPolicies(Collection<? extends GlossaryPolicy> glossaryPolicies) {
            if (glossaryPolicies == null) {
                throw new NullPointerException("glossaryPolicies cannot be null");
            }
            if (this.glossaryPolicies == null) {
                this.glossaryPolicies = new ArrayList();
            }
            this.glossaryPolicies.addAll(glossaryPolicies);
            return (B)this.self();
        }

        @Generated
        public B clearGlossaryPolicies() {
            if (this.glossaryPolicies != null) {
                this.glossaryPolicies.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B enabled(Boolean enabled) {
            this.enabled = enabled;
            return (B)this.self();
        }

        @Generated
        public B createdAt(Long createdAt) {
            this.createdAt = createdAt;
            return (B)this.self();
        }

        @Generated
        public B createdBy(String createdBy) {
            this.createdBy = createdBy;
            return (B)this.self();
        }

        @Generated
        public B updatedAt(String updatedAt) {
            this.updatedAt = updatedAt;
            return (B)this.self();
        }

        @Generated
        public B updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return (B)this.self();
        }

        @Generated
        public B type(String type) {
            this.type = type;
            return (B)this.self();
        }

        @Generated
        public B level(String level) {
            this.level = level;
            return (B)this.self();
        }

        @Generated
        public B version(String version) {
            this.version = version;
            return (B)this.self();
        }

        @JsonIgnore
        @Generated
        public B readme(String readme) {
            this.readme = readme;
            return (B)this.self();
        }

        @JsonIgnore
        @Generated
        public B resources(String resources) {
            this.resources = resources;
            return (B)this.self();
        }

        @Generated
        public B attributes(PersonaAttributes attributes) {
            this.attributes = attributes;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "Persona.PersonaBuilder(super=" + super.toString() + ", id=" + this.id + ", name=" + this.name + ", displayName=" + this.displayName + ", description=" + this.description + ", groups=" + this.groups + ", users=" + this.users + ", apikeys=" + this.apikeys + ", personaType$value=" + this.personaType$value + ", metadataPolicies=" + this.metadataPolicies + ", dataPolicies=" + this.dataPolicies + ", glossaryPolicies=" + this.glossaryPolicies + ", enabled=" + this.enabled + ", createdAt=" + this.createdAt + ", createdBy=" + this.createdBy + ", updatedAt=" + this.updatedAt + ", updatedBy=" + this.updatedBy + ", type=" + this.type + ", level=" + this.level + ", version=" + this.version + ", readme=" + this.readme + ", resources=" + this.resources + ", attributes=" + this.attributes + ")";
        }
    }

    @JsonDeserialize(builder=PersonaPreferencesBuilderImpl.class)
    public static final class PersonaPreferences
    extends AtlanObject {
        private static final long serialVersionUID = 2L;
        SortedSet<AssetSidebarTab> assetTabsDenyList;
        SortedSet<String> customMetadataDenyList;

        @Generated
        protected PersonaPreferences(PersonaPreferencesBuilder<?, ?> b) {
            super(b);
            SortedSet<AssetSidebarTab> assetTabsDenyList = new TreeSet<AssetSidebarTab>();
            if (b.assetTabsDenyList != null) {
                assetTabsDenyList.addAll(b.assetTabsDenyList);
            }
            assetTabsDenyList = Collections.unmodifiableSortedSet(assetTabsDenyList);
            this.assetTabsDenyList = assetTabsDenyList;
            SortedSet<String> customMetadataDenyList = new TreeSet<String>();
            if (b.customMetadataDenyList != null) {
                customMetadataDenyList.addAll(b.customMetadataDenyList);
            }
            customMetadataDenyList = Collections.unmodifiableSortedSet(customMetadataDenyList);
            this.customMetadataDenyList = customMetadataDenyList;
        }

        @Generated
        public static PersonaPreferencesBuilder<?, ?> builder() {
            return new PersonaPreferencesBuilderImpl();
        }

        @Generated
        public PersonaPreferencesBuilder<?, ?> toBuilder() {
            return new PersonaPreferencesBuilderImpl().$fillValuesFrom(this);
        }

        @Generated
        public SortedSet<AssetSidebarTab> getAssetTabsDenyList() {
            return this.assetTabsDenyList;
        }

        @Generated
        public SortedSet<String> getCustomMetadataDenyList() {
            return this.customMetadataDenyList;
        }

        @Generated
        public void setAssetTabsDenyList(SortedSet<AssetSidebarTab> assetTabsDenyList) {
            this.assetTabsDenyList = assetTabsDenyList;
        }

        @Generated
        public void setCustomMetadataDenyList(SortedSet<String> customMetadataDenyList) {
            this.customMetadataDenyList = customMetadataDenyList;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PersonaPreferences)) {
                return false;
            }
            PersonaPreferences other = (PersonaPreferences)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            SortedSet<AssetSidebarTab> this$assetTabsDenyList = this.getAssetTabsDenyList();
            SortedSet<AssetSidebarTab> other$assetTabsDenyList = other.getAssetTabsDenyList();
            if (this$assetTabsDenyList == null ? other$assetTabsDenyList != null : !this$assetTabsDenyList.equals(other$assetTabsDenyList)) {
                return false;
            }
            SortedSet<String> this$customMetadataDenyList = this.getCustomMetadataDenyList();
            SortedSet<String> other$customMetadataDenyList = other.getCustomMetadataDenyList();
            return !(this$customMetadataDenyList == null ? other$customMetadataDenyList != null : !this$customMetadataDenyList.equals(other$customMetadataDenyList));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PersonaPreferences;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            SortedSet<AssetSidebarTab> $assetTabsDenyList = this.getAssetTabsDenyList();
            result = result * 59 + ($assetTabsDenyList == null ? 43 : $assetTabsDenyList.hashCode());
            SortedSet<String> $customMetadataDenyList = this.getCustomMetadataDenyList();
            result = result * 59 + ($customMetadataDenyList == null ? 43 : $customMetadataDenyList.hashCode());
            return result;
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        static final class PersonaPreferencesBuilderImpl
        extends PersonaPreferencesBuilder<PersonaPreferences, PersonaPreferencesBuilderImpl> {
            @Generated
            private PersonaPreferencesBuilderImpl() {
            }

            @Override
            @Generated
            protected PersonaPreferencesBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public PersonaPreferences build() {
                return new PersonaPreferences(this);
            }
        }

        @Generated
        public static abstract class PersonaPreferencesBuilder<C extends PersonaPreferences, B extends PersonaPreferencesBuilder<C, B>>
        extends AtlanObject.AtlanObjectBuilder<C, B> {
            @Generated
            private ArrayList<AssetSidebarTab> assetTabsDenyList;
            @Generated
            private ArrayList<String> customMetadataDenyList;

            @Override
            @Generated
            protected B $fillValuesFrom(C instance) {
                super.$fillValuesFrom(instance);
                PersonaPreferencesBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return (B)this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(PersonaPreferences instance, PersonaPreferencesBuilder<?, ?> b) {
                b.assetTabsDenyList(instance.assetTabsDenyList == null ? Collections.emptySortedSet() : instance.assetTabsDenyList);
                b.customMetadataDenyList(instance.customMetadataDenyList == null ? Collections.emptySortedSet() : instance.customMetadataDenyList);
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Generated
            public B assetTabDeny(AssetSidebarTab assetTabDeny) {
                if (this.assetTabsDenyList == null) {
                    this.assetTabsDenyList = new ArrayList();
                }
                this.assetTabsDenyList.add(assetTabDeny);
                return (B)this.self();
            }

            @Generated
            public B assetTabsDenyList(Collection<? extends AssetSidebarTab> assetTabsDenyList) {
                if (assetTabsDenyList == null) {
                    throw new NullPointerException("assetTabsDenyList cannot be null");
                }
                if (this.assetTabsDenyList == null) {
                    this.assetTabsDenyList = new ArrayList();
                }
                this.assetTabsDenyList.addAll(assetTabsDenyList);
                return (B)this.self();
            }

            @Generated
            public B clearAssetTabsDenyList() {
                if (this.assetTabsDenyList != null) {
                    this.assetTabsDenyList.clear();
                }
                return (B)this.self();
            }

            @Generated
            public B customMetadataDeny(String customMetadataDeny) {
                if (this.customMetadataDenyList == null) {
                    this.customMetadataDenyList = new ArrayList();
                }
                this.customMetadataDenyList.add(customMetadataDeny);
                return (B)this.self();
            }

            @Generated
            public B customMetadataDenyList(Collection<? extends String> customMetadataDenyList) {
                if (customMetadataDenyList == null) {
                    throw new NullPointerException("customMetadataDenyList cannot be null");
                }
                if (this.customMetadataDenyList == null) {
                    this.customMetadataDenyList = new ArrayList();
                }
                this.customMetadataDenyList.addAll(customMetadataDenyList);
                return (B)this.self();
            }

            @Generated
            public B clearCustomMetadataDenyList() {
                if (this.customMetadataDenyList != null) {
                    this.customMetadataDenyList.clear();
                }
                return (B)this.self();
            }

            @Override
            @Generated
            public String toString() {
                return "Persona.PersonaPreferences.PersonaPreferencesBuilder(super=" + super.toString() + ", assetTabsDenyList=" + this.assetTabsDenyList + ", customMetadataDenyList=" + this.customMetadataDenyList + ")";
            }
        }
    }

    @JsonDeserialize(builder=PersonaAttributesBuilderImpl.class)
    public static final class PersonaAttributes
    extends AtlanObject {
        private static final long serialVersionUID = 2L;
        PersonaPreferences preferences;

        @Generated
        protected PersonaAttributes(PersonaAttributesBuilder<?, ?> b) {
            super(b);
            this.preferences = b.preferences;
        }

        @Generated
        public static PersonaAttributesBuilder<?, ?> builder() {
            return new PersonaAttributesBuilderImpl();
        }

        @Generated
        public PersonaAttributesBuilder<?, ?> toBuilder() {
            return new PersonaAttributesBuilderImpl().$fillValuesFrom(this);
        }

        @Generated
        public PersonaPreferences getPreferences() {
            return this.preferences;
        }

        @Generated
        public void setPreferences(PersonaPreferences preferences) {
            this.preferences = preferences;
        }

        @Override
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PersonaAttributes)) {
                return false;
            }
            PersonaAttributes other = (PersonaAttributes)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            PersonaPreferences this$preferences = this.getPreferences();
            PersonaPreferences other$preferences = other.getPreferences();
            return !(this$preferences == null ? other$preferences != null : !((Object)this$preferences).equals(other$preferences));
        }

        @Override
        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PersonaAttributes;
        }

        @Override
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            PersonaPreferences $preferences = this.getPreferences();
            result = result * 59 + ($preferences == null ? 43 : ((Object)$preferences).hashCode());
            return result;
        }

        @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
        @Generated
        static final class PersonaAttributesBuilderImpl
        extends PersonaAttributesBuilder<PersonaAttributes, PersonaAttributesBuilderImpl> {
            @Generated
            private PersonaAttributesBuilderImpl() {
            }

            @Override
            @Generated
            protected PersonaAttributesBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public PersonaAttributes build() {
                return new PersonaAttributes(this);
            }
        }

        @Generated
        public static abstract class PersonaAttributesBuilder<C extends PersonaAttributes, B extends PersonaAttributesBuilder<C, B>>
        extends AtlanObject.AtlanObjectBuilder<C, B> {
            @Generated
            private PersonaPreferences preferences;

            @Override
            @Generated
            protected B $fillValuesFrom(C instance) {
                super.$fillValuesFrom(instance);
                PersonaAttributesBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
                return (B)this.self();
            }

            @Generated
            private static void $fillValuesFromInstanceIntoBuilder(PersonaAttributes instance, PersonaAttributesBuilder<?, ?> b) {
                b.preferences(instance.preferences);
            }

            @Override
            @Generated
            protected abstract B self();

            @Override
            @Generated
            public abstract C build();

            @Generated
            public B preferences(PersonaPreferences preferences) {
                this.preferences = preferences;
                return (B)this.self();
            }

            @Override
            @Generated
            public String toString() {
                return "Persona.PersonaAttributes.PersonaAttributesBuilder(super=" + super.toString() + ", preferences=" + this.preferences + ")";
            }
        }
    }
}

