/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.API;
import com.atlan.model.assets.APISpec;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class APIPath
extends API {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "APIPath";
    String typeName;
    @Attribute
    String apiPathSummary;
    @Attribute
    String apiPathRawURI;
    @Attribute
    Boolean apiPathIsTemplated;
    @Attribute
    SortedSet<String> apiPathAvailableOperations;
    @Attribute
    Map<String, String> apiPathAvailableResponseCodes;
    @Attribute
    Boolean apiPathIsIngressExposed;
    @Attribute
    APISpec apiSpec;

    public static APIPath refByGuid(String guid) {
        return ((APIPathBuilder)APIPath.builder().guid(guid)).build();
    }

    public static APIPath refByQualifiedName(String qualifiedName) {
        return ((APIPathBuilder)APIPath.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static APIPathBuilder<?, ?> creator(String pathURI, String apiSpecQualifiedName) {
        String connectionQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(apiSpecQualifiedName);
        Object normalizedURI = pathURI.startsWith("/") ? pathURI : "/" + pathURI;
        return (APIPathBuilder)((APIPathBuilder)((Asset.AssetBuilder)((APIPathBuilder)((APIPathBuilder)((APIPathBuilder)APIPath.builder().qualifiedName(apiSpecQualifiedName + (String)normalizedURI)).name((String)normalizedURI)).apiPathRawURI((String)normalizedURI)).apiSpec(APISpec.refByQualifiedName(apiSpecQualifiedName))).connectionQualifiedName(connectionQualifiedName)).connectorType(AtlanConnectorType.API);
    }

    public static APIPathBuilder<?, ?> updater(String qualifiedName, String name) {
        return (APIPathBuilder)((APIPathBuilder)APIPath.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected APIPathBuilder<?, ?> trimToRequired() {
        return APIPath.updater(this.getQualifiedName(), this.getName());
    }

    public static APIPath retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof APIPath) {
            return (APIPath)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a APIPath.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static APIPath retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof APIPath) {
            return (APIPath)entity;
        }
        throw new NotFoundException("No APIPath found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static APIPath removeDescription(String qualifiedName, String name) throws AtlanException {
        return (APIPath)Asset.removeDescription(((APIPathBuilder)APIPath.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static APIPath removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (APIPath)Asset.removeUserDescription(((APIPathBuilder)APIPath.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static APIPath removeOwners(String qualifiedName, String name) throws AtlanException {
        return (APIPath)Asset.removeOwners(((APIPathBuilder)APIPath.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static APIPath updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (APIPath)Asset.updateCertificate(APIPath.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static APIPath removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (APIPath)Asset.removeCertificate(((APIPathBuilder)APIPath.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static APIPath updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (APIPath)Asset.updateAnnouncement(APIPath.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static APIPath removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (APIPath)Asset.removeAnnouncement(((APIPathBuilder)APIPath.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static APIPath replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (APIPath)Asset.replaceTerms(APIPath.updater(qualifiedName, name), terms);
    }

    public static APIPath appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (APIPath)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static APIPath removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (APIPath)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected APIPath(APIPathBuilder<?, ?> b) {
        super((API.APIBuilder<?, ?>)b);
        Map<Object, Object> apiPathAvailableResponseCodes;
        this.typeName = b.typeName$set ? b.typeName$value : APIPath.$default$typeName();
        this.apiPathSummary = b.apiPathSummary;
        this.apiPathRawURI = b.apiPathRawURI;
        this.apiPathIsTemplated = b.apiPathIsTemplated;
        SortedSet<String> apiPathAvailableOperations = new TreeSet<String>();
        if (b.apiPathAvailableOperations != null) {
            apiPathAvailableOperations.addAll(b.apiPathAvailableOperations);
        }
        apiPathAvailableOperations = Collections.unmodifiableSortedSet(apiPathAvailableOperations);
        this.apiPathAvailableOperations = apiPathAvailableOperations;
        switch (b.apiPathAvailableResponseCodes$key == null ? 0 : b.apiPathAvailableResponseCodes$key.size()) {
            case 0: {
                apiPathAvailableResponseCodes = Collections.emptyMap();
                break;
            }
            case 1: {
                apiPathAvailableResponseCodes = Collections.singletonMap(b.apiPathAvailableResponseCodes$key.get(0), b.apiPathAvailableResponseCodes$value.get(0));
                break;
            }
            default: {
                apiPathAvailableResponseCodes = new LinkedHashMap(b.apiPathAvailableResponseCodes$key.size() < 0x40000000 ? 1 + b.apiPathAvailableResponseCodes$key.size() + (b.apiPathAvailableResponseCodes$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.apiPathAvailableResponseCodes$key.size(); ++$i) {
                    apiPathAvailableResponseCodes.put(b.apiPathAvailableResponseCodes$key.get($i), b.apiPathAvailableResponseCodes$value.get($i));
                }
                apiPathAvailableResponseCodes = Collections.unmodifiableMap(apiPathAvailableResponseCodes);
            }
        }
        this.apiPathAvailableResponseCodes = apiPathAvailableResponseCodes;
        this.apiPathIsIngressExposed = b.apiPathIsIngressExposed;
        this.apiSpec = b.apiSpec;
    }

    @Generated
    public static APIPathBuilder<?, ?> builder() {
        return new APIPathBuilderImpl();
    }

    @Generated
    public APIPathBuilder<?, ?> toBuilder() {
        return new APIPathBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getApiPathSummary() {
        return this.apiPathSummary;
    }

    @Generated
    public String getApiPathRawURI() {
        return this.apiPathRawURI;
    }

    @Generated
    public Boolean getApiPathIsTemplated() {
        return this.apiPathIsTemplated;
    }

    @Generated
    public SortedSet<String> getApiPathAvailableOperations() {
        return this.apiPathAvailableOperations;
    }

    @Generated
    public Map<String, String> getApiPathAvailableResponseCodes() {
        return this.apiPathAvailableResponseCodes;
    }

    @Generated
    public Boolean getApiPathIsIngressExposed() {
        return this.apiPathIsIngressExposed;
    }

    @Generated
    public APISpec getApiSpec() {
        return this.apiSpec;
    }

    @Generated
    public void setApiPathSummary(String apiPathSummary) {
        this.apiPathSummary = apiPathSummary;
    }

    @Generated
    public void setApiPathRawURI(String apiPathRawURI) {
        this.apiPathRawURI = apiPathRawURI;
    }

    @Generated
    public void setApiPathIsTemplated(Boolean apiPathIsTemplated) {
        this.apiPathIsTemplated = apiPathIsTemplated;
    }

    @Generated
    public void setApiPathAvailableOperations(SortedSet<String> apiPathAvailableOperations) {
        this.apiPathAvailableOperations = apiPathAvailableOperations;
    }

    @Generated
    public void setApiPathAvailableResponseCodes(Map<String, String> apiPathAvailableResponseCodes) {
        this.apiPathAvailableResponseCodes = apiPathAvailableResponseCodes;
    }

    @Generated
    public void setApiPathIsIngressExposed(Boolean apiPathIsIngressExposed) {
        this.apiPathIsIngressExposed = apiPathIsIngressExposed;
    }

    @Generated
    public void setApiSpec(APISpec apiSpec) {
        this.apiSpec = apiSpec;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof APIPath)) {
            return false;
        }
        APIPath other = (APIPath)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$apiPathIsTemplated = this.getApiPathIsTemplated();
        Boolean other$apiPathIsTemplated = other.getApiPathIsTemplated();
        if (this$apiPathIsTemplated == null ? other$apiPathIsTemplated != null : !((Object)this$apiPathIsTemplated).equals(other$apiPathIsTemplated)) {
            return false;
        }
        Boolean this$apiPathIsIngressExposed = this.getApiPathIsIngressExposed();
        Boolean other$apiPathIsIngressExposed = other.getApiPathIsIngressExposed();
        if (this$apiPathIsIngressExposed == null ? other$apiPathIsIngressExposed != null : !((Object)this$apiPathIsIngressExposed).equals(other$apiPathIsIngressExposed)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$apiPathSummary = this.getApiPathSummary();
        String other$apiPathSummary = other.getApiPathSummary();
        if (this$apiPathSummary == null ? other$apiPathSummary != null : !this$apiPathSummary.equals(other$apiPathSummary)) {
            return false;
        }
        String this$apiPathRawURI = this.getApiPathRawURI();
        String other$apiPathRawURI = other.getApiPathRawURI();
        if (this$apiPathRawURI == null ? other$apiPathRawURI != null : !this$apiPathRawURI.equals(other$apiPathRawURI)) {
            return false;
        }
        SortedSet<String> this$apiPathAvailableOperations = this.getApiPathAvailableOperations();
        SortedSet<String> other$apiPathAvailableOperations = other.getApiPathAvailableOperations();
        if (this$apiPathAvailableOperations == null ? other$apiPathAvailableOperations != null : !this$apiPathAvailableOperations.equals(other$apiPathAvailableOperations)) {
            return false;
        }
        Map<String, String> this$apiPathAvailableResponseCodes = this.getApiPathAvailableResponseCodes();
        Map<String, String> other$apiPathAvailableResponseCodes = other.getApiPathAvailableResponseCodes();
        if (this$apiPathAvailableResponseCodes == null ? other$apiPathAvailableResponseCodes != null : !((Object)this$apiPathAvailableResponseCodes).equals(other$apiPathAvailableResponseCodes)) {
            return false;
        }
        APISpec this$apiSpec = this.getApiSpec();
        APISpec other$apiSpec = other.getApiSpec();
        return !(this$apiSpec == null ? other$apiSpec != null : !((Object)this$apiSpec).equals(other$apiSpec));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof APIPath;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $apiPathIsTemplated = this.getApiPathIsTemplated();
        result = result * 59 + ($apiPathIsTemplated == null ? 43 : ((Object)$apiPathIsTemplated).hashCode());
        Boolean $apiPathIsIngressExposed = this.getApiPathIsIngressExposed();
        result = result * 59 + ($apiPathIsIngressExposed == null ? 43 : ((Object)$apiPathIsIngressExposed).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $apiPathSummary = this.getApiPathSummary();
        result = result * 59 + ($apiPathSummary == null ? 43 : $apiPathSummary.hashCode());
        String $apiPathRawURI = this.getApiPathRawURI();
        result = result * 59 + ($apiPathRawURI == null ? 43 : $apiPathRawURI.hashCode());
        SortedSet<String> $apiPathAvailableOperations = this.getApiPathAvailableOperations();
        result = result * 59 + ($apiPathAvailableOperations == null ? 43 : $apiPathAvailableOperations.hashCode());
        Map<String, String> $apiPathAvailableResponseCodes = this.getApiPathAvailableResponseCodes();
        result = result * 59 + ($apiPathAvailableResponseCodes == null ? 43 : ((Object)$apiPathAvailableResponseCodes).hashCode());
        APISpec $apiSpec = this.getApiSpec();
        result = result * 59 + ($apiSpec == null ? 43 : ((Object)$apiSpec).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class APIPathBuilderImpl
    extends APIPathBuilder<APIPath, APIPathBuilderImpl> {
        @Generated
        private APIPathBuilderImpl() {
        }

        @Override
        @Generated
        protected APIPathBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public APIPath build() {
            return new APIPath(this);
        }
    }

    @Generated
    public static abstract class APIPathBuilder<C extends APIPath, B extends APIPathBuilder<C, B>>
    extends API.APIBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String apiPathSummary;
        @Generated
        private String apiPathRawURI;
        @Generated
        private Boolean apiPathIsTemplated;
        @Generated
        private ArrayList<String> apiPathAvailableOperations;
        @Generated
        private ArrayList<String> apiPathAvailableResponseCodes$key;
        @Generated
        private ArrayList<String> apiPathAvailableResponseCodes$value;
        @Generated
        private Boolean apiPathIsIngressExposed;
        @Generated
        private APISpec apiSpec;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            APIPathBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(APIPath instance, APIPathBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.apiPathSummary(instance.apiPathSummary);
            b.apiPathRawURI(instance.apiPathRawURI);
            b.apiPathIsTemplated(instance.apiPathIsTemplated);
            b.apiPathAvailableOperations(instance.apiPathAvailableOperations == null ? Collections.emptySortedSet() : instance.apiPathAvailableOperations);
            b.apiPathAvailableResponseCodes(instance.apiPathAvailableResponseCodes == null ? Collections.emptyMap() : instance.apiPathAvailableResponseCodes);
            b.apiPathIsIngressExposed(instance.apiPathIsIngressExposed);
            b.apiSpec(instance.apiSpec);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B apiPathSummary(String apiPathSummary) {
            this.apiPathSummary = apiPathSummary;
            return (B)this.self();
        }

        @Generated
        public B apiPathRawURI(String apiPathRawURI) {
            this.apiPathRawURI = apiPathRawURI;
            return (B)this.self();
        }

        @Generated
        public B apiPathIsTemplated(Boolean apiPathIsTemplated) {
            this.apiPathIsTemplated = apiPathIsTemplated;
            return (B)this.self();
        }

        @Generated
        public B apiPathAvailableOperation(String apiPathAvailableOperation) {
            if (this.apiPathAvailableOperations == null) {
                this.apiPathAvailableOperations = new ArrayList();
            }
            this.apiPathAvailableOperations.add(apiPathAvailableOperation);
            return (B)this.self();
        }

        @Generated
        public B apiPathAvailableOperations(Collection<? extends String> apiPathAvailableOperations) {
            if (apiPathAvailableOperations == null) {
                throw new NullPointerException("apiPathAvailableOperations cannot be null");
            }
            if (this.apiPathAvailableOperations == null) {
                this.apiPathAvailableOperations = new ArrayList();
            }
            this.apiPathAvailableOperations.addAll(apiPathAvailableOperations);
            return (B)this.self();
        }

        @Generated
        public B clearApiPathAvailableOperations() {
            if (this.apiPathAvailableOperations != null) {
                this.apiPathAvailableOperations.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B apiPathAvailableResponseCode(String apiPathAvailableResponseCodeKey, String apiPathAvailableResponseCodeValue) {
            if (this.apiPathAvailableResponseCodes$key == null) {
                this.apiPathAvailableResponseCodes$key = new ArrayList();
                this.apiPathAvailableResponseCodes$value = new ArrayList();
            }
            this.apiPathAvailableResponseCodes$key.add(apiPathAvailableResponseCodeKey);
            this.apiPathAvailableResponseCodes$value.add(apiPathAvailableResponseCodeValue);
            return (B)this.self();
        }

        @Generated
        public B apiPathAvailableResponseCodes(Map<? extends String, ? extends String> apiPathAvailableResponseCodes) {
            if (apiPathAvailableResponseCodes == null) {
                throw new NullPointerException("apiPathAvailableResponseCodes cannot be null");
            }
            if (this.apiPathAvailableResponseCodes$key == null) {
                this.apiPathAvailableResponseCodes$key = new ArrayList();
                this.apiPathAvailableResponseCodes$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : apiPathAvailableResponseCodes.entrySet()) {
                this.apiPathAvailableResponseCodes$key.add($lombokEntry.getKey());
                this.apiPathAvailableResponseCodes$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearApiPathAvailableResponseCodes() {
            if (this.apiPathAvailableResponseCodes$key != null) {
                this.apiPathAvailableResponseCodes$key.clear();
                this.apiPathAvailableResponseCodes$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B apiPathIsIngressExposed(Boolean apiPathIsIngressExposed) {
            this.apiPathIsIngressExposed = apiPathIsIngressExposed;
            return (B)this.self();
        }

        @Generated
        public B apiSpec(APISpec apiSpec) {
            this.apiSpec = apiSpec;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "APIPath.APIPathBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", apiPathSummary=" + this.apiPathSummary + ", apiPathRawURI=" + this.apiPathRawURI + ", apiPathIsTemplated=" + this.apiPathIsTemplated + ", apiPathAvailableOperations=" + this.apiPathAvailableOperations + ", apiPathAvailableResponseCodes$key=" + this.apiPathAvailableResponseCodes$key + ", apiPathAvailableResponseCodes$value=" + this.apiPathAvailableResponseCodes$value + ", apiPathIsIngressExposed=" + this.apiPathIsIngressExposed + ", apiSpec=" + this.apiSpec + ")";
        }
    }
}

