/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.API;
import com.atlan.model.assets.APIPath;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class APISpec
extends API {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "APISpec";
    String typeName;
    @Attribute
    String apiSpecTermsOfServiceURL;
    @Attribute
    String apiSpecContactEmail;
    @Attribute
    String apiSpecContactName;
    @Attribute
    String apiSpecContactURL;
    @Attribute
    String apiSpecLicenseName;
    @Attribute
    String apiSpecLicenseURL;
    @Attribute
    String apiSpecContractVersion;
    @Attribute
    String apiSpecServiceAlias;
    @Attribute
    SortedSet<APIPath> apiPaths;

    public static APISpec refByGuid(String guid) {
        return ((APISpecBuilder)APISpec.builder().guid(guid)).build();
    }

    public static APISpec refByQualifiedName(String qualifiedName) {
        return ((APISpecBuilder)APISpec.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static APISpecBuilder<?, ?> creator(String name, String connectionQualifiedName) {
        return (APISpecBuilder)((APISpecBuilder)((APISpecBuilder)((APISpecBuilder)APISpec.builder().qualifiedName(connectionQualifiedName + "/" + name)).name(name)).connectionQualifiedName(connectionQualifiedName)).connectorType(AtlanConnectorType.API);
    }

    public static APISpecBuilder<?, ?> updater(String qualifiedName, String name) {
        return (APISpecBuilder)((APISpecBuilder)APISpec.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected APISpecBuilder<?, ?> trimToRequired() {
        return APISpec.updater(this.getQualifiedName(), this.getName());
    }

    public static APISpec retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof APISpec) {
            return (APISpec)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a APISpec.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static APISpec retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof APISpec) {
            return (APISpec)entity;
        }
        throw new NotFoundException("No APISpec found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static APISpec removeDescription(String qualifiedName, String name) throws AtlanException {
        return (APISpec)Asset.removeDescription(((APISpecBuilder)APISpec.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static APISpec removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (APISpec)Asset.removeUserDescription(((APISpecBuilder)APISpec.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static APISpec removeOwners(String qualifiedName, String name) throws AtlanException {
        return (APISpec)Asset.removeOwners(((APISpecBuilder)APISpec.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static APISpec updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (APISpec)Asset.updateCertificate(APISpec.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static APISpec removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (APISpec)Asset.removeCertificate(((APISpecBuilder)APISpec.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static APISpec updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (APISpec)Asset.updateAnnouncement(APISpec.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static APISpec removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (APISpec)Asset.removeAnnouncement(((APISpecBuilder)APISpec.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static APISpec replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (APISpec)Asset.replaceTerms(APISpec.updater(qualifiedName, name), terms);
    }

    public static APISpec appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (APISpec)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static APISpec removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (APISpec)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected APISpec(APISpecBuilder<?, ?> b) {
        super((API.APIBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : APISpec.$default$typeName();
        this.apiSpecTermsOfServiceURL = b.apiSpecTermsOfServiceURL;
        this.apiSpecContactEmail = b.apiSpecContactEmail;
        this.apiSpecContactName = b.apiSpecContactName;
        this.apiSpecContactURL = b.apiSpecContactURL;
        this.apiSpecLicenseName = b.apiSpecLicenseName;
        this.apiSpecLicenseURL = b.apiSpecLicenseURL;
        this.apiSpecContractVersion = b.apiSpecContractVersion;
        this.apiSpecServiceAlias = b.apiSpecServiceAlias;
        SortedSet<APIPath> apiPaths = new TreeSet<APIPath>();
        if (b.apiPaths != null) {
            apiPaths.addAll(b.apiPaths);
        }
        apiPaths = Collections.unmodifiableSortedSet(apiPaths);
        this.apiPaths = apiPaths;
    }

    @Generated
    public static APISpecBuilder<?, ?> builder() {
        return new APISpecBuilderImpl();
    }

    @Generated
    public APISpecBuilder<?, ?> toBuilder() {
        return new APISpecBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getApiSpecTermsOfServiceURL() {
        return this.apiSpecTermsOfServiceURL;
    }

    @Generated
    public String getApiSpecContactEmail() {
        return this.apiSpecContactEmail;
    }

    @Generated
    public String getApiSpecContactName() {
        return this.apiSpecContactName;
    }

    @Generated
    public String getApiSpecContactURL() {
        return this.apiSpecContactURL;
    }

    @Generated
    public String getApiSpecLicenseName() {
        return this.apiSpecLicenseName;
    }

    @Generated
    public String getApiSpecLicenseURL() {
        return this.apiSpecLicenseURL;
    }

    @Generated
    public String getApiSpecContractVersion() {
        return this.apiSpecContractVersion;
    }

    @Generated
    public String getApiSpecServiceAlias() {
        return this.apiSpecServiceAlias;
    }

    @Generated
    public SortedSet<APIPath> getApiPaths() {
        return this.apiPaths;
    }

    @Generated
    public void setApiSpecTermsOfServiceURL(String apiSpecTermsOfServiceURL) {
        this.apiSpecTermsOfServiceURL = apiSpecTermsOfServiceURL;
    }

    @Generated
    public void setApiSpecContactEmail(String apiSpecContactEmail) {
        this.apiSpecContactEmail = apiSpecContactEmail;
    }

    @Generated
    public void setApiSpecContactName(String apiSpecContactName) {
        this.apiSpecContactName = apiSpecContactName;
    }

    @Generated
    public void setApiSpecContactURL(String apiSpecContactURL) {
        this.apiSpecContactURL = apiSpecContactURL;
    }

    @Generated
    public void setApiSpecLicenseName(String apiSpecLicenseName) {
        this.apiSpecLicenseName = apiSpecLicenseName;
    }

    @Generated
    public void setApiSpecLicenseURL(String apiSpecLicenseURL) {
        this.apiSpecLicenseURL = apiSpecLicenseURL;
    }

    @Generated
    public void setApiSpecContractVersion(String apiSpecContractVersion) {
        this.apiSpecContractVersion = apiSpecContractVersion;
    }

    @Generated
    public void setApiSpecServiceAlias(String apiSpecServiceAlias) {
        this.apiSpecServiceAlias = apiSpecServiceAlias;
    }

    @Generated
    public void setApiPaths(SortedSet<APIPath> apiPaths) {
        this.apiPaths = apiPaths;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof APISpec)) {
            return false;
        }
        APISpec other = (APISpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$apiSpecTermsOfServiceURL = this.getApiSpecTermsOfServiceURL();
        String other$apiSpecTermsOfServiceURL = other.getApiSpecTermsOfServiceURL();
        if (this$apiSpecTermsOfServiceURL == null ? other$apiSpecTermsOfServiceURL != null : !this$apiSpecTermsOfServiceURL.equals(other$apiSpecTermsOfServiceURL)) {
            return false;
        }
        String this$apiSpecContactEmail = this.getApiSpecContactEmail();
        String other$apiSpecContactEmail = other.getApiSpecContactEmail();
        if (this$apiSpecContactEmail == null ? other$apiSpecContactEmail != null : !this$apiSpecContactEmail.equals(other$apiSpecContactEmail)) {
            return false;
        }
        String this$apiSpecContactName = this.getApiSpecContactName();
        String other$apiSpecContactName = other.getApiSpecContactName();
        if (this$apiSpecContactName == null ? other$apiSpecContactName != null : !this$apiSpecContactName.equals(other$apiSpecContactName)) {
            return false;
        }
        String this$apiSpecContactURL = this.getApiSpecContactURL();
        String other$apiSpecContactURL = other.getApiSpecContactURL();
        if (this$apiSpecContactURL == null ? other$apiSpecContactURL != null : !this$apiSpecContactURL.equals(other$apiSpecContactURL)) {
            return false;
        }
        String this$apiSpecLicenseName = this.getApiSpecLicenseName();
        String other$apiSpecLicenseName = other.getApiSpecLicenseName();
        if (this$apiSpecLicenseName == null ? other$apiSpecLicenseName != null : !this$apiSpecLicenseName.equals(other$apiSpecLicenseName)) {
            return false;
        }
        String this$apiSpecLicenseURL = this.getApiSpecLicenseURL();
        String other$apiSpecLicenseURL = other.getApiSpecLicenseURL();
        if (this$apiSpecLicenseURL == null ? other$apiSpecLicenseURL != null : !this$apiSpecLicenseURL.equals(other$apiSpecLicenseURL)) {
            return false;
        }
        String this$apiSpecContractVersion = this.getApiSpecContractVersion();
        String other$apiSpecContractVersion = other.getApiSpecContractVersion();
        if (this$apiSpecContractVersion == null ? other$apiSpecContractVersion != null : !this$apiSpecContractVersion.equals(other$apiSpecContractVersion)) {
            return false;
        }
        String this$apiSpecServiceAlias = this.getApiSpecServiceAlias();
        String other$apiSpecServiceAlias = other.getApiSpecServiceAlias();
        if (this$apiSpecServiceAlias == null ? other$apiSpecServiceAlias != null : !this$apiSpecServiceAlias.equals(other$apiSpecServiceAlias)) {
            return false;
        }
        SortedSet<APIPath> this$apiPaths = this.getApiPaths();
        SortedSet<APIPath> other$apiPaths = other.getApiPaths();
        return !(this$apiPaths == null ? other$apiPaths != null : !this$apiPaths.equals(other$apiPaths));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof APISpec;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $apiSpecTermsOfServiceURL = this.getApiSpecTermsOfServiceURL();
        result = result * 59 + ($apiSpecTermsOfServiceURL == null ? 43 : $apiSpecTermsOfServiceURL.hashCode());
        String $apiSpecContactEmail = this.getApiSpecContactEmail();
        result = result * 59 + ($apiSpecContactEmail == null ? 43 : $apiSpecContactEmail.hashCode());
        String $apiSpecContactName = this.getApiSpecContactName();
        result = result * 59 + ($apiSpecContactName == null ? 43 : $apiSpecContactName.hashCode());
        String $apiSpecContactURL = this.getApiSpecContactURL();
        result = result * 59 + ($apiSpecContactURL == null ? 43 : $apiSpecContactURL.hashCode());
        String $apiSpecLicenseName = this.getApiSpecLicenseName();
        result = result * 59 + ($apiSpecLicenseName == null ? 43 : $apiSpecLicenseName.hashCode());
        String $apiSpecLicenseURL = this.getApiSpecLicenseURL();
        result = result * 59 + ($apiSpecLicenseURL == null ? 43 : $apiSpecLicenseURL.hashCode());
        String $apiSpecContractVersion = this.getApiSpecContractVersion();
        result = result * 59 + ($apiSpecContractVersion == null ? 43 : $apiSpecContractVersion.hashCode());
        String $apiSpecServiceAlias = this.getApiSpecServiceAlias();
        result = result * 59 + ($apiSpecServiceAlias == null ? 43 : $apiSpecServiceAlias.hashCode());
        SortedSet<APIPath> $apiPaths = this.getApiPaths();
        result = result * 59 + ($apiPaths == null ? 43 : $apiPaths.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class APISpecBuilderImpl
    extends APISpecBuilder<APISpec, APISpecBuilderImpl> {
        @Generated
        private APISpecBuilderImpl() {
        }

        @Override
        @Generated
        protected APISpecBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public APISpec build() {
            return new APISpec(this);
        }
    }

    @Generated
    public static abstract class APISpecBuilder<C extends APISpec, B extends APISpecBuilder<C, B>>
    extends API.APIBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String apiSpecTermsOfServiceURL;
        @Generated
        private String apiSpecContactEmail;
        @Generated
        private String apiSpecContactName;
        @Generated
        private String apiSpecContactURL;
        @Generated
        private String apiSpecLicenseName;
        @Generated
        private String apiSpecLicenseURL;
        @Generated
        private String apiSpecContractVersion;
        @Generated
        private String apiSpecServiceAlias;
        @Generated
        private ArrayList<APIPath> apiPaths;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            APISpecBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(APISpec instance, APISpecBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.apiSpecTermsOfServiceURL(instance.apiSpecTermsOfServiceURL);
            b.apiSpecContactEmail(instance.apiSpecContactEmail);
            b.apiSpecContactName(instance.apiSpecContactName);
            b.apiSpecContactURL(instance.apiSpecContactURL);
            b.apiSpecLicenseName(instance.apiSpecLicenseName);
            b.apiSpecLicenseURL(instance.apiSpecLicenseURL);
            b.apiSpecContractVersion(instance.apiSpecContractVersion);
            b.apiSpecServiceAlias(instance.apiSpecServiceAlias);
            b.apiPaths(instance.apiPaths == null ? Collections.emptySortedSet() : instance.apiPaths);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B apiSpecTermsOfServiceURL(String apiSpecTermsOfServiceURL) {
            this.apiSpecTermsOfServiceURL = apiSpecTermsOfServiceURL;
            return (B)this.self();
        }

        @Generated
        public B apiSpecContactEmail(String apiSpecContactEmail) {
            this.apiSpecContactEmail = apiSpecContactEmail;
            return (B)this.self();
        }

        @Generated
        public B apiSpecContactName(String apiSpecContactName) {
            this.apiSpecContactName = apiSpecContactName;
            return (B)this.self();
        }

        @Generated
        public B apiSpecContactURL(String apiSpecContactURL) {
            this.apiSpecContactURL = apiSpecContactURL;
            return (B)this.self();
        }

        @Generated
        public B apiSpecLicenseName(String apiSpecLicenseName) {
            this.apiSpecLicenseName = apiSpecLicenseName;
            return (B)this.self();
        }

        @Generated
        public B apiSpecLicenseURL(String apiSpecLicenseURL) {
            this.apiSpecLicenseURL = apiSpecLicenseURL;
            return (B)this.self();
        }

        @Generated
        public B apiSpecContractVersion(String apiSpecContractVersion) {
            this.apiSpecContractVersion = apiSpecContractVersion;
            return (B)this.self();
        }

        @Generated
        public B apiSpecServiceAlias(String apiSpecServiceAlias) {
            this.apiSpecServiceAlias = apiSpecServiceAlias;
            return (B)this.self();
        }

        @Generated
        public B apiPath(APIPath apiPath) {
            if (this.apiPaths == null) {
                this.apiPaths = new ArrayList();
            }
            this.apiPaths.add(apiPath);
            return (B)this.self();
        }

        @Generated
        public B apiPaths(Collection<? extends APIPath> apiPaths) {
            if (apiPaths == null) {
                throw new NullPointerException("apiPaths cannot be null");
            }
            if (this.apiPaths == null) {
                this.apiPaths = new ArrayList();
            }
            this.apiPaths.addAll(apiPaths);
            return (B)this.self();
        }

        @Generated
        public B clearApiPaths() {
            if (this.apiPaths != null) {
                this.apiPaths.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "APISpec.APISpecBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", apiSpecTermsOfServiceURL=" + this.apiSpecTermsOfServiceURL + ", apiSpecContactEmail=" + this.apiSpecContactEmail + ", apiSpecContactName=" + this.apiSpecContactName + ", apiSpecContactURL=" + this.apiSpecContactURL + ", apiSpecLicenseName=" + this.apiSpecLicenseName + ", apiSpecLicenseURL=" + this.apiSpecLicenseURL + ", apiSpecContractVersion=" + this.apiSpecContractVersion + ", apiSpecServiceAlias=" + this.apiSpecServiceAlias + ", apiPaths=" + this.apiPaths + ")";
        }
    }
}

