/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.model.assets.AbstractColumnProcess;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.BIProcess;
import com.atlan.model.assets.Catalog;
import com.atlan.model.assets.ColumnProcess;
import com.atlan.model.assets.DbtProcess;
import com.atlan.model.assets.LineageProcess;
import com.atlan.model.enums.AtlanConnectorType;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

@JsonSubTypes(value={@JsonSubTypes.Type(value=BIProcess.class, name="BIProcess"), @JsonSubTypes.Type(value=DbtProcess.class, name="DbtProcess"), @JsonSubTypes.Type(value=ColumnProcess.class, name="ColumnProcess"), @JsonSubTypes.Type(value=LineageProcess.class, name="Process")})
public abstract class AbstractProcess
extends Asset {
    public static final String TYPE_NAME = "Process";
    @Attribute
    String code;
    @Attribute
    String sql;
    @Attribute
    String ast;
    @Attribute
    SortedSet<Catalog> outputs;
    @Attribute
    SortedSet<Catalog> inputs;
    @Attribute
    SortedSet<AbstractColumnProcess> columnProcesses;

    public static String generateQualifiedName(String name, AtlanConnectorType connectorType, String connectionName, String connectionQualifiedName, List<Catalog> inputs, List<Catalog> outputs, LineageProcess parent) {
        StringBuilder sb = new StringBuilder();
        sb.append(name).append(connectorType.getValue()).append(connectionName).append(connectionQualifiedName);
        if (parent != null) {
            AbstractProcess.appendRelationship(sb, parent);
        }
        AbstractProcess.appendRelationships(sb, inputs);
        AbstractProcess.appendRelationships(sb, outputs);
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(sb.toString().getBytes(StandardCharsets.UTF_8));
            return String.format("%032x", new BigInteger(1, md.digest()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to generate the qualifiedName for the process: MD5 algorithm does not exist on your platform!");
        }
    }

    private static void appendRelationships(StringBuilder sb, List<Catalog> relationships) {
        for (Catalog relationship : relationships) {
            AbstractProcess.appendRelationship(sb, relationship);
        }
    }

    private static void appendRelationship(StringBuilder sb, Asset relationship) {
        if (relationship.getGuid() != null) {
            sb.append(relationship.getGuid());
        } else if (relationship.getUniqueAttributes() != null && relationship.getUniqueAttributes().getQualifiedName() != null) {
            sb.append(relationship.getUniqueAttributes().getQualifiedName());
        }
    }

    @Generated
    protected AbstractProcess(AbstractProcessBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        this.code = b.code;
        this.sql = b.sql;
        this.ast = b.ast;
        SortedSet<Catalog> outputs = new TreeSet<Catalog>();
        if (b.outputs != null) {
            outputs.addAll(b.outputs);
        }
        outputs = Collections.unmodifiableSortedSet(outputs);
        this.outputs = outputs;
        SortedSet<Catalog> inputs = new TreeSet<Catalog>();
        if (b.inputs != null) {
            inputs.addAll(b.inputs);
        }
        inputs = Collections.unmodifiableSortedSet(inputs);
        this.inputs = inputs;
        SortedSet<AbstractColumnProcess> columnProcesses = new TreeSet<AbstractColumnProcess>();
        if (b.columnProcesses != null) {
            columnProcesses.addAll(b.columnProcesses);
        }
        columnProcesses = Collections.unmodifiableSortedSet(columnProcesses);
        this.columnProcesses = columnProcesses;
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public String getSql() {
        return this.sql;
    }

    @Generated
    public String getAst() {
        return this.ast;
    }

    @Generated
    public SortedSet<Catalog> getOutputs() {
        return this.outputs;
    }

    @Generated
    public SortedSet<Catalog> getInputs() {
        return this.inputs;
    }

    @Generated
    public SortedSet<AbstractColumnProcess> getColumnProcesses() {
        return this.columnProcesses;
    }

    @Generated
    public void setCode(String code) {
        this.code = code;
    }

    @Generated
    public void setSql(String sql) {
        this.sql = sql;
    }

    @Generated
    public void setAst(String ast) {
        this.ast = ast;
    }

    @Generated
    public void setOutputs(SortedSet<Catalog> outputs) {
        this.outputs = outputs;
    }

    @Generated
    public void setInputs(SortedSet<Catalog> inputs) {
        this.inputs = inputs;
    }

    @Generated
    public void setColumnProcesses(SortedSet<AbstractColumnProcess> columnProcesses) {
        this.columnProcesses = columnProcesses;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractProcess)) {
            return false;
        }
        AbstractProcess other = (AbstractProcess)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$sql = this.getSql();
        String other$sql = other.getSql();
        if (this$sql == null ? other$sql != null : !this$sql.equals(other$sql)) {
            return false;
        }
        String this$ast = this.getAst();
        String other$ast = other.getAst();
        if (this$ast == null ? other$ast != null : !this$ast.equals(other$ast)) {
            return false;
        }
        SortedSet<Catalog> this$outputs = this.getOutputs();
        SortedSet<Catalog> other$outputs = other.getOutputs();
        if (this$outputs == null ? other$outputs != null : !this$outputs.equals(other$outputs)) {
            return false;
        }
        SortedSet<Catalog> this$inputs = this.getInputs();
        SortedSet<Catalog> other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !this$inputs.equals(other$inputs)) {
            return false;
        }
        SortedSet<AbstractColumnProcess> this$columnProcesses = this.getColumnProcesses();
        SortedSet<AbstractColumnProcess> other$columnProcesses = other.getColumnProcesses();
        return !(this$columnProcesses == null ? other$columnProcesses != null : !this$columnProcesses.equals(other$columnProcesses));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractProcess;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $sql = this.getSql();
        result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
        String $ast = this.getAst();
        result = result * 59 + ($ast == null ? 43 : $ast.hashCode());
        SortedSet<Catalog> $outputs = this.getOutputs();
        result = result * 59 + ($outputs == null ? 43 : $outputs.hashCode());
        SortedSet<Catalog> $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : $inputs.hashCode());
        SortedSet<AbstractColumnProcess> $columnProcesses = this.getColumnProcesses();
        result = result * 59 + ($columnProcesses == null ? 43 : $columnProcesses.hashCode());
        return result;
    }

    @Generated
    public static abstract class AbstractProcessBuilder<C extends AbstractProcess, B extends AbstractProcessBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private String code;
        @Generated
        private String sql;
        @Generated
        private String ast;
        @Generated
        private ArrayList<Catalog> outputs;
        @Generated
        private ArrayList<Catalog> inputs;
        @Generated
        private ArrayList<AbstractColumnProcess> columnProcesses;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AbstractProcessBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(AbstractProcess instance, AbstractProcessBuilder<?, ?> b) {
            b.code(instance.code);
            b.sql(instance.sql);
            b.ast(instance.ast);
            b.outputs(instance.outputs == null ? Collections.emptySortedSet() : instance.outputs);
            b.inputs(instance.inputs == null ? Collections.emptySortedSet() : instance.inputs);
            b.columnProcesses(instance.columnProcesses == null ? Collections.emptySortedSet() : instance.columnProcesses);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B code(String code) {
            this.code = code;
            return (B)this.self();
        }

        @Generated
        public B sql(String sql) {
            this.sql = sql;
            return (B)this.self();
        }

        @Generated
        public B ast(String ast) {
            this.ast = ast;
            return (B)this.self();
        }

        @Generated
        public B output(Catalog output) {
            if (this.outputs == null) {
                this.outputs = new ArrayList();
            }
            this.outputs.add(output);
            return (B)this.self();
        }

        @Generated
        public B outputs(Collection<? extends Catalog> outputs) {
            if (outputs == null) {
                throw new NullPointerException("outputs cannot be null");
            }
            if (this.outputs == null) {
                this.outputs = new ArrayList();
            }
            this.outputs.addAll(outputs);
            return (B)this.self();
        }

        @Generated
        public B clearOutputs() {
            if (this.outputs != null) {
                this.outputs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B input(Catalog input) {
            if (this.inputs == null) {
                this.inputs = new ArrayList();
            }
            this.inputs.add(input);
            return (B)this.self();
        }

        @Generated
        public B inputs(Collection<? extends Catalog> inputs) {
            if (inputs == null) {
                throw new NullPointerException("inputs cannot be null");
            }
            if (this.inputs == null) {
                this.inputs = new ArrayList();
            }
            this.inputs.addAll(inputs);
            return (B)this.self();
        }

        @Generated
        public B clearInputs() {
            if (this.inputs != null) {
                this.inputs.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B columnProcess(AbstractColumnProcess columnProcess) {
            if (this.columnProcesses == null) {
                this.columnProcesses = new ArrayList();
            }
            this.columnProcesses.add(columnProcess);
            return (B)this.self();
        }

        @Generated
        public B columnProcesses(Collection<? extends AbstractColumnProcess> columnProcesses) {
            if (columnProcesses == null) {
                throw new NullPointerException("columnProcesses cannot be null");
            }
            if (this.columnProcesses == null) {
                this.columnProcesses = new ArrayList();
            }
            this.columnProcesses.addAll(columnProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearColumnProcesses() {
            if (this.columnProcesses != null) {
                this.columnProcesses.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "AbstractProcess.AbstractProcessBuilder(super=" + super.toString() + ", code=" + this.code + ", sql=" + this.sql + ", ast=" + this.ast + ", outputs=" + this.outputs + ", inputs=" + this.inputs + ", columnProcesses=" + this.columnProcesses + ")";
        }
    }
}

