/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.api.EntityBulkEndpoint;
import com.atlan.api.EntityUniqueAttributesEndpoint;
import com.atlan.exception.AtlanException;
import com.atlan.exception.InvalidRequestException;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Catalog;
import com.atlan.model.assets.Cloud;
import com.atlan.model.assets.Connection;
import com.atlan.model.assets.Glossary;
import com.atlan.model.assets.GlossaryCategory;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.Link;
import com.atlan.model.assets.Namespace;
import com.atlan.model.assets.Readme;
import com.atlan.model.core.Entity;
import com.atlan.model.core.EntityMutationResponse;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.AtlanStatus;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

@JsonSubTypes(value={@JsonSubTypes.Type(value=Catalog.class, name="Catalog"), @JsonSubTypes.Type(value=Namespace.class, name="Namespace"), @JsonSubTypes.Type(value=Glossary.class, name="AtlasGlossary"), @JsonSubTypes.Type(value=GlossaryCategory.class, name="AtlasGlossaryCategory"), @JsonSubTypes.Type(value=GlossaryTerm.class, name="AtlasGlossaryTerm"), @JsonSubTypes.Type(value=Cloud.class, name="Cloud"), @JsonSubTypes.Type(value=Connection.class, name="Connection")})
public abstract class Asset
extends Entity {
    public static final String TYPE_NAME = "Asset";
    @Attribute
    String qualifiedName;
    @Attribute
    String name;
    @Attribute
    String displayName;
    @Attribute
    String description;
    @Attribute
    String userDescription;
    @Attribute
    String tenantId;
    @Attribute
    AtlanCertificateStatus certificateStatus;
    @Attribute
    String certificateStatusMessage;
    @Attribute
    String certificateUpdatedBy;
    @Attribute
    Long certificateUpdatedAt;
    @Attribute
    String announcementTitle;
    @Attribute
    String announcementMessage;
    @Attribute
    Long announcementUpdatedAt;
    @Attribute
    String announcementUpdatedBy;
    @Attribute
    AtlanAnnouncementType announcementType;
    @Attribute
    SortedSet<String> ownerUsers;
    @Attribute
    SortedSet<String> ownerGroups;
    @Attribute
    SortedSet<String> adminUsers;
    @Attribute
    SortedSet<String> adminGroups;
    @Attribute
    SortedSet<String> adminRoles;
    @Attribute
    SortedSet<String> viewerUsers;
    @Attribute
    SortedSet<String> viewerGroups;
    @Attribute
    @JsonProperty(value="connectorName")
    AtlanConnectorType connectorType;
    @Attribute
    String connectionName;
    @Attribute
    String connectionQualifiedName;
    @Attribute
    @JsonProperty(value="__hasLineage")
    Boolean hasLineage;
    @Attribute
    Boolean isDiscoverable;
    @Attribute
    Boolean isEditable;
    @Attribute
    Object subType;
    @Attribute
    Double viewScore;
    @Attribute
    Double popularityScore;
    @Attribute
    String sourceOwners;
    @Attribute
    String sourceURL;
    @Attribute
    String sourceEmbedURL;
    @Attribute
    String lastSyncWorkflowName;
    @Attribute
    Long lastSyncRunAt;
    @Attribute
    String lastSyncRun;
    @Attribute
    String sourceCreatedBy;
    @Attribute
    Long sourceCreatedAt;
    @Attribute
    Long sourceUpdatedAt;
    @Attribute
    String sourceUpdatedBy;
    @Attribute
    String dbtQualifiedName;
    @Attribute
    String assetDbtAlias;
    @Attribute
    String assetDbtMeta;
    @Attribute
    String assetDbtUniqueId;
    @Attribute
    String assetDbtAccountName;
    @Attribute
    String assetDbtProjectName;
    @Attribute
    String assetDbtPackageName;
    @Attribute
    String assetDbtJobName;
    @Attribute
    String assetDbtJobSchedule;
    @Attribute
    String assetDbtJobStatus;
    @Attribute
    String assetDbtJobScheduleCronHumanized;
    @Attribute
    Long assetDbtJobLastRun;
    @Attribute
    String assetDbtJobLastRunUrl;
    @Attribute
    Long assetDbtJobLastRunCreatedAt;
    @Attribute
    Long assetDbtJobLastRunUpdatedAt;
    @Attribute
    Long assetDbtJobLastRunDequedAt;
    @Attribute
    Long assetDbtJobLastRunStartedAt;
    @Attribute
    String assetDbtJobLastRunTotalDuration;
    @Attribute
    String assetDbtJobLastRunTotalDurationHumanized;
    @Attribute
    String assetDbtJobLastRunQueuedDuration;
    @Attribute
    String assetDbtJobLastRunQueuedDurationHumanized;
    @Attribute
    String assetDbtJobLastRunRunDuration;
    @Attribute
    String assetDbtJobLastRunRunDurationHumanized;
    @Attribute
    String assetDbtJobLastRunGitBranch;
    @Attribute
    String assetDbtJobLastRunGitSha;
    @Attribute
    String assetDbtJobLastRunStatusMessage;
    @Attribute
    String assetDbtJobLastRunOwnerThreadId;
    @Attribute
    String assetDbtJobLastRunExecutedByThreadId;
    @Attribute
    Boolean assetDbtJobLastRunArtifactsSaved;
    @Attribute
    String assetDbtJobLastRunArtifactS3Path;
    @Attribute
    Boolean assetDbtJobLastRunHasDocsGenerated;
    @Attribute
    Boolean assetDbtJobLastRunHasSourcesGenerated;
    @Attribute
    Boolean assetDbtJobLastRunNotificationsSent;
    @Attribute
    Long assetDbtJobNextRun;
    @Attribute
    String assetDbtJobNextRunHumanized;
    @Attribute
    String assetDbtEnvironmentName;
    @Attribute
    String assetDbtEnvironmentDbtVersion;
    @Attribute
    SortedSet<String> assetDbtTags;
    @Attribute
    String assetDbtSemanticLayerProxyUrl;
    @Attribute
    SortedSet<Link> links;
    @Attribute
    Readme readme;
    @Attribute
    @JsonProperty(value="meanings")
    SortedSet<GlossaryTerm> assignedTerms;

    public void removeDescription() {
        this.addNullField("description");
    }

    public void removeUserDescription() {
        this.addNullField("userDescription");
    }

    public void removeOwners() {
        this.addNullField("ownerUsers");
        this.addNullField("ownerGroups");
    }

    public void removeCertificate() {
        this.addNullField("certificateStatus");
        this.addNullField("certificateStatusMessage");
    }

    public void removeAnnouncement() {
        this.addNullField("announcementType");
        this.addNullField("announcementTitle");
        this.addNullField("announcementMessage");
    }

    public void removeAssignedTerms() {
        this.addNullField("assignedTerms");
    }

    protected abstract AssetBuilder<?, ?> trimToRequired();

    protected static Entity updateCertificate(AssetBuilder<?, ?> builder, AtlanCertificateStatus certificate, String message) throws AtlanException {
        builder = ((AssetBuilder)builder).certificateStatus(certificate);
        if (message != null && message.length() > 1) {
            builder = ((AssetBuilder)builder).certificateStatusMessage(message);
        }
        return Asset.updateAttributes((Asset)((AssetBuilder)builder).build());
    }

    protected static Entity removeCertificate(AssetBuilder<?, ?> builder) throws AtlanException {
        Entity asset = builder.build();
        ((Asset)asset).removeCertificate();
        EntityMutationResponse response = asset.upsert();
        if (response != null && !response.getUpdatedEntities().isEmpty()) {
            return response.getUpdatedEntities().get(0);
        }
        return null;
    }

    protected static Entity updateAnnouncement(AssetBuilder<?, ?> builder, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        builder = ((AssetBuilder)builder).announcementType(type);
        if (title != null && title.length() > 1) {
            builder = ((AssetBuilder)builder).announcementTitle(title);
        }
        if (message != null && message.length() > 1) {
            builder = ((AssetBuilder)builder).announcementMessage(message);
        }
        return Asset.updateAttributes((Asset)((AssetBuilder)builder).build());
    }

    protected static Entity removeAnnouncement(AssetBuilder<?, ?> builder) throws AtlanException {
        Entity asset = builder.build();
        ((Asset)asset).removeAnnouncement();
        EntityMutationResponse response = asset.upsert();
        if (response != null && !response.getUpdatedEntities().isEmpty()) {
            return response.getUpdatedEntities().get(0);
        }
        return null;
    }

    protected static Entity removeDescription(AssetBuilder<?, ?> builder) throws AtlanException {
        Entity asset = builder.build();
        ((Asset)asset).removeDescription();
        EntityMutationResponse response = asset.upsert();
        if (response != null && !response.getUpdatedEntities().isEmpty()) {
            return response.getUpdatedEntities().get(0);
        }
        return null;
    }

    protected static Entity removeUserDescription(AssetBuilder<?, ?> builder) throws AtlanException {
        Entity asset = builder.build();
        ((Asset)asset).removeUserDescription();
        EntityMutationResponse response = asset.upsert();
        if (response != null && !response.getUpdatedEntities().isEmpty()) {
            return response.getUpdatedEntities().get(0);
        }
        return null;
    }

    protected static Entity removeOwners(AssetBuilder<?, ?> builder) throws AtlanException {
        Entity asset = builder.build();
        ((Asset)asset).removeOwners();
        EntityMutationResponse response = asset.upsert();
        if (response != null && !response.getUpdatedEntities().isEmpty()) {
            return response.getUpdatedEntities().get(0);
        }
        return null;
    }

    private static Entity updateAttributes(Asset asset) throws AtlanException {
        EntityMutationResponse response = EntityBulkEndpoint.upsert(asset, false, false);
        if (response != null && !response.getUpdatedEntities().isEmpty()) {
            return response.getUpdatedEntities().get(0);
        }
        return null;
    }

    protected static Entity updateCertificate(AssetBuilder<?, ?> builder, String typeName, String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        builder = ((AssetBuilder)((AssetBuilder)builder).qualifiedName(qualifiedName)).certificateStatus(certificate);
        if (message != null && message.length() > 1) {
            builder = ((AssetBuilder)builder).certificateStatusMessage(message);
        }
        return Asset.updateAttributes(typeName, qualifiedName, (Asset)((AssetBuilder)builder).build());
    }

    protected static Entity updateAnnouncement(AssetBuilder<?, ?> builder, String typeName, String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        builder = ((AssetBuilder)((AssetBuilder)builder).qualifiedName(qualifiedName)).announcementType(type);
        if (title != null && title.length() > 1) {
            builder = ((AssetBuilder)builder).announcementTitle(title);
        }
        if (message != null && message.length() > 1) {
            builder = ((AssetBuilder)builder).announcementMessage(message);
        }
        return Asset.updateAttributes(typeName, qualifiedName, (Asset)((AssetBuilder)builder).build());
    }

    private static Entity updateAttributes(String typeName, String qualifiedName, Asset asset) throws AtlanException {
        EntityMutationResponse response = EntityUniqueAttributesEndpoint.updateAttributes(typeName, qualifiedName, asset);
        if (response != null && !response.getPartiallyUpdatedEntities().isEmpty()) {
            return response.getPartiallyUpdatedEntities().get(0);
        }
        if (response != null && !response.getUpdatedEntities().isEmpty()) {
            return response.getUpdatedEntities().get(0);
        }
        return null;
    }

    protected static boolean restore(String typeName, String qualifiedName) throws AtlanException {
        Asset existing = Asset.getExistingAsset(typeName, qualifiedName);
        if (existing == null) {
            return false;
        }
        if (existing.getStatus() == AtlanStatus.ACTIVE) {
            return true;
        }
        Optional<String> guidRestored = Asset.restore((Asset)((AssetBuilder)existing.trimToRequired().status(AtlanStatus.ACTIVE)).build());
        return guidRestored.isPresent() && guidRestored.get().equals(existing.getGuid());
    }

    protected static Entity replaceTerms(AssetBuilder<?, ?> builder, List<GlossaryTerm> terms) throws AtlanException {
        if (terms == null || terms.isEmpty()) {
            Entity asset = builder.build();
            ((Asset)asset).removeAssignedTerms();
            return Asset.updateRelationships((Asset)asset);
        }
        return Asset.updateRelationships((Asset)((AssetBuilder)builder.assignedTerms(Asset.getTermRefs(terms))).build());
    }

    protected static Entity appendTerms(String typeName, String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        Asset existing = Asset.getExistingAsset(typeName, qualifiedName);
        if (terms == null) {
            return existing;
        }
        if (existing != null) {
            TreeSet<GlossaryTerm> replacementTerms = new TreeSet<GlossaryTerm>();
            SortedSet<GlossaryTerm> existingTerms = existing.getAssignedTerms();
            if (existingTerms != null) {
                for (GlossaryTerm term : existingTerms) {
                    if (term.getRelationshipStatus() == AtlanStatus.DELETED) continue;
                    replacementTerms.add(term);
                }
            }
            replacementTerms.addAll(terms);
            AssetBuilder<?, ?> minimal = existing.trimToRequired();
            return Asset.updateRelationships((Asset)((AssetBuilder)minimal.assignedTerms(Asset.getTermRefs(replacementTerms))).build());
        }
        return null;
    }

    protected static Entity removeTerms(String typeName, String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        Asset existing = Asset.getExistingAsset(typeName, qualifiedName);
        if (existing != null) {
            Entity update;
            TreeSet<GlossaryTerm> replacementTerms = new TreeSet<GlossaryTerm>();
            SortedSet<GlossaryTerm> existingTerms = existing.getAssignedTerms();
            HashSet<String> removeGuids = new HashSet<String>();
            for (GlossaryTerm term : terms) {
                if (term.isValidReferenceByGuid()) {
                    removeGuids.add(term.getGuid());
                    continue;
                }
                throw new InvalidRequestException("Term provided for removal did not specify its GUID", "terms", "ATLAN_JAVA_CLIENT-400-301", 400, null);
            }
            for (GlossaryTerm term : existingTerms) {
                String existingTermGuid = term.getGuid();
                if (removeGuids.contains(existingTermGuid) || term.getRelationshipStatus() == AtlanStatus.DELETED) continue;
                replacementTerms.add(term);
            }
            AssetBuilder<?, ?> minimal = existing.trimToRequired();
            if (replacementTerms.isEmpty()) {
                update = minimal.build();
                ((Asset)update).removeAssignedTerms();
            } else {
                update = ((AssetBuilder)minimal.assignedTerms(Asset.getTermRefs(replacementTerms))).build();
            }
            return Asset.updateRelationships((Asset)update);
        }
        return null;
    }

    private static Collection<GlossaryTerm> getTermRefs(Collection<GlossaryTerm> terms) {
        if (terms != null && !terms.isEmpty()) {
            TreeSet<GlossaryTerm> termRefs = new TreeSet<GlossaryTerm>();
            for (GlossaryTerm term : terms) {
                if (term.getGuid() != null) {
                    termRefs.add(GlossaryTerm.refByGuid(term.getGuid()));
                    continue;
                }
                if (term.getQualifiedName() == null) continue;
                termRefs.add(GlossaryTerm.refByQualifiedName(term.getQualifiedName()));
            }
            return termRefs;
        }
        return Collections.emptySet();
    }

    private static Asset getExistingAsset(String typeName, String qualifiedName) throws AtlanException {
        return (Asset)Entity.retrieveFull(typeName, qualifiedName);
    }

    private static Entity updateRelationships(Asset asset) throws AtlanException {
        String typeNameToUpdate = asset.getTypeName();
        EntityMutationResponse response = EntityBulkEndpoint.upsert(asset, false, false);
        if (response != null && !response.getUpdatedEntities().isEmpty()) {
            for (Entity result : response.getUpdatedEntities()) {
                String foundQN;
                if (!result.getTypeName().equals(typeNameToUpdate) || (foundQN = ((Asset)result).getQualifiedName()) == null || !foundQN.equals(asset.getQualifiedName())) continue;
                return result;
            }
        }
        return null;
    }

    private static Optional<String> restore(Asset asset) throws AtlanException {
        EntityMutationResponse response = EntityBulkEndpoint.upsert(asset, false, false);
        if (response != null && !response.getGuidAssignments().isEmpty()) {
            return response.getGuidAssignments().values().stream().findFirst();
        }
        return Optional.empty();
    }

    @Generated
    protected Asset(AssetBuilder<?, ?> b) {
        super((Entity.EntityBuilder<?, ?>)b);
        this.qualifiedName = b.qualifiedName;
        this.name = b.name;
        this.displayName = b.displayName;
        this.description = b.description;
        this.userDescription = b.userDescription;
        this.tenantId = b.tenantId;
        this.certificateStatus = b.certificateStatus;
        this.certificateStatusMessage = b.certificateStatusMessage;
        this.certificateUpdatedBy = b.certificateUpdatedBy;
        this.certificateUpdatedAt = b.certificateUpdatedAt;
        this.announcementTitle = b.announcementTitle;
        this.announcementMessage = b.announcementMessage;
        this.announcementUpdatedAt = b.announcementUpdatedAt;
        this.announcementUpdatedBy = b.announcementUpdatedBy;
        this.announcementType = b.announcementType;
        SortedSet<String> ownerUsers = new TreeSet<String>();
        if (b.ownerUsers != null) {
            ownerUsers.addAll(b.ownerUsers);
        }
        ownerUsers = Collections.unmodifiableSortedSet(ownerUsers);
        this.ownerUsers = ownerUsers;
        SortedSet<String> ownerGroups = new TreeSet<String>();
        if (b.ownerGroups != null) {
            ownerGroups.addAll(b.ownerGroups);
        }
        ownerGroups = Collections.unmodifiableSortedSet(ownerGroups);
        this.ownerGroups = ownerGroups;
        SortedSet<String> adminUsers = new TreeSet<String>();
        if (b.adminUsers != null) {
            adminUsers.addAll(b.adminUsers);
        }
        adminUsers = Collections.unmodifiableSortedSet(adminUsers);
        this.adminUsers = adminUsers;
        SortedSet<String> adminGroups = new TreeSet<String>();
        if (b.adminGroups != null) {
            adminGroups.addAll(b.adminGroups);
        }
        adminGroups = Collections.unmodifiableSortedSet(adminGroups);
        this.adminGroups = adminGroups;
        SortedSet<String> adminRoles = new TreeSet<String>();
        if (b.adminRoles != null) {
            adminRoles.addAll(b.adminRoles);
        }
        adminRoles = Collections.unmodifiableSortedSet(adminRoles);
        this.adminRoles = adminRoles;
        SortedSet<String> viewerUsers = new TreeSet<String>();
        if (b.viewerUsers != null) {
            viewerUsers.addAll(b.viewerUsers);
        }
        viewerUsers = Collections.unmodifiableSortedSet(viewerUsers);
        this.viewerUsers = viewerUsers;
        SortedSet<String> viewerGroups = new TreeSet<String>();
        if (b.viewerGroups != null) {
            viewerGroups.addAll(b.viewerGroups);
        }
        viewerGroups = Collections.unmodifiableSortedSet(viewerGroups);
        this.viewerGroups = viewerGroups;
        this.connectorType = b.connectorType;
        this.connectionName = b.connectionName;
        this.connectionQualifiedName = b.connectionQualifiedName;
        this.hasLineage = b.hasLineage;
        this.isDiscoverable = b.isDiscoverable;
        this.isEditable = b.isEditable;
        this.subType = b.subType;
        this.viewScore = b.viewScore;
        this.popularityScore = b.popularityScore;
        this.sourceOwners = b.sourceOwners;
        this.sourceURL = b.sourceURL;
        this.sourceEmbedURL = b.sourceEmbedURL;
        this.lastSyncWorkflowName = b.lastSyncWorkflowName;
        this.lastSyncRunAt = b.lastSyncRunAt;
        this.lastSyncRun = b.lastSyncRun;
        this.sourceCreatedBy = b.sourceCreatedBy;
        this.sourceCreatedAt = b.sourceCreatedAt;
        this.sourceUpdatedAt = b.sourceUpdatedAt;
        this.sourceUpdatedBy = b.sourceUpdatedBy;
        this.dbtQualifiedName = b.dbtQualifiedName;
        this.assetDbtAlias = b.assetDbtAlias;
        this.assetDbtMeta = b.assetDbtMeta;
        this.assetDbtUniqueId = b.assetDbtUniqueId;
        this.assetDbtAccountName = b.assetDbtAccountName;
        this.assetDbtProjectName = b.assetDbtProjectName;
        this.assetDbtPackageName = b.assetDbtPackageName;
        this.assetDbtJobName = b.assetDbtJobName;
        this.assetDbtJobSchedule = b.assetDbtJobSchedule;
        this.assetDbtJobStatus = b.assetDbtJobStatus;
        this.assetDbtJobScheduleCronHumanized = b.assetDbtJobScheduleCronHumanized;
        this.assetDbtJobLastRun = b.assetDbtJobLastRun;
        this.assetDbtJobLastRunUrl = b.assetDbtJobLastRunUrl;
        this.assetDbtJobLastRunCreatedAt = b.assetDbtJobLastRunCreatedAt;
        this.assetDbtJobLastRunUpdatedAt = b.assetDbtJobLastRunUpdatedAt;
        this.assetDbtJobLastRunDequedAt = b.assetDbtJobLastRunDequedAt;
        this.assetDbtJobLastRunStartedAt = b.assetDbtJobLastRunStartedAt;
        this.assetDbtJobLastRunTotalDuration = b.assetDbtJobLastRunTotalDuration;
        this.assetDbtJobLastRunTotalDurationHumanized = b.assetDbtJobLastRunTotalDurationHumanized;
        this.assetDbtJobLastRunQueuedDuration = b.assetDbtJobLastRunQueuedDuration;
        this.assetDbtJobLastRunQueuedDurationHumanized = b.assetDbtJobLastRunQueuedDurationHumanized;
        this.assetDbtJobLastRunRunDuration = b.assetDbtJobLastRunRunDuration;
        this.assetDbtJobLastRunRunDurationHumanized = b.assetDbtJobLastRunRunDurationHumanized;
        this.assetDbtJobLastRunGitBranch = b.assetDbtJobLastRunGitBranch;
        this.assetDbtJobLastRunGitSha = b.assetDbtJobLastRunGitSha;
        this.assetDbtJobLastRunStatusMessage = b.assetDbtJobLastRunStatusMessage;
        this.assetDbtJobLastRunOwnerThreadId = b.assetDbtJobLastRunOwnerThreadId;
        this.assetDbtJobLastRunExecutedByThreadId = b.assetDbtJobLastRunExecutedByThreadId;
        this.assetDbtJobLastRunArtifactsSaved = b.assetDbtJobLastRunArtifactsSaved;
        this.assetDbtJobLastRunArtifactS3Path = b.assetDbtJobLastRunArtifactS3Path;
        this.assetDbtJobLastRunHasDocsGenerated = b.assetDbtJobLastRunHasDocsGenerated;
        this.assetDbtJobLastRunHasSourcesGenerated = b.assetDbtJobLastRunHasSourcesGenerated;
        this.assetDbtJobLastRunNotificationsSent = b.assetDbtJobLastRunNotificationsSent;
        this.assetDbtJobNextRun = b.assetDbtJobNextRun;
        this.assetDbtJobNextRunHumanized = b.assetDbtJobNextRunHumanized;
        this.assetDbtEnvironmentName = b.assetDbtEnvironmentName;
        this.assetDbtEnvironmentDbtVersion = b.assetDbtEnvironmentDbtVersion;
        SortedSet<String> assetDbtTags = new TreeSet<String>();
        if (b.assetDbtTags != null) {
            assetDbtTags.addAll(b.assetDbtTags);
        }
        assetDbtTags = Collections.unmodifiableSortedSet(assetDbtTags);
        this.assetDbtTags = assetDbtTags;
        this.assetDbtSemanticLayerProxyUrl = b.assetDbtSemanticLayerProxyUrl;
        SortedSet<Link> links = new TreeSet<Link>();
        if (b.links != null) {
            links.addAll(b.links);
        }
        links = Collections.unmodifiableSortedSet(links);
        this.links = links;
        this.readme = b.readme;
        SortedSet<GlossaryTerm> assignedTerms = new TreeSet<GlossaryTerm>();
        if (b.assignedTerms != null) {
            assignedTerms.addAll(b.assignedTerms);
        }
        assignedTerms = Collections.unmodifiableSortedSet(assignedTerms);
        this.assignedTerms = assignedTerms;
    }

    @Generated
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getUserDescription() {
        return this.userDescription;
    }

    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public AtlanCertificateStatus getCertificateStatus() {
        return this.certificateStatus;
    }

    @Generated
    public String getCertificateStatusMessage() {
        return this.certificateStatusMessage;
    }

    @Generated
    public String getCertificateUpdatedBy() {
        return this.certificateUpdatedBy;
    }

    @Generated
    public Long getCertificateUpdatedAt() {
        return this.certificateUpdatedAt;
    }

    @Generated
    public String getAnnouncementTitle() {
        return this.announcementTitle;
    }

    @Generated
    public String getAnnouncementMessage() {
        return this.announcementMessage;
    }

    @Generated
    public Long getAnnouncementUpdatedAt() {
        return this.announcementUpdatedAt;
    }

    @Generated
    public String getAnnouncementUpdatedBy() {
        return this.announcementUpdatedBy;
    }

    @Generated
    public AtlanAnnouncementType getAnnouncementType() {
        return this.announcementType;
    }

    @Generated
    public SortedSet<String> getOwnerUsers() {
        return this.ownerUsers;
    }

    @Generated
    public SortedSet<String> getOwnerGroups() {
        return this.ownerGroups;
    }

    @Generated
    public SortedSet<String> getAdminUsers() {
        return this.adminUsers;
    }

    @Generated
    public SortedSet<String> getAdminGroups() {
        return this.adminGroups;
    }

    @Generated
    public SortedSet<String> getAdminRoles() {
        return this.adminRoles;
    }

    @Generated
    public SortedSet<String> getViewerUsers() {
        return this.viewerUsers;
    }

    @Generated
    public SortedSet<String> getViewerGroups() {
        return this.viewerGroups;
    }

    @Generated
    public AtlanConnectorType getConnectorType() {
        return this.connectorType;
    }

    @Generated
    public String getConnectionName() {
        return this.connectionName;
    }

    @Generated
    public String getConnectionQualifiedName() {
        return this.connectionQualifiedName;
    }

    @Generated
    public Boolean getHasLineage() {
        return this.hasLineage;
    }

    @Generated
    public Boolean getIsDiscoverable() {
        return this.isDiscoverable;
    }

    @Generated
    public Boolean getIsEditable() {
        return this.isEditable;
    }

    @Generated
    public Object getSubType() {
        return this.subType;
    }

    @Generated
    public Double getViewScore() {
        return this.viewScore;
    }

    @Generated
    public Double getPopularityScore() {
        return this.popularityScore;
    }

    @Generated
    public String getSourceOwners() {
        return this.sourceOwners;
    }

    @Generated
    public String getSourceURL() {
        return this.sourceURL;
    }

    @Generated
    public String getSourceEmbedURL() {
        return this.sourceEmbedURL;
    }

    @Generated
    public String getLastSyncWorkflowName() {
        return this.lastSyncWorkflowName;
    }

    @Generated
    public Long getLastSyncRunAt() {
        return this.lastSyncRunAt;
    }

    @Generated
    public String getLastSyncRun() {
        return this.lastSyncRun;
    }

    @Generated
    public String getSourceCreatedBy() {
        return this.sourceCreatedBy;
    }

    @Generated
    public Long getSourceCreatedAt() {
        return this.sourceCreatedAt;
    }

    @Generated
    public Long getSourceUpdatedAt() {
        return this.sourceUpdatedAt;
    }

    @Generated
    public String getSourceUpdatedBy() {
        return this.sourceUpdatedBy;
    }

    @Generated
    public String getDbtQualifiedName() {
        return this.dbtQualifiedName;
    }

    @Generated
    public String getAssetDbtAlias() {
        return this.assetDbtAlias;
    }

    @Generated
    public String getAssetDbtMeta() {
        return this.assetDbtMeta;
    }

    @Generated
    public String getAssetDbtUniqueId() {
        return this.assetDbtUniqueId;
    }

    @Generated
    public String getAssetDbtAccountName() {
        return this.assetDbtAccountName;
    }

    @Generated
    public String getAssetDbtProjectName() {
        return this.assetDbtProjectName;
    }

    @Generated
    public String getAssetDbtPackageName() {
        return this.assetDbtPackageName;
    }

    @Generated
    public String getAssetDbtJobName() {
        return this.assetDbtJobName;
    }

    @Generated
    public String getAssetDbtJobSchedule() {
        return this.assetDbtJobSchedule;
    }

    @Generated
    public String getAssetDbtJobStatus() {
        return this.assetDbtJobStatus;
    }

    @Generated
    public String getAssetDbtJobScheduleCronHumanized() {
        return this.assetDbtJobScheduleCronHumanized;
    }

    @Generated
    public Long getAssetDbtJobLastRun() {
        return this.assetDbtJobLastRun;
    }

    @Generated
    public String getAssetDbtJobLastRunUrl() {
        return this.assetDbtJobLastRunUrl;
    }

    @Generated
    public Long getAssetDbtJobLastRunCreatedAt() {
        return this.assetDbtJobLastRunCreatedAt;
    }

    @Generated
    public Long getAssetDbtJobLastRunUpdatedAt() {
        return this.assetDbtJobLastRunUpdatedAt;
    }

    @Generated
    public Long getAssetDbtJobLastRunDequedAt() {
        return this.assetDbtJobLastRunDequedAt;
    }

    @Generated
    public Long getAssetDbtJobLastRunStartedAt() {
        return this.assetDbtJobLastRunStartedAt;
    }

    @Generated
    public String getAssetDbtJobLastRunTotalDuration() {
        return this.assetDbtJobLastRunTotalDuration;
    }

    @Generated
    public String getAssetDbtJobLastRunTotalDurationHumanized() {
        return this.assetDbtJobLastRunTotalDurationHumanized;
    }

    @Generated
    public String getAssetDbtJobLastRunQueuedDuration() {
        return this.assetDbtJobLastRunQueuedDuration;
    }

    @Generated
    public String getAssetDbtJobLastRunQueuedDurationHumanized() {
        return this.assetDbtJobLastRunQueuedDurationHumanized;
    }

    @Generated
    public String getAssetDbtJobLastRunRunDuration() {
        return this.assetDbtJobLastRunRunDuration;
    }

    @Generated
    public String getAssetDbtJobLastRunRunDurationHumanized() {
        return this.assetDbtJobLastRunRunDurationHumanized;
    }

    @Generated
    public String getAssetDbtJobLastRunGitBranch() {
        return this.assetDbtJobLastRunGitBranch;
    }

    @Generated
    public String getAssetDbtJobLastRunGitSha() {
        return this.assetDbtJobLastRunGitSha;
    }

    @Generated
    public String getAssetDbtJobLastRunStatusMessage() {
        return this.assetDbtJobLastRunStatusMessage;
    }

    @Generated
    public String getAssetDbtJobLastRunOwnerThreadId() {
        return this.assetDbtJobLastRunOwnerThreadId;
    }

    @Generated
    public String getAssetDbtJobLastRunExecutedByThreadId() {
        return this.assetDbtJobLastRunExecutedByThreadId;
    }

    @Generated
    public Boolean getAssetDbtJobLastRunArtifactsSaved() {
        return this.assetDbtJobLastRunArtifactsSaved;
    }

    @Generated
    public String getAssetDbtJobLastRunArtifactS3Path() {
        return this.assetDbtJobLastRunArtifactS3Path;
    }

    @Generated
    public Boolean getAssetDbtJobLastRunHasDocsGenerated() {
        return this.assetDbtJobLastRunHasDocsGenerated;
    }

    @Generated
    public Boolean getAssetDbtJobLastRunHasSourcesGenerated() {
        return this.assetDbtJobLastRunHasSourcesGenerated;
    }

    @Generated
    public Boolean getAssetDbtJobLastRunNotificationsSent() {
        return this.assetDbtJobLastRunNotificationsSent;
    }

    @Generated
    public Long getAssetDbtJobNextRun() {
        return this.assetDbtJobNextRun;
    }

    @Generated
    public String getAssetDbtJobNextRunHumanized() {
        return this.assetDbtJobNextRunHumanized;
    }

    @Generated
    public String getAssetDbtEnvironmentName() {
        return this.assetDbtEnvironmentName;
    }

    @Generated
    public String getAssetDbtEnvironmentDbtVersion() {
        return this.assetDbtEnvironmentDbtVersion;
    }

    @Generated
    public SortedSet<String> getAssetDbtTags() {
        return this.assetDbtTags;
    }

    @Generated
    public String getAssetDbtSemanticLayerProxyUrl() {
        return this.assetDbtSemanticLayerProxyUrl;
    }

    @Generated
    public SortedSet<Link> getLinks() {
        return this.links;
    }

    @Generated
    public Readme getReadme() {
        return this.readme;
    }

    @Generated
    public SortedSet<GlossaryTerm> getAssignedTerms() {
        return this.assignedTerms;
    }

    @Generated
    public void setQualifiedName(String qualifiedName) {
        this.qualifiedName = qualifiedName;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setUserDescription(String userDescription) {
        this.userDescription = userDescription;
    }

    @Generated
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setCertificateStatus(AtlanCertificateStatus certificateStatus) {
        this.certificateStatus = certificateStatus;
    }

    @Generated
    public void setCertificateStatusMessage(String certificateStatusMessage) {
        this.certificateStatusMessage = certificateStatusMessage;
    }

    @Generated
    public void setCertificateUpdatedBy(String certificateUpdatedBy) {
        this.certificateUpdatedBy = certificateUpdatedBy;
    }

    @Generated
    public void setCertificateUpdatedAt(Long certificateUpdatedAt) {
        this.certificateUpdatedAt = certificateUpdatedAt;
    }

    @Generated
    public void setAnnouncementTitle(String announcementTitle) {
        this.announcementTitle = announcementTitle;
    }

    @Generated
    public void setAnnouncementMessage(String announcementMessage) {
        this.announcementMessage = announcementMessage;
    }

    @Generated
    public void setAnnouncementUpdatedAt(Long announcementUpdatedAt) {
        this.announcementUpdatedAt = announcementUpdatedAt;
    }

    @Generated
    public void setAnnouncementUpdatedBy(String announcementUpdatedBy) {
        this.announcementUpdatedBy = announcementUpdatedBy;
    }

    @Generated
    public void setAnnouncementType(AtlanAnnouncementType announcementType) {
        this.announcementType = announcementType;
    }

    @Generated
    public void setOwnerUsers(SortedSet<String> ownerUsers) {
        this.ownerUsers = ownerUsers;
    }

    @Generated
    public void setOwnerGroups(SortedSet<String> ownerGroups) {
        this.ownerGroups = ownerGroups;
    }

    @Generated
    public void setAdminUsers(SortedSet<String> adminUsers) {
        this.adminUsers = adminUsers;
    }

    @Generated
    public void setAdminGroups(SortedSet<String> adminGroups) {
        this.adminGroups = adminGroups;
    }

    @Generated
    public void setAdminRoles(SortedSet<String> adminRoles) {
        this.adminRoles = adminRoles;
    }

    @Generated
    public void setViewerUsers(SortedSet<String> viewerUsers) {
        this.viewerUsers = viewerUsers;
    }

    @Generated
    public void setViewerGroups(SortedSet<String> viewerGroups) {
        this.viewerGroups = viewerGroups;
    }

    @JsonProperty(value="connectorName")
    @Generated
    public void setConnectorType(AtlanConnectorType connectorType) {
        this.connectorType = connectorType;
    }

    @Generated
    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    @Generated
    public void setConnectionQualifiedName(String connectionQualifiedName) {
        this.connectionQualifiedName = connectionQualifiedName;
    }

    @JsonProperty(value="__hasLineage")
    @Generated
    public void setHasLineage(Boolean hasLineage) {
        this.hasLineage = hasLineage;
    }

    @Generated
    public void setIsDiscoverable(Boolean isDiscoverable) {
        this.isDiscoverable = isDiscoverable;
    }

    @Generated
    public void setIsEditable(Boolean isEditable) {
        this.isEditable = isEditable;
    }

    @Generated
    public void setSubType(Object subType) {
        this.subType = subType;
    }

    @Generated
    public void setViewScore(Double viewScore) {
        this.viewScore = viewScore;
    }

    @Generated
    public void setPopularityScore(Double popularityScore) {
        this.popularityScore = popularityScore;
    }

    @Generated
    public void setSourceOwners(String sourceOwners) {
        this.sourceOwners = sourceOwners;
    }

    @Generated
    public void setSourceURL(String sourceURL) {
        this.sourceURL = sourceURL;
    }

    @Generated
    public void setSourceEmbedURL(String sourceEmbedURL) {
        this.sourceEmbedURL = sourceEmbedURL;
    }

    @Generated
    public void setLastSyncWorkflowName(String lastSyncWorkflowName) {
        this.lastSyncWorkflowName = lastSyncWorkflowName;
    }

    @Generated
    public void setLastSyncRunAt(Long lastSyncRunAt) {
        this.lastSyncRunAt = lastSyncRunAt;
    }

    @Generated
    public void setLastSyncRun(String lastSyncRun) {
        this.lastSyncRun = lastSyncRun;
    }

    @Generated
    public void setSourceCreatedBy(String sourceCreatedBy) {
        this.sourceCreatedBy = sourceCreatedBy;
    }

    @Generated
    public void setSourceCreatedAt(Long sourceCreatedAt) {
        this.sourceCreatedAt = sourceCreatedAt;
    }

    @Generated
    public void setSourceUpdatedAt(Long sourceUpdatedAt) {
        this.sourceUpdatedAt = sourceUpdatedAt;
    }

    @Generated
    public void setSourceUpdatedBy(String sourceUpdatedBy) {
        this.sourceUpdatedBy = sourceUpdatedBy;
    }

    @Generated
    public void setDbtQualifiedName(String dbtQualifiedName) {
        this.dbtQualifiedName = dbtQualifiedName;
    }

    @Generated
    public void setAssetDbtAlias(String assetDbtAlias) {
        this.assetDbtAlias = assetDbtAlias;
    }

    @Generated
    public void setAssetDbtMeta(String assetDbtMeta) {
        this.assetDbtMeta = assetDbtMeta;
    }

    @Generated
    public void setAssetDbtUniqueId(String assetDbtUniqueId) {
        this.assetDbtUniqueId = assetDbtUniqueId;
    }

    @Generated
    public void setAssetDbtAccountName(String assetDbtAccountName) {
        this.assetDbtAccountName = assetDbtAccountName;
    }

    @Generated
    public void setAssetDbtProjectName(String assetDbtProjectName) {
        this.assetDbtProjectName = assetDbtProjectName;
    }

    @Generated
    public void setAssetDbtPackageName(String assetDbtPackageName) {
        this.assetDbtPackageName = assetDbtPackageName;
    }

    @Generated
    public void setAssetDbtJobName(String assetDbtJobName) {
        this.assetDbtJobName = assetDbtJobName;
    }

    @Generated
    public void setAssetDbtJobSchedule(String assetDbtJobSchedule) {
        this.assetDbtJobSchedule = assetDbtJobSchedule;
    }

    @Generated
    public void setAssetDbtJobStatus(String assetDbtJobStatus) {
        this.assetDbtJobStatus = assetDbtJobStatus;
    }

    @Generated
    public void setAssetDbtJobScheduleCronHumanized(String assetDbtJobScheduleCronHumanized) {
        this.assetDbtJobScheduleCronHumanized = assetDbtJobScheduleCronHumanized;
    }

    @Generated
    public void setAssetDbtJobLastRun(Long assetDbtJobLastRun) {
        this.assetDbtJobLastRun = assetDbtJobLastRun;
    }

    @Generated
    public void setAssetDbtJobLastRunUrl(String assetDbtJobLastRunUrl) {
        this.assetDbtJobLastRunUrl = assetDbtJobLastRunUrl;
    }

    @Generated
    public void setAssetDbtJobLastRunCreatedAt(Long assetDbtJobLastRunCreatedAt) {
        this.assetDbtJobLastRunCreatedAt = assetDbtJobLastRunCreatedAt;
    }

    @Generated
    public void setAssetDbtJobLastRunUpdatedAt(Long assetDbtJobLastRunUpdatedAt) {
        this.assetDbtJobLastRunUpdatedAt = assetDbtJobLastRunUpdatedAt;
    }

    @Generated
    public void setAssetDbtJobLastRunDequedAt(Long assetDbtJobLastRunDequedAt) {
        this.assetDbtJobLastRunDequedAt = assetDbtJobLastRunDequedAt;
    }

    @Generated
    public void setAssetDbtJobLastRunStartedAt(Long assetDbtJobLastRunStartedAt) {
        this.assetDbtJobLastRunStartedAt = assetDbtJobLastRunStartedAt;
    }

    @Generated
    public void setAssetDbtJobLastRunTotalDuration(String assetDbtJobLastRunTotalDuration) {
        this.assetDbtJobLastRunTotalDuration = assetDbtJobLastRunTotalDuration;
    }

    @Generated
    public void setAssetDbtJobLastRunTotalDurationHumanized(String assetDbtJobLastRunTotalDurationHumanized) {
        this.assetDbtJobLastRunTotalDurationHumanized = assetDbtJobLastRunTotalDurationHumanized;
    }

    @Generated
    public void setAssetDbtJobLastRunQueuedDuration(String assetDbtJobLastRunQueuedDuration) {
        this.assetDbtJobLastRunQueuedDuration = assetDbtJobLastRunQueuedDuration;
    }

    @Generated
    public void setAssetDbtJobLastRunQueuedDurationHumanized(String assetDbtJobLastRunQueuedDurationHumanized) {
        this.assetDbtJobLastRunQueuedDurationHumanized = assetDbtJobLastRunQueuedDurationHumanized;
    }

    @Generated
    public void setAssetDbtJobLastRunRunDuration(String assetDbtJobLastRunRunDuration) {
        this.assetDbtJobLastRunRunDuration = assetDbtJobLastRunRunDuration;
    }

    @Generated
    public void setAssetDbtJobLastRunRunDurationHumanized(String assetDbtJobLastRunRunDurationHumanized) {
        this.assetDbtJobLastRunRunDurationHumanized = assetDbtJobLastRunRunDurationHumanized;
    }

    @Generated
    public void setAssetDbtJobLastRunGitBranch(String assetDbtJobLastRunGitBranch) {
        this.assetDbtJobLastRunGitBranch = assetDbtJobLastRunGitBranch;
    }

    @Generated
    public void setAssetDbtJobLastRunGitSha(String assetDbtJobLastRunGitSha) {
        this.assetDbtJobLastRunGitSha = assetDbtJobLastRunGitSha;
    }

    @Generated
    public void setAssetDbtJobLastRunStatusMessage(String assetDbtJobLastRunStatusMessage) {
        this.assetDbtJobLastRunStatusMessage = assetDbtJobLastRunStatusMessage;
    }

    @Generated
    public void setAssetDbtJobLastRunOwnerThreadId(String assetDbtJobLastRunOwnerThreadId) {
        this.assetDbtJobLastRunOwnerThreadId = assetDbtJobLastRunOwnerThreadId;
    }

    @Generated
    public void setAssetDbtJobLastRunExecutedByThreadId(String assetDbtJobLastRunExecutedByThreadId) {
        this.assetDbtJobLastRunExecutedByThreadId = assetDbtJobLastRunExecutedByThreadId;
    }

    @Generated
    public void setAssetDbtJobLastRunArtifactsSaved(Boolean assetDbtJobLastRunArtifactsSaved) {
        this.assetDbtJobLastRunArtifactsSaved = assetDbtJobLastRunArtifactsSaved;
    }

    @Generated
    public void setAssetDbtJobLastRunArtifactS3Path(String assetDbtJobLastRunArtifactS3Path) {
        this.assetDbtJobLastRunArtifactS3Path = assetDbtJobLastRunArtifactS3Path;
    }

    @Generated
    public void setAssetDbtJobLastRunHasDocsGenerated(Boolean assetDbtJobLastRunHasDocsGenerated) {
        this.assetDbtJobLastRunHasDocsGenerated = assetDbtJobLastRunHasDocsGenerated;
    }

    @Generated
    public void setAssetDbtJobLastRunHasSourcesGenerated(Boolean assetDbtJobLastRunHasSourcesGenerated) {
        this.assetDbtJobLastRunHasSourcesGenerated = assetDbtJobLastRunHasSourcesGenerated;
    }

    @Generated
    public void setAssetDbtJobLastRunNotificationsSent(Boolean assetDbtJobLastRunNotificationsSent) {
        this.assetDbtJobLastRunNotificationsSent = assetDbtJobLastRunNotificationsSent;
    }

    @Generated
    public void setAssetDbtJobNextRun(Long assetDbtJobNextRun) {
        this.assetDbtJobNextRun = assetDbtJobNextRun;
    }

    @Generated
    public void setAssetDbtJobNextRunHumanized(String assetDbtJobNextRunHumanized) {
        this.assetDbtJobNextRunHumanized = assetDbtJobNextRunHumanized;
    }

    @Generated
    public void setAssetDbtEnvironmentName(String assetDbtEnvironmentName) {
        this.assetDbtEnvironmentName = assetDbtEnvironmentName;
    }

    @Generated
    public void setAssetDbtEnvironmentDbtVersion(String assetDbtEnvironmentDbtVersion) {
        this.assetDbtEnvironmentDbtVersion = assetDbtEnvironmentDbtVersion;
    }

    @Generated
    public void setAssetDbtTags(SortedSet<String> assetDbtTags) {
        this.assetDbtTags = assetDbtTags;
    }

    @Generated
    public void setAssetDbtSemanticLayerProxyUrl(String assetDbtSemanticLayerProxyUrl) {
        this.assetDbtSemanticLayerProxyUrl = assetDbtSemanticLayerProxyUrl;
    }

    @Generated
    public void setLinks(SortedSet<Link> links) {
        this.links = links;
    }

    @Generated
    public void setReadme(Readme readme) {
        this.readme = readme;
    }

    @JsonProperty(value="meanings")
    @Generated
    public void setAssignedTerms(SortedSet<GlossaryTerm> assignedTerms) {
        this.assignedTerms = assignedTerms;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Asset)) {
            return false;
        }
        Asset other = (Asset)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$certificateUpdatedAt = this.getCertificateUpdatedAt();
        Long other$certificateUpdatedAt = other.getCertificateUpdatedAt();
        if (this$certificateUpdatedAt == null ? other$certificateUpdatedAt != null : !((Object)this$certificateUpdatedAt).equals(other$certificateUpdatedAt)) {
            return false;
        }
        Long this$announcementUpdatedAt = this.getAnnouncementUpdatedAt();
        Long other$announcementUpdatedAt = other.getAnnouncementUpdatedAt();
        if (this$announcementUpdatedAt == null ? other$announcementUpdatedAt != null : !((Object)this$announcementUpdatedAt).equals(other$announcementUpdatedAt)) {
            return false;
        }
        Boolean this$hasLineage = this.getHasLineage();
        Boolean other$hasLineage = other.getHasLineage();
        if (this$hasLineage == null ? other$hasLineage != null : !((Object)this$hasLineage).equals(other$hasLineage)) {
            return false;
        }
        Boolean this$isDiscoverable = this.getIsDiscoverable();
        Boolean other$isDiscoverable = other.getIsDiscoverable();
        if (this$isDiscoverable == null ? other$isDiscoverable != null : !((Object)this$isDiscoverable).equals(other$isDiscoverable)) {
            return false;
        }
        Boolean this$isEditable = this.getIsEditable();
        Boolean other$isEditable = other.getIsEditable();
        if (this$isEditable == null ? other$isEditable != null : !((Object)this$isEditable).equals(other$isEditable)) {
            return false;
        }
        Double this$viewScore = this.getViewScore();
        Double other$viewScore = other.getViewScore();
        if (this$viewScore == null ? other$viewScore != null : !((Object)this$viewScore).equals(other$viewScore)) {
            return false;
        }
        Double this$popularityScore = this.getPopularityScore();
        Double other$popularityScore = other.getPopularityScore();
        if (this$popularityScore == null ? other$popularityScore != null : !((Object)this$popularityScore).equals(other$popularityScore)) {
            return false;
        }
        Long this$lastSyncRunAt = this.getLastSyncRunAt();
        Long other$lastSyncRunAt = other.getLastSyncRunAt();
        if (this$lastSyncRunAt == null ? other$lastSyncRunAt != null : !((Object)this$lastSyncRunAt).equals(other$lastSyncRunAt)) {
            return false;
        }
        Long this$sourceCreatedAt = this.getSourceCreatedAt();
        Long other$sourceCreatedAt = other.getSourceCreatedAt();
        if (this$sourceCreatedAt == null ? other$sourceCreatedAt != null : !((Object)this$sourceCreatedAt).equals(other$sourceCreatedAt)) {
            return false;
        }
        Long this$sourceUpdatedAt = this.getSourceUpdatedAt();
        Long other$sourceUpdatedAt = other.getSourceUpdatedAt();
        if (this$sourceUpdatedAt == null ? other$sourceUpdatedAt != null : !((Object)this$sourceUpdatedAt).equals(other$sourceUpdatedAt)) {
            return false;
        }
        Long this$assetDbtJobLastRun = this.getAssetDbtJobLastRun();
        Long other$assetDbtJobLastRun = other.getAssetDbtJobLastRun();
        if (this$assetDbtJobLastRun == null ? other$assetDbtJobLastRun != null : !((Object)this$assetDbtJobLastRun).equals(other$assetDbtJobLastRun)) {
            return false;
        }
        Long this$assetDbtJobLastRunCreatedAt = this.getAssetDbtJobLastRunCreatedAt();
        Long other$assetDbtJobLastRunCreatedAt = other.getAssetDbtJobLastRunCreatedAt();
        if (this$assetDbtJobLastRunCreatedAt == null ? other$assetDbtJobLastRunCreatedAt != null : !((Object)this$assetDbtJobLastRunCreatedAt).equals(other$assetDbtJobLastRunCreatedAt)) {
            return false;
        }
        Long this$assetDbtJobLastRunUpdatedAt = this.getAssetDbtJobLastRunUpdatedAt();
        Long other$assetDbtJobLastRunUpdatedAt = other.getAssetDbtJobLastRunUpdatedAt();
        if (this$assetDbtJobLastRunUpdatedAt == null ? other$assetDbtJobLastRunUpdatedAt != null : !((Object)this$assetDbtJobLastRunUpdatedAt).equals(other$assetDbtJobLastRunUpdatedAt)) {
            return false;
        }
        Long this$assetDbtJobLastRunDequedAt = this.getAssetDbtJobLastRunDequedAt();
        Long other$assetDbtJobLastRunDequedAt = other.getAssetDbtJobLastRunDequedAt();
        if (this$assetDbtJobLastRunDequedAt == null ? other$assetDbtJobLastRunDequedAt != null : !((Object)this$assetDbtJobLastRunDequedAt).equals(other$assetDbtJobLastRunDequedAt)) {
            return false;
        }
        Long this$assetDbtJobLastRunStartedAt = this.getAssetDbtJobLastRunStartedAt();
        Long other$assetDbtJobLastRunStartedAt = other.getAssetDbtJobLastRunStartedAt();
        if (this$assetDbtJobLastRunStartedAt == null ? other$assetDbtJobLastRunStartedAt != null : !((Object)this$assetDbtJobLastRunStartedAt).equals(other$assetDbtJobLastRunStartedAt)) {
            return false;
        }
        Boolean this$assetDbtJobLastRunArtifactsSaved = this.getAssetDbtJobLastRunArtifactsSaved();
        Boolean other$assetDbtJobLastRunArtifactsSaved = other.getAssetDbtJobLastRunArtifactsSaved();
        if (this$assetDbtJobLastRunArtifactsSaved == null ? other$assetDbtJobLastRunArtifactsSaved != null : !((Object)this$assetDbtJobLastRunArtifactsSaved).equals(other$assetDbtJobLastRunArtifactsSaved)) {
            return false;
        }
        Boolean this$assetDbtJobLastRunHasDocsGenerated = this.getAssetDbtJobLastRunHasDocsGenerated();
        Boolean other$assetDbtJobLastRunHasDocsGenerated = other.getAssetDbtJobLastRunHasDocsGenerated();
        if (this$assetDbtJobLastRunHasDocsGenerated == null ? other$assetDbtJobLastRunHasDocsGenerated != null : !((Object)this$assetDbtJobLastRunHasDocsGenerated).equals(other$assetDbtJobLastRunHasDocsGenerated)) {
            return false;
        }
        Boolean this$assetDbtJobLastRunHasSourcesGenerated = this.getAssetDbtJobLastRunHasSourcesGenerated();
        Boolean other$assetDbtJobLastRunHasSourcesGenerated = other.getAssetDbtJobLastRunHasSourcesGenerated();
        if (this$assetDbtJobLastRunHasSourcesGenerated == null ? other$assetDbtJobLastRunHasSourcesGenerated != null : !((Object)this$assetDbtJobLastRunHasSourcesGenerated).equals(other$assetDbtJobLastRunHasSourcesGenerated)) {
            return false;
        }
        Boolean this$assetDbtJobLastRunNotificationsSent = this.getAssetDbtJobLastRunNotificationsSent();
        Boolean other$assetDbtJobLastRunNotificationsSent = other.getAssetDbtJobLastRunNotificationsSent();
        if (this$assetDbtJobLastRunNotificationsSent == null ? other$assetDbtJobLastRunNotificationsSent != null : !((Object)this$assetDbtJobLastRunNotificationsSent).equals(other$assetDbtJobLastRunNotificationsSent)) {
            return false;
        }
        Long this$assetDbtJobNextRun = this.getAssetDbtJobNextRun();
        Long other$assetDbtJobNextRun = other.getAssetDbtJobNextRun();
        if (this$assetDbtJobNextRun == null ? other$assetDbtJobNextRun != null : !((Object)this$assetDbtJobNextRun).equals(other$assetDbtJobNextRun)) {
            return false;
        }
        String this$qualifiedName = this.getQualifiedName();
        String other$qualifiedName = other.getQualifiedName();
        if (this$qualifiedName == null ? other$qualifiedName != null : !this$qualifiedName.equals(other$qualifiedName)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$userDescription = this.getUserDescription();
        String other$userDescription = other.getUserDescription();
        if (this$userDescription == null ? other$userDescription != null : !this$userDescription.equals(other$userDescription)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        AtlanCertificateStatus this$certificateStatus = this.getCertificateStatus();
        AtlanCertificateStatus other$certificateStatus = other.getCertificateStatus();
        if (this$certificateStatus == null ? other$certificateStatus != null : !this$certificateStatus.equals(other$certificateStatus)) {
            return false;
        }
        String this$certificateStatusMessage = this.getCertificateStatusMessage();
        String other$certificateStatusMessage = other.getCertificateStatusMessage();
        if (this$certificateStatusMessage == null ? other$certificateStatusMessage != null : !this$certificateStatusMessage.equals(other$certificateStatusMessage)) {
            return false;
        }
        String this$certificateUpdatedBy = this.getCertificateUpdatedBy();
        String other$certificateUpdatedBy = other.getCertificateUpdatedBy();
        if (this$certificateUpdatedBy == null ? other$certificateUpdatedBy != null : !this$certificateUpdatedBy.equals(other$certificateUpdatedBy)) {
            return false;
        }
        String this$announcementTitle = this.getAnnouncementTitle();
        String other$announcementTitle = other.getAnnouncementTitle();
        if (this$announcementTitle == null ? other$announcementTitle != null : !this$announcementTitle.equals(other$announcementTitle)) {
            return false;
        }
        String this$announcementMessage = this.getAnnouncementMessage();
        String other$announcementMessage = other.getAnnouncementMessage();
        if (this$announcementMessage == null ? other$announcementMessage != null : !this$announcementMessage.equals(other$announcementMessage)) {
            return false;
        }
        String this$announcementUpdatedBy = this.getAnnouncementUpdatedBy();
        String other$announcementUpdatedBy = other.getAnnouncementUpdatedBy();
        if (this$announcementUpdatedBy == null ? other$announcementUpdatedBy != null : !this$announcementUpdatedBy.equals(other$announcementUpdatedBy)) {
            return false;
        }
        AtlanAnnouncementType this$announcementType = this.getAnnouncementType();
        AtlanAnnouncementType other$announcementType = other.getAnnouncementType();
        if (this$announcementType == null ? other$announcementType != null : !this$announcementType.equals(other$announcementType)) {
            return false;
        }
        SortedSet<String> this$ownerUsers = this.getOwnerUsers();
        SortedSet<String> other$ownerUsers = other.getOwnerUsers();
        if (this$ownerUsers == null ? other$ownerUsers != null : !this$ownerUsers.equals(other$ownerUsers)) {
            return false;
        }
        SortedSet<String> this$ownerGroups = this.getOwnerGroups();
        SortedSet<String> other$ownerGroups = other.getOwnerGroups();
        if (this$ownerGroups == null ? other$ownerGroups != null : !this$ownerGroups.equals(other$ownerGroups)) {
            return false;
        }
        SortedSet<String> this$adminUsers = this.getAdminUsers();
        SortedSet<String> other$adminUsers = other.getAdminUsers();
        if (this$adminUsers == null ? other$adminUsers != null : !this$adminUsers.equals(other$adminUsers)) {
            return false;
        }
        SortedSet<String> this$adminGroups = this.getAdminGroups();
        SortedSet<String> other$adminGroups = other.getAdminGroups();
        if (this$adminGroups == null ? other$adminGroups != null : !this$adminGroups.equals(other$adminGroups)) {
            return false;
        }
        SortedSet<String> this$adminRoles = this.getAdminRoles();
        SortedSet<String> other$adminRoles = other.getAdminRoles();
        if (this$adminRoles == null ? other$adminRoles != null : !this$adminRoles.equals(other$adminRoles)) {
            return false;
        }
        SortedSet<String> this$viewerUsers = this.getViewerUsers();
        SortedSet<String> other$viewerUsers = other.getViewerUsers();
        if (this$viewerUsers == null ? other$viewerUsers != null : !this$viewerUsers.equals(other$viewerUsers)) {
            return false;
        }
        SortedSet<String> this$viewerGroups = this.getViewerGroups();
        SortedSet<String> other$viewerGroups = other.getViewerGroups();
        if (this$viewerGroups == null ? other$viewerGroups != null : !this$viewerGroups.equals(other$viewerGroups)) {
            return false;
        }
        AtlanConnectorType this$connectorType = this.getConnectorType();
        AtlanConnectorType other$connectorType = other.getConnectorType();
        if (this$connectorType == null ? other$connectorType != null : !this$connectorType.equals(other$connectorType)) {
            return false;
        }
        String this$connectionName = this.getConnectionName();
        String other$connectionName = other.getConnectionName();
        if (this$connectionName == null ? other$connectionName != null : !this$connectionName.equals(other$connectionName)) {
            return false;
        }
        String this$connectionQualifiedName = this.getConnectionQualifiedName();
        String other$connectionQualifiedName = other.getConnectionQualifiedName();
        if (this$connectionQualifiedName == null ? other$connectionQualifiedName != null : !this$connectionQualifiedName.equals(other$connectionQualifiedName)) {
            return false;
        }
        Object this$subType = this.getSubType();
        Object other$subType = other.getSubType();
        if (this$subType == null ? other$subType != null : !this$subType.equals(other$subType)) {
            return false;
        }
        String this$sourceOwners = this.getSourceOwners();
        String other$sourceOwners = other.getSourceOwners();
        if (this$sourceOwners == null ? other$sourceOwners != null : !this$sourceOwners.equals(other$sourceOwners)) {
            return false;
        }
        String this$sourceURL = this.getSourceURL();
        String other$sourceURL = other.getSourceURL();
        if (this$sourceURL == null ? other$sourceURL != null : !this$sourceURL.equals(other$sourceURL)) {
            return false;
        }
        String this$sourceEmbedURL = this.getSourceEmbedURL();
        String other$sourceEmbedURL = other.getSourceEmbedURL();
        if (this$sourceEmbedURL == null ? other$sourceEmbedURL != null : !this$sourceEmbedURL.equals(other$sourceEmbedURL)) {
            return false;
        }
        String this$lastSyncWorkflowName = this.getLastSyncWorkflowName();
        String other$lastSyncWorkflowName = other.getLastSyncWorkflowName();
        if (this$lastSyncWorkflowName == null ? other$lastSyncWorkflowName != null : !this$lastSyncWorkflowName.equals(other$lastSyncWorkflowName)) {
            return false;
        }
        String this$lastSyncRun = this.getLastSyncRun();
        String other$lastSyncRun = other.getLastSyncRun();
        if (this$lastSyncRun == null ? other$lastSyncRun != null : !this$lastSyncRun.equals(other$lastSyncRun)) {
            return false;
        }
        String this$sourceCreatedBy = this.getSourceCreatedBy();
        String other$sourceCreatedBy = other.getSourceCreatedBy();
        if (this$sourceCreatedBy == null ? other$sourceCreatedBy != null : !this$sourceCreatedBy.equals(other$sourceCreatedBy)) {
            return false;
        }
        String this$sourceUpdatedBy = this.getSourceUpdatedBy();
        String other$sourceUpdatedBy = other.getSourceUpdatedBy();
        if (this$sourceUpdatedBy == null ? other$sourceUpdatedBy != null : !this$sourceUpdatedBy.equals(other$sourceUpdatedBy)) {
            return false;
        }
        String this$dbtQualifiedName = this.getDbtQualifiedName();
        String other$dbtQualifiedName = other.getDbtQualifiedName();
        if (this$dbtQualifiedName == null ? other$dbtQualifiedName != null : !this$dbtQualifiedName.equals(other$dbtQualifiedName)) {
            return false;
        }
        String this$assetDbtAlias = this.getAssetDbtAlias();
        String other$assetDbtAlias = other.getAssetDbtAlias();
        if (this$assetDbtAlias == null ? other$assetDbtAlias != null : !this$assetDbtAlias.equals(other$assetDbtAlias)) {
            return false;
        }
        String this$assetDbtMeta = this.getAssetDbtMeta();
        String other$assetDbtMeta = other.getAssetDbtMeta();
        if (this$assetDbtMeta == null ? other$assetDbtMeta != null : !this$assetDbtMeta.equals(other$assetDbtMeta)) {
            return false;
        }
        String this$assetDbtUniqueId = this.getAssetDbtUniqueId();
        String other$assetDbtUniqueId = other.getAssetDbtUniqueId();
        if (this$assetDbtUniqueId == null ? other$assetDbtUniqueId != null : !this$assetDbtUniqueId.equals(other$assetDbtUniqueId)) {
            return false;
        }
        String this$assetDbtAccountName = this.getAssetDbtAccountName();
        String other$assetDbtAccountName = other.getAssetDbtAccountName();
        if (this$assetDbtAccountName == null ? other$assetDbtAccountName != null : !this$assetDbtAccountName.equals(other$assetDbtAccountName)) {
            return false;
        }
        String this$assetDbtProjectName = this.getAssetDbtProjectName();
        String other$assetDbtProjectName = other.getAssetDbtProjectName();
        if (this$assetDbtProjectName == null ? other$assetDbtProjectName != null : !this$assetDbtProjectName.equals(other$assetDbtProjectName)) {
            return false;
        }
        String this$assetDbtPackageName = this.getAssetDbtPackageName();
        String other$assetDbtPackageName = other.getAssetDbtPackageName();
        if (this$assetDbtPackageName == null ? other$assetDbtPackageName != null : !this$assetDbtPackageName.equals(other$assetDbtPackageName)) {
            return false;
        }
        String this$assetDbtJobName = this.getAssetDbtJobName();
        String other$assetDbtJobName = other.getAssetDbtJobName();
        if (this$assetDbtJobName == null ? other$assetDbtJobName != null : !this$assetDbtJobName.equals(other$assetDbtJobName)) {
            return false;
        }
        String this$assetDbtJobSchedule = this.getAssetDbtJobSchedule();
        String other$assetDbtJobSchedule = other.getAssetDbtJobSchedule();
        if (this$assetDbtJobSchedule == null ? other$assetDbtJobSchedule != null : !this$assetDbtJobSchedule.equals(other$assetDbtJobSchedule)) {
            return false;
        }
        String this$assetDbtJobStatus = this.getAssetDbtJobStatus();
        String other$assetDbtJobStatus = other.getAssetDbtJobStatus();
        if (this$assetDbtJobStatus == null ? other$assetDbtJobStatus != null : !this$assetDbtJobStatus.equals(other$assetDbtJobStatus)) {
            return false;
        }
        String this$assetDbtJobScheduleCronHumanized = this.getAssetDbtJobScheduleCronHumanized();
        String other$assetDbtJobScheduleCronHumanized = other.getAssetDbtJobScheduleCronHumanized();
        if (this$assetDbtJobScheduleCronHumanized == null ? other$assetDbtJobScheduleCronHumanized != null : !this$assetDbtJobScheduleCronHumanized.equals(other$assetDbtJobScheduleCronHumanized)) {
            return false;
        }
        String this$assetDbtJobLastRunUrl = this.getAssetDbtJobLastRunUrl();
        String other$assetDbtJobLastRunUrl = other.getAssetDbtJobLastRunUrl();
        if (this$assetDbtJobLastRunUrl == null ? other$assetDbtJobLastRunUrl != null : !this$assetDbtJobLastRunUrl.equals(other$assetDbtJobLastRunUrl)) {
            return false;
        }
        String this$assetDbtJobLastRunTotalDuration = this.getAssetDbtJobLastRunTotalDuration();
        String other$assetDbtJobLastRunTotalDuration = other.getAssetDbtJobLastRunTotalDuration();
        if (this$assetDbtJobLastRunTotalDuration == null ? other$assetDbtJobLastRunTotalDuration != null : !this$assetDbtJobLastRunTotalDuration.equals(other$assetDbtJobLastRunTotalDuration)) {
            return false;
        }
        String this$assetDbtJobLastRunTotalDurationHumanized = this.getAssetDbtJobLastRunTotalDurationHumanized();
        String other$assetDbtJobLastRunTotalDurationHumanized = other.getAssetDbtJobLastRunTotalDurationHumanized();
        if (this$assetDbtJobLastRunTotalDurationHumanized == null ? other$assetDbtJobLastRunTotalDurationHumanized != null : !this$assetDbtJobLastRunTotalDurationHumanized.equals(other$assetDbtJobLastRunTotalDurationHumanized)) {
            return false;
        }
        String this$assetDbtJobLastRunQueuedDuration = this.getAssetDbtJobLastRunQueuedDuration();
        String other$assetDbtJobLastRunQueuedDuration = other.getAssetDbtJobLastRunQueuedDuration();
        if (this$assetDbtJobLastRunQueuedDuration == null ? other$assetDbtJobLastRunQueuedDuration != null : !this$assetDbtJobLastRunQueuedDuration.equals(other$assetDbtJobLastRunQueuedDuration)) {
            return false;
        }
        String this$assetDbtJobLastRunQueuedDurationHumanized = this.getAssetDbtJobLastRunQueuedDurationHumanized();
        String other$assetDbtJobLastRunQueuedDurationHumanized = other.getAssetDbtJobLastRunQueuedDurationHumanized();
        if (this$assetDbtJobLastRunQueuedDurationHumanized == null ? other$assetDbtJobLastRunQueuedDurationHumanized != null : !this$assetDbtJobLastRunQueuedDurationHumanized.equals(other$assetDbtJobLastRunQueuedDurationHumanized)) {
            return false;
        }
        String this$assetDbtJobLastRunRunDuration = this.getAssetDbtJobLastRunRunDuration();
        String other$assetDbtJobLastRunRunDuration = other.getAssetDbtJobLastRunRunDuration();
        if (this$assetDbtJobLastRunRunDuration == null ? other$assetDbtJobLastRunRunDuration != null : !this$assetDbtJobLastRunRunDuration.equals(other$assetDbtJobLastRunRunDuration)) {
            return false;
        }
        String this$assetDbtJobLastRunRunDurationHumanized = this.getAssetDbtJobLastRunRunDurationHumanized();
        String other$assetDbtJobLastRunRunDurationHumanized = other.getAssetDbtJobLastRunRunDurationHumanized();
        if (this$assetDbtJobLastRunRunDurationHumanized == null ? other$assetDbtJobLastRunRunDurationHumanized != null : !this$assetDbtJobLastRunRunDurationHumanized.equals(other$assetDbtJobLastRunRunDurationHumanized)) {
            return false;
        }
        String this$assetDbtJobLastRunGitBranch = this.getAssetDbtJobLastRunGitBranch();
        String other$assetDbtJobLastRunGitBranch = other.getAssetDbtJobLastRunGitBranch();
        if (this$assetDbtJobLastRunGitBranch == null ? other$assetDbtJobLastRunGitBranch != null : !this$assetDbtJobLastRunGitBranch.equals(other$assetDbtJobLastRunGitBranch)) {
            return false;
        }
        String this$assetDbtJobLastRunGitSha = this.getAssetDbtJobLastRunGitSha();
        String other$assetDbtJobLastRunGitSha = other.getAssetDbtJobLastRunGitSha();
        if (this$assetDbtJobLastRunGitSha == null ? other$assetDbtJobLastRunGitSha != null : !this$assetDbtJobLastRunGitSha.equals(other$assetDbtJobLastRunGitSha)) {
            return false;
        }
        String this$assetDbtJobLastRunStatusMessage = this.getAssetDbtJobLastRunStatusMessage();
        String other$assetDbtJobLastRunStatusMessage = other.getAssetDbtJobLastRunStatusMessage();
        if (this$assetDbtJobLastRunStatusMessage == null ? other$assetDbtJobLastRunStatusMessage != null : !this$assetDbtJobLastRunStatusMessage.equals(other$assetDbtJobLastRunStatusMessage)) {
            return false;
        }
        String this$assetDbtJobLastRunOwnerThreadId = this.getAssetDbtJobLastRunOwnerThreadId();
        String other$assetDbtJobLastRunOwnerThreadId = other.getAssetDbtJobLastRunOwnerThreadId();
        if (this$assetDbtJobLastRunOwnerThreadId == null ? other$assetDbtJobLastRunOwnerThreadId != null : !this$assetDbtJobLastRunOwnerThreadId.equals(other$assetDbtJobLastRunOwnerThreadId)) {
            return false;
        }
        String this$assetDbtJobLastRunExecutedByThreadId = this.getAssetDbtJobLastRunExecutedByThreadId();
        String other$assetDbtJobLastRunExecutedByThreadId = other.getAssetDbtJobLastRunExecutedByThreadId();
        if (this$assetDbtJobLastRunExecutedByThreadId == null ? other$assetDbtJobLastRunExecutedByThreadId != null : !this$assetDbtJobLastRunExecutedByThreadId.equals(other$assetDbtJobLastRunExecutedByThreadId)) {
            return false;
        }
        String this$assetDbtJobLastRunArtifactS3Path = this.getAssetDbtJobLastRunArtifactS3Path();
        String other$assetDbtJobLastRunArtifactS3Path = other.getAssetDbtJobLastRunArtifactS3Path();
        if (this$assetDbtJobLastRunArtifactS3Path == null ? other$assetDbtJobLastRunArtifactS3Path != null : !this$assetDbtJobLastRunArtifactS3Path.equals(other$assetDbtJobLastRunArtifactS3Path)) {
            return false;
        }
        String this$assetDbtJobNextRunHumanized = this.getAssetDbtJobNextRunHumanized();
        String other$assetDbtJobNextRunHumanized = other.getAssetDbtJobNextRunHumanized();
        if (this$assetDbtJobNextRunHumanized == null ? other$assetDbtJobNextRunHumanized != null : !this$assetDbtJobNextRunHumanized.equals(other$assetDbtJobNextRunHumanized)) {
            return false;
        }
        String this$assetDbtEnvironmentName = this.getAssetDbtEnvironmentName();
        String other$assetDbtEnvironmentName = other.getAssetDbtEnvironmentName();
        if (this$assetDbtEnvironmentName == null ? other$assetDbtEnvironmentName != null : !this$assetDbtEnvironmentName.equals(other$assetDbtEnvironmentName)) {
            return false;
        }
        String this$assetDbtEnvironmentDbtVersion = this.getAssetDbtEnvironmentDbtVersion();
        String other$assetDbtEnvironmentDbtVersion = other.getAssetDbtEnvironmentDbtVersion();
        if (this$assetDbtEnvironmentDbtVersion == null ? other$assetDbtEnvironmentDbtVersion != null : !this$assetDbtEnvironmentDbtVersion.equals(other$assetDbtEnvironmentDbtVersion)) {
            return false;
        }
        SortedSet<String> this$assetDbtTags = this.getAssetDbtTags();
        SortedSet<String> other$assetDbtTags = other.getAssetDbtTags();
        if (this$assetDbtTags == null ? other$assetDbtTags != null : !this$assetDbtTags.equals(other$assetDbtTags)) {
            return false;
        }
        String this$assetDbtSemanticLayerProxyUrl = this.getAssetDbtSemanticLayerProxyUrl();
        String other$assetDbtSemanticLayerProxyUrl = other.getAssetDbtSemanticLayerProxyUrl();
        if (this$assetDbtSemanticLayerProxyUrl == null ? other$assetDbtSemanticLayerProxyUrl != null : !this$assetDbtSemanticLayerProxyUrl.equals(other$assetDbtSemanticLayerProxyUrl)) {
            return false;
        }
        SortedSet<Link> this$links = this.getLinks();
        SortedSet<Link> other$links = other.getLinks();
        if (this$links == null ? other$links != null : !this$links.equals(other$links)) {
            return false;
        }
        Readme this$readme = this.getReadme();
        Readme other$readme = other.getReadme();
        if (this$readme == null ? other$readme != null : !((Object)this$readme).equals(other$readme)) {
            return false;
        }
        SortedSet<GlossaryTerm> this$assignedTerms = this.getAssignedTerms();
        SortedSet<GlossaryTerm> other$assignedTerms = other.getAssignedTerms();
        return !(this$assignedTerms == null ? other$assignedTerms != null : !this$assignedTerms.equals(other$assignedTerms));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Asset;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $certificateUpdatedAt = this.getCertificateUpdatedAt();
        result = result * 59 + ($certificateUpdatedAt == null ? 43 : ((Object)$certificateUpdatedAt).hashCode());
        Long $announcementUpdatedAt = this.getAnnouncementUpdatedAt();
        result = result * 59 + ($announcementUpdatedAt == null ? 43 : ((Object)$announcementUpdatedAt).hashCode());
        Boolean $hasLineage = this.getHasLineage();
        result = result * 59 + ($hasLineage == null ? 43 : ((Object)$hasLineage).hashCode());
        Boolean $isDiscoverable = this.getIsDiscoverable();
        result = result * 59 + ($isDiscoverable == null ? 43 : ((Object)$isDiscoverable).hashCode());
        Boolean $isEditable = this.getIsEditable();
        result = result * 59 + ($isEditable == null ? 43 : ((Object)$isEditable).hashCode());
        Double $viewScore = this.getViewScore();
        result = result * 59 + ($viewScore == null ? 43 : ((Object)$viewScore).hashCode());
        Double $popularityScore = this.getPopularityScore();
        result = result * 59 + ($popularityScore == null ? 43 : ((Object)$popularityScore).hashCode());
        Long $lastSyncRunAt = this.getLastSyncRunAt();
        result = result * 59 + ($lastSyncRunAt == null ? 43 : ((Object)$lastSyncRunAt).hashCode());
        Long $sourceCreatedAt = this.getSourceCreatedAt();
        result = result * 59 + ($sourceCreatedAt == null ? 43 : ((Object)$sourceCreatedAt).hashCode());
        Long $sourceUpdatedAt = this.getSourceUpdatedAt();
        result = result * 59 + ($sourceUpdatedAt == null ? 43 : ((Object)$sourceUpdatedAt).hashCode());
        Long $assetDbtJobLastRun = this.getAssetDbtJobLastRun();
        result = result * 59 + ($assetDbtJobLastRun == null ? 43 : ((Object)$assetDbtJobLastRun).hashCode());
        Long $assetDbtJobLastRunCreatedAt = this.getAssetDbtJobLastRunCreatedAt();
        result = result * 59 + ($assetDbtJobLastRunCreatedAt == null ? 43 : ((Object)$assetDbtJobLastRunCreatedAt).hashCode());
        Long $assetDbtJobLastRunUpdatedAt = this.getAssetDbtJobLastRunUpdatedAt();
        result = result * 59 + ($assetDbtJobLastRunUpdatedAt == null ? 43 : ((Object)$assetDbtJobLastRunUpdatedAt).hashCode());
        Long $assetDbtJobLastRunDequedAt = this.getAssetDbtJobLastRunDequedAt();
        result = result * 59 + ($assetDbtJobLastRunDequedAt == null ? 43 : ((Object)$assetDbtJobLastRunDequedAt).hashCode());
        Long $assetDbtJobLastRunStartedAt = this.getAssetDbtJobLastRunStartedAt();
        result = result * 59 + ($assetDbtJobLastRunStartedAt == null ? 43 : ((Object)$assetDbtJobLastRunStartedAt).hashCode());
        Boolean $assetDbtJobLastRunArtifactsSaved = this.getAssetDbtJobLastRunArtifactsSaved();
        result = result * 59 + ($assetDbtJobLastRunArtifactsSaved == null ? 43 : ((Object)$assetDbtJobLastRunArtifactsSaved).hashCode());
        Boolean $assetDbtJobLastRunHasDocsGenerated = this.getAssetDbtJobLastRunHasDocsGenerated();
        result = result * 59 + ($assetDbtJobLastRunHasDocsGenerated == null ? 43 : ((Object)$assetDbtJobLastRunHasDocsGenerated).hashCode());
        Boolean $assetDbtJobLastRunHasSourcesGenerated = this.getAssetDbtJobLastRunHasSourcesGenerated();
        result = result * 59 + ($assetDbtJobLastRunHasSourcesGenerated == null ? 43 : ((Object)$assetDbtJobLastRunHasSourcesGenerated).hashCode());
        Boolean $assetDbtJobLastRunNotificationsSent = this.getAssetDbtJobLastRunNotificationsSent();
        result = result * 59 + ($assetDbtJobLastRunNotificationsSent == null ? 43 : ((Object)$assetDbtJobLastRunNotificationsSent).hashCode());
        Long $assetDbtJobNextRun = this.getAssetDbtJobNextRun();
        result = result * 59 + ($assetDbtJobNextRun == null ? 43 : ((Object)$assetDbtJobNextRun).hashCode());
        String $qualifiedName = this.getQualifiedName();
        result = result * 59 + ($qualifiedName == null ? 43 : $qualifiedName.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $userDescription = this.getUserDescription();
        result = result * 59 + ($userDescription == null ? 43 : $userDescription.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        AtlanCertificateStatus $certificateStatus = this.getCertificateStatus();
        result = result * 59 + ($certificateStatus == null ? 43 : $certificateStatus.hashCode());
        String $certificateStatusMessage = this.getCertificateStatusMessage();
        result = result * 59 + ($certificateStatusMessage == null ? 43 : $certificateStatusMessage.hashCode());
        String $certificateUpdatedBy = this.getCertificateUpdatedBy();
        result = result * 59 + ($certificateUpdatedBy == null ? 43 : $certificateUpdatedBy.hashCode());
        String $announcementTitle = this.getAnnouncementTitle();
        result = result * 59 + ($announcementTitle == null ? 43 : $announcementTitle.hashCode());
        String $announcementMessage = this.getAnnouncementMessage();
        result = result * 59 + ($announcementMessage == null ? 43 : $announcementMessage.hashCode());
        String $announcementUpdatedBy = this.getAnnouncementUpdatedBy();
        result = result * 59 + ($announcementUpdatedBy == null ? 43 : $announcementUpdatedBy.hashCode());
        AtlanAnnouncementType $announcementType = this.getAnnouncementType();
        result = result * 59 + ($announcementType == null ? 43 : $announcementType.hashCode());
        SortedSet<String> $ownerUsers = this.getOwnerUsers();
        result = result * 59 + ($ownerUsers == null ? 43 : $ownerUsers.hashCode());
        SortedSet<String> $ownerGroups = this.getOwnerGroups();
        result = result * 59 + ($ownerGroups == null ? 43 : $ownerGroups.hashCode());
        SortedSet<String> $adminUsers = this.getAdminUsers();
        result = result * 59 + ($adminUsers == null ? 43 : $adminUsers.hashCode());
        SortedSet<String> $adminGroups = this.getAdminGroups();
        result = result * 59 + ($adminGroups == null ? 43 : $adminGroups.hashCode());
        SortedSet<String> $adminRoles = this.getAdminRoles();
        result = result * 59 + ($adminRoles == null ? 43 : $adminRoles.hashCode());
        SortedSet<String> $viewerUsers = this.getViewerUsers();
        result = result * 59 + ($viewerUsers == null ? 43 : $viewerUsers.hashCode());
        SortedSet<String> $viewerGroups = this.getViewerGroups();
        result = result * 59 + ($viewerGroups == null ? 43 : $viewerGroups.hashCode());
        AtlanConnectorType $connectorType = this.getConnectorType();
        result = result * 59 + ($connectorType == null ? 43 : $connectorType.hashCode());
        String $connectionName = this.getConnectionName();
        result = result * 59 + ($connectionName == null ? 43 : $connectionName.hashCode());
        String $connectionQualifiedName = this.getConnectionQualifiedName();
        result = result * 59 + ($connectionQualifiedName == null ? 43 : $connectionQualifiedName.hashCode());
        Object $subType = this.getSubType();
        result = result * 59 + ($subType == null ? 43 : $subType.hashCode());
        String $sourceOwners = this.getSourceOwners();
        result = result * 59 + ($sourceOwners == null ? 43 : $sourceOwners.hashCode());
        String $sourceURL = this.getSourceURL();
        result = result * 59 + ($sourceURL == null ? 43 : $sourceURL.hashCode());
        String $sourceEmbedURL = this.getSourceEmbedURL();
        result = result * 59 + ($sourceEmbedURL == null ? 43 : $sourceEmbedURL.hashCode());
        String $lastSyncWorkflowName = this.getLastSyncWorkflowName();
        result = result * 59 + ($lastSyncWorkflowName == null ? 43 : $lastSyncWorkflowName.hashCode());
        String $lastSyncRun = this.getLastSyncRun();
        result = result * 59 + ($lastSyncRun == null ? 43 : $lastSyncRun.hashCode());
        String $sourceCreatedBy = this.getSourceCreatedBy();
        result = result * 59 + ($sourceCreatedBy == null ? 43 : $sourceCreatedBy.hashCode());
        String $sourceUpdatedBy = this.getSourceUpdatedBy();
        result = result * 59 + ($sourceUpdatedBy == null ? 43 : $sourceUpdatedBy.hashCode());
        String $dbtQualifiedName = this.getDbtQualifiedName();
        result = result * 59 + ($dbtQualifiedName == null ? 43 : $dbtQualifiedName.hashCode());
        String $assetDbtAlias = this.getAssetDbtAlias();
        result = result * 59 + ($assetDbtAlias == null ? 43 : $assetDbtAlias.hashCode());
        String $assetDbtMeta = this.getAssetDbtMeta();
        result = result * 59 + ($assetDbtMeta == null ? 43 : $assetDbtMeta.hashCode());
        String $assetDbtUniqueId = this.getAssetDbtUniqueId();
        result = result * 59 + ($assetDbtUniqueId == null ? 43 : $assetDbtUniqueId.hashCode());
        String $assetDbtAccountName = this.getAssetDbtAccountName();
        result = result * 59 + ($assetDbtAccountName == null ? 43 : $assetDbtAccountName.hashCode());
        String $assetDbtProjectName = this.getAssetDbtProjectName();
        result = result * 59 + ($assetDbtProjectName == null ? 43 : $assetDbtProjectName.hashCode());
        String $assetDbtPackageName = this.getAssetDbtPackageName();
        result = result * 59 + ($assetDbtPackageName == null ? 43 : $assetDbtPackageName.hashCode());
        String $assetDbtJobName = this.getAssetDbtJobName();
        result = result * 59 + ($assetDbtJobName == null ? 43 : $assetDbtJobName.hashCode());
        String $assetDbtJobSchedule = this.getAssetDbtJobSchedule();
        result = result * 59 + ($assetDbtJobSchedule == null ? 43 : $assetDbtJobSchedule.hashCode());
        String $assetDbtJobStatus = this.getAssetDbtJobStatus();
        result = result * 59 + ($assetDbtJobStatus == null ? 43 : $assetDbtJobStatus.hashCode());
        String $assetDbtJobScheduleCronHumanized = this.getAssetDbtJobScheduleCronHumanized();
        result = result * 59 + ($assetDbtJobScheduleCronHumanized == null ? 43 : $assetDbtJobScheduleCronHumanized.hashCode());
        String $assetDbtJobLastRunUrl = this.getAssetDbtJobLastRunUrl();
        result = result * 59 + ($assetDbtJobLastRunUrl == null ? 43 : $assetDbtJobLastRunUrl.hashCode());
        String $assetDbtJobLastRunTotalDuration = this.getAssetDbtJobLastRunTotalDuration();
        result = result * 59 + ($assetDbtJobLastRunTotalDuration == null ? 43 : $assetDbtJobLastRunTotalDuration.hashCode());
        String $assetDbtJobLastRunTotalDurationHumanized = this.getAssetDbtJobLastRunTotalDurationHumanized();
        result = result * 59 + ($assetDbtJobLastRunTotalDurationHumanized == null ? 43 : $assetDbtJobLastRunTotalDurationHumanized.hashCode());
        String $assetDbtJobLastRunQueuedDuration = this.getAssetDbtJobLastRunQueuedDuration();
        result = result * 59 + ($assetDbtJobLastRunQueuedDuration == null ? 43 : $assetDbtJobLastRunQueuedDuration.hashCode());
        String $assetDbtJobLastRunQueuedDurationHumanized = this.getAssetDbtJobLastRunQueuedDurationHumanized();
        result = result * 59 + ($assetDbtJobLastRunQueuedDurationHumanized == null ? 43 : $assetDbtJobLastRunQueuedDurationHumanized.hashCode());
        String $assetDbtJobLastRunRunDuration = this.getAssetDbtJobLastRunRunDuration();
        result = result * 59 + ($assetDbtJobLastRunRunDuration == null ? 43 : $assetDbtJobLastRunRunDuration.hashCode());
        String $assetDbtJobLastRunRunDurationHumanized = this.getAssetDbtJobLastRunRunDurationHumanized();
        result = result * 59 + ($assetDbtJobLastRunRunDurationHumanized == null ? 43 : $assetDbtJobLastRunRunDurationHumanized.hashCode());
        String $assetDbtJobLastRunGitBranch = this.getAssetDbtJobLastRunGitBranch();
        result = result * 59 + ($assetDbtJobLastRunGitBranch == null ? 43 : $assetDbtJobLastRunGitBranch.hashCode());
        String $assetDbtJobLastRunGitSha = this.getAssetDbtJobLastRunGitSha();
        result = result * 59 + ($assetDbtJobLastRunGitSha == null ? 43 : $assetDbtJobLastRunGitSha.hashCode());
        String $assetDbtJobLastRunStatusMessage = this.getAssetDbtJobLastRunStatusMessage();
        result = result * 59 + ($assetDbtJobLastRunStatusMessage == null ? 43 : $assetDbtJobLastRunStatusMessage.hashCode());
        String $assetDbtJobLastRunOwnerThreadId = this.getAssetDbtJobLastRunOwnerThreadId();
        result = result * 59 + ($assetDbtJobLastRunOwnerThreadId == null ? 43 : $assetDbtJobLastRunOwnerThreadId.hashCode());
        String $assetDbtJobLastRunExecutedByThreadId = this.getAssetDbtJobLastRunExecutedByThreadId();
        result = result * 59 + ($assetDbtJobLastRunExecutedByThreadId == null ? 43 : $assetDbtJobLastRunExecutedByThreadId.hashCode());
        String $assetDbtJobLastRunArtifactS3Path = this.getAssetDbtJobLastRunArtifactS3Path();
        result = result * 59 + ($assetDbtJobLastRunArtifactS3Path == null ? 43 : $assetDbtJobLastRunArtifactS3Path.hashCode());
        String $assetDbtJobNextRunHumanized = this.getAssetDbtJobNextRunHumanized();
        result = result * 59 + ($assetDbtJobNextRunHumanized == null ? 43 : $assetDbtJobNextRunHumanized.hashCode());
        String $assetDbtEnvironmentName = this.getAssetDbtEnvironmentName();
        result = result * 59 + ($assetDbtEnvironmentName == null ? 43 : $assetDbtEnvironmentName.hashCode());
        String $assetDbtEnvironmentDbtVersion = this.getAssetDbtEnvironmentDbtVersion();
        result = result * 59 + ($assetDbtEnvironmentDbtVersion == null ? 43 : $assetDbtEnvironmentDbtVersion.hashCode());
        SortedSet<String> $assetDbtTags = this.getAssetDbtTags();
        result = result * 59 + ($assetDbtTags == null ? 43 : $assetDbtTags.hashCode());
        String $assetDbtSemanticLayerProxyUrl = this.getAssetDbtSemanticLayerProxyUrl();
        result = result * 59 + ($assetDbtSemanticLayerProxyUrl == null ? 43 : $assetDbtSemanticLayerProxyUrl.hashCode());
        SortedSet<Link> $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : $links.hashCode());
        Readme $readme = this.getReadme();
        result = result * 59 + ($readme == null ? 43 : ((Object)$readme).hashCode());
        SortedSet<GlossaryTerm> $assignedTerms = this.getAssignedTerms();
        result = result * 59 + ($assignedTerms == null ? 43 : $assignedTerms.hashCode());
        return result;
    }

    @Generated
    public static abstract class AssetBuilder<C extends Asset, B extends AssetBuilder<C, B>>
    extends Entity.EntityBuilder<C, B> {
        @Generated
        private String qualifiedName;
        @Generated
        private String name;
        @Generated
        private String displayName;
        @Generated
        private String description;
        @Generated
        private String userDescription;
        @Generated
        private String tenantId;
        @Generated
        private AtlanCertificateStatus certificateStatus;
        @Generated
        private String certificateStatusMessage;
        @Generated
        private String certificateUpdatedBy;
        @Generated
        private Long certificateUpdatedAt;
        @Generated
        private String announcementTitle;
        @Generated
        private String announcementMessage;
        @Generated
        private Long announcementUpdatedAt;
        @Generated
        private String announcementUpdatedBy;
        @Generated
        private AtlanAnnouncementType announcementType;
        @Generated
        private ArrayList<String> ownerUsers;
        @Generated
        private ArrayList<String> ownerGroups;
        @Generated
        private ArrayList<String> adminUsers;
        @Generated
        private ArrayList<String> adminGroups;
        @Generated
        private ArrayList<String> adminRoles;
        @Generated
        private ArrayList<String> viewerUsers;
        @Generated
        private ArrayList<String> viewerGroups;
        @Generated
        private AtlanConnectorType connectorType;
        @Generated
        private String connectionName;
        @Generated
        private String connectionQualifiedName;
        @Generated
        private Boolean hasLineage;
        @Generated
        private Boolean isDiscoverable;
        @Generated
        private Boolean isEditable;
        @Generated
        private Object subType;
        @Generated
        private Double viewScore;
        @Generated
        private Double popularityScore;
        @Generated
        private String sourceOwners;
        @Generated
        private String sourceURL;
        @Generated
        private String sourceEmbedURL;
        @Generated
        private String lastSyncWorkflowName;
        @Generated
        private Long lastSyncRunAt;
        @Generated
        private String lastSyncRun;
        @Generated
        private String sourceCreatedBy;
        @Generated
        private Long sourceCreatedAt;
        @Generated
        private Long sourceUpdatedAt;
        @Generated
        private String sourceUpdatedBy;
        @Generated
        private String dbtQualifiedName;
        @Generated
        private String assetDbtAlias;
        @Generated
        private String assetDbtMeta;
        @Generated
        private String assetDbtUniqueId;
        @Generated
        private String assetDbtAccountName;
        @Generated
        private String assetDbtProjectName;
        @Generated
        private String assetDbtPackageName;
        @Generated
        private String assetDbtJobName;
        @Generated
        private String assetDbtJobSchedule;
        @Generated
        private String assetDbtJobStatus;
        @Generated
        private String assetDbtJobScheduleCronHumanized;
        @Generated
        private Long assetDbtJobLastRun;
        @Generated
        private String assetDbtJobLastRunUrl;
        @Generated
        private Long assetDbtJobLastRunCreatedAt;
        @Generated
        private Long assetDbtJobLastRunUpdatedAt;
        @Generated
        private Long assetDbtJobLastRunDequedAt;
        @Generated
        private Long assetDbtJobLastRunStartedAt;
        @Generated
        private String assetDbtJobLastRunTotalDuration;
        @Generated
        private String assetDbtJobLastRunTotalDurationHumanized;
        @Generated
        private String assetDbtJobLastRunQueuedDuration;
        @Generated
        private String assetDbtJobLastRunQueuedDurationHumanized;
        @Generated
        private String assetDbtJobLastRunRunDuration;
        @Generated
        private String assetDbtJobLastRunRunDurationHumanized;
        @Generated
        private String assetDbtJobLastRunGitBranch;
        @Generated
        private String assetDbtJobLastRunGitSha;
        @Generated
        private String assetDbtJobLastRunStatusMessage;
        @Generated
        private String assetDbtJobLastRunOwnerThreadId;
        @Generated
        private String assetDbtJobLastRunExecutedByThreadId;
        @Generated
        private Boolean assetDbtJobLastRunArtifactsSaved;
        @Generated
        private String assetDbtJobLastRunArtifactS3Path;
        @Generated
        private Boolean assetDbtJobLastRunHasDocsGenerated;
        @Generated
        private Boolean assetDbtJobLastRunHasSourcesGenerated;
        @Generated
        private Boolean assetDbtJobLastRunNotificationsSent;
        @Generated
        private Long assetDbtJobNextRun;
        @Generated
        private String assetDbtJobNextRunHumanized;
        @Generated
        private String assetDbtEnvironmentName;
        @Generated
        private String assetDbtEnvironmentDbtVersion;
        @Generated
        private ArrayList<String> assetDbtTags;
        @Generated
        private String assetDbtSemanticLayerProxyUrl;
        @Generated
        private ArrayList<Link> links;
        @Generated
        private Readme readme;
        @Generated
        private ArrayList<GlossaryTerm> assignedTerms;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AssetBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Asset instance, AssetBuilder<?, ?> b) {
            b.qualifiedName(instance.qualifiedName);
            b.name(instance.name);
            b.displayName(instance.displayName);
            b.description(instance.description);
            b.userDescription(instance.userDescription);
            b.tenantId(instance.tenantId);
            b.certificateStatus(instance.certificateStatus);
            b.certificateStatusMessage(instance.certificateStatusMessage);
            b.certificateUpdatedBy(instance.certificateUpdatedBy);
            b.certificateUpdatedAt(instance.certificateUpdatedAt);
            b.announcementTitle(instance.announcementTitle);
            b.announcementMessage(instance.announcementMessage);
            b.announcementUpdatedAt(instance.announcementUpdatedAt);
            b.announcementUpdatedBy(instance.announcementUpdatedBy);
            b.announcementType(instance.announcementType);
            b.ownerUsers(instance.ownerUsers == null ? Collections.emptySortedSet() : instance.ownerUsers);
            b.ownerGroups(instance.ownerGroups == null ? Collections.emptySortedSet() : instance.ownerGroups);
            b.adminUsers(instance.adminUsers == null ? Collections.emptySortedSet() : instance.adminUsers);
            b.adminGroups(instance.adminGroups == null ? Collections.emptySortedSet() : instance.adminGroups);
            b.adminRoles(instance.adminRoles == null ? Collections.emptySortedSet() : instance.adminRoles);
            b.viewerUsers(instance.viewerUsers == null ? Collections.emptySortedSet() : instance.viewerUsers);
            b.viewerGroups(instance.viewerGroups == null ? Collections.emptySortedSet() : instance.viewerGroups);
            b.connectorType(instance.connectorType);
            b.connectionName(instance.connectionName);
            b.connectionQualifiedName(instance.connectionQualifiedName);
            b.hasLineage(instance.hasLineage);
            b.isDiscoverable(instance.isDiscoverable);
            b.isEditable(instance.isEditable);
            b.subType(instance.subType);
            b.viewScore(instance.viewScore);
            b.popularityScore(instance.popularityScore);
            b.sourceOwners(instance.sourceOwners);
            b.sourceURL(instance.sourceURL);
            b.sourceEmbedURL(instance.sourceEmbedURL);
            b.lastSyncWorkflowName(instance.lastSyncWorkflowName);
            b.lastSyncRunAt(instance.lastSyncRunAt);
            b.lastSyncRun(instance.lastSyncRun);
            b.sourceCreatedBy(instance.sourceCreatedBy);
            b.sourceCreatedAt(instance.sourceCreatedAt);
            b.sourceUpdatedAt(instance.sourceUpdatedAt);
            b.sourceUpdatedBy(instance.sourceUpdatedBy);
            b.dbtQualifiedName(instance.dbtQualifiedName);
            b.assetDbtAlias(instance.assetDbtAlias);
            b.assetDbtMeta(instance.assetDbtMeta);
            b.assetDbtUniqueId(instance.assetDbtUniqueId);
            b.assetDbtAccountName(instance.assetDbtAccountName);
            b.assetDbtProjectName(instance.assetDbtProjectName);
            b.assetDbtPackageName(instance.assetDbtPackageName);
            b.assetDbtJobName(instance.assetDbtJobName);
            b.assetDbtJobSchedule(instance.assetDbtJobSchedule);
            b.assetDbtJobStatus(instance.assetDbtJobStatus);
            b.assetDbtJobScheduleCronHumanized(instance.assetDbtJobScheduleCronHumanized);
            b.assetDbtJobLastRun(instance.assetDbtJobLastRun);
            b.assetDbtJobLastRunUrl(instance.assetDbtJobLastRunUrl);
            b.assetDbtJobLastRunCreatedAt(instance.assetDbtJobLastRunCreatedAt);
            b.assetDbtJobLastRunUpdatedAt(instance.assetDbtJobLastRunUpdatedAt);
            b.assetDbtJobLastRunDequedAt(instance.assetDbtJobLastRunDequedAt);
            b.assetDbtJobLastRunStartedAt(instance.assetDbtJobLastRunStartedAt);
            b.assetDbtJobLastRunTotalDuration(instance.assetDbtJobLastRunTotalDuration);
            b.assetDbtJobLastRunTotalDurationHumanized(instance.assetDbtJobLastRunTotalDurationHumanized);
            b.assetDbtJobLastRunQueuedDuration(instance.assetDbtJobLastRunQueuedDuration);
            b.assetDbtJobLastRunQueuedDurationHumanized(instance.assetDbtJobLastRunQueuedDurationHumanized);
            b.assetDbtJobLastRunRunDuration(instance.assetDbtJobLastRunRunDuration);
            b.assetDbtJobLastRunRunDurationHumanized(instance.assetDbtJobLastRunRunDurationHumanized);
            b.assetDbtJobLastRunGitBranch(instance.assetDbtJobLastRunGitBranch);
            b.assetDbtJobLastRunGitSha(instance.assetDbtJobLastRunGitSha);
            b.assetDbtJobLastRunStatusMessage(instance.assetDbtJobLastRunStatusMessage);
            b.assetDbtJobLastRunOwnerThreadId(instance.assetDbtJobLastRunOwnerThreadId);
            b.assetDbtJobLastRunExecutedByThreadId(instance.assetDbtJobLastRunExecutedByThreadId);
            b.assetDbtJobLastRunArtifactsSaved(instance.assetDbtJobLastRunArtifactsSaved);
            b.assetDbtJobLastRunArtifactS3Path(instance.assetDbtJobLastRunArtifactS3Path);
            b.assetDbtJobLastRunHasDocsGenerated(instance.assetDbtJobLastRunHasDocsGenerated);
            b.assetDbtJobLastRunHasSourcesGenerated(instance.assetDbtJobLastRunHasSourcesGenerated);
            b.assetDbtJobLastRunNotificationsSent(instance.assetDbtJobLastRunNotificationsSent);
            b.assetDbtJobNextRun(instance.assetDbtJobNextRun);
            b.assetDbtJobNextRunHumanized(instance.assetDbtJobNextRunHumanized);
            b.assetDbtEnvironmentName(instance.assetDbtEnvironmentName);
            b.assetDbtEnvironmentDbtVersion(instance.assetDbtEnvironmentDbtVersion);
            b.assetDbtTags(instance.assetDbtTags == null ? Collections.emptySortedSet() : instance.assetDbtTags);
            b.assetDbtSemanticLayerProxyUrl(instance.assetDbtSemanticLayerProxyUrl);
            b.links(instance.links == null ? Collections.emptySortedSet() : instance.links);
            b.readme(instance.readme);
            b.assignedTerms(instance.assignedTerms == null ? Collections.emptySortedSet() : instance.assignedTerms);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Generated
        public B qualifiedName(String qualifiedName) {
            this.qualifiedName = qualifiedName;
            return (B)this.self();
        }

        @Generated
        public B name(String name) {
            this.name = name;
            return (B)this.self();
        }

        @Generated
        public B displayName(String displayName) {
            this.displayName = displayName;
            return (B)this.self();
        }

        @Generated
        public B description(String description) {
            this.description = description;
            return (B)this.self();
        }

        @Generated
        public B userDescription(String userDescription) {
            this.userDescription = userDescription;
            return (B)this.self();
        }

        @Generated
        public B tenantId(String tenantId) {
            this.tenantId = tenantId;
            return (B)this.self();
        }

        @Generated
        public B certificateStatus(AtlanCertificateStatus certificateStatus) {
            this.certificateStatus = certificateStatus;
            return (B)this.self();
        }

        @Generated
        public B certificateStatusMessage(String certificateStatusMessage) {
            this.certificateStatusMessage = certificateStatusMessage;
            return (B)this.self();
        }

        @Generated
        public B certificateUpdatedBy(String certificateUpdatedBy) {
            this.certificateUpdatedBy = certificateUpdatedBy;
            return (B)this.self();
        }

        @Generated
        public B certificateUpdatedAt(Long certificateUpdatedAt) {
            this.certificateUpdatedAt = certificateUpdatedAt;
            return (B)this.self();
        }

        @Generated
        public B announcementTitle(String announcementTitle) {
            this.announcementTitle = announcementTitle;
            return (B)this.self();
        }

        @Generated
        public B announcementMessage(String announcementMessage) {
            this.announcementMessage = announcementMessage;
            return (B)this.self();
        }

        @Generated
        public B announcementUpdatedAt(Long announcementUpdatedAt) {
            this.announcementUpdatedAt = announcementUpdatedAt;
            return (B)this.self();
        }

        @Generated
        public B announcementUpdatedBy(String announcementUpdatedBy) {
            this.announcementUpdatedBy = announcementUpdatedBy;
            return (B)this.self();
        }

        @Generated
        public B announcementType(AtlanAnnouncementType announcementType) {
            this.announcementType = announcementType;
            return (B)this.self();
        }

        @Generated
        public B ownerUser(String ownerUser) {
            if (this.ownerUsers == null) {
                this.ownerUsers = new ArrayList();
            }
            this.ownerUsers.add(ownerUser);
            return (B)this.self();
        }

        @Generated
        public B ownerUsers(Collection<? extends String> ownerUsers) {
            if (ownerUsers == null) {
                throw new NullPointerException("ownerUsers cannot be null");
            }
            if (this.ownerUsers == null) {
                this.ownerUsers = new ArrayList();
            }
            this.ownerUsers.addAll(ownerUsers);
            return (B)this.self();
        }

        @Generated
        public B clearOwnerUsers() {
            if (this.ownerUsers != null) {
                this.ownerUsers.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B ownerGroup(String ownerGroup) {
            if (this.ownerGroups == null) {
                this.ownerGroups = new ArrayList();
            }
            this.ownerGroups.add(ownerGroup);
            return (B)this.self();
        }

        @Generated
        public B ownerGroups(Collection<? extends String> ownerGroups) {
            if (ownerGroups == null) {
                throw new NullPointerException("ownerGroups cannot be null");
            }
            if (this.ownerGroups == null) {
                this.ownerGroups = new ArrayList();
            }
            this.ownerGroups.addAll(ownerGroups);
            return (B)this.self();
        }

        @Generated
        public B clearOwnerGroups() {
            if (this.ownerGroups != null) {
                this.ownerGroups.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B adminUser(String adminUser) {
            if (this.adminUsers == null) {
                this.adminUsers = new ArrayList();
            }
            this.adminUsers.add(adminUser);
            return (B)this.self();
        }

        @Generated
        public B adminUsers(Collection<? extends String> adminUsers) {
            if (adminUsers == null) {
                throw new NullPointerException("adminUsers cannot be null");
            }
            if (this.adminUsers == null) {
                this.adminUsers = new ArrayList();
            }
            this.adminUsers.addAll(adminUsers);
            return (B)this.self();
        }

        @Generated
        public B clearAdminUsers() {
            if (this.adminUsers != null) {
                this.adminUsers.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B adminGroup(String adminGroup) {
            if (this.adminGroups == null) {
                this.adminGroups = new ArrayList();
            }
            this.adminGroups.add(adminGroup);
            return (B)this.self();
        }

        @Generated
        public B adminGroups(Collection<? extends String> adminGroups) {
            if (adminGroups == null) {
                throw new NullPointerException("adminGroups cannot be null");
            }
            if (this.adminGroups == null) {
                this.adminGroups = new ArrayList();
            }
            this.adminGroups.addAll(adminGroups);
            return (B)this.self();
        }

        @Generated
        public B clearAdminGroups() {
            if (this.adminGroups != null) {
                this.adminGroups.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B adminRole(String adminRole) {
            if (this.adminRoles == null) {
                this.adminRoles = new ArrayList();
            }
            this.adminRoles.add(adminRole);
            return (B)this.self();
        }

        @Generated
        public B adminRoles(Collection<? extends String> adminRoles) {
            if (adminRoles == null) {
                throw new NullPointerException("adminRoles cannot be null");
            }
            if (this.adminRoles == null) {
                this.adminRoles = new ArrayList();
            }
            this.adminRoles.addAll(adminRoles);
            return (B)this.self();
        }

        @Generated
        public B clearAdminRoles() {
            if (this.adminRoles != null) {
                this.adminRoles.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B viewerUser(String viewerUser) {
            if (this.viewerUsers == null) {
                this.viewerUsers = new ArrayList();
            }
            this.viewerUsers.add(viewerUser);
            return (B)this.self();
        }

        @Generated
        public B viewerUsers(Collection<? extends String> viewerUsers) {
            if (viewerUsers == null) {
                throw new NullPointerException("viewerUsers cannot be null");
            }
            if (this.viewerUsers == null) {
                this.viewerUsers = new ArrayList();
            }
            this.viewerUsers.addAll(viewerUsers);
            return (B)this.self();
        }

        @Generated
        public B clearViewerUsers() {
            if (this.viewerUsers != null) {
                this.viewerUsers.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B viewerGroup(String viewerGroup) {
            if (this.viewerGroups == null) {
                this.viewerGroups = new ArrayList();
            }
            this.viewerGroups.add(viewerGroup);
            return (B)this.self();
        }

        @Generated
        public B viewerGroups(Collection<? extends String> viewerGroups) {
            if (viewerGroups == null) {
                throw new NullPointerException("viewerGroups cannot be null");
            }
            if (this.viewerGroups == null) {
                this.viewerGroups = new ArrayList();
            }
            this.viewerGroups.addAll(viewerGroups);
            return (B)this.self();
        }

        @Generated
        public B clearViewerGroups() {
            if (this.viewerGroups != null) {
                this.viewerGroups.clear();
            }
            return (B)this.self();
        }

        @JsonProperty(value="connectorName")
        @Generated
        public B connectorType(AtlanConnectorType connectorType) {
            this.connectorType = connectorType;
            return (B)this.self();
        }

        @Generated
        public B connectionName(String connectionName) {
            this.connectionName = connectionName;
            return (B)this.self();
        }

        @Generated
        public B connectionQualifiedName(String connectionQualifiedName) {
            this.connectionQualifiedName = connectionQualifiedName;
            return (B)this.self();
        }

        @JsonProperty(value="__hasLineage")
        @Generated
        public B hasLineage(Boolean hasLineage) {
            this.hasLineage = hasLineage;
            return (B)this.self();
        }

        @Generated
        public B isDiscoverable(Boolean isDiscoverable) {
            this.isDiscoverable = isDiscoverable;
            return (B)this.self();
        }

        @Generated
        public B isEditable(Boolean isEditable) {
            this.isEditable = isEditable;
            return (B)this.self();
        }

        @Generated
        public B subType(Object subType) {
            this.subType = subType;
            return (B)this.self();
        }

        @Generated
        public B viewScore(Double viewScore) {
            this.viewScore = viewScore;
            return (B)this.self();
        }

        @Generated
        public B popularityScore(Double popularityScore) {
            this.popularityScore = popularityScore;
            return (B)this.self();
        }

        @Generated
        public B sourceOwners(String sourceOwners) {
            this.sourceOwners = sourceOwners;
            return (B)this.self();
        }

        @Generated
        public B sourceURL(String sourceURL) {
            this.sourceURL = sourceURL;
            return (B)this.self();
        }

        @Generated
        public B sourceEmbedURL(String sourceEmbedURL) {
            this.sourceEmbedURL = sourceEmbedURL;
            return (B)this.self();
        }

        @Generated
        public B lastSyncWorkflowName(String lastSyncWorkflowName) {
            this.lastSyncWorkflowName = lastSyncWorkflowName;
            return (B)this.self();
        }

        @Generated
        public B lastSyncRunAt(Long lastSyncRunAt) {
            this.lastSyncRunAt = lastSyncRunAt;
            return (B)this.self();
        }

        @Generated
        public B lastSyncRun(String lastSyncRun) {
            this.lastSyncRun = lastSyncRun;
            return (B)this.self();
        }

        @Generated
        public B sourceCreatedBy(String sourceCreatedBy) {
            this.sourceCreatedBy = sourceCreatedBy;
            return (B)this.self();
        }

        @Generated
        public B sourceCreatedAt(Long sourceCreatedAt) {
            this.sourceCreatedAt = sourceCreatedAt;
            return (B)this.self();
        }

        @Generated
        public B sourceUpdatedAt(Long sourceUpdatedAt) {
            this.sourceUpdatedAt = sourceUpdatedAt;
            return (B)this.self();
        }

        @Generated
        public B sourceUpdatedBy(String sourceUpdatedBy) {
            this.sourceUpdatedBy = sourceUpdatedBy;
            return (B)this.self();
        }

        @Generated
        public B dbtQualifiedName(String dbtQualifiedName) {
            this.dbtQualifiedName = dbtQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B assetDbtAlias(String assetDbtAlias) {
            this.assetDbtAlias = assetDbtAlias;
            return (B)this.self();
        }

        @Generated
        public B assetDbtMeta(String assetDbtMeta) {
            this.assetDbtMeta = assetDbtMeta;
            return (B)this.self();
        }

        @Generated
        public B assetDbtUniqueId(String assetDbtUniqueId) {
            this.assetDbtUniqueId = assetDbtUniqueId;
            return (B)this.self();
        }

        @Generated
        public B assetDbtAccountName(String assetDbtAccountName) {
            this.assetDbtAccountName = assetDbtAccountName;
            return (B)this.self();
        }

        @Generated
        public B assetDbtProjectName(String assetDbtProjectName) {
            this.assetDbtProjectName = assetDbtProjectName;
            return (B)this.self();
        }

        @Generated
        public B assetDbtPackageName(String assetDbtPackageName) {
            this.assetDbtPackageName = assetDbtPackageName;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobName(String assetDbtJobName) {
            this.assetDbtJobName = assetDbtJobName;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobSchedule(String assetDbtJobSchedule) {
            this.assetDbtJobSchedule = assetDbtJobSchedule;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobStatus(String assetDbtJobStatus) {
            this.assetDbtJobStatus = assetDbtJobStatus;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobScheduleCronHumanized(String assetDbtJobScheduleCronHumanized) {
            this.assetDbtJobScheduleCronHumanized = assetDbtJobScheduleCronHumanized;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobLastRun(Long assetDbtJobLastRun) {
            this.assetDbtJobLastRun = assetDbtJobLastRun;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobLastRunUrl(String assetDbtJobLastRunUrl) {
            this.assetDbtJobLastRunUrl = assetDbtJobLastRunUrl;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobLastRunCreatedAt(Long assetDbtJobLastRunCreatedAt) {
            this.assetDbtJobLastRunCreatedAt = assetDbtJobLastRunCreatedAt;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobLastRunUpdatedAt(Long assetDbtJobLastRunUpdatedAt) {
            this.assetDbtJobLastRunUpdatedAt = assetDbtJobLastRunUpdatedAt;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobLastRunDequedAt(Long assetDbtJobLastRunDequedAt) {
            this.assetDbtJobLastRunDequedAt = assetDbtJobLastRunDequedAt;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobLastRunStartedAt(Long assetDbtJobLastRunStartedAt) {
            this.assetDbtJobLastRunStartedAt = assetDbtJobLastRunStartedAt;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobLastRunTotalDuration(String assetDbtJobLastRunTotalDuration) {
            this.assetDbtJobLastRunTotalDuration = assetDbtJobLastRunTotalDuration;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobLastRunTotalDurationHumanized(String assetDbtJobLastRunTotalDurationHumanized) {
            this.assetDbtJobLastRunTotalDurationHumanized = assetDbtJobLastRunTotalDurationHumanized;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobLastRunQueuedDuration(String assetDbtJobLastRunQueuedDuration) {
            this.assetDbtJobLastRunQueuedDuration = assetDbtJobLastRunQueuedDuration;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobLastRunQueuedDurationHumanized(String assetDbtJobLastRunQueuedDurationHumanized) {
            this.assetDbtJobLastRunQueuedDurationHumanized = assetDbtJobLastRunQueuedDurationHumanized;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobLastRunRunDuration(String assetDbtJobLastRunRunDuration) {
            this.assetDbtJobLastRunRunDuration = assetDbtJobLastRunRunDuration;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobLastRunRunDurationHumanized(String assetDbtJobLastRunRunDurationHumanized) {
            this.assetDbtJobLastRunRunDurationHumanized = assetDbtJobLastRunRunDurationHumanized;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobLastRunGitBranch(String assetDbtJobLastRunGitBranch) {
            this.assetDbtJobLastRunGitBranch = assetDbtJobLastRunGitBranch;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobLastRunGitSha(String assetDbtJobLastRunGitSha) {
            this.assetDbtJobLastRunGitSha = assetDbtJobLastRunGitSha;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobLastRunStatusMessage(String assetDbtJobLastRunStatusMessage) {
            this.assetDbtJobLastRunStatusMessage = assetDbtJobLastRunStatusMessage;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobLastRunOwnerThreadId(String assetDbtJobLastRunOwnerThreadId) {
            this.assetDbtJobLastRunOwnerThreadId = assetDbtJobLastRunOwnerThreadId;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobLastRunExecutedByThreadId(String assetDbtJobLastRunExecutedByThreadId) {
            this.assetDbtJobLastRunExecutedByThreadId = assetDbtJobLastRunExecutedByThreadId;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobLastRunArtifactsSaved(Boolean assetDbtJobLastRunArtifactsSaved) {
            this.assetDbtJobLastRunArtifactsSaved = assetDbtJobLastRunArtifactsSaved;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobLastRunArtifactS3Path(String assetDbtJobLastRunArtifactS3Path) {
            this.assetDbtJobLastRunArtifactS3Path = assetDbtJobLastRunArtifactS3Path;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobLastRunHasDocsGenerated(Boolean assetDbtJobLastRunHasDocsGenerated) {
            this.assetDbtJobLastRunHasDocsGenerated = assetDbtJobLastRunHasDocsGenerated;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobLastRunHasSourcesGenerated(Boolean assetDbtJobLastRunHasSourcesGenerated) {
            this.assetDbtJobLastRunHasSourcesGenerated = assetDbtJobLastRunHasSourcesGenerated;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobLastRunNotificationsSent(Boolean assetDbtJobLastRunNotificationsSent) {
            this.assetDbtJobLastRunNotificationsSent = assetDbtJobLastRunNotificationsSent;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobNextRun(Long assetDbtJobNextRun) {
            this.assetDbtJobNextRun = assetDbtJobNextRun;
            return (B)this.self();
        }

        @Generated
        public B assetDbtJobNextRunHumanized(String assetDbtJobNextRunHumanized) {
            this.assetDbtJobNextRunHumanized = assetDbtJobNextRunHumanized;
            return (B)this.self();
        }

        @Generated
        public B assetDbtEnvironmentName(String assetDbtEnvironmentName) {
            this.assetDbtEnvironmentName = assetDbtEnvironmentName;
            return (B)this.self();
        }

        @Generated
        public B assetDbtEnvironmentDbtVersion(String assetDbtEnvironmentDbtVersion) {
            this.assetDbtEnvironmentDbtVersion = assetDbtEnvironmentDbtVersion;
            return (B)this.self();
        }

        @Generated
        public B assetDbtTag(String assetDbtTag) {
            if (this.assetDbtTags == null) {
                this.assetDbtTags = new ArrayList();
            }
            this.assetDbtTags.add(assetDbtTag);
            return (B)this.self();
        }

        @Generated
        public B assetDbtTags(Collection<? extends String> assetDbtTags) {
            if (assetDbtTags == null) {
                throw new NullPointerException("assetDbtTags cannot be null");
            }
            if (this.assetDbtTags == null) {
                this.assetDbtTags = new ArrayList();
            }
            this.assetDbtTags.addAll(assetDbtTags);
            return (B)this.self();
        }

        @Generated
        public B clearAssetDbtTags() {
            if (this.assetDbtTags != null) {
                this.assetDbtTags.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B assetDbtSemanticLayerProxyUrl(String assetDbtSemanticLayerProxyUrl) {
            this.assetDbtSemanticLayerProxyUrl = assetDbtSemanticLayerProxyUrl;
            return (B)this.self();
        }

        @Generated
        public B link(Link link) {
            if (this.links == null) {
                this.links = new ArrayList();
            }
            this.links.add(link);
            return (B)this.self();
        }

        @Generated
        public B links(Collection<? extends Link> links) {
            if (links == null) {
                throw new NullPointerException("links cannot be null");
            }
            if (this.links == null) {
                this.links = new ArrayList();
            }
            this.links.addAll(links);
            return (B)this.self();
        }

        @Generated
        public B clearLinks() {
            if (this.links != null) {
                this.links.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B readme(Readme readme) {
            this.readme = readme;
            return (B)this.self();
        }

        @Generated
        public B assignedTerm(GlossaryTerm assignedTerm) {
            if (this.assignedTerms == null) {
                this.assignedTerms = new ArrayList();
            }
            this.assignedTerms.add(assignedTerm);
            return (B)this.self();
        }

        @JsonProperty(value="meanings")
        @Generated
        public B assignedTerms(Collection<? extends GlossaryTerm> assignedTerms) {
            if (assignedTerms == null) {
                throw new NullPointerException("assignedTerms cannot be null");
            }
            if (this.assignedTerms == null) {
                this.assignedTerms = new ArrayList();
            }
            this.assignedTerms.addAll(assignedTerms);
            return (B)this.self();
        }

        @Generated
        public B clearAssignedTerms() {
            if (this.assignedTerms != null) {
                this.assignedTerms.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "Asset.AssetBuilder(super=" + super.toString() + ", qualifiedName=" + this.qualifiedName + ", name=" + this.name + ", displayName=" + this.displayName + ", description=" + this.description + ", userDescription=" + this.userDescription + ", tenantId=" + this.tenantId + ", certificateStatus=" + this.certificateStatus + ", certificateStatusMessage=" + this.certificateStatusMessage + ", certificateUpdatedBy=" + this.certificateUpdatedBy + ", certificateUpdatedAt=" + this.certificateUpdatedAt + ", announcementTitle=" + this.announcementTitle + ", announcementMessage=" + this.announcementMessage + ", announcementUpdatedAt=" + this.announcementUpdatedAt + ", announcementUpdatedBy=" + this.announcementUpdatedBy + ", announcementType=" + this.announcementType + ", ownerUsers=" + this.ownerUsers + ", ownerGroups=" + this.ownerGroups + ", adminUsers=" + this.adminUsers + ", adminGroups=" + this.adminGroups + ", adminRoles=" + this.adminRoles + ", viewerUsers=" + this.viewerUsers + ", viewerGroups=" + this.viewerGroups + ", connectorType=" + this.connectorType + ", connectionName=" + this.connectionName + ", connectionQualifiedName=" + this.connectionQualifiedName + ", hasLineage=" + this.hasLineage + ", isDiscoverable=" + this.isDiscoverable + ", isEditable=" + this.isEditable + ", subType=" + this.subType + ", viewScore=" + this.viewScore + ", popularityScore=" + this.popularityScore + ", sourceOwners=" + this.sourceOwners + ", sourceURL=" + this.sourceURL + ", sourceEmbedURL=" + this.sourceEmbedURL + ", lastSyncWorkflowName=" + this.lastSyncWorkflowName + ", lastSyncRunAt=" + this.lastSyncRunAt + ", lastSyncRun=" + this.lastSyncRun + ", sourceCreatedBy=" + this.sourceCreatedBy + ", sourceCreatedAt=" + this.sourceCreatedAt + ", sourceUpdatedAt=" + this.sourceUpdatedAt + ", sourceUpdatedBy=" + this.sourceUpdatedBy + ", dbtQualifiedName=" + this.dbtQualifiedName + ", assetDbtAlias=" + this.assetDbtAlias + ", assetDbtMeta=" + this.assetDbtMeta + ", assetDbtUniqueId=" + this.assetDbtUniqueId + ", assetDbtAccountName=" + this.assetDbtAccountName + ", assetDbtProjectName=" + this.assetDbtProjectName + ", assetDbtPackageName=" + this.assetDbtPackageName + ", assetDbtJobName=" + this.assetDbtJobName + ", assetDbtJobSchedule=" + this.assetDbtJobSchedule + ", assetDbtJobStatus=" + this.assetDbtJobStatus + ", assetDbtJobScheduleCronHumanized=" + this.assetDbtJobScheduleCronHumanized + ", assetDbtJobLastRun=" + this.assetDbtJobLastRun + ", assetDbtJobLastRunUrl=" + this.assetDbtJobLastRunUrl + ", assetDbtJobLastRunCreatedAt=" + this.assetDbtJobLastRunCreatedAt + ", assetDbtJobLastRunUpdatedAt=" + this.assetDbtJobLastRunUpdatedAt + ", assetDbtJobLastRunDequedAt=" + this.assetDbtJobLastRunDequedAt + ", assetDbtJobLastRunStartedAt=" + this.assetDbtJobLastRunStartedAt + ", assetDbtJobLastRunTotalDuration=" + this.assetDbtJobLastRunTotalDuration + ", assetDbtJobLastRunTotalDurationHumanized=" + this.assetDbtJobLastRunTotalDurationHumanized + ", assetDbtJobLastRunQueuedDuration=" + this.assetDbtJobLastRunQueuedDuration + ", assetDbtJobLastRunQueuedDurationHumanized=" + this.assetDbtJobLastRunQueuedDurationHumanized + ", assetDbtJobLastRunRunDuration=" + this.assetDbtJobLastRunRunDuration + ", assetDbtJobLastRunRunDurationHumanized=" + this.assetDbtJobLastRunRunDurationHumanized + ", assetDbtJobLastRunGitBranch=" + this.assetDbtJobLastRunGitBranch + ", assetDbtJobLastRunGitSha=" + this.assetDbtJobLastRunGitSha + ", assetDbtJobLastRunStatusMessage=" + this.assetDbtJobLastRunStatusMessage + ", assetDbtJobLastRunOwnerThreadId=" + this.assetDbtJobLastRunOwnerThreadId + ", assetDbtJobLastRunExecutedByThreadId=" + this.assetDbtJobLastRunExecutedByThreadId + ", assetDbtJobLastRunArtifactsSaved=" + this.assetDbtJobLastRunArtifactsSaved + ", assetDbtJobLastRunArtifactS3Path=" + this.assetDbtJobLastRunArtifactS3Path + ", assetDbtJobLastRunHasDocsGenerated=" + this.assetDbtJobLastRunHasDocsGenerated + ", assetDbtJobLastRunHasSourcesGenerated=" + this.assetDbtJobLastRunHasSourcesGenerated + ", assetDbtJobLastRunNotificationsSent=" + this.assetDbtJobLastRunNotificationsSent + ", assetDbtJobNextRun=" + this.assetDbtJobNextRun + ", assetDbtJobNextRunHumanized=" + this.assetDbtJobNextRunHumanized + ", assetDbtEnvironmentName=" + this.assetDbtEnvironmentName + ", assetDbtEnvironmentDbtVersion=" + this.assetDbtEnvironmentDbtVersion + ", assetDbtTags=" + this.assetDbtTags + ", assetDbtSemanticLayerProxyUrl=" + this.assetDbtSemanticLayerProxyUrl + ", links=" + this.links + ", readme=" + this.readme + ", assignedTerms=" + this.assignedTerms + ")";
        }
    }
}

