/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.Namespace;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.enums.LinkIconType;
import com.atlan.model.relations.UniqueAttributes;
import java.util.List;
import lombok.Generated;

public class AtlanCollection
extends Namespace {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "Collection";
    String typeName;
    @Attribute
    String icon;
    @Attribute
    LinkIconType iconType;

    public static AtlanCollection refByGuid(String guid) {
        return ((AtlanCollectionBuilder)AtlanCollection.builder().guid(guid)).build();
    }

    public static AtlanCollection refByQualifiedName(String qualifiedName) {
        return ((AtlanCollectionBuilder)AtlanCollection.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static AtlanCollectionBuilder<?, ?> updater(String qualifiedName, String name) {
        return (AtlanCollectionBuilder)((AtlanCollectionBuilder)AtlanCollection.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected AtlanCollectionBuilder<?, ?> trimToRequired() {
        return AtlanCollection.updater(this.getQualifiedName(), this.getName());
    }

    public static AtlanCollection retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof AtlanCollection) {
            return (AtlanCollection)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a AtlanCollection.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static AtlanCollection retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof AtlanCollection) {
            return (AtlanCollection)entity;
        }
        throw new NotFoundException("No AtlanCollection found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static AtlanCollection removeDescription(String qualifiedName, String name) throws AtlanException {
        return (AtlanCollection)Asset.removeDescription(((AtlanCollectionBuilder)AtlanCollection.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static AtlanCollection removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (AtlanCollection)Asset.removeUserDescription(((AtlanCollectionBuilder)AtlanCollection.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static AtlanCollection removeOwners(String qualifiedName, String name) throws AtlanException {
        return (AtlanCollection)Asset.removeOwners(((AtlanCollectionBuilder)AtlanCollection.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static AtlanCollection updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (AtlanCollection)Asset.updateCertificate(AtlanCollection.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static AtlanCollection removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (AtlanCollection)Asset.removeCertificate(((AtlanCollectionBuilder)AtlanCollection.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static AtlanCollection updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (AtlanCollection)Asset.updateAnnouncement(AtlanCollection.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static AtlanCollection removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (AtlanCollection)Asset.removeAnnouncement(((AtlanCollectionBuilder)AtlanCollection.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static AtlanCollection replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (AtlanCollection)Asset.replaceTerms(AtlanCollection.updater(qualifiedName, name), terms);
    }

    public static AtlanCollection appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (AtlanCollection)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static AtlanCollection removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (AtlanCollection)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected AtlanCollection(AtlanCollectionBuilder<?, ?> b) {
        super((Namespace.NamespaceBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : AtlanCollection.$default$typeName();
        this.icon = b.icon;
        this.iconType = b.iconType;
    }

    @Generated
    public static AtlanCollectionBuilder<?, ?> builder() {
        return new AtlanCollectionBuilderImpl();
    }

    @Generated
    public AtlanCollectionBuilder<?, ?> toBuilder() {
        return new AtlanCollectionBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getIcon() {
        return this.icon;
    }

    @Generated
    public LinkIconType getIconType() {
        return this.iconType;
    }

    @Generated
    public void setIcon(String icon) {
        this.icon = icon;
    }

    @Generated
    public void setIconType(LinkIconType iconType) {
        this.iconType = iconType;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AtlanCollection)) {
            return false;
        }
        AtlanCollection other = (AtlanCollection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$icon = this.getIcon();
        String other$icon = other.getIcon();
        if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
            return false;
        }
        LinkIconType this$iconType = this.getIconType();
        LinkIconType other$iconType = other.getIconType();
        return !(this$iconType == null ? other$iconType != null : !this$iconType.equals(other$iconType));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AtlanCollection;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $icon = this.getIcon();
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        LinkIconType $iconType = this.getIconType();
        result = result * 59 + ($iconType == null ? 43 : $iconType.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class AtlanCollectionBuilderImpl
    extends AtlanCollectionBuilder<AtlanCollection, AtlanCollectionBuilderImpl> {
        @Generated
        private AtlanCollectionBuilderImpl() {
        }

        @Override
        @Generated
        protected AtlanCollectionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public AtlanCollection build() {
            return new AtlanCollection(this);
        }
    }

    @Generated
    public static abstract class AtlanCollectionBuilder<C extends AtlanCollection, B extends AtlanCollectionBuilder<C, B>>
    extends Namespace.NamespaceBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String icon;
        @Generated
        private LinkIconType iconType;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AtlanCollectionBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(AtlanCollection instance, AtlanCollectionBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.icon(instance.icon);
            b.iconType(instance.iconType);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B icon(String icon) {
            this.icon = icon;
            return (B)this.self();
        }

        @Generated
        public B iconType(LinkIconType iconType) {
            this.iconType = iconType;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "AtlanCollection.AtlanCollectionBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", icon=" + this.icon + ", iconType=" + this.iconType + ")";
        }
    }
}

