/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Column;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.Namespace;
import com.atlan.model.assets.SQL;
import com.atlan.model.assets.Table;
import com.atlan.model.assets.View;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class AtlanQuery
extends SQL {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "Query";
    String typeName;
    @Attribute
    String rawQuery;
    @Attribute
    String defaultSchemaQualifiedName;
    @Attribute
    String defaultDatabaseQualifiedName;
    @Attribute
    String variablesSchemaBase64;
    @Attribute
    Boolean isPrivate;
    @Attribute
    Boolean isSqlSnippet;
    @Attribute
    String parentQualifiedName;
    @Attribute
    String collectionQualifiedName;
    @Attribute
    Boolean isVisualQuery;
    @Attribute
    String visualBuilderSchemaBase64;
    @Attribute
    Namespace parent;
    @Attribute
    SortedSet<Table> tables;
    @Attribute
    SortedSet<Column> columns;
    @Attribute
    SortedSet<View> views;

    public static AtlanQuery refByGuid(String guid) {
        return ((AtlanQueryBuilder)AtlanQuery.builder().guid(guid)).build();
    }

    public static AtlanQuery refByQualifiedName(String qualifiedName) {
        return ((AtlanQueryBuilder)AtlanQuery.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static AtlanQueryBuilder<?, ?> updater(String qualifiedName, String name) {
        return (AtlanQueryBuilder)((AtlanQueryBuilder)AtlanQuery.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected AtlanQueryBuilder<?, ?> trimToRequired() {
        return AtlanQuery.updater(this.getQualifiedName(), this.getName());
    }

    public static AtlanQuery retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof AtlanQuery) {
            return (AtlanQuery)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a AtlanQuery.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static AtlanQuery retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof AtlanQuery) {
            return (AtlanQuery)entity;
        }
        throw new NotFoundException("No AtlanQuery found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static AtlanQuery removeDescription(String qualifiedName, String name) throws AtlanException {
        return (AtlanQuery)Asset.removeDescription(((AtlanQueryBuilder)AtlanQuery.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static AtlanQuery removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (AtlanQuery)Asset.removeUserDescription(((AtlanQueryBuilder)AtlanQuery.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static AtlanQuery removeOwners(String qualifiedName, String name) throws AtlanException {
        return (AtlanQuery)Asset.removeOwners(((AtlanQueryBuilder)AtlanQuery.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static AtlanQuery updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (AtlanQuery)Asset.updateCertificate(AtlanQuery.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static AtlanQuery removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (AtlanQuery)Asset.removeCertificate(((AtlanQueryBuilder)AtlanQuery.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static AtlanQuery updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (AtlanQuery)Asset.updateAnnouncement(AtlanQuery.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static AtlanQuery removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (AtlanQuery)Asset.removeAnnouncement(((AtlanQueryBuilder)AtlanQuery.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static AtlanQuery replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (AtlanQuery)Asset.replaceTerms(AtlanQuery.updater(qualifiedName, name), terms);
    }

    public static AtlanQuery appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (AtlanQuery)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static AtlanQuery removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (AtlanQuery)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected AtlanQuery(AtlanQueryBuilder<?, ?> b) {
        super((SQL.SQLBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : AtlanQuery.$default$typeName();
        this.rawQuery = b.rawQuery;
        this.defaultSchemaQualifiedName = b.defaultSchemaQualifiedName;
        this.defaultDatabaseQualifiedName = b.defaultDatabaseQualifiedName;
        this.variablesSchemaBase64 = b.variablesSchemaBase64;
        this.isPrivate = b.isPrivate;
        this.isSqlSnippet = b.isSqlSnippet;
        this.parentQualifiedName = b.parentQualifiedName;
        this.collectionQualifiedName = b.collectionQualifiedName;
        this.isVisualQuery = b.isVisualQuery;
        this.visualBuilderSchemaBase64 = b.visualBuilderSchemaBase64;
        this.parent = b.parent;
        SortedSet<Table> tables = new TreeSet<Table>();
        if (b.tables != null) {
            tables.addAll(b.tables);
        }
        tables = Collections.unmodifiableSortedSet(tables);
        this.tables = tables;
        SortedSet<Column> columns = new TreeSet<Column>();
        if (b.columns != null) {
            columns.addAll(b.columns);
        }
        columns = Collections.unmodifiableSortedSet(columns);
        this.columns = columns;
        SortedSet<View> views = new TreeSet<View>();
        if (b.views != null) {
            views.addAll(b.views);
        }
        views = Collections.unmodifiableSortedSet(views);
        this.views = views;
    }

    @Generated
    public static AtlanQueryBuilder<?, ?> builder() {
        return new AtlanQueryBuilderImpl();
    }

    @Generated
    public AtlanQueryBuilder<?, ?> toBuilder() {
        return new AtlanQueryBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getRawQuery() {
        return this.rawQuery;
    }

    @Generated
    public String getDefaultSchemaQualifiedName() {
        return this.defaultSchemaQualifiedName;
    }

    @Generated
    public String getDefaultDatabaseQualifiedName() {
        return this.defaultDatabaseQualifiedName;
    }

    @Generated
    public String getVariablesSchemaBase64() {
        return this.variablesSchemaBase64;
    }

    @Generated
    public Boolean getIsPrivate() {
        return this.isPrivate;
    }

    @Generated
    public Boolean getIsSqlSnippet() {
        return this.isSqlSnippet;
    }

    @Generated
    public String getParentQualifiedName() {
        return this.parentQualifiedName;
    }

    @Generated
    public String getCollectionQualifiedName() {
        return this.collectionQualifiedName;
    }

    @Generated
    public Boolean getIsVisualQuery() {
        return this.isVisualQuery;
    }

    @Generated
    public String getVisualBuilderSchemaBase64() {
        return this.visualBuilderSchemaBase64;
    }

    @Generated
    public Namespace getParent() {
        return this.parent;
    }

    @Generated
    public SortedSet<Table> getTables() {
        return this.tables;
    }

    @Generated
    public SortedSet<Column> getColumns() {
        return this.columns;
    }

    @Generated
    public SortedSet<View> getViews() {
        return this.views;
    }

    @Generated
    public void setRawQuery(String rawQuery) {
        this.rawQuery = rawQuery;
    }

    @Generated
    public void setDefaultSchemaQualifiedName(String defaultSchemaQualifiedName) {
        this.defaultSchemaQualifiedName = defaultSchemaQualifiedName;
    }

    @Generated
    public void setDefaultDatabaseQualifiedName(String defaultDatabaseQualifiedName) {
        this.defaultDatabaseQualifiedName = defaultDatabaseQualifiedName;
    }

    @Generated
    public void setVariablesSchemaBase64(String variablesSchemaBase64) {
        this.variablesSchemaBase64 = variablesSchemaBase64;
    }

    @Generated
    public void setIsPrivate(Boolean isPrivate) {
        this.isPrivate = isPrivate;
    }

    @Generated
    public void setIsSqlSnippet(Boolean isSqlSnippet) {
        this.isSqlSnippet = isSqlSnippet;
    }

    @Generated
    public void setParentQualifiedName(String parentQualifiedName) {
        this.parentQualifiedName = parentQualifiedName;
    }

    @Generated
    public void setCollectionQualifiedName(String collectionQualifiedName) {
        this.collectionQualifiedName = collectionQualifiedName;
    }

    @Generated
    public void setIsVisualQuery(Boolean isVisualQuery) {
        this.isVisualQuery = isVisualQuery;
    }

    @Generated
    public void setVisualBuilderSchemaBase64(String visualBuilderSchemaBase64) {
        this.visualBuilderSchemaBase64 = visualBuilderSchemaBase64;
    }

    @Generated
    public void setParent(Namespace parent) {
        this.parent = parent;
    }

    @Generated
    public void setTables(SortedSet<Table> tables) {
        this.tables = tables;
    }

    @Generated
    public void setColumns(SortedSet<Column> columns) {
        this.columns = columns;
    }

    @Generated
    public void setViews(SortedSet<View> views) {
        this.views = views;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AtlanQuery)) {
            return false;
        }
        AtlanQuery other = (AtlanQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$isPrivate = this.getIsPrivate();
        Boolean other$isPrivate = other.getIsPrivate();
        if (this$isPrivate == null ? other$isPrivate != null : !((Object)this$isPrivate).equals(other$isPrivate)) {
            return false;
        }
        Boolean this$isSqlSnippet = this.getIsSqlSnippet();
        Boolean other$isSqlSnippet = other.getIsSqlSnippet();
        if (this$isSqlSnippet == null ? other$isSqlSnippet != null : !((Object)this$isSqlSnippet).equals(other$isSqlSnippet)) {
            return false;
        }
        Boolean this$isVisualQuery = this.getIsVisualQuery();
        Boolean other$isVisualQuery = other.getIsVisualQuery();
        if (this$isVisualQuery == null ? other$isVisualQuery != null : !((Object)this$isVisualQuery).equals(other$isVisualQuery)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$rawQuery = this.getRawQuery();
        String other$rawQuery = other.getRawQuery();
        if (this$rawQuery == null ? other$rawQuery != null : !this$rawQuery.equals(other$rawQuery)) {
            return false;
        }
        String this$defaultSchemaQualifiedName = this.getDefaultSchemaQualifiedName();
        String other$defaultSchemaQualifiedName = other.getDefaultSchemaQualifiedName();
        if (this$defaultSchemaQualifiedName == null ? other$defaultSchemaQualifiedName != null : !this$defaultSchemaQualifiedName.equals(other$defaultSchemaQualifiedName)) {
            return false;
        }
        String this$defaultDatabaseQualifiedName = this.getDefaultDatabaseQualifiedName();
        String other$defaultDatabaseQualifiedName = other.getDefaultDatabaseQualifiedName();
        if (this$defaultDatabaseQualifiedName == null ? other$defaultDatabaseQualifiedName != null : !this$defaultDatabaseQualifiedName.equals(other$defaultDatabaseQualifiedName)) {
            return false;
        }
        String this$variablesSchemaBase64 = this.getVariablesSchemaBase64();
        String other$variablesSchemaBase64 = other.getVariablesSchemaBase64();
        if (this$variablesSchemaBase64 == null ? other$variablesSchemaBase64 != null : !this$variablesSchemaBase64.equals(other$variablesSchemaBase64)) {
            return false;
        }
        String this$parentQualifiedName = this.getParentQualifiedName();
        String other$parentQualifiedName = other.getParentQualifiedName();
        if (this$parentQualifiedName == null ? other$parentQualifiedName != null : !this$parentQualifiedName.equals(other$parentQualifiedName)) {
            return false;
        }
        String this$collectionQualifiedName = this.getCollectionQualifiedName();
        String other$collectionQualifiedName = other.getCollectionQualifiedName();
        if (this$collectionQualifiedName == null ? other$collectionQualifiedName != null : !this$collectionQualifiedName.equals(other$collectionQualifiedName)) {
            return false;
        }
        String this$visualBuilderSchemaBase64 = this.getVisualBuilderSchemaBase64();
        String other$visualBuilderSchemaBase64 = other.getVisualBuilderSchemaBase64();
        if (this$visualBuilderSchemaBase64 == null ? other$visualBuilderSchemaBase64 != null : !this$visualBuilderSchemaBase64.equals(other$visualBuilderSchemaBase64)) {
            return false;
        }
        Namespace this$parent = this.getParent();
        Namespace other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
            return false;
        }
        SortedSet<Table> this$tables = this.getTables();
        SortedSet<Table> other$tables = other.getTables();
        if (this$tables == null ? other$tables != null : !this$tables.equals(other$tables)) {
            return false;
        }
        SortedSet<Column> this$columns = this.getColumns();
        SortedSet<Column> other$columns = other.getColumns();
        if (this$columns == null ? other$columns != null : !this$columns.equals(other$columns)) {
            return false;
        }
        SortedSet<View> this$views = this.getViews();
        SortedSet<View> other$views = other.getViews();
        return !(this$views == null ? other$views != null : !this$views.equals(other$views));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AtlanQuery;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $isPrivate = this.getIsPrivate();
        result = result * 59 + ($isPrivate == null ? 43 : ((Object)$isPrivate).hashCode());
        Boolean $isSqlSnippet = this.getIsSqlSnippet();
        result = result * 59 + ($isSqlSnippet == null ? 43 : ((Object)$isSqlSnippet).hashCode());
        Boolean $isVisualQuery = this.getIsVisualQuery();
        result = result * 59 + ($isVisualQuery == null ? 43 : ((Object)$isVisualQuery).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $rawQuery = this.getRawQuery();
        result = result * 59 + ($rawQuery == null ? 43 : $rawQuery.hashCode());
        String $defaultSchemaQualifiedName = this.getDefaultSchemaQualifiedName();
        result = result * 59 + ($defaultSchemaQualifiedName == null ? 43 : $defaultSchemaQualifiedName.hashCode());
        String $defaultDatabaseQualifiedName = this.getDefaultDatabaseQualifiedName();
        result = result * 59 + ($defaultDatabaseQualifiedName == null ? 43 : $defaultDatabaseQualifiedName.hashCode());
        String $variablesSchemaBase64 = this.getVariablesSchemaBase64();
        result = result * 59 + ($variablesSchemaBase64 == null ? 43 : $variablesSchemaBase64.hashCode());
        String $parentQualifiedName = this.getParentQualifiedName();
        result = result * 59 + ($parentQualifiedName == null ? 43 : $parentQualifiedName.hashCode());
        String $collectionQualifiedName = this.getCollectionQualifiedName();
        result = result * 59 + ($collectionQualifiedName == null ? 43 : $collectionQualifiedName.hashCode());
        String $visualBuilderSchemaBase64 = this.getVisualBuilderSchemaBase64();
        result = result * 59 + ($visualBuilderSchemaBase64 == null ? 43 : $visualBuilderSchemaBase64.hashCode());
        Namespace $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
        SortedSet<Table> $tables = this.getTables();
        result = result * 59 + ($tables == null ? 43 : $tables.hashCode());
        SortedSet<Column> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : $columns.hashCode());
        SortedSet<View> $views = this.getViews();
        result = result * 59 + ($views == null ? 43 : $views.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class AtlanQueryBuilderImpl
    extends AtlanQueryBuilder<AtlanQuery, AtlanQueryBuilderImpl> {
        @Generated
        private AtlanQueryBuilderImpl() {
        }

        @Override
        @Generated
        protected AtlanQueryBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public AtlanQuery build() {
            return new AtlanQuery(this);
        }
    }

    @Generated
    public static abstract class AtlanQueryBuilder<C extends AtlanQuery, B extends AtlanQueryBuilder<C, B>>
    extends SQL.SQLBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String rawQuery;
        @Generated
        private String defaultSchemaQualifiedName;
        @Generated
        private String defaultDatabaseQualifiedName;
        @Generated
        private String variablesSchemaBase64;
        @Generated
        private Boolean isPrivate;
        @Generated
        private Boolean isSqlSnippet;
        @Generated
        private String parentQualifiedName;
        @Generated
        private String collectionQualifiedName;
        @Generated
        private Boolean isVisualQuery;
        @Generated
        private String visualBuilderSchemaBase64;
        @Generated
        private Namespace parent;
        @Generated
        private ArrayList<Table> tables;
        @Generated
        private ArrayList<Column> columns;
        @Generated
        private ArrayList<View> views;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            AtlanQueryBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(AtlanQuery instance, AtlanQueryBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.rawQuery(instance.rawQuery);
            b.defaultSchemaQualifiedName(instance.defaultSchemaQualifiedName);
            b.defaultDatabaseQualifiedName(instance.defaultDatabaseQualifiedName);
            b.variablesSchemaBase64(instance.variablesSchemaBase64);
            b.isPrivate(instance.isPrivate);
            b.isSqlSnippet(instance.isSqlSnippet);
            b.parentQualifiedName(instance.parentQualifiedName);
            b.collectionQualifiedName(instance.collectionQualifiedName);
            b.isVisualQuery(instance.isVisualQuery);
            b.visualBuilderSchemaBase64(instance.visualBuilderSchemaBase64);
            b.parent(instance.parent);
            b.tables(instance.tables == null ? Collections.emptySortedSet() : instance.tables);
            b.columns(instance.columns == null ? Collections.emptySortedSet() : instance.columns);
            b.views(instance.views == null ? Collections.emptySortedSet() : instance.views);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B rawQuery(String rawQuery) {
            this.rawQuery = rawQuery;
            return (B)this.self();
        }

        @Generated
        public B defaultSchemaQualifiedName(String defaultSchemaQualifiedName) {
            this.defaultSchemaQualifiedName = defaultSchemaQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B defaultDatabaseQualifiedName(String defaultDatabaseQualifiedName) {
            this.defaultDatabaseQualifiedName = defaultDatabaseQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B variablesSchemaBase64(String variablesSchemaBase64) {
            this.variablesSchemaBase64 = variablesSchemaBase64;
            return (B)this.self();
        }

        @Generated
        public B isPrivate(Boolean isPrivate) {
            this.isPrivate = isPrivate;
            return (B)this.self();
        }

        @Generated
        public B isSqlSnippet(Boolean isSqlSnippet) {
            this.isSqlSnippet = isSqlSnippet;
            return (B)this.self();
        }

        @Generated
        public B parentQualifiedName(String parentQualifiedName) {
            this.parentQualifiedName = parentQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B collectionQualifiedName(String collectionQualifiedName) {
            this.collectionQualifiedName = collectionQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B isVisualQuery(Boolean isVisualQuery) {
            this.isVisualQuery = isVisualQuery;
            return (B)this.self();
        }

        @Generated
        public B visualBuilderSchemaBase64(String visualBuilderSchemaBase64) {
            this.visualBuilderSchemaBase64 = visualBuilderSchemaBase64;
            return (B)this.self();
        }

        @Generated
        public B parent(Namespace parent) {
            this.parent = parent;
            return (B)this.self();
        }

        @Generated
        public B table(Table table) {
            if (this.tables == null) {
                this.tables = new ArrayList();
            }
            this.tables.add(table);
            return (B)this.self();
        }

        @Generated
        public B tables(Collection<? extends Table> tables) {
            if (tables == null) {
                throw new NullPointerException("tables cannot be null");
            }
            if (this.tables == null) {
                this.tables = new ArrayList();
            }
            this.tables.addAll(tables);
            return (B)this.self();
        }

        @Generated
        public B clearTables() {
            if (this.tables != null) {
                this.tables.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B column(Column column) {
            if (this.columns == null) {
                this.columns = new ArrayList();
            }
            this.columns.add(column);
            return (B)this.self();
        }

        @Generated
        public B columns(Collection<? extends Column> columns) {
            if (columns == null) {
                throw new NullPointerException("columns cannot be null");
            }
            if (this.columns == null) {
                this.columns = new ArrayList();
            }
            this.columns.addAll(columns);
            return (B)this.self();
        }

        @Generated
        public B clearColumns() {
            if (this.columns != null) {
                this.columns.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B view(View view) {
            if (this.views == null) {
                this.views = new ArrayList();
            }
            this.views.add(view);
            return (B)this.self();
        }

        @Generated
        public B views(Collection<? extends View> views) {
            if (views == null) {
                throw new NullPointerException("views cannot be null");
            }
            if (this.views == null) {
                this.views = new ArrayList();
            }
            this.views.addAll(views);
            return (B)this.self();
        }

        @Generated
        public B clearViews() {
            if (this.views != null) {
                this.views.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "AtlanQuery.AtlanQueryBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", rawQuery=" + this.rawQuery + ", defaultSchemaQualifiedName=" + this.defaultSchemaQualifiedName + ", defaultDatabaseQualifiedName=" + this.defaultDatabaseQualifiedName + ", variablesSchemaBase64=" + this.variablesSchemaBase64 + ", isPrivate=" + this.isPrivate + ", isSqlSnippet=" + this.isSqlSnippet + ", parentQualifiedName=" + this.parentQualifiedName + ", collectionQualifiedName=" + this.collectionQualifiedName + ", isVisualQuery=" + this.isVisualQuery + ", visualBuilderSchemaBase64=" + this.visualBuilderSchemaBase64 + ", parent=" + this.parent + ", tables=" + this.tables + ", columns=" + this.columns + ", views=" + this.views + ")";
        }
    }
}

