/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.AbstractProcess;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.List;
import lombok.Generated;

public class BIProcess
extends AbstractProcess {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "BIProcess";
    String typeName;

    public static BIProcess refByGuid(String guid) {
        return ((BIProcessBuilder)BIProcess.builder().guid(guid)).build();
    }

    public static BIProcess refByQualifiedName(String qualifiedName) {
        return ((BIProcessBuilder)BIProcess.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static BIProcessBuilder<?, ?> updater(String qualifiedName, String name) {
        return (BIProcessBuilder)((BIProcessBuilder)BIProcess.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected BIProcessBuilder<?, ?> trimToRequired() {
        return BIProcess.updater(this.getQualifiedName(), this.getName());
    }

    public static BIProcess retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof BIProcess) {
            return (BIProcess)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a BIProcess.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static BIProcess retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof BIProcess) {
            return (BIProcess)entity;
        }
        throw new NotFoundException("No BIProcess found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static BIProcess removeDescription(String qualifiedName, String name) throws AtlanException {
        return (BIProcess)Asset.removeDescription(((BIProcessBuilder)BIProcess.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static BIProcess removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (BIProcess)Asset.removeUserDescription(((BIProcessBuilder)BIProcess.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static BIProcess removeOwners(String qualifiedName, String name) throws AtlanException {
        return (BIProcess)Asset.removeOwners(((BIProcessBuilder)BIProcess.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static BIProcess updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (BIProcess)Asset.updateCertificate(BIProcess.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static BIProcess removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (BIProcess)Asset.removeCertificate(((BIProcessBuilder)BIProcess.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static BIProcess updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (BIProcess)Asset.updateAnnouncement(BIProcess.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static BIProcess removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (BIProcess)Asset.removeAnnouncement(((BIProcessBuilder)BIProcess.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static BIProcess replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (BIProcess)Asset.replaceTerms(BIProcess.updater(qualifiedName, name), terms);
    }

    public static BIProcess appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (BIProcess)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static BIProcess removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (BIProcess)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected BIProcess(BIProcessBuilder<?, ?> b) {
        super((AbstractProcess.AbstractProcessBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : BIProcess.$default$typeName();
    }

    @Generated
    public static BIProcessBuilder<?, ?> builder() {
        return new BIProcessBuilderImpl();
    }

    @Generated
    public BIProcessBuilder<?, ?> toBuilder() {
        return new BIProcessBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BIProcess)) {
            return false;
        }
        BIProcess other = (BIProcess)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        return !(this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BIProcess;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class BIProcessBuilderImpl
    extends BIProcessBuilder<BIProcess, BIProcessBuilderImpl> {
        @Generated
        private BIProcessBuilderImpl() {
        }

        @Override
        @Generated
        protected BIProcessBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public BIProcess build() {
            return new BIProcess(this);
        }
    }

    @Generated
    public static abstract class BIProcessBuilder<C extends BIProcess, B extends BIProcessBuilder<C, B>>
    extends AbstractProcess.AbstractProcessBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            BIProcessBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(BIProcess instance, BIProcessBuilder<?, ?> b) {
            b.typeName(instance.typeName);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "BIProcess.BIProcessBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ")";
        }
    }
}

