/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.BadgeCondition;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public class Badge
extends Asset {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "Badge";
    String typeName;
    @Attribute
    List<BadgeCondition> badgeConditions;
    @Attribute
    String badgeMetadataAttribute;

    public static Badge refByGuid(String guid) {
        return ((BadgeBuilder)Badge.builder().guid(guid)).build();
    }

    public static Badge refByQualifiedName(String qualifiedName) {
        return ((BadgeBuilder)Badge.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static BadgeBuilder<?, ?> updater(String qualifiedName, String name) {
        return (BadgeBuilder)((BadgeBuilder)Badge.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected BadgeBuilder<?, ?> trimToRequired() {
        return Badge.updater(this.getQualifiedName(), this.getName());
    }

    public static Badge retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof Badge) {
            return (Badge)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a Badge.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static Badge retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof Badge) {
            return (Badge)entity;
        }
        throw new NotFoundException("No Badge found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static Badge removeDescription(String qualifiedName, String name) throws AtlanException {
        return (Badge)Asset.removeDescription(((BadgeBuilder)Badge.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static Badge removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (Badge)Asset.removeUserDescription(((BadgeBuilder)Badge.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static Badge removeOwners(String qualifiedName, String name) throws AtlanException {
        return (Badge)Asset.removeOwners(((BadgeBuilder)Badge.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static Badge updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (Badge)Asset.updateCertificate(Badge.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static Badge removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (Badge)Asset.removeCertificate(((BadgeBuilder)Badge.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static Badge updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (Badge)Asset.updateAnnouncement(Badge.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static Badge removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (Badge)Asset.removeAnnouncement(((BadgeBuilder)Badge.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static Badge replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (Badge)Asset.replaceTerms(Badge.updater(qualifiedName, name), terms);
    }

    public static Badge appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (Badge)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static Badge removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (Badge)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected Badge(BadgeBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        List<Object> badgeConditions;
        this.typeName = b.typeName$set ? b.typeName$value : Badge.$default$typeName();
        switch (b.badgeConditions == null ? 0 : b.badgeConditions.size()) {
            case 0: {
                badgeConditions = Collections.emptyList();
                break;
            }
            case 1: {
                badgeConditions = Collections.singletonList(b.badgeConditions.get(0));
                break;
            }
            default: {
                badgeConditions = Collections.unmodifiableList(new ArrayList<BadgeCondition>(b.badgeConditions));
            }
        }
        this.badgeConditions = badgeConditions;
        this.badgeMetadataAttribute = b.badgeMetadataAttribute;
    }

    @Generated
    public static BadgeBuilder<?, ?> builder() {
        return new BadgeBuilderImpl();
    }

    @Generated
    public BadgeBuilder<?, ?> toBuilder() {
        return new BadgeBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public List<BadgeCondition> getBadgeConditions() {
        return this.badgeConditions;
    }

    @Generated
    public String getBadgeMetadataAttribute() {
        return this.badgeMetadataAttribute;
    }

    @Generated
    public void setBadgeConditions(List<BadgeCondition> badgeConditions) {
        this.badgeConditions = badgeConditions;
    }

    @Generated
    public void setBadgeMetadataAttribute(String badgeMetadataAttribute) {
        this.badgeMetadataAttribute = badgeMetadataAttribute;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Badge)) {
            return false;
        }
        Badge other = (Badge)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        List<BadgeCondition> this$badgeConditions = this.getBadgeConditions();
        List<BadgeCondition> other$badgeConditions = other.getBadgeConditions();
        if (this$badgeConditions == null ? other$badgeConditions != null : !((Object)this$badgeConditions).equals(other$badgeConditions)) {
            return false;
        }
        String this$badgeMetadataAttribute = this.getBadgeMetadataAttribute();
        String other$badgeMetadataAttribute = other.getBadgeMetadataAttribute();
        return !(this$badgeMetadataAttribute == null ? other$badgeMetadataAttribute != null : !this$badgeMetadataAttribute.equals(other$badgeMetadataAttribute));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Badge;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        List<BadgeCondition> $badgeConditions = this.getBadgeConditions();
        result = result * 59 + ($badgeConditions == null ? 43 : ((Object)$badgeConditions).hashCode());
        String $badgeMetadataAttribute = this.getBadgeMetadataAttribute();
        result = result * 59 + ($badgeMetadataAttribute == null ? 43 : $badgeMetadataAttribute.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class BadgeBuilderImpl
    extends BadgeBuilder<Badge, BadgeBuilderImpl> {
        @Generated
        private BadgeBuilderImpl() {
        }

        @Override
        @Generated
        protected BadgeBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Badge build() {
            return new Badge(this);
        }
    }

    @Generated
    public static abstract class BadgeBuilder<C extends Badge, B extends BadgeBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<BadgeCondition> badgeConditions;
        @Generated
        private String badgeMetadataAttribute;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            BadgeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Badge instance, BadgeBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.badgeConditions(instance.badgeConditions == null ? Collections.emptyList() : instance.badgeConditions);
            b.badgeMetadataAttribute(instance.badgeMetadataAttribute);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B badgeCondition(BadgeCondition badgeCondition) {
            if (this.badgeConditions == null) {
                this.badgeConditions = new ArrayList();
            }
            this.badgeConditions.add(badgeCondition);
            return (B)this.self();
        }

        @Generated
        public B badgeConditions(Collection<? extends BadgeCondition> badgeConditions) {
            if (badgeConditions == null) {
                throw new NullPointerException("badgeConditions cannot be null");
            }
            if (this.badgeConditions == null) {
                this.badgeConditions = new ArrayList();
            }
            this.badgeConditions.addAll(badgeConditions);
            return (B)this.self();
        }

        @Generated
        public B clearBadgeConditions() {
            if (this.badgeConditions != null) {
                this.badgeConditions.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B badgeMetadataAttribute(String badgeMetadataAttribute) {
            this.badgeMetadataAttribute = badgeMetadataAttribute;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "Badge.BadgeBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", badgeConditions=" + this.badgeConditions + ", badgeMetadataAttribute=" + this.badgeMetadataAttribute + ")";
        }
    }
}

