/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.AtlanQuery;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Connection;
import com.atlan.model.assets.DbtMetric;
import com.atlan.model.assets.DbtModelColumn;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.MaterializedView;
import com.atlan.model.assets.Metric;
import com.atlan.model.assets.SQL;
import com.atlan.model.assets.Table;
import com.atlan.model.assets.TablePartition;
import com.atlan.model.assets.View;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class Column
extends SQL {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "Column";
    String typeName;
    @Attribute
    String dataType;
    @Attribute
    String subDataType;
    @Attribute
    Integer order;
    @Attribute
    Boolean isPartition;
    @Attribute
    Integer partitionOrder;
    @Attribute
    Boolean isClustered;
    @Attribute
    Boolean isPrimary;
    @Attribute
    Boolean isForeign;
    @Attribute
    Boolean isIndexed;
    @Attribute
    Boolean isSort;
    @Attribute
    Boolean isDist;
    @Attribute
    Boolean isPinned;
    @Attribute
    String pinnedBy;
    @Attribute
    Long pinnedAt;
    @Attribute
    Integer precision;
    @Attribute
    String defaultValue;
    @Attribute
    Boolean isNullable;
    @Attribute
    Double numericScale;
    @Attribute
    Long maxLength;
    @Attribute
    Map<String, String> validations;
    @Attribute
    @JsonProperty(value="materialisedView")
    MaterializedView materializedView;
    @Attribute
    SortedSet<AtlanQuery> queries;
    @Attribute
    SortedSet<Metric> metricTimestamps;
    @Attribute
    SortedSet<DbtMetric> dbtMetrics;
    @Attribute
    View view;
    @Attribute
    TablePartition tablePartition;
    @Attribute
    SortedSet<Metric> dataQualityMetricDimensions;
    @Attribute
    SortedSet<DbtModelColumn> dbtModelColumns;
    @Attribute
    Table table;

    public SQL getParent() {
        if (this.table != null) {
            return this.table;
        }
        if (this.view != null) {
            return this.view;
        }
        if (this.materializedView != null) {
            return this.materializedView;
        }
        return null;
    }

    public static Column refByGuid(String guid) {
        return ((ColumnBuilder)Column.builder().guid(guid)).build();
    }

    public static Column refByQualifiedName(String qualifiedName) {
        return ((ColumnBuilder)Column.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static ColumnBuilder<?, ?> creator(String name, String parentType, String parentQualifiedName, int order) {
        String[] tokens = parentQualifiedName.split("/");
        AtlanConnectorType connectorType = Connection.getConnectorTypeFromQualifiedName(tokens);
        String parentName = StringUtils.getNameFromQualifiedName(parentQualifiedName);
        String schemaQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(parentQualifiedName);
        String schemaName = StringUtils.getNameFromQualifiedName(schemaQualifiedName);
        String databaseQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(schemaQualifiedName);
        String databaseName = StringUtils.getNameFromQualifiedName(databaseQualifiedName);
        String connectionQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(databaseQualifiedName);
        Object builder = ((ColumnBuilder)((ColumnBuilder)((ColumnBuilder)((ColumnBuilder)((ColumnBuilder)((ColumnBuilder)((ColumnBuilder)((ColumnBuilder)Column.builder().name(name)).qualifiedName(parentQualifiedName + "/" + name)).connectorType(connectorType)).schemaName(schemaName)).schemaQualifiedName(schemaQualifiedName)).databaseName(databaseName)).databaseQualifiedName(databaseQualifiedName)).connectionQualifiedName(connectionQualifiedName)).order(order);
        switch (parentType) {
            case "Table": {
                builder = ((ColumnBuilder)((ColumnBuilder)((SQL.SQLBuilder)builder).tableName(parentName)).tableQualifiedName(parentQualifiedName)).table(Table.refByQualifiedName(parentQualifiedName));
                break;
            }
            case "View": {
                builder = ((ColumnBuilder)((ColumnBuilder)((SQL.SQLBuilder)builder).viewName(parentName)).viewQualifiedName(parentQualifiedName)).view(View.refByQualifiedName(parentQualifiedName));
                break;
            }
            case "MaterialisedView": {
                builder = ((ColumnBuilder)((ColumnBuilder)((SQL.SQLBuilder)builder).viewName(parentName)).viewQualifiedName(parentQualifiedName)).materializedView(MaterializedView.refByQualifiedName(parentQualifiedName));
            }
        }
        return builder;
    }

    public static ColumnBuilder<?, ?> updater(String qualifiedName, String name) {
        return (ColumnBuilder)((ColumnBuilder)Column.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected ColumnBuilder<?, ?> trimToRequired() {
        return Column.updater(this.getQualifiedName(), this.getName());
    }

    public static Column retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof Column) {
            return (Column)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a Column.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static Column retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof Column) {
            return (Column)entity;
        }
        throw new NotFoundException("No Column found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static Column removeDescription(String qualifiedName, String name) throws AtlanException {
        return (Column)Asset.removeDescription(((ColumnBuilder)Column.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static Column removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (Column)Asset.removeUserDescription(((ColumnBuilder)Column.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static Column removeOwners(String qualifiedName, String name) throws AtlanException {
        return (Column)Asset.removeOwners(((ColumnBuilder)Column.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static Column updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (Column)Asset.updateCertificate(Column.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static Column removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (Column)Asset.removeCertificate(((ColumnBuilder)Column.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static Column updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (Column)Asset.updateAnnouncement(Column.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static Column removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (Column)Asset.removeAnnouncement(((ColumnBuilder)Column.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static Column replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (Column)Asset.replaceTerms(Column.updater(qualifiedName, name), terms);
    }

    public static Column appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (Column)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static Column removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (Column)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected Column(ColumnBuilder<?, ?> b) {
        super((SQL.SQLBuilder<?, ?>)b);
        Map<Object, Object> validations;
        this.typeName = b.typeName$set ? b.typeName$value : Column.$default$typeName();
        this.dataType = b.dataType;
        this.subDataType = b.subDataType;
        this.order = b.order;
        this.isPartition = b.isPartition;
        this.partitionOrder = b.partitionOrder;
        this.isClustered = b.isClustered;
        this.isPrimary = b.isPrimary;
        this.isForeign = b.isForeign;
        this.isIndexed = b.isIndexed;
        this.isSort = b.isSort;
        this.isDist = b.isDist;
        this.isPinned = b.isPinned;
        this.pinnedBy = b.pinnedBy;
        this.pinnedAt = b.pinnedAt;
        this.precision = b.precision;
        this.defaultValue = b.defaultValue;
        this.isNullable = b.isNullable;
        this.numericScale = b.numericScale;
        this.maxLength = b.maxLength;
        switch (b.validations$key == null ? 0 : b.validations$key.size()) {
            case 0: {
                validations = Collections.emptyMap();
                break;
            }
            case 1: {
                validations = Collections.singletonMap(b.validations$key.get(0), b.validations$value.get(0));
                break;
            }
            default: {
                validations = new LinkedHashMap(b.validations$key.size() < 0x40000000 ? 1 + b.validations$key.size() + (b.validations$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.validations$key.size(); ++$i) {
                    validations.put(b.validations$key.get($i), b.validations$value.get($i));
                }
                validations = Collections.unmodifiableMap(validations);
            }
        }
        this.validations = validations;
        this.materializedView = b.materializedView;
        SortedSet<AtlanQuery> queries = new TreeSet<AtlanQuery>();
        if (b.queries != null) {
            queries.addAll(b.queries);
        }
        queries = Collections.unmodifiableSortedSet(queries);
        this.queries = queries;
        SortedSet<Metric> metricTimestamps = new TreeSet<Metric>();
        if (b.metricTimestamps != null) {
            metricTimestamps.addAll(b.metricTimestamps);
        }
        metricTimestamps = Collections.unmodifiableSortedSet(metricTimestamps);
        this.metricTimestamps = metricTimestamps;
        SortedSet<DbtMetric> dbtMetrics = new TreeSet<DbtMetric>();
        if (b.dbtMetrics != null) {
            dbtMetrics.addAll(b.dbtMetrics);
        }
        dbtMetrics = Collections.unmodifiableSortedSet(dbtMetrics);
        this.dbtMetrics = dbtMetrics;
        this.view = b.view;
        this.tablePartition = b.tablePartition;
        SortedSet<Metric> dataQualityMetricDimensions = new TreeSet<Metric>();
        if (b.dataQualityMetricDimensions != null) {
            dataQualityMetricDimensions.addAll(b.dataQualityMetricDimensions);
        }
        dataQualityMetricDimensions = Collections.unmodifiableSortedSet(dataQualityMetricDimensions);
        this.dataQualityMetricDimensions = dataQualityMetricDimensions;
        SortedSet<DbtModelColumn> dbtModelColumns = new TreeSet<DbtModelColumn>();
        if (b.dbtModelColumns != null) {
            dbtModelColumns.addAll(b.dbtModelColumns);
        }
        dbtModelColumns = Collections.unmodifiableSortedSet(dbtModelColumns);
        this.dbtModelColumns = dbtModelColumns;
        this.table = b.table;
    }

    @Generated
    public static ColumnBuilder<?, ?> builder() {
        return new ColumnBuilderImpl();
    }

    @Generated
    public ColumnBuilder<?, ?> toBuilder() {
        return new ColumnBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getDataType() {
        return this.dataType;
    }

    @Generated
    public String getSubDataType() {
        return this.subDataType;
    }

    @Generated
    public Integer getOrder() {
        return this.order;
    }

    @Generated
    public Boolean getIsPartition() {
        return this.isPartition;
    }

    @Generated
    public Integer getPartitionOrder() {
        return this.partitionOrder;
    }

    @Generated
    public Boolean getIsClustered() {
        return this.isClustered;
    }

    @Generated
    public Boolean getIsPrimary() {
        return this.isPrimary;
    }

    @Generated
    public Boolean getIsForeign() {
        return this.isForeign;
    }

    @Generated
    public Boolean getIsIndexed() {
        return this.isIndexed;
    }

    @Generated
    public Boolean getIsSort() {
        return this.isSort;
    }

    @Generated
    public Boolean getIsDist() {
        return this.isDist;
    }

    @Generated
    public Boolean getIsPinned() {
        return this.isPinned;
    }

    @Generated
    public String getPinnedBy() {
        return this.pinnedBy;
    }

    @Generated
    public Long getPinnedAt() {
        return this.pinnedAt;
    }

    @Generated
    public Integer getPrecision() {
        return this.precision;
    }

    @Generated
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public Boolean getIsNullable() {
        return this.isNullable;
    }

    @Generated
    public Double getNumericScale() {
        return this.numericScale;
    }

    @Generated
    public Long getMaxLength() {
        return this.maxLength;
    }

    @Generated
    public Map<String, String> getValidations() {
        return this.validations;
    }

    @Generated
    public MaterializedView getMaterializedView() {
        return this.materializedView;
    }

    @Generated
    public SortedSet<AtlanQuery> getQueries() {
        return this.queries;
    }

    @Generated
    public SortedSet<Metric> getMetricTimestamps() {
        return this.metricTimestamps;
    }

    @Generated
    public SortedSet<DbtMetric> getDbtMetrics() {
        return this.dbtMetrics;
    }

    @Generated
    public View getView() {
        return this.view;
    }

    @Generated
    public TablePartition getTablePartition() {
        return this.tablePartition;
    }

    @Generated
    public SortedSet<Metric> getDataQualityMetricDimensions() {
        return this.dataQualityMetricDimensions;
    }

    @Generated
    public SortedSet<DbtModelColumn> getDbtModelColumns() {
        return this.dbtModelColumns;
    }

    @Generated
    public Table getTable() {
        return this.table;
    }

    @Generated
    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    @Generated
    public void setSubDataType(String subDataType) {
        this.subDataType = subDataType;
    }

    @Generated
    public void setOrder(Integer order) {
        this.order = order;
    }

    @Generated
    public void setIsPartition(Boolean isPartition) {
        this.isPartition = isPartition;
    }

    @Generated
    public void setPartitionOrder(Integer partitionOrder) {
        this.partitionOrder = partitionOrder;
    }

    @Generated
    public void setIsClustered(Boolean isClustered) {
        this.isClustered = isClustered;
    }

    @Generated
    public void setIsPrimary(Boolean isPrimary) {
        this.isPrimary = isPrimary;
    }

    @Generated
    public void setIsForeign(Boolean isForeign) {
        this.isForeign = isForeign;
    }

    @Generated
    public void setIsIndexed(Boolean isIndexed) {
        this.isIndexed = isIndexed;
    }

    @Generated
    public void setIsSort(Boolean isSort) {
        this.isSort = isSort;
    }

    @Generated
    public void setIsDist(Boolean isDist) {
        this.isDist = isDist;
    }

    @Generated
    public void setIsPinned(Boolean isPinned) {
        this.isPinned = isPinned;
    }

    @Generated
    public void setPinnedBy(String pinnedBy) {
        this.pinnedBy = pinnedBy;
    }

    @Generated
    public void setPinnedAt(Long pinnedAt) {
        this.pinnedAt = pinnedAt;
    }

    @Generated
    public void setPrecision(Integer precision) {
        this.precision = precision;
    }

    @Generated
    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Generated
    public void setIsNullable(Boolean isNullable) {
        this.isNullable = isNullable;
    }

    @Generated
    public void setNumericScale(Double numericScale) {
        this.numericScale = numericScale;
    }

    @Generated
    public void setMaxLength(Long maxLength) {
        this.maxLength = maxLength;
    }

    @Generated
    public void setValidations(Map<String, String> validations) {
        this.validations = validations;
    }

    @JsonProperty(value="materialisedView")
    @Generated
    public void setMaterializedView(MaterializedView materializedView) {
        this.materializedView = materializedView;
    }

    @Generated
    public void setQueries(SortedSet<AtlanQuery> queries) {
        this.queries = queries;
    }

    @Generated
    public void setMetricTimestamps(SortedSet<Metric> metricTimestamps) {
        this.metricTimestamps = metricTimestamps;
    }

    @Generated
    public void setDbtMetrics(SortedSet<DbtMetric> dbtMetrics) {
        this.dbtMetrics = dbtMetrics;
    }

    @Generated
    public void setView(View view) {
        this.view = view;
    }

    @Generated
    public void setTablePartition(TablePartition tablePartition) {
        this.tablePartition = tablePartition;
    }

    @Generated
    public void setDataQualityMetricDimensions(SortedSet<Metric> dataQualityMetricDimensions) {
        this.dataQualityMetricDimensions = dataQualityMetricDimensions;
    }

    @Generated
    public void setDbtModelColumns(SortedSet<DbtModelColumn> dbtModelColumns) {
        this.dbtModelColumns = dbtModelColumns;
    }

    @Generated
    public void setTable(Table table) {
        this.table = table;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Column)) {
            return false;
        }
        Column other = (Column)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$order = this.getOrder();
        Integer other$order = other.getOrder();
        if (this$order == null ? other$order != null : !((Object)this$order).equals(other$order)) {
            return false;
        }
        Boolean this$isPartition = this.getIsPartition();
        Boolean other$isPartition = other.getIsPartition();
        if (this$isPartition == null ? other$isPartition != null : !((Object)this$isPartition).equals(other$isPartition)) {
            return false;
        }
        Integer this$partitionOrder = this.getPartitionOrder();
        Integer other$partitionOrder = other.getPartitionOrder();
        if (this$partitionOrder == null ? other$partitionOrder != null : !((Object)this$partitionOrder).equals(other$partitionOrder)) {
            return false;
        }
        Boolean this$isClustered = this.getIsClustered();
        Boolean other$isClustered = other.getIsClustered();
        if (this$isClustered == null ? other$isClustered != null : !((Object)this$isClustered).equals(other$isClustered)) {
            return false;
        }
        Boolean this$isPrimary = this.getIsPrimary();
        Boolean other$isPrimary = other.getIsPrimary();
        if (this$isPrimary == null ? other$isPrimary != null : !((Object)this$isPrimary).equals(other$isPrimary)) {
            return false;
        }
        Boolean this$isForeign = this.getIsForeign();
        Boolean other$isForeign = other.getIsForeign();
        if (this$isForeign == null ? other$isForeign != null : !((Object)this$isForeign).equals(other$isForeign)) {
            return false;
        }
        Boolean this$isIndexed = this.getIsIndexed();
        Boolean other$isIndexed = other.getIsIndexed();
        if (this$isIndexed == null ? other$isIndexed != null : !((Object)this$isIndexed).equals(other$isIndexed)) {
            return false;
        }
        Boolean this$isSort = this.getIsSort();
        Boolean other$isSort = other.getIsSort();
        if (this$isSort == null ? other$isSort != null : !((Object)this$isSort).equals(other$isSort)) {
            return false;
        }
        Boolean this$isDist = this.getIsDist();
        Boolean other$isDist = other.getIsDist();
        if (this$isDist == null ? other$isDist != null : !((Object)this$isDist).equals(other$isDist)) {
            return false;
        }
        Boolean this$isPinned = this.getIsPinned();
        Boolean other$isPinned = other.getIsPinned();
        if (this$isPinned == null ? other$isPinned != null : !((Object)this$isPinned).equals(other$isPinned)) {
            return false;
        }
        Long this$pinnedAt = this.getPinnedAt();
        Long other$pinnedAt = other.getPinnedAt();
        if (this$pinnedAt == null ? other$pinnedAt != null : !((Object)this$pinnedAt).equals(other$pinnedAt)) {
            return false;
        }
        Integer this$precision = this.getPrecision();
        Integer other$precision = other.getPrecision();
        if (this$precision == null ? other$precision != null : !((Object)this$precision).equals(other$precision)) {
            return false;
        }
        Boolean this$isNullable = this.getIsNullable();
        Boolean other$isNullable = other.getIsNullable();
        if (this$isNullable == null ? other$isNullable != null : !((Object)this$isNullable).equals(other$isNullable)) {
            return false;
        }
        Double this$numericScale = this.getNumericScale();
        Double other$numericScale = other.getNumericScale();
        if (this$numericScale == null ? other$numericScale != null : !((Object)this$numericScale).equals(other$numericScale)) {
            return false;
        }
        Long this$maxLength = this.getMaxLength();
        Long other$maxLength = other.getMaxLength();
        if (this$maxLength == null ? other$maxLength != null : !((Object)this$maxLength).equals(other$maxLength)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$dataType = this.getDataType();
        String other$dataType = other.getDataType();
        if (this$dataType == null ? other$dataType != null : !this$dataType.equals(other$dataType)) {
            return false;
        }
        String this$subDataType = this.getSubDataType();
        String other$subDataType = other.getSubDataType();
        if (this$subDataType == null ? other$subDataType != null : !this$subDataType.equals(other$subDataType)) {
            return false;
        }
        String this$pinnedBy = this.getPinnedBy();
        String other$pinnedBy = other.getPinnedBy();
        if (this$pinnedBy == null ? other$pinnedBy != null : !this$pinnedBy.equals(other$pinnedBy)) {
            return false;
        }
        String this$defaultValue = this.getDefaultValue();
        String other$defaultValue = other.getDefaultValue();
        if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
            return false;
        }
        Map<String, String> this$validations = this.getValidations();
        Map<String, String> other$validations = other.getValidations();
        if (this$validations == null ? other$validations != null : !((Object)this$validations).equals(other$validations)) {
            return false;
        }
        MaterializedView this$materializedView = this.getMaterializedView();
        MaterializedView other$materializedView = other.getMaterializedView();
        if (this$materializedView == null ? other$materializedView != null : !((Object)this$materializedView).equals(other$materializedView)) {
            return false;
        }
        SortedSet<AtlanQuery> this$queries = this.getQueries();
        SortedSet<AtlanQuery> other$queries = other.getQueries();
        if (this$queries == null ? other$queries != null : !this$queries.equals(other$queries)) {
            return false;
        }
        SortedSet<Metric> this$metricTimestamps = this.getMetricTimestamps();
        SortedSet<Metric> other$metricTimestamps = other.getMetricTimestamps();
        if (this$metricTimestamps == null ? other$metricTimestamps != null : !this$metricTimestamps.equals(other$metricTimestamps)) {
            return false;
        }
        SortedSet<DbtMetric> this$dbtMetrics = this.getDbtMetrics();
        SortedSet<DbtMetric> other$dbtMetrics = other.getDbtMetrics();
        if (this$dbtMetrics == null ? other$dbtMetrics != null : !this$dbtMetrics.equals(other$dbtMetrics)) {
            return false;
        }
        View this$view = this.getView();
        View other$view = other.getView();
        if (this$view == null ? other$view != null : !((Object)this$view).equals(other$view)) {
            return false;
        }
        TablePartition this$tablePartition = this.getTablePartition();
        TablePartition other$tablePartition = other.getTablePartition();
        if (this$tablePartition == null ? other$tablePartition != null : !((Object)this$tablePartition).equals(other$tablePartition)) {
            return false;
        }
        SortedSet<Metric> this$dataQualityMetricDimensions = this.getDataQualityMetricDimensions();
        SortedSet<Metric> other$dataQualityMetricDimensions = other.getDataQualityMetricDimensions();
        if (this$dataQualityMetricDimensions == null ? other$dataQualityMetricDimensions != null : !this$dataQualityMetricDimensions.equals(other$dataQualityMetricDimensions)) {
            return false;
        }
        SortedSet<DbtModelColumn> this$dbtModelColumns = this.getDbtModelColumns();
        SortedSet<DbtModelColumn> other$dbtModelColumns = other.getDbtModelColumns();
        if (this$dbtModelColumns == null ? other$dbtModelColumns != null : !this$dbtModelColumns.equals(other$dbtModelColumns)) {
            return false;
        }
        Table this$table = this.getTable();
        Table other$table = other.getTable();
        return !(this$table == null ? other$table != null : !((Object)this$table).equals(other$table));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Column;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : ((Object)$order).hashCode());
        Boolean $isPartition = this.getIsPartition();
        result = result * 59 + ($isPartition == null ? 43 : ((Object)$isPartition).hashCode());
        Integer $partitionOrder = this.getPartitionOrder();
        result = result * 59 + ($partitionOrder == null ? 43 : ((Object)$partitionOrder).hashCode());
        Boolean $isClustered = this.getIsClustered();
        result = result * 59 + ($isClustered == null ? 43 : ((Object)$isClustered).hashCode());
        Boolean $isPrimary = this.getIsPrimary();
        result = result * 59 + ($isPrimary == null ? 43 : ((Object)$isPrimary).hashCode());
        Boolean $isForeign = this.getIsForeign();
        result = result * 59 + ($isForeign == null ? 43 : ((Object)$isForeign).hashCode());
        Boolean $isIndexed = this.getIsIndexed();
        result = result * 59 + ($isIndexed == null ? 43 : ((Object)$isIndexed).hashCode());
        Boolean $isSort = this.getIsSort();
        result = result * 59 + ($isSort == null ? 43 : ((Object)$isSort).hashCode());
        Boolean $isDist = this.getIsDist();
        result = result * 59 + ($isDist == null ? 43 : ((Object)$isDist).hashCode());
        Boolean $isPinned = this.getIsPinned();
        result = result * 59 + ($isPinned == null ? 43 : ((Object)$isPinned).hashCode());
        Long $pinnedAt = this.getPinnedAt();
        result = result * 59 + ($pinnedAt == null ? 43 : ((Object)$pinnedAt).hashCode());
        Integer $precision = this.getPrecision();
        result = result * 59 + ($precision == null ? 43 : ((Object)$precision).hashCode());
        Boolean $isNullable = this.getIsNullable();
        result = result * 59 + ($isNullable == null ? 43 : ((Object)$isNullable).hashCode());
        Double $numericScale = this.getNumericScale();
        result = result * 59 + ($numericScale == null ? 43 : ((Object)$numericScale).hashCode());
        Long $maxLength = this.getMaxLength();
        result = result * 59 + ($maxLength == null ? 43 : ((Object)$maxLength).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $dataType = this.getDataType();
        result = result * 59 + ($dataType == null ? 43 : $dataType.hashCode());
        String $subDataType = this.getSubDataType();
        result = result * 59 + ($subDataType == null ? 43 : $subDataType.hashCode());
        String $pinnedBy = this.getPinnedBy();
        result = result * 59 + ($pinnedBy == null ? 43 : $pinnedBy.hashCode());
        String $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        Map<String, String> $validations = this.getValidations();
        result = result * 59 + ($validations == null ? 43 : ((Object)$validations).hashCode());
        MaterializedView $materializedView = this.getMaterializedView();
        result = result * 59 + ($materializedView == null ? 43 : ((Object)$materializedView).hashCode());
        SortedSet<AtlanQuery> $queries = this.getQueries();
        result = result * 59 + ($queries == null ? 43 : $queries.hashCode());
        SortedSet<Metric> $metricTimestamps = this.getMetricTimestamps();
        result = result * 59 + ($metricTimestamps == null ? 43 : $metricTimestamps.hashCode());
        SortedSet<DbtMetric> $dbtMetrics = this.getDbtMetrics();
        result = result * 59 + ($dbtMetrics == null ? 43 : $dbtMetrics.hashCode());
        View $view = this.getView();
        result = result * 59 + ($view == null ? 43 : ((Object)$view).hashCode());
        TablePartition $tablePartition = this.getTablePartition();
        result = result * 59 + ($tablePartition == null ? 43 : ((Object)$tablePartition).hashCode());
        SortedSet<Metric> $dataQualityMetricDimensions = this.getDataQualityMetricDimensions();
        result = result * 59 + ($dataQualityMetricDimensions == null ? 43 : $dataQualityMetricDimensions.hashCode());
        SortedSet<DbtModelColumn> $dbtModelColumns = this.getDbtModelColumns();
        result = result * 59 + ($dbtModelColumns == null ? 43 : $dbtModelColumns.hashCode());
        Table $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : ((Object)$table).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class ColumnBuilderImpl
    extends ColumnBuilder<Column, ColumnBuilderImpl> {
        @Generated
        private ColumnBuilderImpl() {
        }

        @Override
        @Generated
        protected ColumnBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Column build() {
            return new Column(this);
        }
    }

    @Generated
    public static abstract class ColumnBuilder<C extends Column, B extends ColumnBuilder<C, B>>
    extends SQL.SQLBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String dataType;
        @Generated
        private String subDataType;
        @Generated
        private Integer order;
        @Generated
        private Boolean isPartition;
        @Generated
        private Integer partitionOrder;
        @Generated
        private Boolean isClustered;
        @Generated
        private Boolean isPrimary;
        @Generated
        private Boolean isForeign;
        @Generated
        private Boolean isIndexed;
        @Generated
        private Boolean isSort;
        @Generated
        private Boolean isDist;
        @Generated
        private Boolean isPinned;
        @Generated
        private String pinnedBy;
        @Generated
        private Long pinnedAt;
        @Generated
        private Integer precision;
        @Generated
        private String defaultValue;
        @Generated
        private Boolean isNullable;
        @Generated
        private Double numericScale;
        @Generated
        private Long maxLength;
        @Generated
        private ArrayList<String> validations$key;
        @Generated
        private ArrayList<String> validations$value;
        @Generated
        private MaterializedView materializedView;
        @Generated
        private ArrayList<AtlanQuery> queries;
        @Generated
        private ArrayList<Metric> metricTimestamps;
        @Generated
        private ArrayList<DbtMetric> dbtMetrics;
        @Generated
        private View view;
        @Generated
        private TablePartition tablePartition;
        @Generated
        private ArrayList<Metric> dataQualityMetricDimensions;
        @Generated
        private ArrayList<DbtModelColumn> dbtModelColumns;
        @Generated
        private Table table;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ColumnBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Column instance, ColumnBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.dataType(instance.dataType);
            b.subDataType(instance.subDataType);
            b.order(instance.order);
            b.isPartition(instance.isPartition);
            b.partitionOrder(instance.partitionOrder);
            b.isClustered(instance.isClustered);
            b.isPrimary(instance.isPrimary);
            b.isForeign(instance.isForeign);
            b.isIndexed(instance.isIndexed);
            b.isSort(instance.isSort);
            b.isDist(instance.isDist);
            b.isPinned(instance.isPinned);
            b.pinnedBy(instance.pinnedBy);
            b.pinnedAt(instance.pinnedAt);
            b.precision(instance.precision);
            b.defaultValue(instance.defaultValue);
            b.isNullable(instance.isNullable);
            b.numericScale(instance.numericScale);
            b.maxLength(instance.maxLength);
            b.validations(instance.validations == null ? Collections.emptyMap() : instance.validations);
            b.materializedView(instance.materializedView);
            b.queries(instance.queries == null ? Collections.emptySortedSet() : instance.queries);
            b.metricTimestamps(instance.metricTimestamps == null ? Collections.emptySortedSet() : instance.metricTimestamps);
            b.dbtMetrics(instance.dbtMetrics == null ? Collections.emptySortedSet() : instance.dbtMetrics);
            b.view(instance.view);
            b.tablePartition(instance.tablePartition);
            b.dataQualityMetricDimensions(instance.dataQualityMetricDimensions == null ? Collections.emptySortedSet() : instance.dataQualityMetricDimensions);
            b.dbtModelColumns(instance.dbtModelColumns == null ? Collections.emptySortedSet() : instance.dbtModelColumns);
            b.table(instance.table);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B dataType(String dataType) {
            this.dataType = dataType;
            return (B)this.self();
        }

        @Generated
        public B subDataType(String subDataType) {
            this.subDataType = subDataType;
            return (B)this.self();
        }

        @Generated
        public B order(Integer order) {
            this.order = order;
            return (B)this.self();
        }

        @Generated
        public B isPartition(Boolean isPartition) {
            this.isPartition = isPartition;
            return (B)this.self();
        }

        @Generated
        public B partitionOrder(Integer partitionOrder) {
            this.partitionOrder = partitionOrder;
            return (B)this.self();
        }

        @Generated
        public B isClustered(Boolean isClustered) {
            this.isClustered = isClustered;
            return (B)this.self();
        }

        @Generated
        public B isPrimary(Boolean isPrimary) {
            this.isPrimary = isPrimary;
            return (B)this.self();
        }

        @Generated
        public B isForeign(Boolean isForeign) {
            this.isForeign = isForeign;
            return (B)this.self();
        }

        @Generated
        public B isIndexed(Boolean isIndexed) {
            this.isIndexed = isIndexed;
            return (B)this.self();
        }

        @Generated
        public B isSort(Boolean isSort) {
            this.isSort = isSort;
            return (B)this.self();
        }

        @Generated
        public B isDist(Boolean isDist) {
            this.isDist = isDist;
            return (B)this.self();
        }

        @Generated
        public B isPinned(Boolean isPinned) {
            this.isPinned = isPinned;
            return (B)this.self();
        }

        @Generated
        public B pinnedBy(String pinnedBy) {
            this.pinnedBy = pinnedBy;
            return (B)this.self();
        }

        @Generated
        public B pinnedAt(Long pinnedAt) {
            this.pinnedAt = pinnedAt;
            return (B)this.self();
        }

        @Generated
        public B precision(Integer precision) {
            this.precision = precision;
            return (B)this.self();
        }

        @Generated
        public B defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return (B)this.self();
        }

        @Generated
        public B isNullable(Boolean isNullable) {
            this.isNullable = isNullable;
            return (B)this.self();
        }

        @Generated
        public B numericScale(Double numericScale) {
            this.numericScale = numericScale;
            return (B)this.self();
        }

        @Generated
        public B maxLength(Long maxLength) {
            this.maxLength = maxLength;
            return (B)this.self();
        }

        @Generated
        public B validation(String validationKey, String validationValue) {
            if (this.validations$key == null) {
                this.validations$key = new ArrayList();
                this.validations$value = new ArrayList();
            }
            this.validations$key.add(validationKey);
            this.validations$value.add(validationValue);
            return (B)this.self();
        }

        @Generated
        public B validations(Map<? extends String, ? extends String> validations) {
            if (validations == null) {
                throw new NullPointerException("validations cannot be null");
            }
            if (this.validations$key == null) {
                this.validations$key = new ArrayList();
                this.validations$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : validations.entrySet()) {
                this.validations$key.add($lombokEntry.getKey());
                this.validations$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearValidations() {
            if (this.validations$key != null) {
                this.validations$key.clear();
                this.validations$value.clear();
            }
            return (B)this.self();
        }

        @JsonProperty(value="materialisedView")
        @Generated
        public B materializedView(MaterializedView materializedView) {
            this.materializedView = materializedView;
            return (B)this.self();
        }

        @Generated
        public B query(AtlanQuery query) {
            if (this.queries == null) {
                this.queries = new ArrayList();
            }
            this.queries.add(query);
            return (B)this.self();
        }

        @Generated
        public B queries(Collection<? extends AtlanQuery> queries) {
            if (queries == null) {
                throw new NullPointerException("queries cannot be null");
            }
            if (this.queries == null) {
                this.queries = new ArrayList();
            }
            this.queries.addAll(queries);
            return (B)this.self();
        }

        @Generated
        public B clearQueries() {
            if (this.queries != null) {
                this.queries.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B metricTimestamp(Metric metricTimestamp) {
            if (this.metricTimestamps == null) {
                this.metricTimestamps = new ArrayList();
            }
            this.metricTimestamps.add(metricTimestamp);
            return (B)this.self();
        }

        @Generated
        public B metricTimestamps(Collection<? extends Metric> metricTimestamps) {
            if (metricTimestamps == null) {
                throw new NullPointerException("metricTimestamps cannot be null");
            }
            if (this.metricTimestamps == null) {
                this.metricTimestamps = new ArrayList();
            }
            this.metricTimestamps.addAll(metricTimestamps);
            return (B)this.self();
        }

        @Generated
        public B clearMetricTimestamps() {
            if (this.metricTimestamps != null) {
                this.metricTimestamps.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dbtMetric(DbtMetric dbtMetric) {
            if (this.dbtMetrics == null) {
                this.dbtMetrics = new ArrayList();
            }
            this.dbtMetrics.add(dbtMetric);
            return (B)this.self();
        }

        @Generated
        public B dbtMetrics(Collection<? extends DbtMetric> dbtMetrics) {
            if (dbtMetrics == null) {
                throw new NullPointerException("dbtMetrics cannot be null");
            }
            if (this.dbtMetrics == null) {
                this.dbtMetrics = new ArrayList();
            }
            this.dbtMetrics.addAll(dbtMetrics);
            return (B)this.self();
        }

        @Generated
        public B clearDbtMetrics() {
            if (this.dbtMetrics != null) {
                this.dbtMetrics.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B view(View view) {
            this.view = view;
            return (B)this.self();
        }

        @Generated
        public B tablePartition(TablePartition tablePartition) {
            this.tablePartition = tablePartition;
            return (B)this.self();
        }

        @Generated
        public B dataQualityMetricDimension(Metric dataQualityMetricDimension) {
            if (this.dataQualityMetricDimensions == null) {
                this.dataQualityMetricDimensions = new ArrayList();
            }
            this.dataQualityMetricDimensions.add(dataQualityMetricDimension);
            return (B)this.self();
        }

        @Generated
        public B dataQualityMetricDimensions(Collection<? extends Metric> dataQualityMetricDimensions) {
            if (dataQualityMetricDimensions == null) {
                throw new NullPointerException("dataQualityMetricDimensions cannot be null");
            }
            if (this.dataQualityMetricDimensions == null) {
                this.dataQualityMetricDimensions = new ArrayList();
            }
            this.dataQualityMetricDimensions.addAll(dataQualityMetricDimensions);
            return (B)this.self();
        }

        @Generated
        public B clearDataQualityMetricDimensions() {
            if (this.dataQualityMetricDimensions != null) {
                this.dataQualityMetricDimensions.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dbtModelColumn(DbtModelColumn dbtModelColumn) {
            if (this.dbtModelColumns == null) {
                this.dbtModelColumns = new ArrayList();
            }
            this.dbtModelColumns.add(dbtModelColumn);
            return (B)this.self();
        }

        @Generated
        public B dbtModelColumns(Collection<? extends DbtModelColumn> dbtModelColumns) {
            if (dbtModelColumns == null) {
                throw new NullPointerException("dbtModelColumns cannot be null");
            }
            if (this.dbtModelColumns == null) {
                this.dbtModelColumns = new ArrayList();
            }
            this.dbtModelColumns.addAll(dbtModelColumns);
            return (B)this.self();
        }

        @Generated
        public B clearDbtModelColumns() {
            if (this.dbtModelColumns != null) {
                this.dbtModelColumns.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B table(Table table) {
            this.table = table;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "Column.ColumnBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", dataType=" + this.dataType + ", subDataType=" + this.subDataType + ", order=" + this.order + ", isPartition=" + this.isPartition + ", partitionOrder=" + this.partitionOrder + ", isClustered=" + this.isClustered + ", isPrimary=" + this.isPrimary + ", isForeign=" + this.isForeign + ", isIndexed=" + this.isIndexed + ", isSort=" + this.isSort + ", isDist=" + this.isDist + ", isPinned=" + this.isPinned + ", pinnedBy=" + this.pinnedBy + ", pinnedAt=" + this.pinnedAt + ", precision=" + this.precision + ", defaultValue=" + this.defaultValue + ", isNullable=" + this.isNullable + ", numericScale=" + this.numericScale + ", maxLength=" + this.maxLength + ", validations$key=" + this.validations$key + ", validations$value=" + this.validations$value + ", materializedView=" + this.materializedView + ", queries=" + this.queries + ", metricTimestamps=" + this.metricTimestamps + ", dbtMetrics=" + this.dbtMetrics + ", view=" + this.view + ", tablePartition=" + this.tablePartition + ", dataQualityMetricDimensions=" + this.dataQualityMetricDimensions + ", dbtModelColumns=" + this.dbtModelColumns + ", table=" + this.table + ")";
        }
    }
}

