/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.AbstractColumnProcess;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Catalog;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.relations.UniqueAttributes;
import java.util.List;
import lombok.Generated;

public class ColumnProcess
extends AbstractColumnProcess {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "ColumnProcess";
    String typeName;

    public static ColumnProcess refByGuid(String guid) {
        return ((ColumnProcessBuilder)ColumnProcess.builder().guid(guid)).build();
    }

    public static ColumnProcess refByQualifiedName(String qualifiedName) {
        return ((ColumnProcessBuilder)ColumnProcess.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static ColumnProcessBuilder<?, ?> creator(String name, AtlanConnectorType connectorType, String connectionName, String connectionQualifiedName, List<Catalog> inputs, List<Catalog> outputs) {
        return (ColumnProcessBuilder)((ColumnProcessBuilder)((ColumnProcessBuilder)((ColumnProcessBuilder)ColumnProcess.builder().qualifiedName(ColumnProcess.generateQualifiedName(name, connectorType, connectionName, connectionQualifiedName, inputs, outputs, null))).name(name)).inputs(inputs)).outputs(outputs);
    }

    public static ColumnProcessBuilder<?, ?> updater(String qualifiedName, String name) {
        return (ColumnProcessBuilder)((ColumnProcessBuilder)ColumnProcess.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected ColumnProcessBuilder<?, ?> trimToRequired() {
        return ColumnProcess.updater(this.getQualifiedName(), this.getName());
    }

    public static ColumnProcess retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof ColumnProcess) {
            return (ColumnProcess)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a ColumnProcess.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static ColumnProcess retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof ColumnProcess) {
            return (ColumnProcess)entity;
        }
        throw new NotFoundException("No ColumnProcess found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static ColumnProcess removeDescription(String qualifiedName, String name) throws AtlanException {
        return (ColumnProcess)Asset.removeDescription(((ColumnProcessBuilder)ColumnProcess.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static ColumnProcess removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (ColumnProcess)Asset.removeUserDescription(((ColumnProcessBuilder)ColumnProcess.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static ColumnProcess removeOwners(String qualifiedName, String name) throws AtlanException {
        return (ColumnProcess)Asset.removeOwners(((ColumnProcessBuilder)ColumnProcess.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static ColumnProcess updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (ColumnProcess)Asset.updateCertificate(ColumnProcess.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static ColumnProcess removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (ColumnProcess)Asset.removeCertificate(((ColumnProcessBuilder)ColumnProcess.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static ColumnProcess updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (ColumnProcess)Asset.updateAnnouncement(ColumnProcess.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static ColumnProcess removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (ColumnProcess)Asset.removeAnnouncement(((ColumnProcessBuilder)ColumnProcess.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static ColumnProcess replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (ColumnProcess)Asset.replaceTerms(ColumnProcess.updater(qualifiedName, name), terms);
    }

    public static ColumnProcess appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (ColumnProcess)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static ColumnProcess removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (ColumnProcess)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected ColumnProcess(ColumnProcessBuilder<?, ?> b) {
        super((AbstractColumnProcess.AbstractColumnProcessBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : ColumnProcess.$default$typeName();
    }

    @Generated
    public static ColumnProcessBuilder<?, ?> builder() {
        return new ColumnProcessBuilderImpl();
    }

    @Generated
    public ColumnProcessBuilder<?, ?> toBuilder() {
        return new ColumnProcessBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ColumnProcess)) {
            return false;
        }
        ColumnProcess other = (ColumnProcess)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        return !(this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ColumnProcess;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class ColumnProcessBuilderImpl
    extends ColumnProcessBuilder<ColumnProcess, ColumnProcessBuilderImpl> {
        @Generated
        private ColumnProcessBuilderImpl() {
        }

        @Override
        @Generated
        protected ColumnProcessBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public ColumnProcess build() {
            return new ColumnProcess(this);
        }
    }

    @Generated
    public static abstract class ColumnProcessBuilder<C extends ColumnProcess, B extends ColumnProcessBuilder<C, B>>
    extends AbstractColumnProcess.AbstractColumnProcessBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ColumnProcessBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(ColumnProcess instance, ColumnProcessBuilder<?, ?> b) {
            b.typeName(instance.typeName);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "ColumnProcess.ColumnProcessBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ")";
        }
    }
}

