/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.TermQuery;
import com.atlan.exception.AtlanException;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.enums.AtlanConnectionCategory;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.IndexSearchDSL;
import com.atlan.model.search.IndexSearchRequest;
import com.atlan.model.search.IndexSearchResponse;
import com.atlan.util.QueryFactory;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class Connection
extends Asset {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "Connection";
    String typeName;
    @Attribute
    AtlanConnectionCategory category;
    @Attribute
    String subCategory;
    @Attribute
    String host;
    @Attribute
    Integer port;
    @Attribute
    Boolean allowQuery;
    @Attribute
    Boolean allowQueryPreview;
    @Attribute
    Map<String, String> queryPreviewConfig;
    @Attribute
    String queryConfig;
    @Attribute
    String credentialStrategy;
    @Attribute
    String previewCredentialStrategy;
    @Attribute
    Long rowLimit;
    @Attribute
    String defaultCredentialGuid;
    @Attribute
    String connectorIcon;
    @Attribute
    String connectorImage;
    @Attribute
    String sourceLogo;
    @Attribute
    Long popularityInsightsTimeframe;
    @Attribute
    Boolean hasPopularityInsights;
    @Attribute
    SortedSet<String> connectionDbtEnvironments;

    protected static AtlanConnectorType getConnectorTypeFromQualifiedName(String[] tokens) {
        if (tokens.length > 1) {
            return AtlanConnectorType.fromValue(tokens[1]);
        }
        return null;
    }

    public static Connection refByGuid(String guid) {
        return ((ConnectionBuilder)Connection.builder().guid(guid)).build();
    }

    public static Connection refByQualifiedName(String qualifiedName) {
        return ((ConnectionBuilder)Connection.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static ConnectionBuilder<?, ?> creator(String name, AtlanConnectorType connectorType, List<String> adminRoles, List<String> adminGroups, List<String> adminUsers) throws InvalidRequestException {
        boolean adminFound = false;
        ConnectionBuilder builder = (ConnectionBuilder)((Asset.AssetBuilder)((ConnectionBuilder)((ConnectionBuilder)Connection.builder().name(name)).qualifiedName(Connection.generateQualifiedName(connectorType))).category(connectorType.getCategory())).connectorType(connectorType);
        if (adminRoles != null && !adminRoles.isEmpty()) {
            adminFound = true;
            builder = (ConnectionBuilder)builder.adminRoles(adminRoles);
        }
        if (adminGroups != null && !adminGroups.isEmpty()) {
            adminFound = true;
            builder = (ConnectionBuilder)builder.adminGroups(adminGroups);
        }
        if (adminUsers != null && !adminUsers.isEmpty()) {
            adminFound = true;
            builder = (ConnectionBuilder)builder.adminUsers(adminUsers);
        }
        if (adminFound) {
            return builder;
        }
        throw new InvalidRequestException("No admin provided for the connection, will not attempt to create one.", "adminRoles,adminGroups,adminUsers", "ATLAN-CLIENT-CONNECTION-400-001", 400, null);
    }

    private static String generateQualifiedName(AtlanConnectorType connectorType) {
        long now = System.currentTimeMillis() / 1000L;
        return "default/" + connectorType.getValue() + "/" + now;
    }

    public static ConnectionBuilder<?, ?> updater(String qualifiedName, String name) {
        return (ConnectionBuilder)((ConnectionBuilder)Connection.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected ConnectionBuilder<?, ?> trimToRequired() {
        return Connection.updater(this.getQualifiedName(), this.getName());
    }

    @JsonIgnore
    public static String getEpochFromQualifiedName(String qualifiedName) {
        return qualifiedName.substring(qualifiedName.lastIndexOf("/") + 1);
    }

    public static List<Connection> findByName(String name, AtlanConnectorType type, Collection<String> attributes) throws AtlanException {
        Query byType = QueryFactory.withType(TYPE_NAME);
        Query byName = QueryFactory.withExactName(name);
        Query active = QueryFactory.active();
        Query byConnectorType = TermQuery.of(t -> t.field("connectorName").value(type.getValue()))._toQuery();
        Query filter = BoolQuery.of(b -> b.filter(byType, new Query[]{byName, active, byConnectorType}))._toQuery();
        Object builder = IndexSearchRequest.builder().dsl((IndexSearchDSL)((IndexSearchDSL.IndexSearchDSLBuilder)IndexSearchDSL.builder().query(filter)).build());
        if (attributes != null && !attributes.isEmpty()) {
            ((IndexSearchRequest.IndexSearchRequestBuilder)builder).attributes(attributes);
        }
        AtlanObject request = ((IndexSearchRequest.IndexSearchRequestBuilder)builder).build();
        IndexSearchResponse response = ((IndexSearchRequest)request).search();
        ArrayList<Connection> connections = new ArrayList<Connection>();
        if (response != null) {
            List<Entity> results = response.getEntities();
            while (results != null) {
                for (Entity result : results) {
                    if (!(result instanceof Connection)) continue;
                    connections.add((Connection)result);
                }
                response = response.getNextPage();
                results = response.getEntities();
            }
        }
        if (connections.isEmpty()) {
            throw new NotFoundException("Unable to find a connection with the name '" + name + "' of type: " + type.getValue(), "ATLAN-JAVA-CLIENT-404-095", 404, null);
        }
        return connections;
    }

    public static Connection retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof Connection) {
            return (Connection)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a Connection.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static Connection retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof Connection) {
            return (Connection)entity;
        }
        throw new NotFoundException("No Connection found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static Connection removeDescription(String qualifiedName, String name) throws AtlanException {
        return (Connection)Asset.removeDescription(((ConnectionBuilder)Connection.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static Connection removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (Connection)Asset.removeUserDescription(((ConnectionBuilder)Connection.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static Connection removeOwners(String qualifiedName, String name) throws AtlanException {
        return (Connection)Asset.removeOwners(((ConnectionBuilder)Connection.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static Connection updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (Connection)Asset.updateCertificate(Connection.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static Connection removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (Connection)Asset.removeCertificate(((ConnectionBuilder)Connection.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static Connection updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (Connection)Asset.updateAnnouncement(Connection.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static Connection removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (Connection)Asset.removeAnnouncement(((ConnectionBuilder)Connection.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static Connection replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (Connection)Asset.replaceTerms(Connection.updater(qualifiedName, name), terms);
    }

    public static Connection appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (Connection)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static Connection removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (Connection)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected Connection(ConnectionBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        Map<Object, Object> queryPreviewConfig;
        this.typeName = b.typeName$set ? b.typeName$value : Connection.$default$typeName();
        this.category = b.category;
        this.subCategory = b.subCategory;
        this.host = b.host;
        this.port = b.port;
        this.allowQuery = b.allowQuery;
        this.allowQueryPreview = b.allowQueryPreview;
        switch (b.queryPreviewConfig$key == null ? 0 : b.queryPreviewConfig$key.size()) {
            case 0: {
                queryPreviewConfig = Collections.emptyMap();
                break;
            }
            case 1: {
                queryPreviewConfig = Collections.singletonMap(b.queryPreviewConfig$key.get(0), b.queryPreviewConfig$value.get(0));
                break;
            }
            default: {
                queryPreviewConfig = new LinkedHashMap(b.queryPreviewConfig$key.size() < 0x40000000 ? 1 + b.queryPreviewConfig$key.size() + (b.queryPreviewConfig$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.queryPreviewConfig$key.size(); ++$i) {
                    queryPreviewConfig.put(b.queryPreviewConfig$key.get($i), b.queryPreviewConfig$value.get($i));
                }
                queryPreviewConfig = Collections.unmodifiableMap(queryPreviewConfig);
            }
        }
        this.queryPreviewConfig = queryPreviewConfig;
        this.queryConfig = b.queryConfig;
        this.credentialStrategy = b.credentialStrategy;
        this.previewCredentialStrategy = b.previewCredentialStrategy;
        this.rowLimit = b.rowLimit;
        this.defaultCredentialGuid = b.defaultCredentialGuid;
        this.connectorIcon = b.connectorIcon;
        this.connectorImage = b.connectorImage;
        this.sourceLogo = b.sourceLogo;
        this.popularityInsightsTimeframe = b.popularityInsightsTimeframe;
        this.hasPopularityInsights = b.hasPopularityInsights;
        SortedSet<String> connectionDbtEnvironments = new TreeSet<String>();
        if (b.connectionDbtEnvironments != null) {
            connectionDbtEnvironments.addAll(b.connectionDbtEnvironments);
        }
        connectionDbtEnvironments = Collections.unmodifiableSortedSet(connectionDbtEnvironments);
        this.connectionDbtEnvironments = connectionDbtEnvironments;
    }

    @Generated
    public static ConnectionBuilder<?, ?> builder() {
        return new ConnectionBuilderImpl();
    }

    @Generated
    public ConnectionBuilder<?, ?> toBuilder() {
        return new ConnectionBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public AtlanConnectionCategory getCategory() {
        return this.category;
    }

    @Generated
    public String getSubCategory() {
        return this.subCategory;
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public Integer getPort() {
        return this.port;
    }

    @Generated
    public Boolean getAllowQuery() {
        return this.allowQuery;
    }

    @Generated
    public Boolean getAllowQueryPreview() {
        return this.allowQueryPreview;
    }

    @Generated
    public Map<String, String> getQueryPreviewConfig() {
        return this.queryPreviewConfig;
    }

    @Generated
    public String getQueryConfig() {
        return this.queryConfig;
    }

    @Generated
    public String getCredentialStrategy() {
        return this.credentialStrategy;
    }

    @Generated
    public String getPreviewCredentialStrategy() {
        return this.previewCredentialStrategy;
    }

    @Generated
    public Long getRowLimit() {
        return this.rowLimit;
    }

    @Generated
    public String getDefaultCredentialGuid() {
        return this.defaultCredentialGuid;
    }

    @Generated
    public String getConnectorIcon() {
        return this.connectorIcon;
    }

    @Generated
    public String getConnectorImage() {
        return this.connectorImage;
    }

    @Generated
    public String getSourceLogo() {
        return this.sourceLogo;
    }

    @Generated
    public Long getPopularityInsightsTimeframe() {
        return this.popularityInsightsTimeframe;
    }

    @Generated
    public Boolean getHasPopularityInsights() {
        return this.hasPopularityInsights;
    }

    @Generated
    public SortedSet<String> getConnectionDbtEnvironments() {
        return this.connectionDbtEnvironments;
    }

    @Generated
    public void setCategory(AtlanConnectionCategory category) {
        this.category = category;
    }

    @Generated
    public void setSubCategory(String subCategory) {
        this.subCategory = subCategory;
    }

    @Generated
    public void setHost(String host) {
        this.host = host;
    }

    @Generated
    public void setPort(Integer port) {
        this.port = port;
    }

    @Generated
    public void setAllowQuery(Boolean allowQuery) {
        this.allowQuery = allowQuery;
    }

    @Generated
    public void setAllowQueryPreview(Boolean allowQueryPreview) {
        this.allowQueryPreview = allowQueryPreview;
    }

    @Generated
    public void setQueryPreviewConfig(Map<String, String> queryPreviewConfig) {
        this.queryPreviewConfig = queryPreviewConfig;
    }

    @Generated
    public void setQueryConfig(String queryConfig) {
        this.queryConfig = queryConfig;
    }

    @Generated
    public void setCredentialStrategy(String credentialStrategy) {
        this.credentialStrategy = credentialStrategy;
    }

    @Generated
    public void setPreviewCredentialStrategy(String previewCredentialStrategy) {
        this.previewCredentialStrategy = previewCredentialStrategy;
    }

    @Generated
    public void setRowLimit(Long rowLimit) {
        this.rowLimit = rowLimit;
    }

    @Generated
    public void setDefaultCredentialGuid(String defaultCredentialGuid) {
        this.defaultCredentialGuid = defaultCredentialGuid;
    }

    @Generated
    public void setConnectorIcon(String connectorIcon) {
        this.connectorIcon = connectorIcon;
    }

    @Generated
    public void setConnectorImage(String connectorImage) {
        this.connectorImage = connectorImage;
    }

    @Generated
    public void setSourceLogo(String sourceLogo) {
        this.sourceLogo = sourceLogo;
    }

    @Generated
    public void setPopularityInsightsTimeframe(Long popularityInsightsTimeframe) {
        this.popularityInsightsTimeframe = popularityInsightsTimeframe;
    }

    @Generated
    public void setHasPopularityInsights(Boolean hasPopularityInsights) {
        this.hasPopularityInsights = hasPopularityInsights;
    }

    @Generated
    public void setConnectionDbtEnvironments(SortedSet<String> connectionDbtEnvironments) {
        this.connectionDbtEnvironments = connectionDbtEnvironments;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Connection)) {
            return false;
        }
        Connection other = (Connection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        Boolean this$allowQuery = this.getAllowQuery();
        Boolean other$allowQuery = other.getAllowQuery();
        if (this$allowQuery == null ? other$allowQuery != null : !((Object)this$allowQuery).equals(other$allowQuery)) {
            return false;
        }
        Boolean this$allowQueryPreview = this.getAllowQueryPreview();
        Boolean other$allowQueryPreview = other.getAllowQueryPreview();
        if (this$allowQueryPreview == null ? other$allowQueryPreview != null : !((Object)this$allowQueryPreview).equals(other$allowQueryPreview)) {
            return false;
        }
        Long this$rowLimit = this.getRowLimit();
        Long other$rowLimit = other.getRowLimit();
        if (this$rowLimit == null ? other$rowLimit != null : !((Object)this$rowLimit).equals(other$rowLimit)) {
            return false;
        }
        Long this$popularityInsightsTimeframe = this.getPopularityInsightsTimeframe();
        Long other$popularityInsightsTimeframe = other.getPopularityInsightsTimeframe();
        if (this$popularityInsightsTimeframe == null ? other$popularityInsightsTimeframe != null : !((Object)this$popularityInsightsTimeframe).equals(other$popularityInsightsTimeframe)) {
            return false;
        }
        Boolean this$hasPopularityInsights = this.getHasPopularityInsights();
        Boolean other$hasPopularityInsights = other.getHasPopularityInsights();
        if (this$hasPopularityInsights == null ? other$hasPopularityInsights != null : !((Object)this$hasPopularityInsights).equals(other$hasPopularityInsights)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        AtlanConnectionCategory this$category = this.getCategory();
        AtlanConnectionCategory other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        String this$subCategory = this.getSubCategory();
        String other$subCategory = other.getSubCategory();
        if (this$subCategory == null ? other$subCategory != null : !this$subCategory.equals(other$subCategory)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        Map<String, String> this$queryPreviewConfig = this.getQueryPreviewConfig();
        Map<String, String> other$queryPreviewConfig = other.getQueryPreviewConfig();
        if (this$queryPreviewConfig == null ? other$queryPreviewConfig != null : !((Object)this$queryPreviewConfig).equals(other$queryPreviewConfig)) {
            return false;
        }
        String this$queryConfig = this.getQueryConfig();
        String other$queryConfig = other.getQueryConfig();
        if (this$queryConfig == null ? other$queryConfig != null : !this$queryConfig.equals(other$queryConfig)) {
            return false;
        }
        String this$credentialStrategy = this.getCredentialStrategy();
        String other$credentialStrategy = other.getCredentialStrategy();
        if (this$credentialStrategy == null ? other$credentialStrategy != null : !this$credentialStrategy.equals(other$credentialStrategy)) {
            return false;
        }
        String this$previewCredentialStrategy = this.getPreviewCredentialStrategy();
        String other$previewCredentialStrategy = other.getPreviewCredentialStrategy();
        if (this$previewCredentialStrategy == null ? other$previewCredentialStrategy != null : !this$previewCredentialStrategy.equals(other$previewCredentialStrategy)) {
            return false;
        }
        String this$defaultCredentialGuid = this.getDefaultCredentialGuid();
        String other$defaultCredentialGuid = other.getDefaultCredentialGuid();
        if (this$defaultCredentialGuid == null ? other$defaultCredentialGuid != null : !this$defaultCredentialGuid.equals(other$defaultCredentialGuid)) {
            return false;
        }
        String this$connectorIcon = this.getConnectorIcon();
        String other$connectorIcon = other.getConnectorIcon();
        if (this$connectorIcon == null ? other$connectorIcon != null : !this$connectorIcon.equals(other$connectorIcon)) {
            return false;
        }
        String this$connectorImage = this.getConnectorImage();
        String other$connectorImage = other.getConnectorImage();
        if (this$connectorImage == null ? other$connectorImage != null : !this$connectorImage.equals(other$connectorImage)) {
            return false;
        }
        String this$sourceLogo = this.getSourceLogo();
        String other$sourceLogo = other.getSourceLogo();
        if (this$sourceLogo == null ? other$sourceLogo != null : !this$sourceLogo.equals(other$sourceLogo)) {
            return false;
        }
        SortedSet<String> this$connectionDbtEnvironments = this.getConnectionDbtEnvironments();
        SortedSet<String> other$connectionDbtEnvironments = other.getConnectionDbtEnvironments();
        return !(this$connectionDbtEnvironments == null ? other$connectionDbtEnvironments != null : !this$connectionDbtEnvironments.equals(other$connectionDbtEnvironments));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Connection;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        Boolean $allowQuery = this.getAllowQuery();
        result = result * 59 + ($allowQuery == null ? 43 : ((Object)$allowQuery).hashCode());
        Boolean $allowQueryPreview = this.getAllowQueryPreview();
        result = result * 59 + ($allowQueryPreview == null ? 43 : ((Object)$allowQueryPreview).hashCode());
        Long $rowLimit = this.getRowLimit();
        result = result * 59 + ($rowLimit == null ? 43 : ((Object)$rowLimit).hashCode());
        Long $popularityInsightsTimeframe = this.getPopularityInsightsTimeframe();
        result = result * 59 + ($popularityInsightsTimeframe == null ? 43 : ((Object)$popularityInsightsTimeframe).hashCode());
        Boolean $hasPopularityInsights = this.getHasPopularityInsights();
        result = result * 59 + ($hasPopularityInsights == null ? 43 : ((Object)$hasPopularityInsights).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        AtlanConnectionCategory $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        String $subCategory = this.getSubCategory();
        result = result * 59 + ($subCategory == null ? 43 : $subCategory.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        Map<String, String> $queryPreviewConfig = this.getQueryPreviewConfig();
        result = result * 59 + ($queryPreviewConfig == null ? 43 : ((Object)$queryPreviewConfig).hashCode());
        String $queryConfig = this.getQueryConfig();
        result = result * 59 + ($queryConfig == null ? 43 : $queryConfig.hashCode());
        String $credentialStrategy = this.getCredentialStrategy();
        result = result * 59 + ($credentialStrategy == null ? 43 : $credentialStrategy.hashCode());
        String $previewCredentialStrategy = this.getPreviewCredentialStrategy();
        result = result * 59 + ($previewCredentialStrategy == null ? 43 : $previewCredentialStrategy.hashCode());
        String $defaultCredentialGuid = this.getDefaultCredentialGuid();
        result = result * 59 + ($defaultCredentialGuid == null ? 43 : $defaultCredentialGuid.hashCode());
        String $connectorIcon = this.getConnectorIcon();
        result = result * 59 + ($connectorIcon == null ? 43 : $connectorIcon.hashCode());
        String $connectorImage = this.getConnectorImage();
        result = result * 59 + ($connectorImage == null ? 43 : $connectorImage.hashCode());
        String $sourceLogo = this.getSourceLogo();
        result = result * 59 + ($sourceLogo == null ? 43 : $sourceLogo.hashCode());
        SortedSet<String> $connectionDbtEnvironments = this.getConnectionDbtEnvironments();
        result = result * 59 + ($connectionDbtEnvironments == null ? 43 : $connectionDbtEnvironments.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class ConnectionBuilderImpl
    extends ConnectionBuilder<Connection, ConnectionBuilderImpl> {
        @Generated
        private ConnectionBuilderImpl() {
        }

        @Override
        @Generated
        protected ConnectionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Connection build() {
            return new Connection(this);
        }
    }

    @Generated
    public static abstract class ConnectionBuilder<C extends Connection, B extends ConnectionBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private AtlanConnectionCategory category;
        @Generated
        private String subCategory;
        @Generated
        private String host;
        @Generated
        private Integer port;
        @Generated
        private Boolean allowQuery;
        @Generated
        private Boolean allowQueryPreview;
        @Generated
        private ArrayList<String> queryPreviewConfig$key;
        @Generated
        private ArrayList<String> queryPreviewConfig$value;
        @Generated
        private String queryConfig;
        @Generated
        private String credentialStrategy;
        @Generated
        private String previewCredentialStrategy;
        @Generated
        private Long rowLimit;
        @Generated
        private String defaultCredentialGuid;
        @Generated
        private String connectorIcon;
        @Generated
        private String connectorImage;
        @Generated
        private String sourceLogo;
        @Generated
        private Long popularityInsightsTimeframe;
        @Generated
        private Boolean hasPopularityInsights;
        @Generated
        private ArrayList<String> connectionDbtEnvironments;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ConnectionBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Connection instance, ConnectionBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.category(instance.category);
            b.subCategory(instance.subCategory);
            b.host(instance.host);
            b.port(instance.port);
            b.allowQuery(instance.allowQuery);
            b.allowQueryPreview(instance.allowQueryPreview);
            b.queryPreviewConfig(instance.queryPreviewConfig == null ? Collections.emptyMap() : instance.queryPreviewConfig);
            b.queryConfig(instance.queryConfig);
            b.credentialStrategy(instance.credentialStrategy);
            b.previewCredentialStrategy(instance.previewCredentialStrategy);
            b.rowLimit(instance.rowLimit);
            b.defaultCredentialGuid(instance.defaultCredentialGuid);
            b.connectorIcon(instance.connectorIcon);
            b.connectorImage(instance.connectorImage);
            b.sourceLogo(instance.sourceLogo);
            b.popularityInsightsTimeframe(instance.popularityInsightsTimeframe);
            b.hasPopularityInsights(instance.hasPopularityInsights);
            b.connectionDbtEnvironments(instance.connectionDbtEnvironments == null ? Collections.emptySortedSet() : instance.connectionDbtEnvironments);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B category(AtlanConnectionCategory category) {
            this.category = category;
            return (B)this.self();
        }

        @Generated
        public B subCategory(String subCategory) {
            this.subCategory = subCategory;
            return (B)this.self();
        }

        @Generated
        public B host(String host) {
            this.host = host;
            return (B)this.self();
        }

        @Generated
        public B port(Integer port) {
            this.port = port;
            return (B)this.self();
        }

        @Generated
        public B allowQuery(Boolean allowQuery) {
            this.allowQuery = allowQuery;
            return (B)this.self();
        }

        @Generated
        public B allowQueryPreview(Boolean allowQueryPreview) {
            this.allowQueryPreview = allowQueryPreview;
            return (B)this.self();
        }

        @Generated
        public B putQueryPreviewConfig(String putQueryPreviewConfigKey, String putQueryPreviewConfigValue) {
            if (this.queryPreviewConfig$key == null) {
                this.queryPreviewConfig$key = new ArrayList();
                this.queryPreviewConfig$value = new ArrayList();
            }
            this.queryPreviewConfig$key.add(putQueryPreviewConfigKey);
            this.queryPreviewConfig$value.add(putQueryPreviewConfigValue);
            return (B)this.self();
        }

        @Generated
        public B queryPreviewConfig(Map<? extends String, ? extends String> queryPreviewConfig) {
            if (queryPreviewConfig == null) {
                throw new NullPointerException("queryPreviewConfig cannot be null");
            }
            if (this.queryPreviewConfig$key == null) {
                this.queryPreviewConfig$key = new ArrayList();
                this.queryPreviewConfig$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : queryPreviewConfig.entrySet()) {
                this.queryPreviewConfig$key.add($lombokEntry.getKey());
                this.queryPreviewConfig$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearQueryPreviewConfig() {
            if (this.queryPreviewConfig$key != null) {
                this.queryPreviewConfig$key.clear();
                this.queryPreviewConfig$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B queryConfig(String queryConfig) {
            this.queryConfig = queryConfig;
            return (B)this.self();
        }

        @Generated
        public B credentialStrategy(String credentialStrategy) {
            this.credentialStrategy = credentialStrategy;
            return (B)this.self();
        }

        @Generated
        public B previewCredentialStrategy(String previewCredentialStrategy) {
            this.previewCredentialStrategy = previewCredentialStrategy;
            return (B)this.self();
        }

        @Generated
        public B rowLimit(Long rowLimit) {
            this.rowLimit = rowLimit;
            return (B)this.self();
        }

        @Generated
        public B defaultCredentialGuid(String defaultCredentialGuid) {
            this.defaultCredentialGuid = defaultCredentialGuid;
            return (B)this.self();
        }

        @Generated
        public B connectorIcon(String connectorIcon) {
            this.connectorIcon = connectorIcon;
            return (B)this.self();
        }

        @Generated
        public B connectorImage(String connectorImage) {
            this.connectorImage = connectorImage;
            return (B)this.self();
        }

        @Generated
        public B sourceLogo(String sourceLogo) {
            this.sourceLogo = sourceLogo;
            return (B)this.self();
        }

        @Generated
        public B popularityInsightsTimeframe(Long popularityInsightsTimeframe) {
            this.popularityInsightsTimeframe = popularityInsightsTimeframe;
            return (B)this.self();
        }

        @Generated
        public B hasPopularityInsights(Boolean hasPopularityInsights) {
            this.hasPopularityInsights = hasPopularityInsights;
            return (B)this.self();
        }

        @Generated
        public B connectionDbtEnvironment(String connectionDbtEnvironment) {
            if (this.connectionDbtEnvironments == null) {
                this.connectionDbtEnvironments = new ArrayList();
            }
            this.connectionDbtEnvironments.add(connectionDbtEnvironment);
            return (B)this.self();
        }

        @Generated
        public B connectionDbtEnvironments(Collection<? extends String> connectionDbtEnvironments) {
            if (connectionDbtEnvironments == null) {
                throw new NullPointerException("connectionDbtEnvironments cannot be null");
            }
            if (this.connectionDbtEnvironments == null) {
                this.connectionDbtEnvironments = new ArrayList();
            }
            this.connectionDbtEnvironments.addAll(connectionDbtEnvironments);
            return (B)this.self();
        }

        @Generated
        public B clearConnectionDbtEnvironments() {
            if (this.connectionDbtEnvironments != null) {
                this.connectionDbtEnvironments.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "Connection.ConnectionBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", category=" + this.category + ", subCategory=" + this.subCategory + ", host=" + this.host + ", port=" + this.port + ", allowQuery=" + this.allowQuery + ", allowQueryPreview=" + this.allowQueryPreview + ", queryPreviewConfig$key=" + this.queryPreviewConfig$key + ", queryPreviewConfig$value=" + this.queryPreviewConfig$value + ", queryConfig=" + this.queryConfig + ", credentialStrategy=" + this.credentialStrategy + ", previewCredentialStrategy=" + this.previewCredentialStrategy + ", rowLimit=" + this.rowLimit + ", defaultCredentialGuid=" + this.defaultCredentialGuid + ", connectorIcon=" + this.connectorIcon + ", connectorImage=" + this.connectorImage + ", sourceLogo=" + this.sourceLogo + ", popularityInsightsTimeframe=" + this.popularityInsightsTimeframe + ", hasPopularityInsights=" + this.hasPopularityInsights + ", connectionDbtEnvironments=" + this.connectionDbtEnvironments + ")";
        }
    }
}

