/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.Google;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.enums.GoogleDataStudioAssetType;
import com.atlan.model.relations.UniqueAttributes;
import java.util.List;
import lombok.Generated;

public class DataStudioAsset
extends Google {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "DataStudioAsset";
    String typeName;
    @Attribute
    GoogleDataStudioAssetType dataStudioAssetType;
    @Attribute
    String dataStudioAssetTitle;
    @Attribute
    String dataStudioAssetOwner;
    @Attribute
    Boolean isTrashedDataStudioAsset;

    public static DataStudioAsset refByGuid(String guid) {
        return ((DataStudioAssetBuilder)DataStudioAsset.builder().guid(guid)).build();
    }

    public static DataStudioAsset refByQualifiedName(String qualifiedName) {
        return ((DataStudioAssetBuilder)DataStudioAsset.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static DataStudioAssetBuilder<?, ?> creator(String name, String connectionQualifiedName, GoogleDataStudioAssetType assetType) {
        return ((DataStudioAssetBuilder)((DataStudioAssetBuilder)((DataStudioAssetBuilder)((DataStudioAssetBuilder)DataStudioAsset.builder().qualifiedName(connectionQualifiedName + "/" + name)).name(name)).connectionQualifiedName(connectionQualifiedName)).connectorType(AtlanConnectorType.DATASTUDIO)).dataStudioAssetType(assetType);
    }

    public static DataStudioAssetBuilder<?, ?> updater(String qualifiedName, String name) {
        return (DataStudioAssetBuilder)((DataStudioAssetBuilder)DataStudioAsset.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected DataStudioAssetBuilder<?, ?> trimToRequired() {
        return DataStudioAsset.updater(this.getQualifiedName(), this.getName());
    }

    public static DataStudioAsset retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof DataStudioAsset) {
            return (DataStudioAsset)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a DataStudioAsset.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static DataStudioAsset retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof DataStudioAsset) {
            return (DataStudioAsset)entity;
        }
        throw new NotFoundException("No DataStudioAsset found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static DataStudioAsset removeDescription(String qualifiedName, String name) throws AtlanException {
        return (DataStudioAsset)Asset.removeDescription(((DataStudioAssetBuilder)DataStudioAsset.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static DataStudioAsset removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (DataStudioAsset)Asset.removeUserDescription(((DataStudioAssetBuilder)DataStudioAsset.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static DataStudioAsset removeOwners(String qualifiedName, String name) throws AtlanException {
        return (DataStudioAsset)Asset.removeOwners(((DataStudioAssetBuilder)DataStudioAsset.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static DataStudioAsset updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (DataStudioAsset)Asset.updateCertificate(DataStudioAsset.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static DataStudioAsset removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (DataStudioAsset)Asset.removeCertificate(((DataStudioAssetBuilder)DataStudioAsset.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static DataStudioAsset updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (DataStudioAsset)Asset.updateAnnouncement(DataStudioAsset.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static DataStudioAsset removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (DataStudioAsset)Asset.removeAnnouncement(((DataStudioAssetBuilder)DataStudioAsset.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static DataStudioAsset replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (DataStudioAsset)Asset.replaceTerms(DataStudioAsset.updater(qualifiedName, name), terms);
    }

    public static DataStudioAsset appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (DataStudioAsset)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static DataStudioAsset removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (DataStudioAsset)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected DataStudioAsset(DataStudioAssetBuilder<?, ?> b) {
        super((Google.GoogleBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : DataStudioAsset.$default$typeName();
        this.dataStudioAssetType = b.dataStudioAssetType;
        this.dataStudioAssetTitle = b.dataStudioAssetTitle;
        this.dataStudioAssetOwner = b.dataStudioAssetOwner;
        this.isTrashedDataStudioAsset = b.isTrashedDataStudioAsset;
    }

    @Generated
    public static DataStudioAssetBuilder<?, ?> builder() {
        return new DataStudioAssetBuilderImpl();
    }

    @Generated
    public DataStudioAssetBuilder<?, ?> toBuilder() {
        return new DataStudioAssetBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public GoogleDataStudioAssetType getDataStudioAssetType() {
        return this.dataStudioAssetType;
    }

    @Generated
    public String getDataStudioAssetTitle() {
        return this.dataStudioAssetTitle;
    }

    @Generated
    public String getDataStudioAssetOwner() {
        return this.dataStudioAssetOwner;
    }

    @Generated
    public Boolean getIsTrashedDataStudioAsset() {
        return this.isTrashedDataStudioAsset;
    }

    @Generated
    public void setDataStudioAssetType(GoogleDataStudioAssetType dataStudioAssetType) {
        this.dataStudioAssetType = dataStudioAssetType;
    }

    @Generated
    public void setDataStudioAssetTitle(String dataStudioAssetTitle) {
        this.dataStudioAssetTitle = dataStudioAssetTitle;
    }

    @Generated
    public void setDataStudioAssetOwner(String dataStudioAssetOwner) {
        this.dataStudioAssetOwner = dataStudioAssetOwner;
    }

    @Generated
    public void setIsTrashedDataStudioAsset(Boolean isTrashedDataStudioAsset) {
        this.isTrashedDataStudioAsset = isTrashedDataStudioAsset;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataStudioAsset)) {
            return false;
        }
        DataStudioAsset other = (DataStudioAsset)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$isTrashedDataStudioAsset = this.getIsTrashedDataStudioAsset();
        Boolean other$isTrashedDataStudioAsset = other.getIsTrashedDataStudioAsset();
        if (this$isTrashedDataStudioAsset == null ? other$isTrashedDataStudioAsset != null : !((Object)this$isTrashedDataStudioAsset).equals(other$isTrashedDataStudioAsset)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        GoogleDataStudioAssetType this$dataStudioAssetType = this.getDataStudioAssetType();
        GoogleDataStudioAssetType other$dataStudioAssetType = other.getDataStudioAssetType();
        if (this$dataStudioAssetType == null ? other$dataStudioAssetType != null : !this$dataStudioAssetType.equals(other$dataStudioAssetType)) {
            return false;
        }
        String this$dataStudioAssetTitle = this.getDataStudioAssetTitle();
        String other$dataStudioAssetTitle = other.getDataStudioAssetTitle();
        if (this$dataStudioAssetTitle == null ? other$dataStudioAssetTitle != null : !this$dataStudioAssetTitle.equals(other$dataStudioAssetTitle)) {
            return false;
        }
        String this$dataStudioAssetOwner = this.getDataStudioAssetOwner();
        String other$dataStudioAssetOwner = other.getDataStudioAssetOwner();
        return !(this$dataStudioAssetOwner == null ? other$dataStudioAssetOwner != null : !this$dataStudioAssetOwner.equals(other$dataStudioAssetOwner));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DataStudioAsset;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $isTrashedDataStudioAsset = this.getIsTrashedDataStudioAsset();
        result = result * 59 + ($isTrashedDataStudioAsset == null ? 43 : ((Object)$isTrashedDataStudioAsset).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        GoogleDataStudioAssetType $dataStudioAssetType = this.getDataStudioAssetType();
        result = result * 59 + ($dataStudioAssetType == null ? 43 : $dataStudioAssetType.hashCode());
        String $dataStudioAssetTitle = this.getDataStudioAssetTitle();
        result = result * 59 + ($dataStudioAssetTitle == null ? 43 : $dataStudioAssetTitle.hashCode());
        String $dataStudioAssetOwner = this.getDataStudioAssetOwner();
        result = result * 59 + ($dataStudioAssetOwner == null ? 43 : $dataStudioAssetOwner.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class DataStudioAssetBuilderImpl
    extends DataStudioAssetBuilder<DataStudioAsset, DataStudioAssetBuilderImpl> {
        @Generated
        private DataStudioAssetBuilderImpl() {
        }

        @Override
        @Generated
        protected DataStudioAssetBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DataStudioAsset build() {
            return new DataStudioAsset(this);
        }
    }

    @Generated
    public static abstract class DataStudioAssetBuilder<C extends DataStudioAsset, B extends DataStudioAssetBuilder<C, B>>
    extends Google.GoogleBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private GoogleDataStudioAssetType dataStudioAssetType;
        @Generated
        private String dataStudioAssetTitle;
        @Generated
        private String dataStudioAssetOwner;
        @Generated
        private Boolean isTrashedDataStudioAsset;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            DataStudioAssetBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(DataStudioAsset instance, DataStudioAssetBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.dataStudioAssetType(instance.dataStudioAssetType);
            b.dataStudioAssetTitle(instance.dataStudioAssetTitle);
            b.dataStudioAssetOwner(instance.dataStudioAssetOwner);
            b.isTrashedDataStudioAsset(instance.isTrashedDataStudioAsset);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B dataStudioAssetType(GoogleDataStudioAssetType dataStudioAssetType) {
            this.dataStudioAssetType = dataStudioAssetType;
            return (B)this.self();
        }

        @Generated
        public B dataStudioAssetTitle(String dataStudioAssetTitle) {
            this.dataStudioAssetTitle = dataStudioAssetTitle;
            return (B)this.self();
        }

        @Generated
        public B dataStudioAssetOwner(String dataStudioAssetOwner) {
            this.dataStudioAssetOwner = dataStudioAssetOwner;
            return (B)this.self();
        }

        @Generated
        public B isTrashedDataStudioAsset(Boolean isTrashedDataStudioAsset) {
            this.isTrashedDataStudioAsset = isTrashedDataStudioAsset;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "DataStudioAsset.DataStudioAssetBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", dataStudioAssetType=" + this.dataStudioAssetType + ", dataStudioAssetTitle=" + this.dataStudioAssetTitle + ", dataStudioAssetOwner=" + this.dataStudioAssetOwner + ", isTrashedDataStudioAsset=" + this.isTrashedDataStudioAsset + ")";
        }
    }
}

