/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Connection;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.SQL;
import com.atlan.model.assets.Schema;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class Database
extends SQL {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "Database";
    String typeName;
    @Attribute
    Integer schemaCount;
    @Attribute
    SortedSet<Schema> schemas;

    public static Database refByGuid(String guid) {
        return ((DatabaseBuilder)Database.builder().guid(guid)).build();
    }

    public static Database refByQualifiedName(String qualifiedName) {
        return ((DatabaseBuilder)Database.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static DatabaseBuilder<?, ?> creator(String name, String connectionQualifiedName) {
        AtlanConnectorType connectorType = Connection.getConnectorTypeFromQualifiedName(connectionQualifiedName.split("/"));
        return (DatabaseBuilder)((DatabaseBuilder)((DatabaseBuilder)((DatabaseBuilder)Database.builder().name(name)).qualifiedName(connectionQualifiedName + "/" + name)).connectorType(connectorType)).connectionQualifiedName(connectionQualifiedName);
    }

    public static DatabaseBuilder<?, ?> updater(String qualifiedName, String name) {
        return (DatabaseBuilder)((DatabaseBuilder)Database.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected DatabaseBuilder<?, ?> trimToRequired() {
        return Database.updater(this.getQualifiedName(), this.getName());
    }

    public static Database retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof Database) {
            return (Database)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a Database.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static Database retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof Database) {
            return (Database)entity;
        }
        throw new NotFoundException("No Database found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static Database removeDescription(String qualifiedName, String name) throws AtlanException {
        return (Database)Asset.removeDescription(((DatabaseBuilder)Database.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static Database removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (Database)Asset.removeUserDescription(((DatabaseBuilder)Database.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static Database removeOwners(String qualifiedName, String name) throws AtlanException {
        return (Database)Asset.removeOwners(((DatabaseBuilder)Database.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static Database updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (Database)Asset.updateCertificate(Database.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static Database removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (Database)Asset.removeCertificate(((DatabaseBuilder)Database.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static Database updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (Database)Asset.updateAnnouncement(Database.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static Database removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (Database)Asset.removeAnnouncement(((DatabaseBuilder)Database.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static Database replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (Database)Asset.replaceTerms(Database.updater(qualifiedName, name), terms);
    }

    public static Database appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (Database)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static Database removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (Database)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected Database(DatabaseBuilder<?, ?> b) {
        super((SQL.SQLBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : Database.$default$typeName();
        this.schemaCount = b.schemaCount;
        SortedSet<Schema> schemas = new TreeSet<Schema>();
        if (b.schemas != null) {
            schemas.addAll(b.schemas);
        }
        schemas = Collections.unmodifiableSortedSet(schemas);
        this.schemas = schemas;
    }

    @Generated
    public static DatabaseBuilder<?, ?> builder() {
        return new DatabaseBuilderImpl();
    }

    @Generated
    public DatabaseBuilder<?, ?> toBuilder() {
        return new DatabaseBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public Integer getSchemaCount() {
        return this.schemaCount;
    }

    @Generated
    public SortedSet<Schema> getSchemas() {
        return this.schemas;
    }

    @Generated
    public void setSchemaCount(Integer schemaCount) {
        this.schemaCount = schemaCount;
    }

    @Generated
    public void setSchemas(SortedSet<Schema> schemas) {
        this.schemas = schemas;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Database)) {
            return false;
        }
        Database other = (Database)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$schemaCount = this.getSchemaCount();
        Integer other$schemaCount = other.getSchemaCount();
        if (this$schemaCount == null ? other$schemaCount != null : !((Object)this$schemaCount).equals(other$schemaCount)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<Schema> this$schemas = this.getSchemas();
        SortedSet<Schema> other$schemas = other.getSchemas();
        return !(this$schemas == null ? other$schemas != null : !this$schemas.equals(other$schemas));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Database;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $schemaCount = this.getSchemaCount();
        result = result * 59 + ($schemaCount == null ? 43 : ((Object)$schemaCount).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<Schema> $schemas = this.getSchemas();
        result = result * 59 + ($schemas == null ? 43 : $schemas.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class DatabaseBuilderImpl
    extends DatabaseBuilder<Database, DatabaseBuilderImpl> {
        @Generated
        private DatabaseBuilderImpl() {
        }

        @Override
        @Generated
        protected DatabaseBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Database build() {
            return new Database(this);
        }
    }

    @Generated
    public static abstract class DatabaseBuilder<C extends Database, B extends DatabaseBuilder<C, B>>
    extends SQL.SQLBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private Integer schemaCount;
        @Generated
        private ArrayList<Schema> schemas;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            DatabaseBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Database instance, DatabaseBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.schemaCount(instance.schemaCount);
            b.schemas(instance.schemas == null ? Collections.emptySortedSet() : instance.schemas);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B schemaCount(Integer schemaCount) {
            this.schemaCount = schemaCount;
            return (B)this.self();
        }

        @Generated
        public B schema(Schema schema) {
            if (this.schemas == null) {
                this.schemas = new ArrayList();
            }
            this.schemas.add(schema);
            return (B)this.self();
        }

        @Generated
        public B schemas(Collection<? extends Schema> schemas) {
            if (schemas == null) {
                throw new NullPointerException("schemas cannot be null");
            }
            if (this.schemas == null) {
                this.schemas = new ArrayList();
            }
            this.schemas.addAll(schemas);
            return (B)this.self();
        }

        @Generated
        public B clearSchemas() {
            if (this.schemas != null) {
                this.schemas.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "Database.DatabaseBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", schemaCount=" + this.schemaCount + ", schemas=" + this.schemas + ")";
        }
    }
}

