/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.AbstractColumnProcess;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.LineageProcess;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class DbtColumnProcess
extends AbstractColumnProcess {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "DbtColumnProcess";
    String typeName;
    @Attribute
    String dbtColumnProcessJobStatus;
    @Attribute
    SortedSet<LineageProcess> inputToProcesses;
    @Attribute
    SortedSet<LineageProcess> outputFromProcesses;

    public static DbtColumnProcess refByGuid(String guid) {
        return ((DbtColumnProcessBuilder)DbtColumnProcess.builder().guid(guid)).build();
    }

    public static DbtColumnProcess refByQualifiedName(String qualifiedName) {
        return ((DbtColumnProcessBuilder)DbtColumnProcess.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static DbtColumnProcessBuilder<?, ?> updater(String qualifiedName, String name) {
        return (DbtColumnProcessBuilder)((DbtColumnProcessBuilder)DbtColumnProcess.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected DbtColumnProcessBuilder<?, ?> trimToRequired() {
        return DbtColumnProcess.updater(this.getQualifiedName(), this.getName());
    }

    public static DbtColumnProcess retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof DbtColumnProcess) {
            return (DbtColumnProcess)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a DbtColumnProcess.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static DbtColumnProcess retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof DbtColumnProcess) {
            return (DbtColumnProcess)entity;
        }
        throw new NotFoundException("No DbtColumnProcess found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static DbtColumnProcess removeDescription(String qualifiedName, String name) throws AtlanException {
        return (DbtColumnProcess)Asset.removeDescription(((DbtColumnProcessBuilder)DbtColumnProcess.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static DbtColumnProcess removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (DbtColumnProcess)Asset.removeUserDescription(((DbtColumnProcessBuilder)DbtColumnProcess.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static DbtColumnProcess removeOwners(String qualifiedName, String name) throws AtlanException {
        return (DbtColumnProcess)Asset.removeOwners(((DbtColumnProcessBuilder)DbtColumnProcess.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static DbtColumnProcess updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (DbtColumnProcess)Asset.updateCertificate(DbtColumnProcess.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static DbtColumnProcess removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (DbtColumnProcess)Asset.removeCertificate(((DbtColumnProcessBuilder)DbtColumnProcess.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static DbtColumnProcess updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (DbtColumnProcess)Asset.updateAnnouncement(DbtColumnProcess.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static DbtColumnProcess removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (DbtColumnProcess)Asset.removeAnnouncement(((DbtColumnProcessBuilder)DbtColumnProcess.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static DbtColumnProcess replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (DbtColumnProcess)Asset.replaceTerms(DbtColumnProcess.updater(qualifiedName, name), terms);
    }

    public static DbtColumnProcess appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (DbtColumnProcess)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static DbtColumnProcess removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (DbtColumnProcess)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected DbtColumnProcess(DbtColumnProcessBuilder<?, ?> b) {
        super((AbstractColumnProcess.AbstractColumnProcessBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : DbtColumnProcess.$default$typeName();
        this.dbtColumnProcessJobStatus = b.dbtColumnProcessJobStatus;
        SortedSet<LineageProcess> inputToProcesses = new TreeSet<LineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<LineageProcess> outputFromProcesses = new TreeSet<LineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
    }

    @Generated
    public static DbtColumnProcessBuilder<?, ?> builder() {
        return new DbtColumnProcessBuilderImpl();
    }

    @Generated
    public DbtColumnProcessBuilder<?, ?> toBuilder() {
        return new DbtColumnProcessBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getDbtColumnProcessJobStatus() {
        return this.dbtColumnProcessJobStatus;
    }

    @Generated
    public SortedSet<LineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Generated
    public SortedSet<LineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Generated
    public void setDbtColumnProcessJobStatus(String dbtColumnProcessJobStatus) {
        this.dbtColumnProcessJobStatus = dbtColumnProcessJobStatus;
    }

    @Generated
    public void setInputToProcesses(SortedSet<LineageProcess> inputToProcesses) {
        this.inputToProcesses = inputToProcesses;
    }

    @Generated
    public void setOutputFromProcesses(SortedSet<LineageProcess> outputFromProcesses) {
        this.outputFromProcesses = outputFromProcesses;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DbtColumnProcess)) {
            return false;
        }
        DbtColumnProcess other = (DbtColumnProcess)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$dbtColumnProcessJobStatus = this.getDbtColumnProcessJobStatus();
        String other$dbtColumnProcessJobStatus = other.getDbtColumnProcessJobStatus();
        if (this$dbtColumnProcessJobStatus == null ? other$dbtColumnProcessJobStatus != null : !this$dbtColumnProcessJobStatus.equals(other$dbtColumnProcessJobStatus)) {
            return false;
        }
        SortedSet<LineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<LineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<LineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<LineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        return !(this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DbtColumnProcess;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $dbtColumnProcessJobStatus = this.getDbtColumnProcessJobStatus();
        result = result * 59 + ($dbtColumnProcessJobStatus == null ? 43 : $dbtColumnProcessJobStatus.hashCode());
        SortedSet<LineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<LineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class DbtColumnProcessBuilderImpl
    extends DbtColumnProcessBuilder<DbtColumnProcess, DbtColumnProcessBuilderImpl> {
        @Generated
        private DbtColumnProcessBuilderImpl() {
        }

        @Override
        @Generated
        protected DbtColumnProcessBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DbtColumnProcess build() {
            return new DbtColumnProcess(this);
        }
    }

    @Generated
    public static abstract class DbtColumnProcessBuilder<C extends DbtColumnProcess, B extends DbtColumnProcessBuilder<C, B>>
    extends AbstractColumnProcess.AbstractColumnProcessBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String dbtColumnProcessJobStatus;
        @Generated
        private ArrayList<LineageProcess> inputToProcesses;
        @Generated
        private ArrayList<LineageProcess> outputFromProcesses;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            DbtColumnProcessBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(DbtColumnProcess instance, DbtColumnProcessBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.dbtColumnProcessJobStatus(instance.dbtColumnProcessJobStatus);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B dbtColumnProcessJobStatus(String dbtColumnProcessJobStatus) {
            this.dbtColumnProcessJobStatus = dbtColumnProcessJobStatus;
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(LineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends LineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(LineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends LineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "DbtColumnProcess.DbtColumnProcessBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", dbtColumnProcessJobStatus=" + this.dbtColumnProcessJobStatus + ", inputToProcesses=" + this.inputToProcesses + ", outputFromProcesses=" + this.outputFromProcesses + ")";
        }
    }
}

