/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Column;
import com.atlan.model.assets.DbtMetricFilter;
import com.atlan.model.assets.DbtModel;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.Metric;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class DbtMetric
extends Metric {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "DbtMetric";
    String typeName;
    @Attribute
    List<DbtMetricFilter> dbtMetricFilters;
    @Attribute
    SortedSet<Column> dbtMetricFilterColumns;
    @Attribute
    DbtModel dbtModel;

    public static DbtMetric refByGuid(String guid) {
        return ((DbtMetricBuilder)DbtMetric.builder().guid(guid)).build();
    }

    public static DbtMetric refByQualifiedName(String qualifiedName) {
        return ((DbtMetricBuilder)DbtMetric.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static DbtMetricBuilder<?, ?> updater(String qualifiedName, String name) {
        return (DbtMetricBuilder)((DbtMetricBuilder)DbtMetric.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected DbtMetricBuilder<?, ?> trimToRequired() {
        return DbtMetric.updater(this.getQualifiedName(), this.getName());
    }

    public static DbtMetric retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof DbtMetric) {
            return (DbtMetric)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a DbtMetric.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static DbtMetric retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof DbtMetric) {
            return (DbtMetric)entity;
        }
        throw new NotFoundException("No DbtMetric found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static DbtMetric removeDescription(String qualifiedName, String name) throws AtlanException {
        return (DbtMetric)Asset.removeDescription(((DbtMetricBuilder)DbtMetric.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static DbtMetric removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (DbtMetric)Asset.removeUserDescription(((DbtMetricBuilder)DbtMetric.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static DbtMetric removeOwners(String qualifiedName, String name) throws AtlanException {
        return (DbtMetric)Asset.removeOwners(((DbtMetricBuilder)DbtMetric.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static DbtMetric updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (DbtMetric)Asset.updateCertificate(DbtMetric.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static DbtMetric removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (DbtMetric)Asset.removeCertificate(((DbtMetricBuilder)DbtMetric.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static DbtMetric updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (DbtMetric)Asset.updateAnnouncement(DbtMetric.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static DbtMetric removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (DbtMetric)Asset.removeAnnouncement(((DbtMetricBuilder)DbtMetric.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static DbtMetric replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (DbtMetric)Asset.replaceTerms(DbtMetric.updater(qualifiedName, name), terms);
    }

    public static DbtMetric appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (DbtMetric)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static DbtMetric removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (DbtMetric)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected DbtMetric(DbtMetricBuilder<?, ?> b) {
        super((Metric.MetricBuilder<?, ?>)b);
        List<Object> dbtMetricFilters;
        this.typeName = b.typeName$set ? b.typeName$value : DbtMetric.$default$typeName();
        switch (b.dbtMetricFilters == null ? 0 : b.dbtMetricFilters.size()) {
            case 0: {
                dbtMetricFilters = Collections.emptyList();
                break;
            }
            case 1: {
                dbtMetricFilters = Collections.singletonList(b.dbtMetricFilters.get(0));
                break;
            }
            default: {
                dbtMetricFilters = Collections.unmodifiableList(new ArrayList<DbtMetricFilter>(b.dbtMetricFilters));
            }
        }
        this.dbtMetricFilters = dbtMetricFilters;
        SortedSet<Column> dbtMetricFilterColumns = new TreeSet<Column>();
        if (b.dbtMetricFilterColumns != null) {
            dbtMetricFilterColumns.addAll(b.dbtMetricFilterColumns);
        }
        dbtMetricFilterColumns = Collections.unmodifiableSortedSet(dbtMetricFilterColumns);
        this.dbtMetricFilterColumns = dbtMetricFilterColumns;
        this.dbtModel = b.dbtModel;
    }

    @Generated
    public static DbtMetricBuilder<?, ?> builder() {
        return new DbtMetricBuilderImpl();
    }

    @Generated
    public DbtMetricBuilder<?, ?> toBuilder() {
        return new DbtMetricBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public List<DbtMetricFilter> getDbtMetricFilters() {
        return this.dbtMetricFilters;
    }

    @Generated
    public SortedSet<Column> getDbtMetricFilterColumns() {
        return this.dbtMetricFilterColumns;
    }

    @Generated
    public DbtModel getDbtModel() {
        return this.dbtModel;
    }

    @Generated
    public void setDbtMetricFilters(List<DbtMetricFilter> dbtMetricFilters) {
        this.dbtMetricFilters = dbtMetricFilters;
    }

    @Generated
    public void setDbtMetricFilterColumns(SortedSet<Column> dbtMetricFilterColumns) {
        this.dbtMetricFilterColumns = dbtMetricFilterColumns;
    }

    @Generated
    public void setDbtModel(DbtModel dbtModel) {
        this.dbtModel = dbtModel;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DbtMetric)) {
            return false;
        }
        DbtMetric other = (DbtMetric)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        List<DbtMetricFilter> this$dbtMetricFilters = this.getDbtMetricFilters();
        List<DbtMetricFilter> other$dbtMetricFilters = other.getDbtMetricFilters();
        if (this$dbtMetricFilters == null ? other$dbtMetricFilters != null : !((Object)this$dbtMetricFilters).equals(other$dbtMetricFilters)) {
            return false;
        }
        SortedSet<Column> this$dbtMetricFilterColumns = this.getDbtMetricFilterColumns();
        SortedSet<Column> other$dbtMetricFilterColumns = other.getDbtMetricFilterColumns();
        if (this$dbtMetricFilterColumns == null ? other$dbtMetricFilterColumns != null : !this$dbtMetricFilterColumns.equals(other$dbtMetricFilterColumns)) {
            return false;
        }
        DbtModel this$dbtModel = this.getDbtModel();
        DbtModel other$dbtModel = other.getDbtModel();
        return !(this$dbtModel == null ? other$dbtModel != null : !((Object)this$dbtModel).equals(other$dbtModel));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DbtMetric;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        List<DbtMetricFilter> $dbtMetricFilters = this.getDbtMetricFilters();
        result = result * 59 + ($dbtMetricFilters == null ? 43 : ((Object)$dbtMetricFilters).hashCode());
        SortedSet<Column> $dbtMetricFilterColumns = this.getDbtMetricFilterColumns();
        result = result * 59 + ($dbtMetricFilterColumns == null ? 43 : $dbtMetricFilterColumns.hashCode());
        DbtModel $dbtModel = this.getDbtModel();
        result = result * 59 + ($dbtModel == null ? 43 : ((Object)$dbtModel).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class DbtMetricBuilderImpl
    extends DbtMetricBuilder<DbtMetric, DbtMetricBuilderImpl> {
        @Generated
        private DbtMetricBuilderImpl() {
        }

        @Override
        @Generated
        protected DbtMetricBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DbtMetric build() {
            return new DbtMetric(this);
        }
    }

    @Generated
    public static abstract class DbtMetricBuilder<C extends DbtMetric, B extends DbtMetricBuilder<C, B>>
    extends Metric.MetricBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<DbtMetricFilter> dbtMetricFilters;
        @Generated
        private ArrayList<Column> dbtMetricFilterColumns;
        @Generated
        private DbtModel dbtModel;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            DbtMetricBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(DbtMetric instance, DbtMetricBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.dbtMetricFilters(instance.dbtMetricFilters == null ? Collections.emptyList() : instance.dbtMetricFilters);
            b.dbtMetricFilterColumns(instance.dbtMetricFilterColumns == null ? Collections.emptySortedSet() : instance.dbtMetricFilterColumns);
            b.dbtModel(instance.dbtModel);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B dbtMetricFilter(DbtMetricFilter dbtMetricFilter) {
            if (this.dbtMetricFilters == null) {
                this.dbtMetricFilters = new ArrayList();
            }
            this.dbtMetricFilters.add(dbtMetricFilter);
            return (B)this.self();
        }

        @Generated
        public B dbtMetricFilters(Collection<? extends DbtMetricFilter> dbtMetricFilters) {
            if (dbtMetricFilters == null) {
                throw new NullPointerException("dbtMetricFilters cannot be null");
            }
            if (this.dbtMetricFilters == null) {
                this.dbtMetricFilters = new ArrayList();
            }
            this.dbtMetricFilters.addAll(dbtMetricFilters);
            return (B)this.self();
        }

        @Generated
        public B clearDbtMetricFilters() {
            if (this.dbtMetricFilters != null) {
                this.dbtMetricFilters.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dbtMetricFilterColumn(Column dbtMetricFilterColumn) {
            if (this.dbtMetricFilterColumns == null) {
                this.dbtMetricFilterColumns = new ArrayList();
            }
            this.dbtMetricFilterColumns.add(dbtMetricFilterColumn);
            return (B)this.self();
        }

        @Generated
        public B dbtMetricFilterColumns(Collection<? extends Column> dbtMetricFilterColumns) {
            if (dbtMetricFilterColumns == null) {
                throw new NullPointerException("dbtMetricFilterColumns cannot be null");
            }
            if (this.dbtMetricFilterColumns == null) {
                this.dbtMetricFilterColumns = new ArrayList();
            }
            this.dbtMetricFilterColumns.addAll(dbtMetricFilterColumns);
            return (B)this.self();
        }

        @Generated
        public B clearDbtMetricFilterColumns() {
            if (this.dbtMetricFilterColumns != null) {
                this.dbtMetricFilterColumns.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dbtModel(DbtModel dbtModel) {
            this.dbtModel = dbtModel;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "DbtMetric.DbtMetricBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", dbtMetricFilters=" + this.dbtMetricFilters + ", dbtMetricFilterColumns=" + this.dbtMetricFilterColumns + ", dbtModel=" + this.dbtModel + ")";
        }
    }
}

