/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Dbt;
import com.atlan.model.assets.DbtMetric;
import com.atlan.model.assets.DbtModelColumn;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.SQL;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class DbtModel
extends Dbt {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "DbtModel";
    String typeName;
    @Attribute
    String dbtStatus;
    @Attribute
    String dbtError;
    @Attribute
    String dbtRawSQL;
    @Attribute
    String dbtCompiledSQL;
    @Attribute
    String dbtStats;
    @Attribute
    String dbtMaterializationType;
    @Attribute
    Long dbtModelCompileStartedAt;
    @Attribute
    Long dbtModelCompileCompletedAt;
    @Attribute
    Long dbtModelExecuteStartedAt;
    @Attribute
    Long dbtModelExecuteCompletedAt;
    @Attribute
    Double dbtModelExecutionTime;
    @Attribute
    Long dbtModelRunGeneratedAt;
    @Attribute
    Double dbtModelRunElapsedTime;
    @Attribute
    SortedSet<DbtMetric> dbtMetrics;
    @Attribute
    SortedSet<DbtModelColumn> dbtModelColumns;
    @Attribute
    SQL sqlAsset;

    public static DbtModel refByGuid(String guid) {
        return ((DbtModelBuilder)DbtModel.builder().guid(guid)).build();
    }

    public static DbtModel refByQualifiedName(String qualifiedName) {
        return ((DbtModelBuilder)DbtModel.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static DbtModelBuilder<?, ?> updater(String qualifiedName, String name) {
        return (DbtModelBuilder)((DbtModelBuilder)DbtModel.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected DbtModelBuilder<?, ?> trimToRequired() {
        return DbtModel.updater(this.getQualifiedName(), this.getName());
    }

    public static DbtModel retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof DbtModel) {
            return (DbtModel)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a DbtModel.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static DbtModel retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof DbtModel) {
            return (DbtModel)entity;
        }
        throw new NotFoundException("No DbtModel found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static DbtModel removeDescription(String qualifiedName, String name) throws AtlanException {
        return (DbtModel)Asset.removeDescription(((DbtModelBuilder)DbtModel.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static DbtModel removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (DbtModel)Asset.removeUserDescription(((DbtModelBuilder)DbtModel.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static DbtModel removeOwners(String qualifiedName, String name) throws AtlanException {
        return (DbtModel)Asset.removeOwners(((DbtModelBuilder)DbtModel.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static DbtModel updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (DbtModel)Asset.updateCertificate(DbtModel.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static DbtModel removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (DbtModel)Asset.removeCertificate(((DbtModelBuilder)DbtModel.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static DbtModel updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (DbtModel)Asset.updateAnnouncement(DbtModel.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static DbtModel removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (DbtModel)Asset.removeAnnouncement(((DbtModelBuilder)DbtModel.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static DbtModel replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (DbtModel)Asset.replaceTerms(DbtModel.updater(qualifiedName, name), terms);
    }

    public static DbtModel appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (DbtModel)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static DbtModel removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (DbtModel)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected DbtModel(DbtModelBuilder<?, ?> b) {
        super((Dbt.DbtBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : DbtModel.$default$typeName();
        this.dbtStatus = b.dbtStatus;
        this.dbtError = b.dbtError;
        this.dbtRawSQL = b.dbtRawSQL;
        this.dbtCompiledSQL = b.dbtCompiledSQL;
        this.dbtStats = b.dbtStats;
        this.dbtMaterializationType = b.dbtMaterializationType;
        this.dbtModelCompileStartedAt = b.dbtModelCompileStartedAt;
        this.dbtModelCompileCompletedAt = b.dbtModelCompileCompletedAt;
        this.dbtModelExecuteStartedAt = b.dbtModelExecuteStartedAt;
        this.dbtModelExecuteCompletedAt = b.dbtModelExecuteCompletedAt;
        this.dbtModelExecutionTime = b.dbtModelExecutionTime;
        this.dbtModelRunGeneratedAt = b.dbtModelRunGeneratedAt;
        this.dbtModelRunElapsedTime = b.dbtModelRunElapsedTime;
        SortedSet<DbtMetric> dbtMetrics = new TreeSet<DbtMetric>();
        if (b.dbtMetrics != null) {
            dbtMetrics.addAll(b.dbtMetrics);
        }
        dbtMetrics = Collections.unmodifiableSortedSet(dbtMetrics);
        this.dbtMetrics = dbtMetrics;
        SortedSet<DbtModelColumn> dbtModelColumns = new TreeSet<DbtModelColumn>();
        if (b.dbtModelColumns != null) {
            dbtModelColumns.addAll(b.dbtModelColumns);
        }
        dbtModelColumns = Collections.unmodifiableSortedSet(dbtModelColumns);
        this.dbtModelColumns = dbtModelColumns;
        this.sqlAsset = b.sqlAsset;
    }

    @Generated
    public static DbtModelBuilder<?, ?> builder() {
        return new DbtModelBuilderImpl();
    }

    @Generated
    public DbtModelBuilder<?, ?> toBuilder() {
        return new DbtModelBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getDbtStatus() {
        return this.dbtStatus;
    }

    @Generated
    public String getDbtError() {
        return this.dbtError;
    }

    @Generated
    public String getDbtRawSQL() {
        return this.dbtRawSQL;
    }

    @Generated
    public String getDbtCompiledSQL() {
        return this.dbtCompiledSQL;
    }

    @Generated
    public String getDbtStats() {
        return this.dbtStats;
    }

    @Generated
    public String getDbtMaterializationType() {
        return this.dbtMaterializationType;
    }

    @Generated
    public Long getDbtModelCompileStartedAt() {
        return this.dbtModelCompileStartedAt;
    }

    @Generated
    public Long getDbtModelCompileCompletedAt() {
        return this.dbtModelCompileCompletedAt;
    }

    @Generated
    public Long getDbtModelExecuteStartedAt() {
        return this.dbtModelExecuteStartedAt;
    }

    @Generated
    public Long getDbtModelExecuteCompletedAt() {
        return this.dbtModelExecuteCompletedAt;
    }

    @Generated
    public Double getDbtModelExecutionTime() {
        return this.dbtModelExecutionTime;
    }

    @Generated
    public Long getDbtModelRunGeneratedAt() {
        return this.dbtModelRunGeneratedAt;
    }

    @Generated
    public Double getDbtModelRunElapsedTime() {
        return this.dbtModelRunElapsedTime;
    }

    @Generated
    public SortedSet<DbtMetric> getDbtMetrics() {
        return this.dbtMetrics;
    }

    @Generated
    public SortedSet<DbtModelColumn> getDbtModelColumns() {
        return this.dbtModelColumns;
    }

    @Generated
    public SQL getSqlAsset() {
        return this.sqlAsset;
    }

    @Generated
    public void setDbtStatus(String dbtStatus) {
        this.dbtStatus = dbtStatus;
    }

    @Generated
    public void setDbtError(String dbtError) {
        this.dbtError = dbtError;
    }

    @Generated
    public void setDbtRawSQL(String dbtRawSQL) {
        this.dbtRawSQL = dbtRawSQL;
    }

    @Generated
    public void setDbtCompiledSQL(String dbtCompiledSQL) {
        this.dbtCompiledSQL = dbtCompiledSQL;
    }

    @Generated
    public void setDbtStats(String dbtStats) {
        this.dbtStats = dbtStats;
    }

    @Generated
    public void setDbtMaterializationType(String dbtMaterializationType) {
        this.dbtMaterializationType = dbtMaterializationType;
    }

    @Generated
    public void setDbtModelCompileStartedAt(Long dbtModelCompileStartedAt) {
        this.dbtModelCompileStartedAt = dbtModelCompileStartedAt;
    }

    @Generated
    public void setDbtModelCompileCompletedAt(Long dbtModelCompileCompletedAt) {
        this.dbtModelCompileCompletedAt = dbtModelCompileCompletedAt;
    }

    @Generated
    public void setDbtModelExecuteStartedAt(Long dbtModelExecuteStartedAt) {
        this.dbtModelExecuteStartedAt = dbtModelExecuteStartedAt;
    }

    @Generated
    public void setDbtModelExecuteCompletedAt(Long dbtModelExecuteCompletedAt) {
        this.dbtModelExecuteCompletedAt = dbtModelExecuteCompletedAt;
    }

    @Generated
    public void setDbtModelExecutionTime(Double dbtModelExecutionTime) {
        this.dbtModelExecutionTime = dbtModelExecutionTime;
    }

    @Generated
    public void setDbtModelRunGeneratedAt(Long dbtModelRunGeneratedAt) {
        this.dbtModelRunGeneratedAt = dbtModelRunGeneratedAt;
    }

    @Generated
    public void setDbtModelRunElapsedTime(Double dbtModelRunElapsedTime) {
        this.dbtModelRunElapsedTime = dbtModelRunElapsedTime;
    }

    @Generated
    public void setDbtMetrics(SortedSet<DbtMetric> dbtMetrics) {
        this.dbtMetrics = dbtMetrics;
    }

    @Generated
    public void setDbtModelColumns(SortedSet<DbtModelColumn> dbtModelColumns) {
        this.dbtModelColumns = dbtModelColumns;
    }

    @Generated
    public void setSqlAsset(SQL sqlAsset) {
        this.sqlAsset = sqlAsset;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DbtModel)) {
            return false;
        }
        DbtModel other = (DbtModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$dbtModelCompileStartedAt = this.getDbtModelCompileStartedAt();
        Long other$dbtModelCompileStartedAt = other.getDbtModelCompileStartedAt();
        if (this$dbtModelCompileStartedAt == null ? other$dbtModelCompileStartedAt != null : !((Object)this$dbtModelCompileStartedAt).equals(other$dbtModelCompileStartedAt)) {
            return false;
        }
        Long this$dbtModelCompileCompletedAt = this.getDbtModelCompileCompletedAt();
        Long other$dbtModelCompileCompletedAt = other.getDbtModelCompileCompletedAt();
        if (this$dbtModelCompileCompletedAt == null ? other$dbtModelCompileCompletedAt != null : !((Object)this$dbtModelCompileCompletedAt).equals(other$dbtModelCompileCompletedAt)) {
            return false;
        }
        Long this$dbtModelExecuteStartedAt = this.getDbtModelExecuteStartedAt();
        Long other$dbtModelExecuteStartedAt = other.getDbtModelExecuteStartedAt();
        if (this$dbtModelExecuteStartedAt == null ? other$dbtModelExecuteStartedAt != null : !((Object)this$dbtModelExecuteStartedAt).equals(other$dbtModelExecuteStartedAt)) {
            return false;
        }
        Long this$dbtModelExecuteCompletedAt = this.getDbtModelExecuteCompletedAt();
        Long other$dbtModelExecuteCompletedAt = other.getDbtModelExecuteCompletedAt();
        if (this$dbtModelExecuteCompletedAt == null ? other$dbtModelExecuteCompletedAt != null : !((Object)this$dbtModelExecuteCompletedAt).equals(other$dbtModelExecuteCompletedAt)) {
            return false;
        }
        Double this$dbtModelExecutionTime = this.getDbtModelExecutionTime();
        Double other$dbtModelExecutionTime = other.getDbtModelExecutionTime();
        if (this$dbtModelExecutionTime == null ? other$dbtModelExecutionTime != null : !((Object)this$dbtModelExecutionTime).equals(other$dbtModelExecutionTime)) {
            return false;
        }
        Long this$dbtModelRunGeneratedAt = this.getDbtModelRunGeneratedAt();
        Long other$dbtModelRunGeneratedAt = other.getDbtModelRunGeneratedAt();
        if (this$dbtModelRunGeneratedAt == null ? other$dbtModelRunGeneratedAt != null : !((Object)this$dbtModelRunGeneratedAt).equals(other$dbtModelRunGeneratedAt)) {
            return false;
        }
        Double this$dbtModelRunElapsedTime = this.getDbtModelRunElapsedTime();
        Double other$dbtModelRunElapsedTime = other.getDbtModelRunElapsedTime();
        if (this$dbtModelRunElapsedTime == null ? other$dbtModelRunElapsedTime != null : !((Object)this$dbtModelRunElapsedTime).equals(other$dbtModelRunElapsedTime)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$dbtStatus = this.getDbtStatus();
        String other$dbtStatus = other.getDbtStatus();
        if (this$dbtStatus == null ? other$dbtStatus != null : !this$dbtStatus.equals(other$dbtStatus)) {
            return false;
        }
        String this$dbtError = this.getDbtError();
        String other$dbtError = other.getDbtError();
        if (this$dbtError == null ? other$dbtError != null : !this$dbtError.equals(other$dbtError)) {
            return false;
        }
        String this$dbtRawSQL = this.getDbtRawSQL();
        String other$dbtRawSQL = other.getDbtRawSQL();
        if (this$dbtRawSQL == null ? other$dbtRawSQL != null : !this$dbtRawSQL.equals(other$dbtRawSQL)) {
            return false;
        }
        String this$dbtCompiledSQL = this.getDbtCompiledSQL();
        String other$dbtCompiledSQL = other.getDbtCompiledSQL();
        if (this$dbtCompiledSQL == null ? other$dbtCompiledSQL != null : !this$dbtCompiledSQL.equals(other$dbtCompiledSQL)) {
            return false;
        }
        String this$dbtStats = this.getDbtStats();
        String other$dbtStats = other.getDbtStats();
        if (this$dbtStats == null ? other$dbtStats != null : !this$dbtStats.equals(other$dbtStats)) {
            return false;
        }
        String this$dbtMaterializationType = this.getDbtMaterializationType();
        String other$dbtMaterializationType = other.getDbtMaterializationType();
        if (this$dbtMaterializationType == null ? other$dbtMaterializationType != null : !this$dbtMaterializationType.equals(other$dbtMaterializationType)) {
            return false;
        }
        SortedSet<DbtMetric> this$dbtMetrics = this.getDbtMetrics();
        SortedSet<DbtMetric> other$dbtMetrics = other.getDbtMetrics();
        if (this$dbtMetrics == null ? other$dbtMetrics != null : !this$dbtMetrics.equals(other$dbtMetrics)) {
            return false;
        }
        SortedSet<DbtModelColumn> this$dbtModelColumns = this.getDbtModelColumns();
        SortedSet<DbtModelColumn> other$dbtModelColumns = other.getDbtModelColumns();
        if (this$dbtModelColumns == null ? other$dbtModelColumns != null : !this$dbtModelColumns.equals(other$dbtModelColumns)) {
            return false;
        }
        SQL this$sqlAsset = this.getSqlAsset();
        SQL other$sqlAsset = other.getSqlAsset();
        return !(this$sqlAsset == null ? other$sqlAsset != null : !((Object)this$sqlAsset).equals(other$sqlAsset));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DbtModel;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $dbtModelCompileStartedAt = this.getDbtModelCompileStartedAt();
        result = result * 59 + ($dbtModelCompileStartedAt == null ? 43 : ((Object)$dbtModelCompileStartedAt).hashCode());
        Long $dbtModelCompileCompletedAt = this.getDbtModelCompileCompletedAt();
        result = result * 59 + ($dbtModelCompileCompletedAt == null ? 43 : ((Object)$dbtModelCompileCompletedAt).hashCode());
        Long $dbtModelExecuteStartedAt = this.getDbtModelExecuteStartedAt();
        result = result * 59 + ($dbtModelExecuteStartedAt == null ? 43 : ((Object)$dbtModelExecuteStartedAt).hashCode());
        Long $dbtModelExecuteCompletedAt = this.getDbtModelExecuteCompletedAt();
        result = result * 59 + ($dbtModelExecuteCompletedAt == null ? 43 : ((Object)$dbtModelExecuteCompletedAt).hashCode());
        Double $dbtModelExecutionTime = this.getDbtModelExecutionTime();
        result = result * 59 + ($dbtModelExecutionTime == null ? 43 : ((Object)$dbtModelExecutionTime).hashCode());
        Long $dbtModelRunGeneratedAt = this.getDbtModelRunGeneratedAt();
        result = result * 59 + ($dbtModelRunGeneratedAt == null ? 43 : ((Object)$dbtModelRunGeneratedAt).hashCode());
        Double $dbtModelRunElapsedTime = this.getDbtModelRunElapsedTime();
        result = result * 59 + ($dbtModelRunElapsedTime == null ? 43 : ((Object)$dbtModelRunElapsedTime).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $dbtStatus = this.getDbtStatus();
        result = result * 59 + ($dbtStatus == null ? 43 : $dbtStatus.hashCode());
        String $dbtError = this.getDbtError();
        result = result * 59 + ($dbtError == null ? 43 : $dbtError.hashCode());
        String $dbtRawSQL = this.getDbtRawSQL();
        result = result * 59 + ($dbtRawSQL == null ? 43 : $dbtRawSQL.hashCode());
        String $dbtCompiledSQL = this.getDbtCompiledSQL();
        result = result * 59 + ($dbtCompiledSQL == null ? 43 : $dbtCompiledSQL.hashCode());
        String $dbtStats = this.getDbtStats();
        result = result * 59 + ($dbtStats == null ? 43 : $dbtStats.hashCode());
        String $dbtMaterializationType = this.getDbtMaterializationType();
        result = result * 59 + ($dbtMaterializationType == null ? 43 : $dbtMaterializationType.hashCode());
        SortedSet<DbtMetric> $dbtMetrics = this.getDbtMetrics();
        result = result * 59 + ($dbtMetrics == null ? 43 : $dbtMetrics.hashCode());
        SortedSet<DbtModelColumn> $dbtModelColumns = this.getDbtModelColumns();
        result = result * 59 + ($dbtModelColumns == null ? 43 : $dbtModelColumns.hashCode());
        SQL $sqlAsset = this.getSqlAsset();
        result = result * 59 + ($sqlAsset == null ? 43 : ((Object)$sqlAsset).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class DbtModelBuilderImpl
    extends DbtModelBuilder<DbtModel, DbtModelBuilderImpl> {
        @Generated
        private DbtModelBuilderImpl() {
        }

        @Override
        @Generated
        protected DbtModelBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DbtModel build() {
            return new DbtModel(this);
        }
    }

    @Generated
    public static abstract class DbtModelBuilder<C extends DbtModel, B extends DbtModelBuilder<C, B>>
    extends Dbt.DbtBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String dbtStatus;
        @Generated
        private String dbtError;
        @Generated
        private String dbtRawSQL;
        @Generated
        private String dbtCompiledSQL;
        @Generated
        private String dbtStats;
        @Generated
        private String dbtMaterializationType;
        @Generated
        private Long dbtModelCompileStartedAt;
        @Generated
        private Long dbtModelCompileCompletedAt;
        @Generated
        private Long dbtModelExecuteStartedAt;
        @Generated
        private Long dbtModelExecuteCompletedAt;
        @Generated
        private Double dbtModelExecutionTime;
        @Generated
        private Long dbtModelRunGeneratedAt;
        @Generated
        private Double dbtModelRunElapsedTime;
        @Generated
        private ArrayList<DbtMetric> dbtMetrics;
        @Generated
        private ArrayList<DbtModelColumn> dbtModelColumns;
        @Generated
        private SQL sqlAsset;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            DbtModelBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(DbtModel instance, DbtModelBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.dbtStatus(instance.dbtStatus);
            b.dbtError(instance.dbtError);
            b.dbtRawSQL(instance.dbtRawSQL);
            b.dbtCompiledSQL(instance.dbtCompiledSQL);
            b.dbtStats(instance.dbtStats);
            b.dbtMaterializationType(instance.dbtMaterializationType);
            b.dbtModelCompileStartedAt(instance.dbtModelCompileStartedAt);
            b.dbtModelCompileCompletedAt(instance.dbtModelCompileCompletedAt);
            b.dbtModelExecuteStartedAt(instance.dbtModelExecuteStartedAt);
            b.dbtModelExecuteCompletedAt(instance.dbtModelExecuteCompletedAt);
            b.dbtModelExecutionTime(instance.dbtModelExecutionTime);
            b.dbtModelRunGeneratedAt(instance.dbtModelRunGeneratedAt);
            b.dbtModelRunElapsedTime(instance.dbtModelRunElapsedTime);
            b.dbtMetrics(instance.dbtMetrics == null ? Collections.emptySortedSet() : instance.dbtMetrics);
            b.dbtModelColumns(instance.dbtModelColumns == null ? Collections.emptySortedSet() : instance.dbtModelColumns);
            b.sqlAsset(instance.sqlAsset);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B dbtStatus(String dbtStatus) {
            this.dbtStatus = dbtStatus;
            return (B)this.self();
        }

        @Generated
        public B dbtError(String dbtError) {
            this.dbtError = dbtError;
            return (B)this.self();
        }

        @Generated
        public B dbtRawSQL(String dbtRawSQL) {
            this.dbtRawSQL = dbtRawSQL;
            return (B)this.self();
        }

        @Generated
        public B dbtCompiledSQL(String dbtCompiledSQL) {
            this.dbtCompiledSQL = dbtCompiledSQL;
            return (B)this.self();
        }

        @Generated
        public B dbtStats(String dbtStats) {
            this.dbtStats = dbtStats;
            return (B)this.self();
        }

        @Generated
        public B dbtMaterializationType(String dbtMaterializationType) {
            this.dbtMaterializationType = dbtMaterializationType;
            return (B)this.self();
        }

        @Generated
        public B dbtModelCompileStartedAt(Long dbtModelCompileStartedAt) {
            this.dbtModelCompileStartedAt = dbtModelCompileStartedAt;
            return (B)this.self();
        }

        @Generated
        public B dbtModelCompileCompletedAt(Long dbtModelCompileCompletedAt) {
            this.dbtModelCompileCompletedAt = dbtModelCompileCompletedAt;
            return (B)this.self();
        }

        @Generated
        public B dbtModelExecuteStartedAt(Long dbtModelExecuteStartedAt) {
            this.dbtModelExecuteStartedAt = dbtModelExecuteStartedAt;
            return (B)this.self();
        }

        @Generated
        public B dbtModelExecuteCompletedAt(Long dbtModelExecuteCompletedAt) {
            this.dbtModelExecuteCompletedAt = dbtModelExecuteCompletedAt;
            return (B)this.self();
        }

        @Generated
        public B dbtModelExecutionTime(Double dbtModelExecutionTime) {
            this.dbtModelExecutionTime = dbtModelExecutionTime;
            return (B)this.self();
        }

        @Generated
        public B dbtModelRunGeneratedAt(Long dbtModelRunGeneratedAt) {
            this.dbtModelRunGeneratedAt = dbtModelRunGeneratedAt;
            return (B)this.self();
        }

        @Generated
        public B dbtModelRunElapsedTime(Double dbtModelRunElapsedTime) {
            this.dbtModelRunElapsedTime = dbtModelRunElapsedTime;
            return (B)this.self();
        }

        @Generated
        public B dbtMetric(DbtMetric dbtMetric) {
            if (this.dbtMetrics == null) {
                this.dbtMetrics = new ArrayList();
            }
            this.dbtMetrics.add(dbtMetric);
            return (B)this.self();
        }

        @Generated
        public B dbtMetrics(Collection<? extends DbtMetric> dbtMetrics) {
            if (dbtMetrics == null) {
                throw new NullPointerException("dbtMetrics cannot be null");
            }
            if (this.dbtMetrics == null) {
                this.dbtMetrics = new ArrayList();
            }
            this.dbtMetrics.addAll(dbtMetrics);
            return (B)this.self();
        }

        @Generated
        public B clearDbtMetrics() {
            if (this.dbtMetrics != null) {
                this.dbtMetrics.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dbtModelColumn(DbtModelColumn dbtModelColumn) {
            if (this.dbtModelColumns == null) {
                this.dbtModelColumns = new ArrayList();
            }
            this.dbtModelColumns.add(dbtModelColumn);
            return (B)this.self();
        }

        @Generated
        public B dbtModelColumns(Collection<? extends DbtModelColumn> dbtModelColumns) {
            if (dbtModelColumns == null) {
                throw new NullPointerException("dbtModelColumns cannot be null");
            }
            if (this.dbtModelColumns == null) {
                this.dbtModelColumns = new ArrayList();
            }
            this.dbtModelColumns.addAll(dbtModelColumns);
            return (B)this.self();
        }

        @Generated
        public B clearDbtModelColumns() {
            if (this.dbtModelColumns != null) {
                this.dbtModelColumns.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B sqlAsset(SQL sqlAsset) {
            this.sqlAsset = sqlAsset;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "DbtModel.DbtModelBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", dbtStatus=" + this.dbtStatus + ", dbtError=" + this.dbtError + ", dbtRawSQL=" + this.dbtRawSQL + ", dbtCompiledSQL=" + this.dbtCompiledSQL + ", dbtStats=" + this.dbtStats + ", dbtMaterializationType=" + this.dbtMaterializationType + ", dbtModelCompileStartedAt=" + this.dbtModelCompileStartedAt + ", dbtModelCompileCompletedAt=" + this.dbtModelCompileCompletedAt + ", dbtModelExecuteStartedAt=" + this.dbtModelExecuteStartedAt + ", dbtModelExecuteCompletedAt=" + this.dbtModelExecuteCompletedAt + ", dbtModelExecutionTime=" + this.dbtModelExecutionTime + ", dbtModelRunGeneratedAt=" + this.dbtModelRunGeneratedAt + ", dbtModelRunElapsedTime=" + this.dbtModelRunElapsedTime + ", dbtMetrics=" + this.dbtMetrics + ", dbtModelColumns=" + this.dbtModelColumns + ", sqlAsset=" + this.sqlAsset + ")";
        }
    }
}

