/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Column;
import com.atlan.model.assets.Dbt;
import com.atlan.model.assets.DbtModel;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.List;
import lombok.Generated;

public class DbtModelColumn
extends Dbt {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "DbtModelColumn";
    String typeName;
    @Attribute
    String dbtModelQualifiedName;
    @Attribute
    String dbtModelColumnDataType;
    @Attribute
    Integer dbtModelColumnOrder;
    @Attribute
    Column sqlColumn;
    @Attribute
    DbtModel dbtModel;

    public static DbtModelColumn refByGuid(String guid) {
        return ((DbtModelColumnBuilder)DbtModelColumn.builder().guid(guid)).build();
    }

    public static DbtModelColumn refByQualifiedName(String qualifiedName) {
        return ((DbtModelColumnBuilder)DbtModelColumn.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static DbtModelColumnBuilder<?, ?> updater(String qualifiedName, String name) {
        return (DbtModelColumnBuilder)((DbtModelColumnBuilder)DbtModelColumn.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected DbtModelColumnBuilder<?, ?> trimToRequired() {
        return DbtModelColumn.updater(this.getQualifiedName(), this.getName());
    }

    public static DbtModelColumn retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof DbtModelColumn) {
            return (DbtModelColumn)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a DbtModelColumn.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static DbtModelColumn retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof DbtModelColumn) {
            return (DbtModelColumn)entity;
        }
        throw new NotFoundException("No DbtModelColumn found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static DbtModelColumn removeDescription(String qualifiedName, String name) throws AtlanException {
        return (DbtModelColumn)Asset.removeDescription(((DbtModelColumnBuilder)DbtModelColumn.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static DbtModelColumn removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (DbtModelColumn)Asset.removeUserDescription(((DbtModelColumnBuilder)DbtModelColumn.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static DbtModelColumn removeOwners(String qualifiedName, String name) throws AtlanException {
        return (DbtModelColumn)Asset.removeOwners(((DbtModelColumnBuilder)DbtModelColumn.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static DbtModelColumn updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (DbtModelColumn)Asset.updateCertificate(DbtModelColumn.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static DbtModelColumn removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (DbtModelColumn)Asset.removeCertificate(((DbtModelColumnBuilder)DbtModelColumn.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static DbtModelColumn updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (DbtModelColumn)Asset.updateAnnouncement(DbtModelColumn.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static DbtModelColumn removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (DbtModelColumn)Asset.removeAnnouncement(((DbtModelColumnBuilder)DbtModelColumn.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static DbtModelColumn replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (DbtModelColumn)Asset.replaceTerms(DbtModelColumn.updater(qualifiedName, name), terms);
    }

    public static DbtModelColumn appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (DbtModelColumn)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static DbtModelColumn removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (DbtModelColumn)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected DbtModelColumn(DbtModelColumnBuilder<?, ?> b) {
        super((Dbt.DbtBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : DbtModelColumn.$default$typeName();
        this.dbtModelQualifiedName = b.dbtModelQualifiedName;
        this.dbtModelColumnDataType = b.dbtModelColumnDataType;
        this.dbtModelColumnOrder = b.dbtModelColumnOrder;
        this.sqlColumn = b.sqlColumn;
        this.dbtModel = b.dbtModel;
    }

    @Generated
    public static DbtModelColumnBuilder<?, ?> builder() {
        return new DbtModelColumnBuilderImpl();
    }

    @Generated
    public DbtModelColumnBuilder<?, ?> toBuilder() {
        return new DbtModelColumnBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getDbtModelQualifiedName() {
        return this.dbtModelQualifiedName;
    }

    @Generated
    public String getDbtModelColumnDataType() {
        return this.dbtModelColumnDataType;
    }

    @Generated
    public Integer getDbtModelColumnOrder() {
        return this.dbtModelColumnOrder;
    }

    @Generated
    public Column getSqlColumn() {
        return this.sqlColumn;
    }

    @Generated
    public DbtModel getDbtModel() {
        return this.dbtModel;
    }

    @Generated
    public void setDbtModelQualifiedName(String dbtModelQualifiedName) {
        this.dbtModelQualifiedName = dbtModelQualifiedName;
    }

    @Generated
    public void setDbtModelColumnDataType(String dbtModelColumnDataType) {
        this.dbtModelColumnDataType = dbtModelColumnDataType;
    }

    @Generated
    public void setDbtModelColumnOrder(Integer dbtModelColumnOrder) {
        this.dbtModelColumnOrder = dbtModelColumnOrder;
    }

    @Generated
    public void setSqlColumn(Column sqlColumn) {
        this.sqlColumn = sqlColumn;
    }

    @Generated
    public void setDbtModel(DbtModel dbtModel) {
        this.dbtModel = dbtModel;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DbtModelColumn)) {
            return false;
        }
        DbtModelColumn other = (DbtModelColumn)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$dbtModelColumnOrder = this.getDbtModelColumnOrder();
        Integer other$dbtModelColumnOrder = other.getDbtModelColumnOrder();
        if (this$dbtModelColumnOrder == null ? other$dbtModelColumnOrder != null : !((Object)this$dbtModelColumnOrder).equals(other$dbtModelColumnOrder)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$dbtModelQualifiedName = this.getDbtModelQualifiedName();
        String other$dbtModelQualifiedName = other.getDbtModelQualifiedName();
        if (this$dbtModelQualifiedName == null ? other$dbtModelQualifiedName != null : !this$dbtModelQualifiedName.equals(other$dbtModelQualifiedName)) {
            return false;
        }
        String this$dbtModelColumnDataType = this.getDbtModelColumnDataType();
        String other$dbtModelColumnDataType = other.getDbtModelColumnDataType();
        if (this$dbtModelColumnDataType == null ? other$dbtModelColumnDataType != null : !this$dbtModelColumnDataType.equals(other$dbtModelColumnDataType)) {
            return false;
        }
        Column this$sqlColumn = this.getSqlColumn();
        Column other$sqlColumn = other.getSqlColumn();
        if (this$sqlColumn == null ? other$sqlColumn != null : !((Object)this$sqlColumn).equals(other$sqlColumn)) {
            return false;
        }
        DbtModel this$dbtModel = this.getDbtModel();
        DbtModel other$dbtModel = other.getDbtModel();
        return !(this$dbtModel == null ? other$dbtModel != null : !((Object)this$dbtModel).equals(other$dbtModel));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DbtModelColumn;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $dbtModelColumnOrder = this.getDbtModelColumnOrder();
        result = result * 59 + ($dbtModelColumnOrder == null ? 43 : ((Object)$dbtModelColumnOrder).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $dbtModelQualifiedName = this.getDbtModelQualifiedName();
        result = result * 59 + ($dbtModelQualifiedName == null ? 43 : $dbtModelQualifiedName.hashCode());
        String $dbtModelColumnDataType = this.getDbtModelColumnDataType();
        result = result * 59 + ($dbtModelColumnDataType == null ? 43 : $dbtModelColumnDataType.hashCode());
        Column $sqlColumn = this.getSqlColumn();
        result = result * 59 + ($sqlColumn == null ? 43 : ((Object)$sqlColumn).hashCode());
        DbtModel $dbtModel = this.getDbtModel();
        result = result * 59 + ($dbtModel == null ? 43 : ((Object)$dbtModel).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class DbtModelColumnBuilderImpl
    extends DbtModelColumnBuilder<DbtModelColumn, DbtModelColumnBuilderImpl> {
        @Generated
        private DbtModelColumnBuilderImpl() {
        }

        @Override
        @Generated
        protected DbtModelColumnBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DbtModelColumn build() {
            return new DbtModelColumn(this);
        }
    }

    @Generated
    public static abstract class DbtModelColumnBuilder<C extends DbtModelColumn, B extends DbtModelColumnBuilder<C, B>>
    extends Dbt.DbtBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String dbtModelQualifiedName;
        @Generated
        private String dbtModelColumnDataType;
        @Generated
        private Integer dbtModelColumnOrder;
        @Generated
        private Column sqlColumn;
        @Generated
        private DbtModel dbtModel;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            DbtModelColumnBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(DbtModelColumn instance, DbtModelColumnBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.dbtModelQualifiedName(instance.dbtModelQualifiedName);
            b.dbtModelColumnDataType(instance.dbtModelColumnDataType);
            b.dbtModelColumnOrder(instance.dbtModelColumnOrder);
            b.sqlColumn(instance.sqlColumn);
            b.dbtModel(instance.dbtModel);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B dbtModelQualifiedName(String dbtModelQualifiedName) {
            this.dbtModelQualifiedName = dbtModelQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B dbtModelColumnDataType(String dbtModelColumnDataType) {
            this.dbtModelColumnDataType = dbtModelColumnDataType;
            return (B)this.self();
        }

        @Generated
        public B dbtModelColumnOrder(Integer dbtModelColumnOrder) {
            this.dbtModelColumnOrder = dbtModelColumnOrder;
            return (B)this.self();
        }

        @Generated
        public B sqlColumn(Column sqlColumn) {
            this.sqlColumn = sqlColumn;
            return (B)this.self();
        }

        @Generated
        public B dbtModel(DbtModel dbtModel) {
            this.dbtModel = dbtModel;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "DbtModelColumn.DbtModelColumnBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", dbtModelQualifiedName=" + this.dbtModelQualifiedName + ", dbtModelColumnDataType=" + this.dbtModelColumnDataType + ", dbtModelColumnOrder=" + this.dbtModelColumnOrder + ", sqlColumn=" + this.sqlColumn + ", dbtModel=" + this.dbtModel + ")";
        }
    }
}

