/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.AbstractProcess;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.LineageProcess;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class DbtProcess
extends AbstractProcess {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "DbtProcess";
    String typeName;
    @Attribute
    String dbtProcessJobStatus;
    @Attribute
    SortedSet<LineageProcess> inputToProcesses;
    @Attribute
    SortedSet<LineageProcess> outputFromProcesses;

    public static DbtProcess refByGuid(String guid) {
        return ((DbtProcessBuilder)DbtProcess.builder().guid(guid)).build();
    }

    public static DbtProcess refByQualifiedName(String qualifiedName) {
        return ((DbtProcessBuilder)DbtProcess.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static DbtProcessBuilder<?, ?> updater(String qualifiedName, String name) {
        return (DbtProcessBuilder)((DbtProcessBuilder)DbtProcess.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected DbtProcessBuilder<?, ?> trimToRequired() {
        return DbtProcess.updater(this.getQualifiedName(), this.getName());
    }

    public static DbtProcess retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof DbtProcess) {
            return (DbtProcess)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a DbtProcess.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static DbtProcess retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof DbtProcess) {
            return (DbtProcess)entity;
        }
        throw new NotFoundException("No DbtProcess found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static DbtProcess removeDescription(String qualifiedName, String name) throws AtlanException {
        return (DbtProcess)Asset.removeDescription(((DbtProcessBuilder)DbtProcess.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static DbtProcess removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (DbtProcess)Asset.removeUserDescription(((DbtProcessBuilder)DbtProcess.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static DbtProcess removeOwners(String qualifiedName, String name) throws AtlanException {
        return (DbtProcess)Asset.removeOwners(((DbtProcessBuilder)DbtProcess.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static DbtProcess updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (DbtProcess)Asset.updateCertificate(DbtProcess.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static DbtProcess removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (DbtProcess)Asset.removeCertificate(((DbtProcessBuilder)DbtProcess.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static DbtProcess updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (DbtProcess)Asset.updateAnnouncement(DbtProcess.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static DbtProcess removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (DbtProcess)Asset.removeAnnouncement(((DbtProcessBuilder)DbtProcess.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static DbtProcess replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (DbtProcess)Asset.replaceTerms(DbtProcess.updater(qualifiedName, name), terms);
    }

    public static DbtProcess appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (DbtProcess)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static DbtProcess removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (DbtProcess)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected DbtProcess(DbtProcessBuilder<?, ?> b) {
        super((AbstractProcess.AbstractProcessBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : DbtProcess.$default$typeName();
        this.dbtProcessJobStatus = b.dbtProcessJobStatus;
        SortedSet<LineageProcess> inputToProcesses = new TreeSet<LineageProcess>();
        if (b.inputToProcesses != null) {
            inputToProcesses.addAll(b.inputToProcesses);
        }
        inputToProcesses = Collections.unmodifiableSortedSet(inputToProcesses);
        this.inputToProcesses = inputToProcesses;
        SortedSet<LineageProcess> outputFromProcesses = new TreeSet<LineageProcess>();
        if (b.outputFromProcesses != null) {
            outputFromProcesses.addAll(b.outputFromProcesses);
        }
        outputFromProcesses = Collections.unmodifiableSortedSet(outputFromProcesses);
        this.outputFromProcesses = outputFromProcesses;
    }

    @Generated
    public static DbtProcessBuilder<?, ?> builder() {
        return new DbtProcessBuilderImpl();
    }

    @Generated
    public DbtProcessBuilder<?, ?> toBuilder() {
        return new DbtProcessBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getDbtProcessJobStatus() {
        return this.dbtProcessJobStatus;
    }

    @Generated
    public SortedSet<LineageProcess> getInputToProcesses() {
        return this.inputToProcesses;
    }

    @Generated
    public SortedSet<LineageProcess> getOutputFromProcesses() {
        return this.outputFromProcesses;
    }

    @Generated
    public void setDbtProcessJobStatus(String dbtProcessJobStatus) {
        this.dbtProcessJobStatus = dbtProcessJobStatus;
    }

    @Generated
    public void setInputToProcesses(SortedSet<LineageProcess> inputToProcesses) {
        this.inputToProcesses = inputToProcesses;
    }

    @Generated
    public void setOutputFromProcesses(SortedSet<LineageProcess> outputFromProcesses) {
        this.outputFromProcesses = outputFromProcesses;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DbtProcess)) {
            return false;
        }
        DbtProcess other = (DbtProcess)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$dbtProcessJobStatus = this.getDbtProcessJobStatus();
        String other$dbtProcessJobStatus = other.getDbtProcessJobStatus();
        if (this$dbtProcessJobStatus == null ? other$dbtProcessJobStatus != null : !this$dbtProcessJobStatus.equals(other$dbtProcessJobStatus)) {
            return false;
        }
        SortedSet<LineageProcess> this$inputToProcesses = this.getInputToProcesses();
        SortedSet<LineageProcess> other$inputToProcesses = other.getInputToProcesses();
        if (this$inputToProcesses == null ? other$inputToProcesses != null : !this$inputToProcesses.equals(other$inputToProcesses)) {
            return false;
        }
        SortedSet<LineageProcess> this$outputFromProcesses = this.getOutputFromProcesses();
        SortedSet<LineageProcess> other$outputFromProcesses = other.getOutputFromProcesses();
        return !(this$outputFromProcesses == null ? other$outputFromProcesses != null : !this$outputFromProcesses.equals(other$outputFromProcesses));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DbtProcess;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $dbtProcessJobStatus = this.getDbtProcessJobStatus();
        result = result * 59 + ($dbtProcessJobStatus == null ? 43 : $dbtProcessJobStatus.hashCode());
        SortedSet<LineageProcess> $inputToProcesses = this.getInputToProcesses();
        result = result * 59 + ($inputToProcesses == null ? 43 : $inputToProcesses.hashCode());
        SortedSet<LineageProcess> $outputFromProcesses = this.getOutputFromProcesses();
        result = result * 59 + ($outputFromProcesses == null ? 43 : $outputFromProcesses.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class DbtProcessBuilderImpl
    extends DbtProcessBuilder<DbtProcess, DbtProcessBuilderImpl> {
        @Generated
        private DbtProcessBuilderImpl() {
        }

        @Override
        @Generated
        protected DbtProcessBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DbtProcess build() {
            return new DbtProcess(this);
        }
    }

    @Generated
    public static abstract class DbtProcessBuilder<C extends DbtProcess, B extends DbtProcessBuilder<C, B>>
    extends AbstractProcess.AbstractProcessBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String dbtProcessJobStatus;
        @Generated
        private ArrayList<LineageProcess> inputToProcesses;
        @Generated
        private ArrayList<LineageProcess> outputFromProcesses;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            DbtProcessBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(DbtProcess instance, DbtProcessBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.dbtProcessJobStatus(instance.dbtProcessJobStatus);
            b.inputToProcesses(instance.inputToProcesses == null ? Collections.emptySortedSet() : instance.inputToProcesses);
            b.outputFromProcesses(instance.outputFromProcesses == null ? Collections.emptySortedSet() : instance.outputFromProcesses);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B dbtProcessJobStatus(String dbtProcessJobStatus) {
            this.dbtProcessJobStatus = dbtProcessJobStatus;
            return (B)this.self();
        }

        @Generated
        public B inputToProcess(LineageProcess inputToProcess) {
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.add(inputToProcess);
            return (B)this.self();
        }

        @Generated
        public B inputToProcesses(Collection<? extends LineageProcess> inputToProcesses) {
            if (inputToProcesses == null) {
                throw new NullPointerException("inputToProcesses cannot be null");
            }
            if (this.inputToProcesses == null) {
                this.inputToProcesses = new ArrayList();
            }
            this.inputToProcesses.addAll(inputToProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearInputToProcesses() {
            if (this.inputToProcesses != null) {
                this.inputToProcesses.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B outputFromProcess(LineageProcess outputFromProcess) {
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.add(outputFromProcess);
            return (B)this.self();
        }

        @Generated
        public B outputFromProcesses(Collection<? extends LineageProcess> outputFromProcesses) {
            if (outputFromProcesses == null) {
                throw new NullPointerException("outputFromProcesses cannot be null");
            }
            if (this.outputFromProcesses == null) {
                this.outputFromProcesses = new ArrayList();
            }
            this.outputFromProcesses.addAll(outputFromProcesses);
            return (B)this.self();
        }

        @Generated
        public B clearOutputFromProcesses() {
            if (this.outputFromProcesses != null) {
                this.outputFromProcesses.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "DbtProcess.DbtProcessBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", dbtProcessJobStatus=" + this.dbtProcessJobStatus + ", inputToProcesses=" + this.inputToProcesses + ", outputFromProcesses=" + this.outputFromProcesses + ")";
        }
    }
}

