/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Dbt;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.SQL;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.List;
import lombok.Generated;

public class DbtSource
extends Dbt {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "DbtSource";
    String typeName;
    @Attribute
    String dbtState;
    @Attribute
    String dbtFreshnessCriteria;
    @Attribute
    SQL sqlAsset;

    public static DbtSource refByGuid(String guid) {
        return ((DbtSourceBuilder)DbtSource.builder().guid(guid)).build();
    }

    public static DbtSource refByQualifiedName(String qualifiedName) {
        return ((DbtSourceBuilder)DbtSource.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static DbtSourceBuilder<?, ?> updater(String qualifiedName, String name) {
        return (DbtSourceBuilder)((DbtSourceBuilder)DbtSource.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected DbtSourceBuilder<?, ?> trimToRequired() {
        return DbtSource.updater(this.getQualifiedName(), this.getName());
    }

    public static DbtSource retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof DbtSource) {
            return (DbtSource)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a DbtSource.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static DbtSource retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof DbtSource) {
            return (DbtSource)entity;
        }
        throw new NotFoundException("No DbtSource found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static DbtSource removeDescription(String qualifiedName, String name) throws AtlanException {
        return (DbtSource)Asset.removeDescription(((DbtSourceBuilder)DbtSource.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static DbtSource removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (DbtSource)Asset.removeUserDescription(((DbtSourceBuilder)DbtSource.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static DbtSource removeOwners(String qualifiedName, String name) throws AtlanException {
        return (DbtSource)Asset.removeOwners(((DbtSourceBuilder)DbtSource.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static DbtSource updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (DbtSource)Asset.updateCertificate(DbtSource.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static DbtSource removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (DbtSource)Asset.removeCertificate(((DbtSourceBuilder)DbtSource.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static DbtSource updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (DbtSource)Asset.updateAnnouncement(DbtSource.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static DbtSource removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (DbtSource)Asset.removeAnnouncement(((DbtSourceBuilder)DbtSource.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static DbtSource replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (DbtSource)Asset.replaceTerms(DbtSource.updater(qualifiedName, name), terms);
    }

    public static DbtSource appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (DbtSource)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static DbtSource removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (DbtSource)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected DbtSource(DbtSourceBuilder<?, ?> b) {
        super((Dbt.DbtBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : DbtSource.$default$typeName();
        this.dbtState = b.dbtState;
        this.dbtFreshnessCriteria = b.dbtFreshnessCriteria;
        this.sqlAsset = b.sqlAsset;
    }

    @Generated
    public static DbtSourceBuilder<?, ?> builder() {
        return new DbtSourceBuilderImpl();
    }

    @Generated
    public DbtSourceBuilder<?, ?> toBuilder() {
        return new DbtSourceBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getDbtState() {
        return this.dbtState;
    }

    @Generated
    public String getDbtFreshnessCriteria() {
        return this.dbtFreshnessCriteria;
    }

    @Generated
    public SQL getSqlAsset() {
        return this.sqlAsset;
    }

    @Generated
    public void setDbtState(String dbtState) {
        this.dbtState = dbtState;
    }

    @Generated
    public void setDbtFreshnessCriteria(String dbtFreshnessCriteria) {
        this.dbtFreshnessCriteria = dbtFreshnessCriteria;
    }

    @Generated
    public void setSqlAsset(SQL sqlAsset) {
        this.sqlAsset = sqlAsset;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DbtSource)) {
            return false;
        }
        DbtSource other = (DbtSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$dbtState = this.getDbtState();
        String other$dbtState = other.getDbtState();
        if (this$dbtState == null ? other$dbtState != null : !this$dbtState.equals(other$dbtState)) {
            return false;
        }
        String this$dbtFreshnessCriteria = this.getDbtFreshnessCriteria();
        String other$dbtFreshnessCriteria = other.getDbtFreshnessCriteria();
        if (this$dbtFreshnessCriteria == null ? other$dbtFreshnessCriteria != null : !this$dbtFreshnessCriteria.equals(other$dbtFreshnessCriteria)) {
            return false;
        }
        SQL this$sqlAsset = this.getSqlAsset();
        SQL other$sqlAsset = other.getSqlAsset();
        return !(this$sqlAsset == null ? other$sqlAsset != null : !((Object)this$sqlAsset).equals(other$sqlAsset));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DbtSource;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $dbtState = this.getDbtState();
        result = result * 59 + ($dbtState == null ? 43 : $dbtState.hashCode());
        String $dbtFreshnessCriteria = this.getDbtFreshnessCriteria();
        result = result * 59 + ($dbtFreshnessCriteria == null ? 43 : $dbtFreshnessCriteria.hashCode());
        SQL $sqlAsset = this.getSqlAsset();
        result = result * 59 + ($sqlAsset == null ? 43 : ((Object)$sqlAsset).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class DbtSourceBuilderImpl
    extends DbtSourceBuilder<DbtSource, DbtSourceBuilderImpl> {
        @Generated
        private DbtSourceBuilderImpl() {
        }

        @Override
        @Generated
        protected DbtSourceBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public DbtSource build() {
            return new DbtSource(this);
        }
    }

    @Generated
    public static abstract class DbtSourceBuilder<C extends DbtSource, B extends DbtSourceBuilder<C, B>>
    extends Dbt.DbtBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String dbtState;
        @Generated
        private String dbtFreshnessCriteria;
        @Generated
        private SQL sqlAsset;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            DbtSourceBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(DbtSource instance, DbtSourceBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.dbtState(instance.dbtState);
            b.dbtFreshnessCriteria(instance.dbtFreshnessCriteria);
            b.sqlAsset(instance.sqlAsset);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B dbtState(String dbtState) {
            this.dbtState = dbtState;
            return (B)this.self();
        }

        @Generated
        public B dbtFreshnessCriteria(String dbtFreshnessCriteria) {
            this.dbtFreshnessCriteria = dbtFreshnessCriteria;
            return (B)this.self();
        }

        @Generated
        public B sqlAsset(SQL sqlAsset) {
            this.sqlAsset = sqlAsset;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "DbtSource.DbtSourceBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", dbtState=" + this.dbtState + ", dbtFreshnessCriteria=" + this.dbtFreshnessCriteria + ", sqlAsset=" + this.sqlAsset + ")";
        }
    }
}

