/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.Namespace;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.List;
import lombok.Generated;

public class Folder
extends Namespace {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "Folder";
    String typeName;
    @Attribute
    String parentQualifiedName;
    @Attribute
    String collectionQualifiedName;
    @Attribute
    Namespace parent;

    public static Folder refByGuid(String guid) {
        return ((FolderBuilder)Folder.builder().guid(guid)).build();
    }

    public static Folder refByQualifiedName(String qualifiedName) {
        return ((FolderBuilder)Folder.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static FolderBuilder<?, ?> updater(String qualifiedName, String name) {
        return (FolderBuilder)((FolderBuilder)Folder.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected FolderBuilder<?, ?> trimToRequired() {
        return Folder.updater(this.getQualifiedName(), this.getName());
    }

    public static Folder retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof Folder) {
            return (Folder)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a Folder.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static Folder retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof Folder) {
            return (Folder)entity;
        }
        throw new NotFoundException("No Folder found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static Folder removeDescription(String qualifiedName, String name) throws AtlanException {
        return (Folder)Asset.removeDescription(((FolderBuilder)Folder.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static Folder removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (Folder)Asset.removeUserDescription(((FolderBuilder)Folder.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static Folder removeOwners(String qualifiedName, String name) throws AtlanException {
        return (Folder)Asset.removeOwners(((FolderBuilder)Folder.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static Folder updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (Folder)Asset.updateCertificate(Folder.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static Folder removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (Folder)Asset.removeCertificate(((FolderBuilder)Folder.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static Folder updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (Folder)Asset.updateAnnouncement(Folder.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static Folder removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (Folder)Asset.removeAnnouncement(((FolderBuilder)Folder.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static Folder replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (Folder)Asset.replaceTerms(Folder.updater(qualifiedName, name), terms);
    }

    public static Folder appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (Folder)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static Folder removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (Folder)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected Folder(FolderBuilder<?, ?> b) {
        super((Namespace.NamespaceBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : Folder.$default$typeName();
        this.parentQualifiedName = b.parentQualifiedName;
        this.collectionQualifiedName = b.collectionQualifiedName;
        this.parent = b.parent;
    }

    @Generated
    public static FolderBuilder<?, ?> builder() {
        return new FolderBuilderImpl();
    }

    @Generated
    public FolderBuilder<?, ?> toBuilder() {
        return new FolderBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getParentQualifiedName() {
        return this.parentQualifiedName;
    }

    @Generated
    public String getCollectionQualifiedName() {
        return this.collectionQualifiedName;
    }

    @Generated
    public Namespace getParent() {
        return this.parent;
    }

    @Generated
    public void setParentQualifiedName(String parentQualifiedName) {
        this.parentQualifiedName = parentQualifiedName;
    }

    @Generated
    public void setCollectionQualifiedName(String collectionQualifiedName) {
        this.collectionQualifiedName = collectionQualifiedName;
    }

    @Generated
    public void setParent(Namespace parent) {
        this.parent = parent;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Folder)) {
            return false;
        }
        Folder other = (Folder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$parentQualifiedName = this.getParentQualifiedName();
        String other$parentQualifiedName = other.getParentQualifiedName();
        if (this$parentQualifiedName == null ? other$parentQualifiedName != null : !this$parentQualifiedName.equals(other$parentQualifiedName)) {
            return false;
        }
        String this$collectionQualifiedName = this.getCollectionQualifiedName();
        String other$collectionQualifiedName = other.getCollectionQualifiedName();
        if (this$collectionQualifiedName == null ? other$collectionQualifiedName != null : !this$collectionQualifiedName.equals(other$collectionQualifiedName)) {
            return false;
        }
        Namespace this$parent = this.getParent();
        Namespace other$parent = other.getParent();
        return !(this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Folder;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $parentQualifiedName = this.getParentQualifiedName();
        result = result * 59 + ($parentQualifiedName == null ? 43 : $parentQualifiedName.hashCode());
        String $collectionQualifiedName = this.getCollectionQualifiedName();
        result = result * 59 + ($collectionQualifiedName == null ? 43 : $collectionQualifiedName.hashCode());
        Namespace $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class FolderBuilderImpl
    extends FolderBuilder<Folder, FolderBuilderImpl> {
        @Generated
        private FolderBuilderImpl() {
        }

        @Override
        @Generated
        protected FolderBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Folder build() {
            return new Folder(this);
        }
    }

    @Generated
    public static abstract class FolderBuilder<C extends Folder, B extends FolderBuilder<C, B>>
    extends Namespace.NamespaceBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String parentQualifiedName;
        @Generated
        private String collectionQualifiedName;
        @Generated
        private Namespace parent;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            FolderBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Folder instance, FolderBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.parentQualifiedName(instance.parentQualifiedName);
            b.collectionQualifiedName(instance.collectionQualifiedName);
            b.parent(instance.parent);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B parentQualifiedName(String parentQualifiedName) {
            this.parentQualifiedName = parentQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B collectionQualifiedName(String collectionQualifiedName) {
            this.collectionQualifiedName = collectionQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B parent(Namespace parent) {
            this.parent = parent;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "Folder.FolderBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", parentQualifiedName=" + this.parentQualifiedName + ", collectionQualifiedName=" + this.collectionQualifiedName + ", parent=" + this.parent + ")";
        }
    }
}

