/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GCS;
import com.atlan.model.assets.GCSObject;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class GCSBucket
extends GCS {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "GCSBucket";
    String typeName;
    @Attribute
    Long gcsObjectCount;
    @Attribute
    Boolean gcsBucketVersioningEnabled;
    @Attribute
    Boolean gcsBucketRetentionLocked;
    @Attribute
    Long gcsBucketRetentionPeriod;
    @Attribute
    Long gcsBucketRetentionEffectiveTime;
    @Attribute
    String gcsBucketLifecycleRules;
    @Attribute
    String gcsBucketRetentionPolicy;
    @Attribute
    SortedSet<GCSObject> gcsObjects;

    public static GCSBucket refByGuid(String guid) {
        return ((GCSBucketBuilder)GCSBucket.builder().guid(guid)).build();
    }

    public static GCSBucket refByQualifiedName(String qualifiedName) {
        return ((GCSBucketBuilder)GCSBucket.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static GCSBucketBuilder<?, ?> creator(String name, String connectionQualifiedName) {
        return (GCSBucketBuilder)((GCSBucketBuilder)((GCSBucketBuilder)((GCSBucketBuilder)GCSBucket.builder().qualifiedName(connectionQualifiedName + "/" + name)).name(name)).connectionQualifiedName(connectionQualifiedName)).connectorType(AtlanConnectorType.GCS);
    }

    public static GCSBucketBuilder<?, ?> updater(String qualifiedName, String name) {
        return (GCSBucketBuilder)((GCSBucketBuilder)GCSBucket.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected GCSBucketBuilder<?, ?> trimToRequired() {
        return GCSBucket.updater(this.getQualifiedName(), this.getName());
    }

    public static GCSBucket retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof GCSBucket) {
            return (GCSBucket)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a GCSBucket.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static GCSBucket retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof GCSBucket) {
            return (GCSBucket)entity;
        }
        throw new NotFoundException("No GCSBucket found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static GCSBucket removeDescription(String qualifiedName, String name) throws AtlanException {
        return (GCSBucket)Asset.removeDescription(((GCSBucketBuilder)GCSBucket.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static GCSBucket removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (GCSBucket)Asset.removeUserDescription(((GCSBucketBuilder)GCSBucket.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static GCSBucket removeOwners(String qualifiedName, String name) throws AtlanException {
        return (GCSBucket)Asset.removeOwners(((GCSBucketBuilder)GCSBucket.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static GCSBucket updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (GCSBucket)Asset.updateCertificate(GCSBucket.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static GCSBucket removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (GCSBucket)Asset.removeCertificate(((GCSBucketBuilder)GCSBucket.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static GCSBucket updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (GCSBucket)Asset.updateAnnouncement(GCSBucket.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static GCSBucket removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (GCSBucket)Asset.removeAnnouncement(((GCSBucketBuilder)GCSBucket.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static GCSBucket replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (GCSBucket)Asset.replaceTerms(GCSBucket.updater(qualifiedName, name), terms);
    }

    public static GCSBucket appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (GCSBucket)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static GCSBucket removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (GCSBucket)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected GCSBucket(GCSBucketBuilder<?, ?> b) {
        super((GCS.GCSBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : GCSBucket.$default$typeName();
        this.gcsObjectCount = b.gcsObjectCount;
        this.gcsBucketVersioningEnabled = b.gcsBucketVersioningEnabled;
        this.gcsBucketRetentionLocked = b.gcsBucketRetentionLocked;
        this.gcsBucketRetentionPeriod = b.gcsBucketRetentionPeriod;
        this.gcsBucketRetentionEffectiveTime = b.gcsBucketRetentionEffectiveTime;
        this.gcsBucketLifecycleRules = b.gcsBucketLifecycleRules;
        this.gcsBucketRetentionPolicy = b.gcsBucketRetentionPolicy;
        SortedSet<GCSObject> gcsObjects = new TreeSet<GCSObject>();
        if (b.gcsObjects != null) {
            gcsObjects.addAll(b.gcsObjects);
        }
        gcsObjects = Collections.unmodifiableSortedSet(gcsObjects);
        this.gcsObjects = gcsObjects;
    }

    @Generated
    public static GCSBucketBuilder<?, ?> builder() {
        return new GCSBucketBuilderImpl();
    }

    @Generated
    public GCSBucketBuilder<?, ?> toBuilder() {
        return new GCSBucketBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public Long getGcsObjectCount() {
        return this.gcsObjectCount;
    }

    @Generated
    public Boolean getGcsBucketVersioningEnabled() {
        return this.gcsBucketVersioningEnabled;
    }

    @Generated
    public Boolean getGcsBucketRetentionLocked() {
        return this.gcsBucketRetentionLocked;
    }

    @Generated
    public Long getGcsBucketRetentionPeriod() {
        return this.gcsBucketRetentionPeriod;
    }

    @Generated
    public Long getGcsBucketRetentionEffectiveTime() {
        return this.gcsBucketRetentionEffectiveTime;
    }

    @Generated
    public String getGcsBucketLifecycleRules() {
        return this.gcsBucketLifecycleRules;
    }

    @Generated
    public String getGcsBucketRetentionPolicy() {
        return this.gcsBucketRetentionPolicy;
    }

    @Generated
    public SortedSet<GCSObject> getGcsObjects() {
        return this.gcsObjects;
    }

    @Generated
    public void setGcsObjectCount(Long gcsObjectCount) {
        this.gcsObjectCount = gcsObjectCount;
    }

    @Generated
    public void setGcsBucketVersioningEnabled(Boolean gcsBucketVersioningEnabled) {
        this.gcsBucketVersioningEnabled = gcsBucketVersioningEnabled;
    }

    @Generated
    public void setGcsBucketRetentionLocked(Boolean gcsBucketRetentionLocked) {
        this.gcsBucketRetentionLocked = gcsBucketRetentionLocked;
    }

    @Generated
    public void setGcsBucketRetentionPeriod(Long gcsBucketRetentionPeriod) {
        this.gcsBucketRetentionPeriod = gcsBucketRetentionPeriod;
    }

    @Generated
    public void setGcsBucketRetentionEffectiveTime(Long gcsBucketRetentionEffectiveTime) {
        this.gcsBucketRetentionEffectiveTime = gcsBucketRetentionEffectiveTime;
    }

    @Generated
    public void setGcsBucketLifecycleRules(String gcsBucketLifecycleRules) {
        this.gcsBucketLifecycleRules = gcsBucketLifecycleRules;
    }

    @Generated
    public void setGcsBucketRetentionPolicy(String gcsBucketRetentionPolicy) {
        this.gcsBucketRetentionPolicy = gcsBucketRetentionPolicy;
    }

    @Generated
    public void setGcsObjects(SortedSet<GCSObject> gcsObjects) {
        this.gcsObjects = gcsObjects;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GCSBucket)) {
            return false;
        }
        GCSBucket other = (GCSBucket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$gcsObjectCount = this.getGcsObjectCount();
        Long other$gcsObjectCount = other.getGcsObjectCount();
        if (this$gcsObjectCount == null ? other$gcsObjectCount != null : !((Object)this$gcsObjectCount).equals(other$gcsObjectCount)) {
            return false;
        }
        Boolean this$gcsBucketVersioningEnabled = this.getGcsBucketVersioningEnabled();
        Boolean other$gcsBucketVersioningEnabled = other.getGcsBucketVersioningEnabled();
        if (this$gcsBucketVersioningEnabled == null ? other$gcsBucketVersioningEnabled != null : !((Object)this$gcsBucketVersioningEnabled).equals(other$gcsBucketVersioningEnabled)) {
            return false;
        }
        Boolean this$gcsBucketRetentionLocked = this.getGcsBucketRetentionLocked();
        Boolean other$gcsBucketRetentionLocked = other.getGcsBucketRetentionLocked();
        if (this$gcsBucketRetentionLocked == null ? other$gcsBucketRetentionLocked != null : !((Object)this$gcsBucketRetentionLocked).equals(other$gcsBucketRetentionLocked)) {
            return false;
        }
        Long this$gcsBucketRetentionPeriod = this.getGcsBucketRetentionPeriod();
        Long other$gcsBucketRetentionPeriod = other.getGcsBucketRetentionPeriod();
        if (this$gcsBucketRetentionPeriod == null ? other$gcsBucketRetentionPeriod != null : !((Object)this$gcsBucketRetentionPeriod).equals(other$gcsBucketRetentionPeriod)) {
            return false;
        }
        Long this$gcsBucketRetentionEffectiveTime = this.getGcsBucketRetentionEffectiveTime();
        Long other$gcsBucketRetentionEffectiveTime = other.getGcsBucketRetentionEffectiveTime();
        if (this$gcsBucketRetentionEffectiveTime == null ? other$gcsBucketRetentionEffectiveTime != null : !((Object)this$gcsBucketRetentionEffectiveTime).equals(other$gcsBucketRetentionEffectiveTime)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$gcsBucketLifecycleRules = this.getGcsBucketLifecycleRules();
        String other$gcsBucketLifecycleRules = other.getGcsBucketLifecycleRules();
        if (this$gcsBucketLifecycleRules == null ? other$gcsBucketLifecycleRules != null : !this$gcsBucketLifecycleRules.equals(other$gcsBucketLifecycleRules)) {
            return false;
        }
        String this$gcsBucketRetentionPolicy = this.getGcsBucketRetentionPolicy();
        String other$gcsBucketRetentionPolicy = other.getGcsBucketRetentionPolicy();
        if (this$gcsBucketRetentionPolicy == null ? other$gcsBucketRetentionPolicy != null : !this$gcsBucketRetentionPolicy.equals(other$gcsBucketRetentionPolicy)) {
            return false;
        }
        SortedSet<GCSObject> this$gcsObjects = this.getGcsObjects();
        SortedSet<GCSObject> other$gcsObjects = other.getGcsObjects();
        return !(this$gcsObjects == null ? other$gcsObjects != null : !this$gcsObjects.equals(other$gcsObjects));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GCSBucket;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $gcsObjectCount = this.getGcsObjectCount();
        result = result * 59 + ($gcsObjectCount == null ? 43 : ((Object)$gcsObjectCount).hashCode());
        Boolean $gcsBucketVersioningEnabled = this.getGcsBucketVersioningEnabled();
        result = result * 59 + ($gcsBucketVersioningEnabled == null ? 43 : ((Object)$gcsBucketVersioningEnabled).hashCode());
        Boolean $gcsBucketRetentionLocked = this.getGcsBucketRetentionLocked();
        result = result * 59 + ($gcsBucketRetentionLocked == null ? 43 : ((Object)$gcsBucketRetentionLocked).hashCode());
        Long $gcsBucketRetentionPeriod = this.getGcsBucketRetentionPeriod();
        result = result * 59 + ($gcsBucketRetentionPeriod == null ? 43 : ((Object)$gcsBucketRetentionPeriod).hashCode());
        Long $gcsBucketRetentionEffectiveTime = this.getGcsBucketRetentionEffectiveTime();
        result = result * 59 + ($gcsBucketRetentionEffectiveTime == null ? 43 : ((Object)$gcsBucketRetentionEffectiveTime).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $gcsBucketLifecycleRules = this.getGcsBucketLifecycleRules();
        result = result * 59 + ($gcsBucketLifecycleRules == null ? 43 : $gcsBucketLifecycleRules.hashCode());
        String $gcsBucketRetentionPolicy = this.getGcsBucketRetentionPolicy();
        result = result * 59 + ($gcsBucketRetentionPolicy == null ? 43 : $gcsBucketRetentionPolicy.hashCode());
        SortedSet<GCSObject> $gcsObjects = this.getGcsObjects();
        result = result * 59 + ($gcsObjects == null ? 43 : $gcsObjects.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class GCSBucketBuilderImpl
    extends GCSBucketBuilder<GCSBucket, GCSBucketBuilderImpl> {
        @Generated
        private GCSBucketBuilderImpl() {
        }

        @Override
        @Generated
        protected GCSBucketBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public GCSBucket build() {
            return new GCSBucket(this);
        }
    }

    @Generated
    public static abstract class GCSBucketBuilder<C extends GCSBucket, B extends GCSBucketBuilder<C, B>>
    extends GCS.GCSBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private Long gcsObjectCount;
        @Generated
        private Boolean gcsBucketVersioningEnabled;
        @Generated
        private Boolean gcsBucketRetentionLocked;
        @Generated
        private Long gcsBucketRetentionPeriod;
        @Generated
        private Long gcsBucketRetentionEffectiveTime;
        @Generated
        private String gcsBucketLifecycleRules;
        @Generated
        private String gcsBucketRetentionPolicy;
        @Generated
        private ArrayList<GCSObject> gcsObjects;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            GCSBucketBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(GCSBucket instance, GCSBucketBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.gcsObjectCount(instance.gcsObjectCount);
            b.gcsBucketVersioningEnabled(instance.gcsBucketVersioningEnabled);
            b.gcsBucketRetentionLocked(instance.gcsBucketRetentionLocked);
            b.gcsBucketRetentionPeriod(instance.gcsBucketRetentionPeriod);
            b.gcsBucketRetentionEffectiveTime(instance.gcsBucketRetentionEffectiveTime);
            b.gcsBucketLifecycleRules(instance.gcsBucketLifecycleRules);
            b.gcsBucketRetentionPolicy(instance.gcsBucketRetentionPolicy);
            b.gcsObjects(instance.gcsObjects == null ? Collections.emptySortedSet() : instance.gcsObjects);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B gcsObjectCount(Long gcsObjectCount) {
            this.gcsObjectCount = gcsObjectCount;
            return (B)this.self();
        }

        @Generated
        public B gcsBucketVersioningEnabled(Boolean gcsBucketVersioningEnabled) {
            this.gcsBucketVersioningEnabled = gcsBucketVersioningEnabled;
            return (B)this.self();
        }

        @Generated
        public B gcsBucketRetentionLocked(Boolean gcsBucketRetentionLocked) {
            this.gcsBucketRetentionLocked = gcsBucketRetentionLocked;
            return (B)this.self();
        }

        @Generated
        public B gcsBucketRetentionPeriod(Long gcsBucketRetentionPeriod) {
            this.gcsBucketRetentionPeriod = gcsBucketRetentionPeriod;
            return (B)this.self();
        }

        @Generated
        public B gcsBucketRetentionEffectiveTime(Long gcsBucketRetentionEffectiveTime) {
            this.gcsBucketRetentionEffectiveTime = gcsBucketRetentionEffectiveTime;
            return (B)this.self();
        }

        @Generated
        public B gcsBucketLifecycleRules(String gcsBucketLifecycleRules) {
            this.gcsBucketLifecycleRules = gcsBucketLifecycleRules;
            return (B)this.self();
        }

        @Generated
        public B gcsBucketRetentionPolicy(String gcsBucketRetentionPolicy) {
            this.gcsBucketRetentionPolicy = gcsBucketRetentionPolicy;
            return (B)this.self();
        }

        @Generated
        public B gcsObject(GCSObject gcsObject) {
            if (this.gcsObjects == null) {
                this.gcsObjects = new ArrayList();
            }
            this.gcsObjects.add(gcsObject);
            return (B)this.self();
        }

        @Generated
        public B gcsObjects(Collection<? extends GCSObject> gcsObjects) {
            if (gcsObjects == null) {
                throw new NullPointerException("gcsObjects cannot be null");
            }
            if (this.gcsObjects == null) {
                this.gcsObjects = new ArrayList();
            }
            this.gcsObjects.addAll(gcsObjects);
            return (B)this.self();
        }

        @Generated
        public B clearGcsObjects() {
            if (this.gcsObjects != null) {
                this.gcsObjects.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "GCSBucket.GCSBucketBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", gcsObjectCount=" + this.gcsObjectCount + ", gcsBucketVersioningEnabled=" + this.gcsBucketVersioningEnabled + ", gcsBucketRetentionLocked=" + this.gcsBucketRetentionLocked + ", gcsBucketRetentionPeriod=" + this.gcsBucketRetentionPeriod + ", gcsBucketRetentionEffectiveTime=" + this.gcsBucketRetentionEffectiveTime + ", gcsBucketLifecycleRules=" + this.gcsBucketLifecycleRules + ", gcsBucketRetentionPolicy=" + this.gcsBucketRetentionPolicy + ", gcsObjects=" + this.gcsObjects + ")";
        }
    }
}

