/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GCS;
import com.atlan.model.assets.GCSBucket;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.util.StringUtils;
import java.util.List;
import lombok.Generated;

public class GCSObject
extends GCS {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "GCSObject";
    String typeName;
    @Attribute
    String gcsBucketName;
    @Attribute
    String gcsBucketQualifiedName;
    @Attribute
    Long gcsObjectSize;
    @Attribute
    String gcsObjectKey;
    @Attribute
    String gcsObjectMediaLink;
    @Attribute
    String gcsObjectHoldType;
    @Attribute
    Long gcsObjectGenerationId;
    @Attribute
    String gcsObjectCRC32CHash;
    @Attribute
    String gcsObjectMD5Hash;
    @Attribute
    Long gcsObjectDataLastModifiedTime;
    @Attribute
    String gcsObjectContentType;
    @Attribute
    String gcsObjectContentEncoding;
    @Attribute
    String gcsObjectContentDisposition;
    @Attribute
    String gcsObjectContentLanguage;
    @Attribute
    Long gcsObjectRetentionExpirationDate;
    @Attribute
    GCSBucket gcsBucket;

    public static GCSObject refByGuid(String guid) {
        return ((GCSObjectBuilder)GCSObject.builder().guid(guid)).build();
    }

    public static GCSObject refByQualifiedName(String qualifiedName) {
        return ((GCSObjectBuilder)GCSObject.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static GCSObjectBuilder<?, ?> creator(String name, String bucketQualifiedName) {
        String connectionQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(bucketQualifiedName);
        String bucketName = StringUtils.getNameFromQualifiedName(bucketQualifiedName);
        return ((GCSObjectBuilder)((GCSObjectBuilder)((GCSObjectBuilder)((GCSObjectBuilder)((GCSObjectBuilder)((GCSObjectBuilder)GCSObject.builder().qualifiedName(bucketQualifiedName + "/" + name)).name(name)).connectionQualifiedName(connectionQualifiedName)).connectorType(AtlanConnectorType.GCS)).gcsBucketName(bucketName)).gcsBucketQualifiedName(bucketQualifiedName)).gcsBucket(GCSBucket.refByQualifiedName(bucketQualifiedName));
    }

    public static GCSObjectBuilder<?, ?> updater(String qualifiedName, String name) {
        return (GCSObjectBuilder)((GCSObjectBuilder)GCSObject.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected GCSObjectBuilder<?, ?> trimToRequired() {
        return GCSObject.updater(this.getQualifiedName(), this.getName());
    }

    public static GCSObject retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof GCSObject) {
            return (GCSObject)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a GCSObject.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static GCSObject retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof GCSObject) {
            return (GCSObject)entity;
        }
        throw new NotFoundException("No GCSObject found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static GCSObject removeDescription(String qualifiedName, String name) throws AtlanException {
        return (GCSObject)Asset.removeDescription(((GCSObjectBuilder)GCSObject.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static GCSObject removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (GCSObject)Asset.removeUserDescription(((GCSObjectBuilder)GCSObject.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static GCSObject removeOwners(String qualifiedName, String name) throws AtlanException {
        return (GCSObject)Asset.removeOwners(((GCSObjectBuilder)GCSObject.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static GCSObject updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (GCSObject)Asset.updateCertificate(GCSObject.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static GCSObject removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (GCSObject)Asset.removeCertificate(((GCSObjectBuilder)GCSObject.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static GCSObject updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (GCSObject)Asset.updateAnnouncement(GCSObject.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static GCSObject removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (GCSObject)Asset.removeAnnouncement(((GCSObjectBuilder)GCSObject.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static GCSObject replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (GCSObject)Asset.replaceTerms(GCSObject.updater(qualifiedName, name), terms);
    }

    public static GCSObject appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (GCSObject)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static GCSObject removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (GCSObject)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected GCSObject(GCSObjectBuilder<?, ?> b) {
        super((GCS.GCSBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : GCSObject.$default$typeName();
        this.gcsBucketName = b.gcsBucketName;
        this.gcsBucketQualifiedName = b.gcsBucketQualifiedName;
        this.gcsObjectSize = b.gcsObjectSize;
        this.gcsObjectKey = b.gcsObjectKey;
        this.gcsObjectMediaLink = b.gcsObjectMediaLink;
        this.gcsObjectHoldType = b.gcsObjectHoldType;
        this.gcsObjectGenerationId = b.gcsObjectGenerationId;
        this.gcsObjectCRC32CHash = b.gcsObjectCRC32CHash;
        this.gcsObjectMD5Hash = b.gcsObjectMD5Hash;
        this.gcsObjectDataLastModifiedTime = b.gcsObjectDataLastModifiedTime;
        this.gcsObjectContentType = b.gcsObjectContentType;
        this.gcsObjectContentEncoding = b.gcsObjectContentEncoding;
        this.gcsObjectContentDisposition = b.gcsObjectContentDisposition;
        this.gcsObjectContentLanguage = b.gcsObjectContentLanguage;
        this.gcsObjectRetentionExpirationDate = b.gcsObjectRetentionExpirationDate;
        this.gcsBucket = b.gcsBucket;
    }

    @Generated
    public static GCSObjectBuilder<?, ?> builder() {
        return new GCSObjectBuilderImpl();
    }

    @Generated
    public GCSObjectBuilder<?, ?> toBuilder() {
        return new GCSObjectBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getGcsBucketName() {
        return this.gcsBucketName;
    }

    @Generated
    public String getGcsBucketQualifiedName() {
        return this.gcsBucketQualifiedName;
    }

    @Generated
    public Long getGcsObjectSize() {
        return this.gcsObjectSize;
    }

    @Generated
    public String getGcsObjectKey() {
        return this.gcsObjectKey;
    }

    @Generated
    public String getGcsObjectMediaLink() {
        return this.gcsObjectMediaLink;
    }

    @Generated
    public String getGcsObjectHoldType() {
        return this.gcsObjectHoldType;
    }

    @Generated
    public Long getGcsObjectGenerationId() {
        return this.gcsObjectGenerationId;
    }

    @Generated
    public String getGcsObjectCRC32CHash() {
        return this.gcsObjectCRC32CHash;
    }

    @Generated
    public String getGcsObjectMD5Hash() {
        return this.gcsObjectMD5Hash;
    }

    @Generated
    public Long getGcsObjectDataLastModifiedTime() {
        return this.gcsObjectDataLastModifiedTime;
    }

    @Generated
    public String getGcsObjectContentType() {
        return this.gcsObjectContentType;
    }

    @Generated
    public String getGcsObjectContentEncoding() {
        return this.gcsObjectContentEncoding;
    }

    @Generated
    public String getGcsObjectContentDisposition() {
        return this.gcsObjectContentDisposition;
    }

    @Generated
    public String getGcsObjectContentLanguage() {
        return this.gcsObjectContentLanguage;
    }

    @Generated
    public Long getGcsObjectRetentionExpirationDate() {
        return this.gcsObjectRetentionExpirationDate;
    }

    @Generated
    public GCSBucket getGcsBucket() {
        return this.gcsBucket;
    }

    @Generated
    public void setGcsBucketName(String gcsBucketName) {
        this.gcsBucketName = gcsBucketName;
    }

    @Generated
    public void setGcsBucketQualifiedName(String gcsBucketQualifiedName) {
        this.gcsBucketQualifiedName = gcsBucketQualifiedName;
    }

    @Generated
    public void setGcsObjectSize(Long gcsObjectSize) {
        this.gcsObjectSize = gcsObjectSize;
    }

    @Generated
    public void setGcsObjectKey(String gcsObjectKey) {
        this.gcsObjectKey = gcsObjectKey;
    }

    @Generated
    public void setGcsObjectMediaLink(String gcsObjectMediaLink) {
        this.gcsObjectMediaLink = gcsObjectMediaLink;
    }

    @Generated
    public void setGcsObjectHoldType(String gcsObjectHoldType) {
        this.gcsObjectHoldType = gcsObjectHoldType;
    }

    @Generated
    public void setGcsObjectGenerationId(Long gcsObjectGenerationId) {
        this.gcsObjectGenerationId = gcsObjectGenerationId;
    }

    @Generated
    public void setGcsObjectCRC32CHash(String gcsObjectCRC32CHash) {
        this.gcsObjectCRC32CHash = gcsObjectCRC32CHash;
    }

    @Generated
    public void setGcsObjectMD5Hash(String gcsObjectMD5Hash) {
        this.gcsObjectMD5Hash = gcsObjectMD5Hash;
    }

    @Generated
    public void setGcsObjectDataLastModifiedTime(Long gcsObjectDataLastModifiedTime) {
        this.gcsObjectDataLastModifiedTime = gcsObjectDataLastModifiedTime;
    }

    @Generated
    public void setGcsObjectContentType(String gcsObjectContentType) {
        this.gcsObjectContentType = gcsObjectContentType;
    }

    @Generated
    public void setGcsObjectContentEncoding(String gcsObjectContentEncoding) {
        this.gcsObjectContentEncoding = gcsObjectContentEncoding;
    }

    @Generated
    public void setGcsObjectContentDisposition(String gcsObjectContentDisposition) {
        this.gcsObjectContentDisposition = gcsObjectContentDisposition;
    }

    @Generated
    public void setGcsObjectContentLanguage(String gcsObjectContentLanguage) {
        this.gcsObjectContentLanguage = gcsObjectContentLanguage;
    }

    @Generated
    public void setGcsObjectRetentionExpirationDate(Long gcsObjectRetentionExpirationDate) {
        this.gcsObjectRetentionExpirationDate = gcsObjectRetentionExpirationDate;
    }

    @Generated
    public void setGcsBucket(GCSBucket gcsBucket) {
        this.gcsBucket = gcsBucket;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GCSObject)) {
            return false;
        }
        GCSObject other = (GCSObject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$gcsObjectSize = this.getGcsObjectSize();
        Long other$gcsObjectSize = other.getGcsObjectSize();
        if (this$gcsObjectSize == null ? other$gcsObjectSize != null : !((Object)this$gcsObjectSize).equals(other$gcsObjectSize)) {
            return false;
        }
        Long this$gcsObjectGenerationId = this.getGcsObjectGenerationId();
        Long other$gcsObjectGenerationId = other.getGcsObjectGenerationId();
        if (this$gcsObjectGenerationId == null ? other$gcsObjectGenerationId != null : !((Object)this$gcsObjectGenerationId).equals(other$gcsObjectGenerationId)) {
            return false;
        }
        Long this$gcsObjectDataLastModifiedTime = this.getGcsObjectDataLastModifiedTime();
        Long other$gcsObjectDataLastModifiedTime = other.getGcsObjectDataLastModifiedTime();
        if (this$gcsObjectDataLastModifiedTime == null ? other$gcsObjectDataLastModifiedTime != null : !((Object)this$gcsObjectDataLastModifiedTime).equals(other$gcsObjectDataLastModifiedTime)) {
            return false;
        }
        Long this$gcsObjectRetentionExpirationDate = this.getGcsObjectRetentionExpirationDate();
        Long other$gcsObjectRetentionExpirationDate = other.getGcsObjectRetentionExpirationDate();
        if (this$gcsObjectRetentionExpirationDate == null ? other$gcsObjectRetentionExpirationDate != null : !((Object)this$gcsObjectRetentionExpirationDate).equals(other$gcsObjectRetentionExpirationDate)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$gcsBucketName = this.getGcsBucketName();
        String other$gcsBucketName = other.getGcsBucketName();
        if (this$gcsBucketName == null ? other$gcsBucketName != null : !this$gcsBucketName.equals(other$gcsBucketName)) {
            return false;
        }
        String this$gcsBucketQualifiedName = this.getGcsBucketQualifiedName();
        String other$gcsBucketQualifiedName = other.getGcsBucketQualifiedName();
        if (this$gcsBucketQualifiedName == null ? other$gcsBucketQualifiedName != null : !this$gcsBucketQualifiedName.equals(other$gcsBucketQualifiedName)) {
            return false;
        }
        String this$gcsObjectKey = this.getGcsObjectKey();
        String other$gcsObjectKey = other.getGcsObjectKey();
        if (this$gcsObjectKey == null ? other$gcsObjectKey != null : !this$gcsObjectKey.equals(other$gcsObjectKey)) {
            return false;
        }
        String this$gcsObjectMediaLink = this.getGcsObjectMediaLink();
        String other$gcsObjectMediaLink = other.getGcsObjectMediaLink();
        if (this$gcsObjectMediaLink == null ? other$gcsObjectMediaLink != null : !this$gcsObjectMediaLink.equals(other$gcsObjectMediaLink)) {
            return false;
        }
        String this$gcsObjectHoldType = this.getGcsObjectHoldType();
        String other$gcsObjectHoldType = other.getGcsObjectHoldType();
        if (this$gcsObjectHoldType == null ? other$gcsObjectHoldType != null : !this$gcsObjectHoldType.equals(other$gcsObjectHoldType)) {
            return false;
        }
        String this$gcsObjectCRC32CHash = this.getGcsObjectCRC32CHash();
        String other$gcsObjectCRC32CHash = other.getGcsObjectCRC32CHash();
        if (this$gcsObjectCRC32CHash == null ? other$gcsObjectCRC32CHash != null : !this$gcsObjectCRC32CHash.equals(other$gcsObjectCRC32CHash)) {
            return false;
        }
        String this$gcsObjectMD5Hash = this.getGcsObjectMD5Hash();
        String other$gcsObjectMD5Hash = other.getGcsObjectMD5Hash();
        if (this$gcsObjectMD5Hash == null ? other$gcsObjectMD5Hash != null : !this$gcsObjectMD5Hash.equals(other$gcsObjectMD5Hash)) {
            return false;
        }
        String this$gcsObjectContentType = this.getGcsObjectContentType();
        String other$gcsObjectContentType = other.getGcsObjectContentType();
        if (this$gcsObjectContentType == null ? other$gcsObjectContentType != null : !this$gcsObjectContentType.equals(other$gcsObjectContentType)) {
            return false;
        }
        String this$gcsObjectContentEncoding = this.getGcsObjectContentEncoding();
        String other$gcsObjectContentEncoding = other.getGcsObjectContentEncoding();
        if (this$gcsObjectContentEncoding == null ? other$gcsObjectContentEncoding != null : !this$gcsObjectContentEncoding.equals(other$gcsObjectContentEncoding)) {
            return false;
        }
        String this$gcsObjectContentDisposition = this.getGcsObjectContentDisposition();
        String other$gcsObjectContentDisposition = other.getGcsObjectContentDisposition();
        if (this$gcsObjectContentDisposition == null ? other$gcsObjectContentDisposition != null : !this$gcsObjectContentDisposition.equals(other$gcsObjectContentDisposition)) {
            return false;
        }
        String this$gcsObjectContentLanguage = this.getGcsObjectContentLanguage();
        String other$gcsObjectContentLanguage = other.getGcsObjectContentLanguage();
        if (this$gcsObjectContentLanguage == null ? other$gcsObjectContentLanguage != null : !this$gcsObjectContentLanguage.equals(other$gcsObjectContentLanguage)) {
            return false;
        }
        GCSBucket this$gcsBucket = this.getGcsBucket();
        GCSBucket other$gcsBucket = other.getGcsBucket();
        return !(this$gcsBucket == null ? other$gcsBucket != null : !((Object)this$gcsBucket).equals(other$gcsBucket));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GCSObject;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $gcsObjectSize = this.getGcsObjectSize();
        result = result * 59 + ($gcsObjectSize == null ? 43 : ((Object)$gcsObjectSize).hashCode());
        Long $gcsObjectGenerationId = this.getGcsObjectGenerationId();
        result = result * 59 + ($gcsObjectGenerationId == null ? 43 : ((Object)$gcsObjectGenerationId).hashCode());
        Long $gcsObjectDataLastModifiedTime = this.getGcsObjectDataLastModifiedTime();
        result = result * 59 + ($gcsObjectDataLastModifiedTime == null ? 43 : ((Object)$gcsObjectDataLastModifiedTime).hashCode());
        Long $gcsObjectRetentionExpirationDate = this.getGcsObjectRetentionExpirationDate();
        result = result * 59 + ($gcsObjectRetentionExpirationDate == null ? 43 : ((Object)$gcsObjectRetentionExpirationDate).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $gcsBucketName = this.getGcsBucketName();
        result = result * 59 + ($gcsBucketName == null ? 43 : $gcsBucketName.hashCode());
        String $gcsBucketQualifiedName = this.getGcsBucketQualifiedName();
        result = result * 59 + ($gcsBucketQualifiedName == null ? 43 : $gcsBucketQualifiedName.hashCode());
        String $gcsObjectKey = this.getGcsObjectKey();
        result = result * 59 + ($gcsObjectKey == null ? 43 : $gcsObjectKey.hashCode());
        String $gcsObjectMediaLink = this.getGcsObjectMediaLink();
        result = result * 59 + ($gcsObjectMediaLink == null ? 43 : $gcsObjectMediaLink.hashCode());
        String $gcsObjectHoldType = this.getGcsObjectHoldType();
        result = result * 59 + ($gcsObjectHoldType == null ? 43 : $gcsObjectHoldType.hashCode());
        String $gcsObjectCRC32CHash = this.getGcsObjectCRC32CHash();
        result = result * 59 + ($gcsObjectCRC32CHash == null ? 43 : $gcsObjectCRC32CHash.hashCode());
        String $gcsObjectMD5Hash = this.getGcsObjectMD5Hash();
        result = result * 59 + ($gcsObjectMD5Hash == null ? 43 : $gcsObjectMD5Hash.hashCode());
        String $gcsObjectContentType = this.getGcsObjectContentType();
        result = result * 59 + ($gcsObjectContentType == null ? 43 : $gcsObjectContentType.hashCode());
        String $gcsObjectContentEncoding = this.getGcsObjectContentEncoding();
        result = result * 59 + ($gcsObjectContentEncoding == null ? 43 : $gcsObjectContentEncoding.hashCode());
        String $gcsObjectContentDisposition = this.getGcsObjectContentDisposition();
        result = result * 59 + ($gcsObjectContentDisposition == null ? 43 : $gcsObjectContentDisposition.hashCode());
        String $gcsObjectContentLanguage = this.getGcsObjectContentLanguage();
        result = result * 59 + ($gcsObjectContentLanguage == null ? 43 : $gcsObjectContentLanguage.hashCode());
        GCSBucket $gcsBucket = this.getGcsBucket();
        result = result * 59 + ($gcsBucket == null ? 43 : ((Object)$gcsBucket).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class GCSObjectBuilderImpl
    extends GCSObjectBuilder<GCSObject, GCSObjectBuilderImpl> {
        @Generated
        private GCSObjectBuilderImpl() {
        }

        @Override
        @Generated
        protected GCSObjectBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public GCSObject build() {
            return new GCSObject(this);
        }
    }

    @Generated
    public static abstract class GCSObjectBuilder<C extends GCSObject, B extends GCSObjectBuilder<C, B>>
    extends GCS.GCSBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String gcsBucketName;
        @Generated
        private String gcsBucketQualifiedName;
        @Generated
        private Long gcsObjectSize;
        @Generated
        private String gcsObjectKey;
        @Generated
        private String gcsObjectMediaLink;
        @Generated
        private String gcsObjectHoldType;
        @Generated
        private Long gcsObjectGenerationId;
        @Generated
        private String gcsObjectCRC32CHash;
        @Generated
        private String gcsObjectMD5Hash;
        @Generated
        private Long gcsObjectDataLastModifiedTime;
        @Generated
        private String gcsObjectContentType;
        @Generated
        private String gcsObjectContentEncoding;
        @Generated
        private String gcsObjectContentDisposition;
        @Generated
        private String gcsObjectContentLanguage;
        @Generated
        private Long gcsObjectRetentionExpirationDate;
        @Generated
        private GCSBucket gcsBucket;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            GCSObjectBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(GCSObject instance, GCSObjectBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.gcsBucketName(instance.gcsBucketName);
            b.gcsBucketQualifiedName(instance.gcsBucketQualifiedName);
            b.gcsObjectSize(instance.gcsObjectSize);
            b.gcsObjectKey(instance.gcsObjectKey);
            b.gcsObjectMediaLink(instance.gcsObjectMediaLink);
            b.gcsObjectHoldType(instance.gcsObjectHoldType);
            b.gcsObjectGenerationId(instance.gcsObjectGenerationId);
            b.gcsObjectCRC32CHash(instance.gcsObjectCRC32CHash);
            b.gcsObjectMD5Hash(instance.gcsObjectMD5Hash);
            b.gcsObjectDataLastModifiedTime(instance.gcsObjectDataLastModifiedTime);
            b.gcsObjectContentType(instance.gcsObjectContentType);
            b.gcsObjectContentEncoding(instance.gcsObjectContentEncoding);
            b.gcsObjectContentDisposition(instance.gcsObjectContentDisposition);
            b.gcsObjectContentLanguage(instance.gcsObjectContentLanguage);
            b.gcsObjectRetentionExpirationDate(instance.gcsObjectRetentionExpirationDate);
            b.gcsBucket(instance.gcsBucket);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B gcsBucketName(String gcsBucketName) {
            this.gcsBucketName = gcsBucketName;
            return (B)this.self();
        }

        @Generated
        public B gcsBucketQualifiedName(String gcsBucketQualifiedName) {
            this.gcsBucketQualifiedName = gcsBucketQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B gcsObjectSize(Long gcsObjectSize) {
            this.gcsObjectSize = gcsObjectSize;
            return (B)this.self();
        }

        @Generated
        public B gcsObjectKey(String gcsObjectKey) {
            this.gcsObjectKey = gcsObjectKey;
            return (B)this.self();
        }

        @Generated
        public B gcsObjectMediaLink(String gcsObjectMediaLink) {
            this.gcsObjectMediaLink = gcsObjectMediaLink;
            return (B)this.self();
        }

        @Generated
        public B gcsObjectHoldType(String gcsObjectHoldType) {
            this.gcsObjectHoldType = gcsObjectHoldType;
            return (B)this.self();
        }

        @Generated
        public B gcsObjectGenerationId(Long gcsObjectGenerationId) {
            this.gcsObjectGenerationId = gcsObjectGenerationId;
            return (B)this.self();
        }

        @Generated
        public B gcsObjectCRC32CHash(String gcsObjectCRC32CHash) {
            this.gcsObjectCRC32CHash = gcsObjectCRC32CHash;
            return (B)this.self();
        }

        @Generated
        public B gcsObjectMD5Hash(String gcsObjectMD5Hash) {
            this.gcsObjectMD5Hash = gcsObjectMD5Hash;
            return (B)this.self();
        }

        @Generated
        public B gcsObjectDataLastModifiedTime(Long gcsObjectDataLastModifiedTime) {
            this.gcsObjectDataLastModifiedTime = gcsObjectDataLastModifiedTime;
            return (B)this.self();
        }

        @Generated
        public B gcsObjectContentType(String gcsObjectContentType) {
            this.gcsObjectContentType = gcsObjectContentType;
            return (B)this.self();
        }

        @Generated
        public B gcsObjectContentEncoding(String gcsObjectContentEncoding) {
            this.gcsObjectContentEncoding = gcsObjectContentEncoding;
            return (B)this.self();
        }

        @Generated
        public B gcsObjectContentDisposition(String gcsObjectContentDisposition) {
            this.gcsObjectContentDisposition = gcsObjectContentDisposition;
            return (B)this.self();
        }

        @Generated
        public B gcsObjectContentLanguage(String gcsObjectContentLanguage) {
            this.gcsObjectContentLanguage = gcsObjectContentLanguage;
            return (B)this.self();
        }

        @Generated
        public B gcsObjectRetentionExpirationDate(Long gcsObjectRetentionExpirationDate) {
            this.gcsObjectRetentionExpirationDate = gcsObjectRetentionExpirationDate;
            return (B)this.self();
        }

        @Generated
        public B gcsBucket(GCSBucket gcsBucket) {
            this.gcsBucket = gcsBucket;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "GCSObject.GCSObjectBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", gcsBucketName=" + this.gcsBucketName + ", gcsBucketQualifiedName=" + this.gcsBucketQualifiedName + ", gcsObjectSize=" + this.gcsObjectSize + ", gcsObjectKey=" + this.gcsObjectKey + ", gcsObjectMediaLink=" + this.gcsObjectMediaLink + ", gcsObjectHoldType=" + this.gcsObjectHoldType + ", gcsObjectGenerationId=" + this.gcsObjectGenerationId + ", gcsObjectCRC32CHash=" + this.gcsObjectCRC32CHash + ", gcsObjectMD5Hash=" + this.gcsObjectMD5Hash + ", gcsObjectDataLastModifiedTime=" + this.gcsObjectDataLastModifiedTime + ", gcsObjectContentType=" + this.gcsObjectContentType + ", gcsObjectContentEncoding=" + this.gcsObjectContentEncoding + ", gcsObjectContentDisposition=" + this.gcsObjectContentDisposition + ", gcsObjectContentLanguage=" + this.gcsObjectContentLanguage + ", gcsObjectRetentionExpirationDate=" + this.gcsObjectRetentionExpirationDate + ", gcsBucket=" + this.gcsBucket + ")";
        }
    }
}

