/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import co.elastic.clients.elasticsearch._types.FieldSort;
import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.SortOrder;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.TermQuery;
import com.atlan.exception.AtlanException;
import com.atlan.exception.InvalidRequestException;
import com.atlan.exception.LogicException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryCategory;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.IndexSearchDSL;
import com.atlan.model.search.IndexSearchRequest;
import com.atlan.model.search.IndexSearchResponse;
import com.atlan.util.QueryFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Glossary
extends Asset {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Glossary.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "AtlasGlossary";
    String typeName;
    @Attribute
    String shortDescription;
    @Attribute
    String longDescription;
    @Attribute
    String language;
    @Attribute
    String usage;
    @Attribute
    Map<String, String> additionalAttributes;
    @Attribute
    SortedSet<GlossaryTerm> terms;
    @Attribute
    SortedSet<GlossaryCategory> categories;

    static Glossary anchorLink(String glossaryGuid, String glossaryQualifiedName) {
        Glossary anchor = null;
        if (glossaryGuid == null && glossaryQualifiedName == null) {
            return null;
        }
        anchor = glossaryGuid != null ? Glossary.refByGuid(glossaryGuid) : Glossary.refByQualifiedName(glossaryQualifiedName);
        return anchor;
    }

    public static Glossary refByGuid(String guid) {
        return ((GlossaryBuilder)Glossary.builder().guid(guid)).build();
    }

    public static Glossary refByQualifiedName(String qualifiedName) {
        return ((GlossaryBuilder)Glossary.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static GlossaryBuilder<?, ?> creator(String name) {
        return (GlossaryBuilder)((GlossaryBuilder)Glossary.builder().qualifiedName(name)).name(name);
    }

    public static GlossaryBuilder<?, ?> updater(String guid, String name) {
        return (GlossaryBuilder)((GlossaryBuilder)((GlossaryBuilder)Glossary.builder().guid(guid)).qualifiedName(name)).name(name);
    }

    protected GlossaryBuilder<?, ?> trimToRequired() {
        return Glossary.updater(this.getGuid(), this.getName());
    }

    public static Glossary findByName(String name, Collection<String> attributes) throws AtlanException {
        AtlanObject request;
        IndexSearchResponse response;
        Query byType = QueryFactory.withType(TYPE_NAME);
        Query byName = QueryFactory.withExactName(name);
        Query active = QueryFactory.active();
        Query filter = BoolQuery.of(b -> b.filter(byType, new Query[]{byName, active}))._toQuery();
        Object builder = IndexSearchRequest.builder().dsl((IndexSearchDSL)((IndexSearchDSL.IndexSearchDSLBuilder)((IndexSearchDSL.IndexSearchDSLBuilder)((IndexSearchDSL.IndexSearchDSLBuilder)IndexSearchDSL.builder().from(0)).size(2)).query(filter)).build());
        if (attributes != null && !attributes.isEmpty()) {
            ((IndexSearchRequest.IndexSearchRequestBuilder)builder).attributes(attributes);
        }
        if ((response = ((IndexSearchRequest)(request = ((IndexSearchRequest.IndexSearchRequestBuilder)builder).build())).search()) != null) {
            List<Entity> results;
            long count = response.getApproximateCount();
            if (count > 1L) {
                log.warn("Multiple glossaries found with the name '{}', returning only the first.", (Object)name);
            }
            if ((results = response.getEntities()) != null && !results.isEmpty()) {
                Entity first = results.get(0);
                if (first instanceof Glossary) {
                    return (Glossary)first;
                }
                throw new LogicException("Found a non-glossary result when searching for only glossaries.", "ATLAN-JAVA-CLIENT-500-090", 500);
            }
        }
        throw new NotFoundException("Unable to find a glossary with the name: " + name, "ATLAN-JAVA-CLIENT-404-090", 404, null);
    }

    public static Glossary retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof Glossary) {
            return (Glossary)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a Glossary.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static Glossary retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof Glossary) {
            return (Glossary)entity;
        }
        throw new NotFoundException("No Glossary found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public CategoryHierarchy getHierarchy() throws AtlanException {
        return this.getHierarchy(null);
    }

    public CategoryHierarchy getHierarchy(List<String> attributes) throws AtlanException {
        AtlanObject request;
        IndexSearchResponse response;
        if (this.qualifiedName == null) {
            throw new InvalidRequestException("Insufficient glossary to query against: no qualifiedName.", "qualifiedName", "ATLAN-JAVA-CLIENT-400-091", 400, null);
        }
        Query byType = QueryFactory.withType("AtlasGlossaryCategory");
        Query byGlossaryQN = TermQuery.of(t -> t.field("__glossary").value(this.getQualifiedName()))._toQuery();
        Query active = QueryFactory.active();
        Query filter = BoolQuery.of(b -> b.filter(byType, new Query[]{byGlossaryQN, active}))._toQuery();
        Object builder = ((IndexSearchRequest.IndexSearchRequestBuilder)IndexSearchRequest.builder().dsl((IndexSearchDSL)((IndexSearchDSL.IndexSearchDSLBuilder)((IndexSearchDSL.IndexSearchDSLBuilder)((IndexSearchDSL.IndexSearchDSLBuilder)((IndexSearchDSL.IndexSearchDSLBuilder)IndexSearchDSL.builder().from(0)).size(20)).query(filter)).sortOption(SortOptions.of(s -> s.field(FieldSort.of(f -> f.field("name.keyword").order(SortOrder.Asc)))))).build())).attribute("parentCategory");
        if (attributes != null) {
            builder = ((IndexSearchRequest.IndexSearchRequestBuilder)builder).attributes(attributes);
        }
        if ((response = ((IndexSearchRequest)(request = ((IndexSearchRequest.IndexSearchRequestBuilder)builder).build())).search()) != null) {
            LinkedHashSet<String> topCategories = new LinkedHashSet<String>();
            HashMap<String, GlossaryCategory> categoryMap = new HashMap<String, GlossaryCategory>();
            List<Entity> results = response.getEntities();
            while (results != null) {
                for (Entity one : results) {
                    if (one instanceof GlossaryCategory) {
                        GlossaryCategory category = (GlossaryCategory)one;
                        categoryMap.put(category.getGuid(), category);
                        if (category.getParentCategory() != null) continue;
                        topCategories.add(category.getGuid());
                        continue;
                    }
                    throw new LogicException("Found a non-category result when searching for only categories.", "ATLAN-JAVA-CLIENT-500-091", 500);
                }
                response = response.getNextPage();
                results = response.getEntities();
            }
            return new CategoryHierarchy(topCategories, categoryMap);
        }
        throw new NotFoundException("Unable to find any categories in glossary: " + this.getGuid() + "/" + this.getQualifiedName(), "ATLAN-JAVA-CLIENT-404-091", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static Glossary removeDescription(String qualifiedName, String name) throws AtlanException {
        return (Glossary)Asset.removeDescription(((GlossaryBuilder)Glossary.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static Glossary removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (Glossary)Asset.removeUserDescription(((GlossaryBuilder)Glossary.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static Glossary removeOwners(String qualifiedName, String name) throws AtlanException {
        return (Glossary)Asset.removeOwners(((GlossaryBuilder)Glossary.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static Glossary updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (Glossary)Asset.updateCertificate(Glossary.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static Glossary removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (Glossary)Asset.removeCertificate(((GlossaryBuilder)Glossary.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static Glossary updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (Glossary)Asset.updateAnnouncement(Glossary.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static Glossary removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (Glossary)Asset.removeAnnouncement(((GlossaryBuilder)Glossary.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected Glossary(GlossaryBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        Map<Object, Object> additionalAttributes;
        this.typeName = b.typeName$set ? b.typeName$value : Glossary.$default$typeName();
        this.shortDescription = b.shortDescription;
        this.longDescription = b.longDescription;
        this.language = b.language;
        this.usage = b.usage;
        switch (b.additionalAttributes$key == null ? 0 : b.additionalAttributes$key.size()) {
            case 0: {
                additionalAttributes = Collections.emptyMap();
                break;
            }
            case 1: {
                additionalAttributes = Collections.singletonMap(b.additionalAttributes$key.get(0), b.additionalAttributes$value.get(0));
                break;
            }
            default: {
                additionalAttributes = new LinkedHashMap(b.additionalAttributes$key.size() < 0x40000000 ? 1 + b.additionalAttributes$key.size() + (b.additionalAttributes$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.additionalAttributes$key.size(); ++$i) {
                    additionalAttributes.put(b.additionalAttributes$key.get($i), b.additionalAttributes$value.get($i));
                }
                additionalAttributes = Collections.unmodifiableMap(additionalAttributes);
            }
        }
        this.additionalAttributes = additionalAttributes;
        SortedSet<GlossaryTerm> terms = new TreeSet<GlossaryTerm>();
        if (b.terms != null) {
            terms.addAll(b.terms);
        }
        terms = Collections.unmodifiableSortedSet(terms);
        this.terms = terms;
        SortedSet<GlossaryCategory> categories = new TreeSet<GlossaryCategory>();
        if (b.categories != null) {
            categories.addAll(b.categories);
        }
        categories = Collections.unmodifiableSortedSet(categories);
        this.categories = categories;
    }

    @Generated
    public static GlossaryBuilder<?, ?> builder() {
        return new GlossaryBuilderImpl();
    }

    @Generated
    public GlossaryBuilder<?, ?> toBuilder() {
        return new GlossaryBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getShortDescription() {
        return this.shortDescription;
    }

    @Generated
    public String getLongDescription() {
        return this.longDescription;
    }

    @Generated
    public String getLanguage() {
        return this.language;
    }

    @Generated
    public String getUsage() {
        return this.usage;
    }

    @Generated
    public Map<String, String> getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    @Generated
    public SortedSet<GlossaryTerm> getTerms() {
        return this.terms;
    }

    @Generated
    public SortedSet<GlossaryCategory> getCategories() {
        return this.categories;
    }

    @Generated
    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    @Generated
    public void setLongDescription(String longDescription) {
        this.longDescription = longDescription;
    }

    @Generated
    public void setLanguage(String language) {
        this.language = language;
    }

    @Generated
    public void setUsage(String usage) {
        this.usage = usage;
    }

    @Generated
    public void setAdditionalAttributes(Map<String, String> additionalAttributes) {
        this.additionalAttributes = additionalAttributes;
    }

    @Generated
    public void setTerms(SortedSet<GlossaryTerm> terms) {
        this.terms = terms;
    }

    @Generated
    public void setCategories(SortedSet<GlossaryCategory> categories) {
        this.categories = categories;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Glossary)) {
            return false;
        }
        Glossary other = (Glossary)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$shortDescription = this.getShortDescription();
        String other$shortDescription = other.getShortDescription();
        if (this$shortDescription == null ? other$shortDescription != null : !this$shortDescription.equals(other$shortDescription)) {
            return false;
        }
        String this$longDescription = this.getLongDescription();
        String other$longDescription = other.getLongDescription();
        if (this$longDescription == null ? other$longDescription != null : !this$longDescription.equals(other$longDescription)) {
            return false;
        }
        String this$language = this.getLanguage();
        String other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
            return false;
        }
        String this$usage = this.getUsage();
        String other$usage = other.getUsage();
        if (this$usage == null ? other$usage != null : !this$usage.equals(other$usage)) {
            return false;
        }
        Map<String, String> this$additionalAttributes = this.getAdditionalAttributes();
        Map<String, String> other$additionalAttributes = other.getAdditionalAttributes();
        if (this$additionalAttributes == null ? other$additionalAttributes != null : !((Object)this$additionalAttributes).equals(other$additionalAttributes)) {
            return false;
        }
        SortedSet<GlossaryTerm> this$terms = this.getTerms();
        SortedSet<GlossaryTerm> other$terms = other.getTerms();
        if (this$terms == null ? other$terms != null : !this$terms.equals(other$terms)) {
            return false;
        }
        SortedSet<GlossaryCategory> this$categories = this.getCategories();
        SortedSet<GlossaryCategory> other$categories = other.getCategories();
        return !(this$categories == null ? other$categories != null : !this$categories.equals(other$categories));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Glossary;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $shortDescription = this.getShortDescription();
        result = result * 59 + ($shortDescription == null ? 43 : $shortDescription.hashCode());
        String $longDescription = this.getLongDescription();
        result = result * 59 + ($longDescription == null ? 43 : $longDescription.hashCode());
        String $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        String $usage = this.getUsage();
        result = result * 59 + ($usage == null ? 43 : $usage.hashCode());
        Map<String, String> $additionalAttributes = this.getAdditionalAttributes();
        result = result * 59 + ($additionalAttributes == null ? 43 : ((Object)$additionalAttributes).hashCode());
        SortedSet<GlossaryTerm> $terms = this.getTerms();
        result = result * 59 + ($terms == null ? 43 : $terms.hashCode());
        SortedSet<GlossaryCategory> $categories = this.getCategories();
        result = result * 59 + ($categories == null ? 43 : $categories.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class GlossaryBuilderImpl
    extends GlossaryBuilder<Glossary, GlossaryBuilderImpl> {
        @Generated
        private GlossaryBuilderImpl() {
        }

        @Override
        @Generated
        protected GlossaryBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Glossary build() {
            return new Glossary(this);
        }
    }

    @Generated
    public static abstract class GlossaryBuilder<C extends Glossary, B extends GlossaryBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String shortDescription;
        @Generated
        private String longDescription;
        @Generated
        private String language;
        @Generated
        private String usage;
        @Generated
        private ArrayList<String> additionalAttributes$key;
        @Generated
        private ArrayList<String> additionalAttributes$value;
        @Generated
        private ArrayList<GlossaryTerm> terms;
        @Generated
        private ArrayList<GlossaryCategory> categories;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            GlossaryBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Glossary instance, GlossaryBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.shortDescription(instance.shortDescription);
            b.longDescription(instance.longDescription);
            b.language(instance.language);
            b.usage(instance.usage);
            b.additionalAttributes(instance.additionalAttributes == null ? Collections.emptyMap() : instance.additionalAttributes);
            b.terms(instance.terms == null ? Collections.emptySortedSet() : instance.terms);
            b.categories(instance.categories == null ? Collections.emptySortedSet() : instance.categories);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B shortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
            return (B)this.self();
        }

        @Generated
        public B longDescription(String longDescription) {
            this.longDescription = longDescription;
            return (B)this.self();
        }

        @Generated
        public B language(String language) {
            this.language = language;
            return (B)this.self();
        }

        @Generated
        public B usage(String usage) {
            this.usage = usage;
            return (B)this.self();
        }

        @Generated
        public B additionalAttribute(String additionalAttributeKey, String additionalAttributeValue) {
            if (this.additionalAttributes$key == null) {
                this.additionalAttributes$key = new ArrayList();
                this.additionalAttributes$value = new ArrayList();
            }
            this.additionalAttributes$key.add(additionalAttributeKey);
            this.additionalAttributes$value.add(additionalAttributeValue);
            return (B)this.self();
        }

        @Generated
        public B additionalAttributes(Map<? extends String, ? extends String> additionalAttributes) {
            if (additionalAttributes == null) {
                throw new NullPointerException("additionalAttributes cannot be null");
            }
            if (this.additionalAttributes$key == null) {
                this.additionalAttributes$key = new ArrayList();
                this.additionalAttributes$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : additionalAttributes.entrySet()) {
                this.additionalAttributes$key.add($lombokEntry.getKey());
                this.additionalAttributes$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearAdditionalAttributes() {
            if (this.additionalAttributes$key != null) {
                this.additionalAttributes$key.clear();
                this.additionalAttributes$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B term(GlossaryTerm term) {
            if (this.terms == null) {
                this.terms = new ArrayList();
            }
            this.terms.add(term);
            return (B)this.self();
        }

        @Generated
        public B terms(Collection<? extends GlossaryTerm> terms) {
            if (terms == null) {
                throw new NullPointerException("terms cannot be null");
            }
            if (this.terms == null) {
                this.terms = new ArrayList();
            }
            this.terms.addAll(terms);
            return (B)this.self();
        }

        @Generated
        public B clearTerms() {
            if (this.terms != null) {
                this.terms.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B category(GlossaryCategory category) {
            if (this.categories == null) {
                this.categories = new ArrayList();
            }
            this.categories.add(category);
            return (B)this.self();
        }

        @Generated
        public B categories(Collection<? extends GlossaryCategory> categories) {
            if (categories == null) {
                throw new NullPointerException("categories cannot be null");
            }
            if (this.categories == null) {
                this.categories = new ArrayList();
            }
            this.categories.addAll(categories);
            return (B)this.self();
        }

        @Generated
        public B clearCategories() {
            if (this.categories != null) {
                this.categories.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "Glossary.GlossaryBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", shortDescription=" + this.shortDescription + ", longDescription=" + this.longDescription + ", language=" + this.language + ", usage=" + this.usage + ", additionalAttributes$key=" + this.additionalAttributes$key + ", additionalAttributes$value=" + this.additionalAttributes$value + ", terms=" + this.terms + ", categories=" + this.categories + ")";
        }
    }

    public static class CategoryHierarchy {
        private final Set<String> topLevel;
        private final List<GlossaryCategory> rootCategories;
        private final Map<String, GlossaryCategory> map;

        private CategoryHierarchy(Set<String> topLevel, Map<String, GlossaryCategory> stubMap) {
            this.topLevel = topLevel;
            this.rootCategories = new ArrayList<GlossaryCategory>();
            this.map = new LinkedHashMap<String, GlossaryCategory>();
            this.buildMaps(stubMap);
        }

        private void buildMaps(Map<String, GlossaryCategory> stubMap) {
            for (Map.Entry<String, GlossaryCategory> entry : stubMap.entrySet()) {
                GlossaryCategory category = entry.getValue();
                GlossaryCategory parent = category.getParentCategory();
                if (parent == null) continue;
                String parentGuid = parent.getGuid();
                GlossaryCategory fullParent = this.map.getOrDefault(parentGuid, stubMap.get(parentGuid));
                TreeSet<GlossaryCategory> children = new TreeSet<GlossaryCategory>(fullParent.getChildrenCategories());
                children.add(category);
                fullParent.setChildrenCategories(children);
                this.map.put(parent.getGuid(), fullParent);
            }
        }

        public List<GlossaryCategory> getRootCategories() {
            if (this.rootCategories.isEmpty()) {
                for (String top : this.topLevel) {
                    this.rootCategories.add(this.map.get(top));
                }
            }
            return Collections.unmodifiableList(this.rootCategories);
        }

        public List<GlossaryCategory> breadthFirst() {
            List<GlossaryCategory> top = this.getRootCategories();
            ArrayList<GlossaryCategory> all = new ArrayList<GlossaryCategory>(top);
            this.bfs(all, top);
            return Collections.unmodifiableList(all);
        }

        public List<GlossaryCategory> depthFirst() {
            ArrayList<GlossaryCategory> all = new ArrayList<GlossaryCategory>();
            this.dfs(all, this.getRootCategories());
            return Collections.unmodifiableList(all);
        }

        private void bfs(List<GlossaryCategory> list, Collection<GlossaryCategory> toAdd) {
            for (GlossaryCategory node : toAdd) {
                list.addAll(node.getChildrenCategories());
            }
            for (GlossaryCategory node : toAdd) {
                this.bfs(list, node.getChildrenCategories());
            }
        }

        private void dfs(List<GlossaryCategory> list, Collection<GlossaryCategory> toAdd) {
            for (GlossaryCategory node : toAdd) {
                list.add(node);
                this.dfs(list, node.getChildrenCategories());
            }
        }
    }
}

