/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Glossary;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class GlossaryCategory
extends Asset {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "AtlasGlossaryCategory";
    String typeName;
    @Attribute
    String shortDescription;
    @Attribute
    String longDescription;
    @Attribute
    Map<String, String> additionalAttributes;
    @Attribute
    SortedSet<GlossaryTerm> terms;
    @Attribute
    Glossary anchor;
    @Attribute
    GlossaryCategory parentCategory;
    @Attribute
    SortedSet<GlossaryCategory> childrenCategories;

    public static GlossaryCategory refByGuid(String guid) {
        return ((GlossaryCategoryBuilder)GlossaryCategory.builder().guid(guid)).build();
    }

    public static GlossaryCategory refByQualifiedName(String qualifiedName) {
        return ((GlossaryCategoryBuilder)GlossaryCategory.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static GlossaryCategoryBuilder<?, ?> creator(String name, String glossaryGuid, String glossaryQualifiedName) {
        return ((GlossaryCategoryBuilder)((GlossaryCategoryBuilder)GlossaryCategory.builder().qualifiedName(name)).name(name)).anchor(Glossary.anchorLink(glossaryGuid, glossaryQualifiedName));
    }

    public static GlossaryCategoryBuilder<?, ?> updater(String qualifiedName, String name, String glossaryGuid) {
        return ((GlossaryCategoryBuilder)((GlossaryCategoryBuilder)GlossaryCategory.builder().qualifiedName(qualifiedName)).name(name)).anchor(Glossary.anchorLink(glossaryGuid, null));
    }

    protected GlossaryCategoryBuilder<?, ?> trimToRequired() {
        return GlossaryCategory.updater(this.getQualifiedName(), this.getName(), this.getAnchor().getGuid());
    }

    public static GlossaryCategory retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof GlossaryCategory) {
            return (GlossaryCategory)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a GlossaryCategory.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static GlossaryCategory retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof GlossaryCategory) {
            return (GlossaryCategory)entity;
        }
        throw new NotFoundException("No GlossaryCategory found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static GlossaryCategory removeDescription(String qualifiedName, String name, String glossaryGuid) throws AtlanException {
        return (GlossaryCategory)Asset.removeDescription(GlossaryCategory.updater(qualifiedName, name, glossaryGuid));
    }

    public static GlossaryCategory removeUserDescription(String qualifiedName, String name, String glossaryGuid) throws AtlanException {
        return (GlossaryCategory)Asset.removeUserDescription(GlossaryCategory.updater(qualifiedName, name, glossaryGuid));
    }

    public static GlossaryCategory removeOwners(String qualifiedName, String name, String glossaryGuid) throws AtlanException {
        return (GlossaryCategory)Asset.removeOwners(GlossaryCategory.updater(qualifiedName, name, glossaryGuid));
    }

    public static GlossaryCategory updateCertificate(String qualifiedName, String name, String glossaryGuid, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (GlossaryCategory)Asset.updateCertificate(GlossaryCategory.updater(qualifiedName, name, glossaryGuid), certificate, message);
    }

    public static GlossaryCategory removeCertificate(String qualifiedName, String name, String glossaryGuid) throws AtlanException {
        return (GlossaryCategory)Asset.removeCertificate(GlossaryCategory.updater(qualifiedName, name, glossaryGuid));
    }

    public static GlossaryCategory updateAnnouncement(String qualifiedName, String name, String glossaryGuid, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (GlossaryCategory)Asset.updateAnnouncement(GlossaryCategory.updater(qualifiedName, name, glossaryGuid), type, title, message);
    }

    public static GlossaryCategory removeAnnouncement(String qualifiedName, String name, String glossaryGuid) throws AtlanException {
        return (GlossaryCategory)Asset.removeAnnouncement(GlossaryCategory.updater(qualifiedName, name, glossaryGuid));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected GlossaryCategory(GlossaryCategoryBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        Map<Object, Object> additionalAttributes;
        this.typeName = b.typeName$set ? b.typeName$value : GlossaryCategory.$default$typeName();
        this.shortDescription = b.shortDescription;
        this.longDescription = b.longDescription;
        switch (b.additionalAttributes$key == null ? 0 : b.additionalAttributes$key.size()) {
            case 0: {
                additionalAttributes = Collections.emptyMap();
                break;
            }
            case 1: {
                additionalAttributes = Collections.singletonMap(b.additionalAttributes$key.get(0), b.additionalAttributes$value.get(0));
                break;
            }
            default: {
                additionalAttributes = new LinkedHashMap(b.additionalAttributes$key.size() < 0x40000000 ? 1 + b.additionalAttributes$key.size() + (b.additionalAttributes$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.additionalAttributes$key.size(); ++$i) {
                    additionalAttributes.put(b.additionalAttributes$key.get($i), b.additionalAttributes$value.get($i));
                }
                additionalAttributes = Collections.unmodifiableMap(additionalAttributes);
            }
        }
        this.additionalAttributes = additionalAttributes;
        SortedSet<GlossaryTerm> terms = new TreeSet<GlossaryTerm>();
        if (b.terms != null) {
            terms.addAll(b.terms);
        }
        terms = Collections.unmodifiableSortedSet(terms);
        this.terms = terms;
        this.anchor = b.anchor;
        this.parentCategory = b.parentCategory;
        SortedSet<GlossaryCategory> childrenCategories = new TreeSet<GlossaryCategory>();
        if (b.childrenCategories != null) {
            childrenCategories.addAll(b.childrenCategories);
        }
        childrenCategories = Collections.unmodifiableSortedSet(childrenCategories);
        this.childrenCategories = childrenCategories;
    }

    @Generated
    public static GlossaryCategoryBuilder<?, ?> builder() {
        return new GlossaryCategoryBuilderImpl();
    }

    @Generated
    public GlossaryCategoryBuilder<?, ?> toBuilder() {
        return new GlossaryCategoryBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getShortDescription() {
        return this.shortDescription;
    }

    @Generated
    public String getLongDescription() {
        return this.longDescription;
    }

    @Generated
    public Map<String, String> getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    @Generated
    public SortedSet<GlossaryTerm> getTerms() {
        return this.terms;
    }

    @Generated
    public Glossary getAnchor() {
        return this.anchor;
    }

    @Generated
    public GlossaryCategory getParentCategory() {
        return this.parentCategory;
    }

    @Generated
    public SortedSet<GlossaryCategory> getChildrenCategories() {
        return this.childrenCategories;
    }

    @Generated
    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    @Generated
    public void setLongDescription(String longDescription) {
        this.longDescription = longDescription;
    }

    @Generated
    public void setAdditionalAttributes(Map<String, String> additionalAttributes) {
        this.additionalAttributes = additionalAttributes;
    }

    @Generated
    public void setTerms(SortedSet<GlossaryTerm> terms) {
        this.terms = terms;
    }

    @Generated
    public void setAnchor(Glossary anchor) {
        this.anchor = anchor;
    }

    @Generated
    public void setParentCategory(GlossaryCategory parentCategory) {
        this.parentCategory = parentCategory;
    }

    @Generated
    public void setChildrenCategories(SortedSet<GlossaryCategory> childrenCategories) {
        this.childrenCategories = childrenCategories;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GlossaryCategory)) {
            return false;
        }
        GlossaryCategory other = (GlossaryCategory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$shortDescription = this.getShortDescription();
        String other$shortDescription = other.getShortDescription();
        if (this$shortDescription == null ? other$shortDescription != null : !this$shortDescription.equals(other$shortDescription)) {
            return false;
        }
        String this$longDescription = this.getLongDescription();
        String other$longDescription = other.getLongDescription();
        if (this$longDescription == null ? other$longDescription != null : !this$longDescription.equals(other$longDescription)) {
            return false;
        }
        Map<String, String> this$additionalAttributes = this.getAdditionalAttributes();
        Map<String, String> other$additionalAttributes = other.getAdditionalAttributes();
        if (this$additionalAttributes == null ? other$additionalAttributes != null : !((Object)this$additionalAttributes).equals(other$additionalAttributes)) {
            return false;
        }
        SortedSet<GlossaryTerm> this$terms = this.getTerms();
        SortedSet<GlossaryTerm> other$terms = other.getTerms();
        if (this$terms == null ? other$terms != null : !this$terms.equals(other$terms)) {
            return false;
        }
        Glossary this$anchor = this.getAnchor();
        Glossary other$anchor = other.getAnchor();
        if (this$anchor == null ? other$anchor != null : !((Object)this$anchor).equals(other$anchor)) {
            return false;
        }
        GlossaryCategory this$parentCategory = this.getParentCategory();
        GlossaryCategory other$parentCategory = other.getParentCategory();
        if (this$parentCategory == null ? other$parentCategory != null : !((Object)this$parentCategory).equals(other$parentCategory)) {
            return false;
        }
        SortedSet<GlossaryCategory> this$childrenCategories = this.getChildrenCategories();
        SortedSet<GlossaryCategory> other$childrenCategories = other.getChildrenCategories();
        return !(this$childrenCategories == null ? other$childrenCategories != null : !this$childrenCategories.equals(other$childrenCategories));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GlossaryCategory;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $shortDescription = this.getShortDescription();
        result = result * 59 + ($shortDescription == null ? 43 : $shortDescription.hashCode());
        String $longDescription = this.getLongDescription();
        result = result * 59 + ($longDescription == null ? 43 : $longDescription.hashCode());
        Map<String, String> $additionalAttributes = this.getAdditionalAttributes();
        result = result * 59 + ($additionalAttributes == null ? 43 : ((Object)$additionalAttributes).hashCode());
        SortedSet<GlossaryTerm> $terms = this.getTerms();
        result = result * 59 + ($terms == null ? 43 : $terms.hashCode());
        Glossary $anchor = this.getAnchor();
        result = result * 59 + ($anchor == null ? 43 : ((Object)$anchor).hashCode());
        GlossaryCategory $parentCategory = this.getParentCategory();
        result = result * 59 + ($parentCategory == null ? 43 : ((Object)$parentCategory).hashCode());
        SortedSet<GlossaryCategory> $childrenCategories = this.getChildrenCategories();
        result = result * 59 + ($childrenCategories == null ? 43 : $childrenCategories.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class GlossaryCategoryBuilderImpl
    extends GlossaryCategoryBuilder<GlossaryCategory, GlossaryCategoryBuilderImpl> {
        @Generated
        private GlossaryCategoryBuilderImpl() {
        }

        @Override
        @Generated
        protected GlossaryCategoryBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public GlossaryCategory build() {
            return new GlossaryCategory(this);
        }
    }

    @Generated
    public static abstract class GlossaryCategoryBuilder<C extends GlossaryCategory, B extends GlossaryCategoryBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String shortDescription;
        @Generated
        private String longDescription;
        @Generated
        private ArrayList<String> additionalAttributes$key;
        @Generated
        private ArrayList<String> additionalAttributes$value;
        @Generated
        private ArrayList<GlossaryTerm> terms;
        @Generated
        private Glossary anchor;
        @Generated
        private GlossaryCategory parentCategory;
        @Generated
        private ArrayList<GlossaryCategory> childrenCategories;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            GlossaryCategoryBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(GlossaryCategory instance, GlossaryCategoryBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.shortDescription(instance.shortDescription);
            b.longDescription(instance.longDescription);
            b.additionalAttributes(instance.additionalAttributes == null ? Collections.emptyMap() : instance.additionalAttributes);
            b.terms(instance.terms == null ? Collections.emptySortedSet() : instance.terms);
            b.anchor(instance.anchor);
            b.parentCategory(instance.parentCategory);
            b.childrenCategories(instance.childrenCategories == null ? Collections.emptySortedSet() : instance.childrenCategories);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B shortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
            return (B)this.self();
        }

        @Generated
        public B longDescription(String longDescription) {
            this.longDescription = longDescription;
            return (B)this.self();
        }

        @Generated
        public B additionalAttribute(String additionalAttributeKey, String additionalAttributeValue) {
            if (this.additionalAttributes$key == null) {
                this.additionalAttributes$key = new ArrayList();
                this.additionalAttributes$value = new ArrayList();
            }
            this.additionalAttributes$key.add(additionalAttributeKey);
            this.additionalAttributes$value.add(additionalAttributeValue);
            return (B)this.self();
        }

        @Generated
        public B additionalAttributes(Map<? extends String, ? extends String> additionalAttributes) {
            if (additionalAttributes == null) {
                throw new NullPointerException("additionalAttributes cannot be null");
            }
            if (this.additionalAttributes$key == null) {
                this.additionalAttributes$key = new ArrayList();
                this.additionalAttributes$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : additionalAttributes.entrySet()) {
                this.additionalAttributes$key.add($lombokEntry.getKey());
                this.additionalAttributes$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearAdditionalAttributes() {
            if (this.additionalAttributes$key != null) {
                this.additionalAttributes$key.clear();
                this.additionalAttributes$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B term(GlossaryTerm term) {
            if (this.terms == null) {
                this.terms = new ArrayList();
            }
            this.terms.add(term);
            return (B)this.self();
        }

        @Generated
        public B terms(Collection<? extends GlossaryTerm> terms) {
            if (terms == null) {
                throw new NullPointerException("terms cannot be null");
            }
            if (this.terms == null) {
                this.terms = new ArrayList();
            }
            this.terms.addAll(terms);
            return (B)this.self();
        }

        @Generated
        public B clearTerms() {
            if (this.terms != null) {
                this.terms.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B anchor(Glossary anchor) {
            this.anchor = anchor;
            return (B)this.self();
        }

        @Generated
        public B parentCategory(GlossaryCategory parentCategory) {
            this.parentCategory = parentCategory;
            return (B)this.self();
        }

        @Generated
        public B childCategory(GlossaryCategory childCategory) {
            if (this.childrenCategories == null) {
                this.childrenCategories = new ArrayList();
            }
            this.childrenCategories.add(childCategory);
            return (B)this.self();
        }

        @Generated
        public B childrenCategories(Collection<? extends GlossaryCategory> childrenCategories) {
            if (childrenCategories == null) {
                throw new NullPointerException("childrenCategories cannot be null");
            }
            if (this.childrenCategories == null) {
                this.childrenCategories = new ArrayList();
            }
            this.childrenCategories.addAll(childrenCategories);
            return (B)this.self();
        }

        @Generated
        public B clearChildrenCategories() {
            if (this.childrenCategories != null) {
                this.childrenCategories.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "GlossaryCategory.GlossaryCategoryBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", shortDescription=" + this.shortDescription + ", longDescription=" + this.longDescription + ", additionalAttributes$key=" + this.additionalAttributes$key + ", additionalAttributes$value=" + this.additionalAttributes$value + ", terms=" + this.terms + ", anchor=" + this.anchor + ", parentCategory=" + this.parentCategory + ", childrenCategories=" + this.childrenCategories + ")";
        }
    }
}

