/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.TermsQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.TermsQueryField;
import com.atlan.exception.AtlanException;
import com.atlan.exception.LogicException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Glossary;
import com.atlan.model.assets.GlossaryCategory;
import com.atlan.model.core.AtlanObject;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.model.search.IndexSearchDSL;
import com.atlan.model.search.IndexSearchRequest;
import com.atlan.model.search.IndexSearchResponse;
import com.atlan.util.QueryFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlossaryTerm
extends Asset {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlossaryTerm.class);
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "AtlasGlossaryTerm";
    String typeName;
    @Attribute
    String shortDescription;
    @Attribute
    String longDescription;
    @Attribute
    SortedSet<String> examples;
    @Attribute
    String abbreviation;
    @Attribute
    String usage;
    @Attribute
    Map<String, String> additionalAttributes;
    @Attribute
    SortedSet<GlossaryTerm> translationTerms;
    @Attribute
    SortedSet<GlossaryTerm> validValuesFor;
    @Attribute
    SortedSet<GlossaryTerm> synonyms;
    @Attribute
    SortedSet<GlossaryTerm> replacedBy;
    @Attribute
    SortedSet<GlossaryTerm> validValues;
    @Attribute
    SortedSet<GlossaryTerm> replacementTerms;
    @Attribute
    SortedSet<GlossaryTerm> seeAlso;
    @Attribute
    SortedSet<GlossaryTerm> translatedTerms;
    @Attribute
    SortedSet<GlossaryTerm> isA;
    @Attribute
    Glossary anchor;
    @Attribute
    SortedSet<GlossaryTerm> antonyms;
    @Attribute
    SortedSet<Asset> assignedEntities;
    @Attribute
    SortedSet<GlossaryCategory> categories;
    @Attribute
    SortedSet<GlossaryTerm> classifies;
    @Attribute
    SortedSet<GlossaryTerm> preferredToTerms;
    @Attribute
    SortedSet<GlossaryTerm> preferredTerms;

    public static GlossaryTerm refByGuid(String guid) {
        return ((GlossaryTermBuilder)GlossaryTerm.builder().guid(guid)).build();
    }

    public static GlossaryTerm refByQualifiedName(String qualifiedName) {
        return ((GlossaryTermBuilder)GlossaryTerm.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public void removeAssignedEntities() {
        this.addNullField("assignedEntities");
    }

    public static GlossaryTermBuilder<?, ?> creator(String name, String glossaryGuid, String glossaryQualifiedName) {
        return ((GlossaryTermBuilder)((GlossaryTermBuilder)GlossaryTerm.builder().qualifiedName(name)).name(name)).anchor(Glossary.anchorLink(glossaryGuid, glossaryQualifiedName));
    }

    public static GlossaryTermBuilder<?, ?> updater(String qualifiedName, String name, String glossaryGuid) {
        return ((GlossaryTermBuilder)((GlossaryTermBuilder)GlossaryTerm.builder().qualifiedName(qualifiedName)).name(name)).anchor(Glossary.anchorLink(glossaryGuid, null));
    }

    protected GlossaryTermBuilder<?, ?> trimToRequired() {
        return GlossaryTerm.updater(this.getQualifiedName(), this.getName(), this.getAnchor().getGuid());
    }

    public static GlossaryTerm findByName(String name, String glossaryQualifiedName, Collection<String> attributes) throws AtlanException {
        AtlanObject request;
        IndexSearchResponse response;
        Query byType = QueryFactory.withType(TYPE_NAME);
        Query byName = QueryFactory.withExactName(name);
        Query byGlossary = TermsQuery.of(t -> t.field("__glossary").terms(TermsQueryField.of(f -> f.value(List.of(FieldValue.of((String)glossaryQualifiedName))))))._toQuery();
        Query active = QueryFactory.active();
        Query filter = BoolQuery.of(b -> b.filter(byType, new Query[]{byName, byGlossary, active}))._toQuery();
        Object builder = IndexSearchRequest.builder().dsl((IndexSearchDSL)((IndexSearchDSL.IndexSearchDSLBuilder)((IndexSearchDSL.IndexSearchDSLBuilder)((IndexSearchDSL.IndexSearchDSLBuilder)IndexSearchDSL.builder().from(0)).size(2)).query(filter)).build());
        if (attributes != null && !attributes.isEmpty()) {
            ((IndexSearchRequest.IndexSearchRequestBuilder)builder).attributes(attributes);
        }
        if ((response = ((IndexSearchRequest)(request = ((IndexSearchRequest.IndexSearchRequestBuilder)builder).build())).search()) != null) {
            List<Entity> results;
            long count = response.getApproximateCount();
            if (count > 1L) {
                log.warn("Multiple glossary terms found with the name '{}' in glossary '{}', returning only the first.", (Object)name, (Object)glossaryQualifiedName);
            }
            if ((results = response.getEntities()) != null && !results.isEmpty()) {
                Entity first = results.get(0);
                if (first instanceof GlossaryTerm) {
                    return (GlossaryTerm)first;
                }
                throw new LogicException("Found a non-glossary term result when searching for only glossary terms.", "ATLAN-JAVA-CLIENT-500-091", 500);
            }
        }
        throw new NotFoundException("Unable to find a glossary term with the name: " + name, "ATLAN-JAVA-CLIENT-404-091", 404, null);
    }

    public static GlossaryTerm retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof GlossaryTerm) {
            return (GlossaryTerm)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a GlossaryTerm.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static GlossaryTerm retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof GlossaryTerm) {
            return (GlossaryTerm)entity;
        }
        throw new NotFoundException("No GlossaryTerm found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static GlossaryTerm removeDescription(String qualifiedName, String name, String glossaryGuid) throws AtlanException {
        return (GlossaryTerm)Asset.removeDescription(GlossaryTerm.updater(qualifiedName, name, glossaryGuid));
    }

    public static GlossaryTerm removeUserDescription(String qualifiedName, String name, String glossaryGuid) throws AtlanException {
        return (GlossaryTerm)Asset.removeUserDescription(GlossaryTerm.updater(qualifiedName, name, glossaryGuid));
    }

    public static GlossaryTerm removeOwners(String qualifiedName, String name, String glossaryGuid) throws AtlanException {
        return (GlossaryTerm)Asset.removeOwners(GlossaryTerm.updater(qualifiedName, name, glossaryGuid));
    }

    public static GlossaryTerm updateCertificate(String qualifiedName, String name, String glossaryGuid, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (GlossaryTerm)Asset.updateCertificate(GlossaryTerm.updater(qualifiedName, name, glossaryGuid), certificate, message);
    }

    public static GlossaryTerm removeCertificate(String qualifiedName, String name, String glossaryGuid) throws AtlanException {
        return (GlossaryTerm)Asset.removeCertificate(GlossaryTerm.updater(qualifiedName, name, glossaryGuid));
    }

    public static GlossaryTerm updateAnnouncement(String qualifiedName, String name, String glossaryGuid, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (GlossaryTerm)Asset.updateAnnouncement(GlossaryTerm.updater(qualifiedName, name, glossaryGuid), type, title, message);
    }

    public static GlossaryTerm removeAnnouncement(String qualifiedName, String name, String glossaryGuid) throws AtlanException {
        return (GlossaryTerm)Asset.removeAnnouncement(GlossaryTerm.updater(qualifiedName, name, glossaryGuid));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected GlossaryTerm(GlossaryTermBuilder<?, ?> b) {
        super((Asset.AssetBuilder<?, ?>)b);
        Map<Object, Object> additionalAttributes;
        this.typeName = b.typeName$set ? b.typeName$value : GlossaryTerm.$default$typeName();
        this.shortDescription = b.shortDescription;
        this.longDescription = b.longDescription;
        SortedSet<String> examples = new TreeSet<String>();
        if (b.examples != null) {
            examples.addAll(b.examples);
        }
        examples = Collections.unmodifiableSortedSet(examples);
        this.examples = examples;
        this.abbreviation = b.abbreviation;
        this.usage = b.usage;
        switch (b.additionalAttributes$key == null ? 0 : b.additionalAttributes$key.size()) {
            case 0: {
                additionalAttributes = Collections.emptyMap();
                break;
            }
            case 1: {
                additionalAttributes = Collections.singletonMap(b.additionalAttributes$key.get(0), b.additionalAttributes$value.get(0));
                break;
            }
            default: {
                additionalAttributes = new LinkedHashMap(b.additionalAttributes$key.size() < 0x40000000 ? 1 + b.additionalAttributes$key.size() + (b.additionalAttributes$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.additionalAttributes$key.size(); ++$i) {
                    additionalAttributes.put(b.additionalAttributes$key.get($i), b.additionalAttributes$value.get($i));
                }
                additionalAttributes = Collections.unmodifiableMap(additionalAttributes);
            }
        }
        this.additionalAttributes = additionalAttributes;
        SortedSet<GlossaryTerm> translationTerms = new TreeSet<GlossaryTerm>();
        if (b.translationTerms != null) {
            translationTerms.addAll(b.translationTerms);
        }
        translationTerms = Collections.unmodifiableSortedSet(translationTerms);
        this.translationTerms = translationTerms;
        SortedSet<GlossaryTerm> validValuesFor = new TreeSet<GlossaryTerm>();
        if (b.validValuesFor != null) {
            validValuesFor.addAll(b.validValuesFor);
        }
        validValuesFor = Collections.unmodifiableSortedSet(validValuesFor);
        this.validValuesFor = validValuesFor;
        SortedSet<GlossaryTerm> synonyms = new TreeSet<GlossaryTerm>();
        if (b.synonyms != null) {
            synonyms.addAll(b.synonyms);
        }
        synonyms = Collections.unmodifiableSortedSet(synonyms);
        this.synonyms = synonyms;
        SortedSet<GlossaryTerm> replacedBy = new TreeSet<GlossaryTerm>();
        if (b.replacedBy != null) {
            replacedBy.addAll(b.replacedBy);
        }
        replacedBy = Collections.unmodifiableSortedSet(replacedBy);
        this.replacedBy = replacedBy;
        SortedSet<GlossaryTerm> validValues = new TreeSet<GlossaryTerm>();
        if (b.validValues != null) {
            validValues.addAll(b.validValues);
        }
        validValues = Collections.unmodifiableSortedSet(validValues);
        this.validValues = validValues;
        SortedSet<GlossaryTerm> replacementTerms = new TreeSet<GlossaryTerm>();
        if (b.replacementTerms != null) {
            replacementTerms.addAll(b.replacementTerms);
        }
        replacementTerms = Collections.unmodifiableSortedSet(replacementTerms);
        this.replacementTerms = replacementTerms;
        SortedSet<GlossaryTerm> seeAlso = new TreeSet<GlossaryTerm>();
        if (b.seeAlso != null) {
            seeAlso.addAll(b.seeAlso);
        }
        seeAlso = Collections.unmodifiableSortedSet(seeAlso);
        this.seeAlso = seeAlso;
        SortedSet<GlossaryTerm> translatedTerms = new TreeSet<GlossaryTerm>();
        if (b.translatedTerms != null) {
            translatedTerms.addAll(b.translatedTerms);
        }
        translatedTerms = Collections.unmodifiableSortedSet(translatedTerms);
        this.translatedTerms = translatedTerms;
        SortedSet<GlossaryTerm> isA = new TreeSet<GlossaryTerm>();
        if (b.isA != null) {
            isA.addAll(b.isA);
        }
        isA = Collections.unmodifiableSortedSet(isA);
        this.isA = isA;
        this.anchor = b.anchor;
        SortedSet<GlossaryTerm> antonyms = new TreeSet<GlossaryTerm>();
        if (b.antonyms != null) {
            antonyms.addAll(b.antonyms);
        }
        antonyms = Collections.unmodifiableSortedSet(antonyms);
        this.antonyms = antonyms;
        SortedSet<Asset> assignedEntities = new TreeSet<Asset>();
        if (b.assignedEntities != null) {
            assignedEntities.addAll(b.assignedEntities);
        }
        assignedEntities = Collections.unmodifiableSortedSet(assignedEntities);
        this.assignedEntities = assignedEntities;
        SortedSet<GlossaryCategory> categories = new TreeSet<GlossaryCategory>();
        if (b.categories != null) {
            categories.addAll(b.categories);
        }
        categories = Collections.unmodifiableSortedSet(categories);
        this.categories = categories;
        SortedSet<GlossaryTerm> classifies = new TreeSet<GlossaryTerm>();
        if (b.classifies != null) {
            classifies.addAll(b.classifies);
        }
        classifies = Collections.unmodifiableSortedSet(classifies);
        this.classifies = classifies;
        SortedSet<GlossaryTerm> preferredToTerms = new TreeSet<GlossaryTerm>();
        if (b.preferredToTerms != null) {
            preferredToTerms.addAll(b.preferredToTerms);
        }
        preferredToTerms = Collections.unmodifiableSortedSet(preferredToTerms);
        this.preferredToTerms = preferredToTerms;
        SortedSet<GlossaryTerm> preferredTerms = new TreeSet<GlossaryTerm>();
        if (b.preferredTerms != null) {
            preferredTerms.addAll(b.preferredTerms);
        }
        preferredTerms = Collections.unmodifiableSortedSet(preferredTerms);
        this.preferredTerms = preferredTerms;
    }

    @Generated
    public static GlossaryTermBuilder<?, ?> builder() {
        return new GlossaryTermBuilderImpl();
    }

    @Generated
    public GlossaryTermBuilder<?, ?> toBuilder() {
        return new GlossaryTermBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getShortDescription() {
        return this.shortDescription;
    }

    @Generated
    public String getLongDescription() {
        return this.longDescription;
    }

    @Generated
    public SortedSet<String> getExamples() {
        return this.examples;
    }

    @Generated
    public String getAbbreviation() {
        return this.abbreviation;
    }

    @Generated
    public String getUsage() {
        return this.usage;
    }

    @Generated
    public Map<String, String> getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    @Generated
    public SortedSet<GlossaryTerm> getTranslationTerms() {
        return this.translationTerms;
    }

    @Generated
    public SortedSet<GlossaryTerm> getValidValuesFor() {
        return this.validValuesFor;
    }

    @Generated
    public SortedSet<GlossaryTerm> getSynonyms() {
        return this.synonyms;
    }

    @Generated
    public SortedSet<GlossaryTerm> getReplacedBy() {
        return this.replacedBy;
    }

    @Generated
    public SortedSet<GlossaryTerm> getValidValues() {
        return this.validValues;
    }

    @Generated
    public SortedSet<GlossaryTerm> getReplacementTerms() {
        return this.replacementTerms;
    }

    @Generated
    public SortedSet<GlossaryTerm> getSeeAlso() {
        return this.seeAlso;
    }

    @Generated
    public SortedSet<GlossaryTerm> getTranslatedTerms() {
        return this.translatedTerms;
    }

    @Generated
    public SortedSet<GlossaryTerm> getIsA() {
        return this.isA;
    }

    @Generated
    public Glossary getAnchor() {
        return this.anchor;
    }

    @Generated
    public SortedSet<GlossaryTerm> getAntonyms() {
        return this.antonyms;
    }

    @Generated
    public SortedSet<Asset> getAssignedEntities() {
        return this.assignedEntities;
    }

    @Generated
    public SortedSet<GlossaryCategory> getCategories() {
        return this.categories;
    }

    @Generated
    public SortedSet<GlossaryTerm> getClassifies() {
        return this.classifies;
    }

    @Generated
    public SortedSet<GlossaryTerm> getPreferredToTerms() {
        return this.preferredToTerms;
    }

    @Generated
    public SortedSet<GlossaryTerm> getPreferredTerms() {
        return this.preferredTerms;
    }

    @Generated
    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    @Generated
    public void setLongDescription(String longDescription) {
        this.longDescription = longDescription;
    }

    @Generated
    public void setExamples(SortedSet<String> examples) {
        this.examples = examples;
    }

    @Generated
    public void setAbbreviation(String abbreviation) {
        this.abbreviation = abbreviation;
    }

    @Generated
    public void setUsage(String usage) {
        this.usage = usage;
    }

    @Generated
    public void setAdditionalAttributes(Map<String, String> additionalAttributes) {
        this.additionalAttributes = additionalAttributes;
    }

    @Generated
    public void setTranslationTerms(SortedSet<GlossaryTerm> translationTerms) {
        this.translationTerms = translationTerms;
    }

    @Generated
    public void setValidValuesFor(SortedSet<GlossaryTerm> validValuesFor) {
        this.validValuesFor = validValuesFor;
    }

    @Generated
    public void setSynonyms(SortedSet<GlossaryTerm> synonyms) {
        this.synonyms = synonyms;
    }

    @Generated
    public void setReplacedBy(SortedSet<GlossaryTerm> replacedBy) {
        this.replacedBy = replacedBy;
    }

    @Generated
    public void setValidValues(SortedSet<GlossaryTerm> validValues) {
        this.validValues = validValues;
    }

    @Generated
    public void setReplacementTerms(SortedSet<GlossaryTerm> replacementTerms) {
        this.replacementTerms = replacementTerms;
    }

    @Generated
    public void setSeeAlso(SortedSet<GlossaryTerm> seeAlso) {
        this.seeAlso = seeAlso;
    }

    @Generated
    public void setTranslatedTerms(SortedSet<GlossaryTerm> translatedTerms) {
        this.translatedTerms = translatedTerms;
    }

    @Generated
    public void setIsA(SortedSet<GlossaryTerm> isA) {
        this.isA = isA;
    }

    @Generated
    public void setAnchor(Glossary anchor) {
        this.anchor = anchor;
    }

    @Generated
    public void setAntonyms(SortedSet<GlossaryTerm> antonyms) {
        this.antonyms = antonyms;
    }

    @Generated
    public void setAssignedEntities(SortedSet<Asset> assignedEntities) {
        this.assignedEntities = assignedEntities;
    }

    @Generated
    public void setCategories(SortedSet<GlossaryCategory> categories) {
        this.categories = categories;
    }

    @Generated
    public void setClassifies(SortedSet<GlossaryTerm> classifies) {
        this.classifies = classifies;
    }

    @Generated
    public void setPreferredToTerms(SortedSet<GlossaryTerm> preferredToTerms) {
        this.preferredToTerms = preferredToTerms;
    }

    @Generated
    public void setPreferredTerms(SortedSet<GlossaryTerm> preferredTerms) {
        this.preferredTerms = preferredTerms;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GlossaryTerm)) {
            return false;
        }
        GlossaryTerm other = (GlossaryTerm)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$shortDescription = this.getShortDescription();
        String other$shortDescription = other.getShortDescription();
        if (this$shortDescription == null ? other$shortDescription != null : !this$shortDescription.equals(other$shortDescription)) {
            return false;
        }
        String this$longDescription = this.getLongDescription();
        String other$longDescription = other.getLongDescription();
        if (this$longDescription == null ? other$longDescription != null : !this$longDescription.equals(other$longDescription)) {
            return false;
        }
        SortedSet<String> this$examples = this.getExamples();
        SortedSet<String> other$examples = other.getExamples();
        if (this$examples == null ? other$examples != null : !this$examples.equals(other$examples)) {
            return false;
        }
        String this$abbreviation = this.getAbbreviation();
        String other$abbreviation = other.getAbbreviation();
        if (this$abbreviation == null ? other$abbreviation != null : !this$abbreviation.equals(other$abbreviation)) {
            return false;
        }
        String this$usage = this.getUsage();
        String other$usage = other.getUsage();
        if (this$usage == null ? other$usage != null : !this$usage.equals(other$usage)) {
            return false;
        }
        Map<String, String> this$additionalAttributes = this.getAdditionalAttributes();
        Map<String, String> other$additionalAttributes = other.getAdditionalAttributes();
        if (this$additionalAttributes == null ? other$additionalAttributes != null : !((Object)this$additionalAttributes).equals(other$additionalAttributes)) {
            return false;
        }
        SortedSet<GlossaryTerm> this$translationTerms = this.getTranslationTerms();
        SortedSet<GlossaryTerm> other$translationTerms = other.getTranslationTerms();
        if (this$translationTerms == null ? other$translationTerms != null : !this$translationTerms.equals(other$translationTerms)) {
            return false;
        }
        SortedSet<GlossaryTerm> this$validValuesFor = this.getValidValuesFor();
        SortedSet<GlossaryTerm> other$validValuesFor = other.getValidValuesFor();
        if (this$validValuesFor == null ? other$validValuesFor != null : !this$validValuesFor.equals(other$validValuesFor)) {
            return false;
        }
        SortedSet<GlossaryTerm> this$synonyms = this.getSynonyms();
        SortedSet<GlossaryTerm> other$synonyms = other.getSynonyms();
        if (this$synonyms == null ? other$synonyms != null : !this$synonyms.equals(other$synonyms)) {
            return false;
        }
        SortedSet<GlossaryTerm> this$replacedBy = this.getReplacedBy();
        SortedSet<GlossaryTerm> other$replacedBy = other.getReplacedBy();
        if (this$replacedBy == null ? other$replacedBy != null : !this$replacedBy.equals(other$replacedBy)) {
            return false;
        }
        SortedSet<GlossaryTerm> this$validValues = this.getValidValues();
        SortedSet<GlossaryTerm> other$validValues = other.getValidValues();
        if (this$validValues == null ? other$validValues != null : !this$validValues.equals(other$validValues)) {
            return false;
        }
        SortedSet<GlossaryTerm> this$replacementTerms = this.getReplacementTerms();
        SortedSet<GlossaryTerm> other$replacementTerms = other.getReplacementTerms();
        if (this$replacementTerms == null ? other$replacementTerms != null : !this$replacementTerms.equals(other$replacementTerms)) {
            return false;
        }
        SortedSet<GlossaryTerm> this$seeAlso = this.getSeeAlso();
        SortedSet<GlossaryTerm> other$seeAlso = other.getSeeAlso();
        if (this$seeAlso == null ? other$seeAlso != null : !this$seeAlso.equals(other$seeAlso)) {
            return false;
        }
        SortedSet<GlossaryTerm> this$translatedTerms = this.getTranslatedTerms();
        SortedSet<GlossaryTerm> other$translatedTerms = other.getTranslatedTerms();
        if (this$translatedTerms == null ? other$translatedTerms != null : !this$translatedTerms.equals(other$translatedTerms)) {
            return false;
        }
        SortedSet<GlossaryTerm> this$isA = this.getIsA();
        SortedSet<GlossaryTerm> other$isA = other.getIsA();
        if (this$isA == null ? other$isA != null : !this$isA.equals(other$isA)) {
            return false;
        }
        Glossary this$anchor = this.getAnchor();
        Glossary other$anchor = other.getAnchor();
        if (this$anchor == null ? other$anchor != null : !((Object)this$anchor).equals(other$anchor)) {
            return false;
        }
        SortedSet<GlossaryTerm> this$antonyms = this.getAntonyms();
        SortedSet<GlossaryTerm> other$antonyms = other.getAntonyms();
        if (this$antonyms == null ? other$antonyms != null : !this$antonyms.equals(other$antonyms)) {
            return false;
        }
        SortedSet<Asset> this$assignedEntities = this.getAssignedEntities();
        SortedSet<Asset> other$assignedEntities = other.getAssignedEntities();
        if (this$assignedEntities == null ? other$assignedEntities != null : !this$assignedEntities.equals(other$assignedEntities)) {
            return false;
        }
        SortedSet<GlossaryCategory> this$categories = this.getCategories();
        SortedSet<GlossaryCategory> other$categories = other.getCategories();
        if (this$categories == null ? other$categories != null : !this$categories.equals(other$categories)) {
            return false;
        }
        SortedSet<GlossaryTerm> this$classifies = this.getClassifies();
        SortedSet<GlossaryTerm> other$classifies = other.getClassifies();
        if (this$classifies == null ? other$classifies != null : !this$classifies.equals(other$classifies)) {
            return false;
        }
        SortedSet<GlossaryTerm> this$preferredToTerms = this.getPreferredToTerms();
        SortedSet<GlossaryTerm> other$preferredToTerms = other.getPreferredToTerms();
        if (this$preferredToTerms == null ? other$preferredToTerms != null : !this$preferredToTerms.equals(other$preferredToTerms)) {
            return false;
        }
        SortedSet<GlossaryTerm> this$preferredTerms = this.getPreferredTerms();
        SortedSet<GlossaryTerm> other$preferredTerms = other.getPreferredTerms();
        return !(this$preferredTerms == null ? other$preferredTerms != null : !this$preferredTerms.equals(other$preferredTerms));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GlossaryTerm;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $shortDescription = this.getShortDescription();
        result = result * 59 + ($shortDescription == null ? 43 : $shortDescription.hashCode());
        String $longDescription = this.getLongDescription();
        result = result * 59 + ($longDescription == null ? 43 : $longDescription.hashCode());
        SortedSet<String> $examples = this.getExamples();
        result = result * 59 + ($examples == null ? 43 : $examples.hashCode());
        String $abbreviation = this.getAbbreviation();
        result = result * 59 + ($abbreviation == null ? 43 : $abbreviation.hashCode());
        String $usage = this.getUsage();
        result = result * 59 + ($usage == null ? 43 : $usage.hashCode());
        Map<String, String> $additionalAttributes = this.getAdditionalAttributes();
        result = result * 59 + ($additionalAttributes == null ? 43 : ((Object)$additionalAttributes).hashCode());
        SortedSet<GlossaryTerm> $translationTerms = this.getTranslationTerms();
        result = result * 59 + ($translationTerms == null ? 43 : $translationTerms.hashCode());
        SortedSet<GlossaryTerm> $validValuesFor = this.getValidValuesFor();
        result = result * 59 + ($validValuesFor == null ? 43 : $validValuesFor.hashCode());
        SortedSet<GlossaryTerm> $synonyms = this.getSynonyms();
        result = result * 59 + ($synonyms == null ? 43 : $synonyms.hashCode());
        SortedSet<GlossaryTerm> $replacedBy = this.getReplacedBy();
        result = result * 59 + ($replacedBy == null ? 43 : $replacedBy.hashCode());
        SortedSet<GlossaryTerm> $validValues = this.getValidValues();
        result = result * 59 + ($validValues == null ? 43 : $validValues.hashCode());
        SortedSet<GlossaryTerm> $replacementTerms = this.getReplacementTerms();
        result = result * 59 + ($replacementTerms == null ? 43 : $replacementTerms.hashCode());
        SortedSet<GlossaryTerm> $seeAlso = this.getSeeAlso();
        result = result * 59 + ($seeAlso == null ? 43 : $seeAlso.hashCode());
        SortedSet<GlossaryTerm> $translatedTerms = this.getTranslatedTerms();
        result = result * 59 + ($translatedTerms == null ? 43 : $translatedTerms.hashCode());
        SortedSet<GlossaryTerm> $isA = this.getIsA();
        result = result * 59 + ($isA == null ? 43 : $isA.hashCode());
        Glossary $anchor = this.getAnchor();
        result = result * 59 + ($anchor == null ? 43 : ((Object)$anchor).hashCode());
        SortedSet<GlossaryTerm> $antonyms = this.getAntonyms();
        result = result * 59 + ($antonyms == null ? 43 : $antonyms.hashCode());
        SortedSet<Asset> $assignedEntities = this.getAssignedEntities();
        result = result * 59 + ($assignedEntities == null ? 43 : $assignedEntities.hashCode());
        SortedSet<GlossaryCategory> $categories = this.getCategories();
        result = result * 59 + ($categories == null ? 43 : $categories.hashCode());
        SortedSet<GlossaryTerm> $classifies = this.getClassifies();
        result = result * 59 + ($classifies == null ? 43 : $classifies.hashCode());
        SortedSet<GlossaryTerm> $preferredToTerms = this.getPreferredToTerms();
        result = result * 59 + ($preferredToTerms == null ? 43 : $preferredToTerms.hashCode());
        SortedSet<GlossaryTerm> $preferredTerms = this.getPreferredTerms();
        result = result * 59 + ($preferredTerms == null ? 43 : $preferredTerms.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class GlossaryTermBuilderImpl
    extends GlossaryTermBuilder<GlossaryTerm, GlossaryTermBuilderImpl> {
        @Generated
        private GlossaryTermBuilderImpl() {
        }

        @Override
        @Generated
        protected GlossaryTermBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public GlossaryTerm build() {
            return new GlossaryTerm(this);
        }
    }

    @Generated
    public static abstract class GlossaryTermBuilder<C extends GlossaryTerm, B extends GlossaryTermBuilder<C, B>>
    extends Asset.AssetBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String shortDescription;
        @Generated
        private String longDescription;
        @Generated
        private ArrayList<String> examples;
        @Generated
        private String abbreviation;
        @Generated
        private String usage;
        @Generated
        private ArrayList<String> additionalAttributes$key;
        @Generated
        private ArrayList<String> additionalAttributes$value;
        @Generated
        private ArrayList<GlossaryTerm> translationTerms;
        @Generated
        private ArrayList<GlossaryTerm> validValuesFor;
        @Generated
        private ArrayList<GlossaryTerm> synonyms;
        @Generated
        private ArrayList<GlossaryTerm> replacedBy;
        @Generated
        private ArrayList<GlossaryTerm> validValues;
        @Generated
        private ArrayList<GlossaryTerm> replacementTerms;
        @Generated
        private ArrayList<GlossaryTerm> seeAlso;
        @Generated
        private ArrayList<GlossaryTerm> translatedTerms;
        @Generated
        private ArrayList<GlossaryTerm> isA;
        @Generated
        private Glossary anchor;
        @Generated
        private ArrayList<GlossaryTerm> antonyms;
        @Generated
        private ArrayList<Asset> assignedEntities;
        @Generated
        private ArrayList<GlossaryCategory> categories;
        @Generated
        private ArrayList<GlossaryTerm> classifies;
        @Generated
        private ArrayList<GlossaryTerm> preferredToTerms;
        @Generated
        private ArrayList<GlossaryTerm> preferredTerms;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            GlossaryTermBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(GlossaryTerm instance, GlossaryTermBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.shortDescription(instance.shortDescription);
            b.longDescription(instance.longDescription);
            b.examples(instance.examples == null ? Collections.emptySortedSet() : instance.examples);
            b.abbreviation(instance.abbreviation);
            b.usage(instance.usage);
            b.additionalAttributes(instance.additionalAttributes == null ? Collections.emptyMap() : instance.additionalAttributes);
            b.translationTerms(instance.translationTerms == null ? Collections.emptySortedSet() : instance.translationTerms);
            b.validValuesFor(instance.validValuesFor == null ? Collections.emptySortedSet() : instance.validValuesFor);
            b.synonyms(instance.synonyms == null ? Collections.emptySortedSet() : instance.synonyms);
            b.replacedBy(instance.replacedBy == null ? Collections.emptySortedSet() : instance.replacedBy);
            b.validValues(instance.validValues == null ? Collections.emptySortedSet() : instance.validValues);
            b.replacementTerms(instance.replacementTerms == null ? Collections.emptySortedSet() : instance.replacementTerms);
            b.seeAlso(instance.seeAlso == null ? Collections.emptySortedSet() : instance.seeAlso);
            b.translatedTerms(instance.translatedTerms == null ? Collections.emptySortedSet() : instance.translatedTerms);
            b.isA(instance.isA == null ? Collections.emptySortedSet() : instance.isA);
            b.anchor(instance.anchor);
            b.antonyms(instance.antonyms == null ? Collections.emptySortedSet() : instance.antonyms);
            b.assignedEntities(instance.assignedEntities == null ? Collections.emptySortedSet() : instance.assignedEntities);
            b.categories(instance.categories == null ? Collections.emptySortedSet() : instance.categories);
            b.classifies(instance.classifies == null ? Collections.emptySortedSet() : instance.classifies);
            b.preferredToTerms(instance.preferredToTerms == null ? Collections.emptySortedSet() : instance.preferredToTerms);
            b.preferredTerms(instance.preferredTerms == null ? Collections.emptySortedSet() : instance.preferredTerms);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B shortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
            return (B)this.self();
        }

        @Generated
        public B longDescription(String longDescription) {
            this.longDescription = longDescription;
            return (B)this.self();
        }

        @Generated
        public B example(String example) {
            if (this.examples == null) {
                this.examples = new ArrayList();
            }
            this.examples.add(example);
            return (B)this.self();
        }

        @Generated
        public B examples(Collection<? extends String> examples) {
            if (examples == null) {
                throw new NullPointerException("examples cannot be null");
            }
            if (this.examples == null) {
                this.examples = new ArrayList();
            }
            this.examples.addAll(examples);
            return (B)this.self();
        }

        @Generated
        public B clearExamples() {
            if (this.examples != null) {
                this.examples.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B abbreviation(String abbreviation) {
            this.abbreviation = abbreviation;
            return (B)this.self();
        }

        @Generated
        public B usage(String usage) {
            this.usage = usage;
            return (B)this.self();
        }

        @Generated
        public B additionalAttribute(String additionalAttributeKey, String additionalAttributeValue) {
            if (this.additionalAttributes$key == null) {
                this.additionalAttributes$key = new ArrayList();
                this.additionalAttributes$value = new ArrayList();
            }
            this.additionalAttributes$key.add(additionalAttributeKey);
            this.additionalAttributes$value.add(additionalAttributeValue);
            return (B)this.self();
        }

        @Generated
        public B additionalAttributes(Map<? extends String, ? extends String> additionalAttributes) {
            if (additionalAttributes == null) {
                throw new NullPointerException("additionalAttributes cannot be null");
            }
            if (this.additionalAttributes$key == null) {
                this.additionalAttributes$key = new ArrayList();
                this.additionalAttributes$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : additionalAttributes.entrySet()) {
                this.additionalAttributes$key.add($lombokEntry.getKey());
                this.additionalAttributes$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearAdditionalAttributes() {
            if (this.additionalAttributes$key != null) {
                this.additionalAttributes$key.clear();
                this.additionalAttributes$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B translationTerm(GlossaryTerm translationTerm) {
            if (this.translationTerms == null) {
                this.translationTerms = new ArrayList();
            }
            this.translationTerms.add(translationTerm);
            return (B)this.self();
        }

        @Generated
        public B translationTerms(Collection<? extends GlossaryTerm> translationTerms) {
            if (translationTerms == null) {
                throw new NullPointerException("translationTerms cannot be null");
            }
            if (this.translationTerms == null) {
                this.translationTerms = new ArrayList();
            }
            this.translationTerms.addAll(translationTerms);
            return (B)this.self();
        }

        @Generated
        public B clearTranslationTerms() {
            if (this.translationTerms != null) {
                this.translationTerms.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B validValueFor(GlossaryTerm validValueFor) {
            if (this.validValuesFor == null) {
                this.validValuesFor = new ArrayList();
            }
            this.validValuesFor.add(validValueFor);
            return (B)this.self();
        }

        @Generated
        public B validValuesFor(Collection<? extends GlossaryTerm> validValuesFor) {
            if (validValuesFor == null) {
                throw new NullPointerException("validValuesFor cannot be null");
            }
            if (this.validValuesFor == null) {
                this.validValuesFor = new ArrayList();
            }
            this.validValuesFor.addAll(validValuesFor);
            return (B)this.self();
        }

        @Generated
        public B clearValidValuesFor() {
            if (this.validValuesFor != null) {
                this.validValuesFor.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B synonym(GlossaryTerm synonym) {
            if (this.synonyms == null) {
                this.synonyms = new ArrayList();
            }
            this.synonyms.add(synonym);
            return (B)this.self();
        }

        @Generated
        public B synonyms(Collection<? extends GlossaryTerm> synonyms) {
            if (synonyms == null) {
                throw new NullPointerException("synonyms cannot be null");
            }
            if (this.synonyms == null) {
                this.synonyms = new ArrayList();
            }
            this.synonyms.addAll(synonyms);
            return (B)this.self();
        }

        @Generated
        public B clearSynonyms() {
            if (this.synonyms != null) {
                this.synonyms.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B replacedByTerm(GlossaryTerm replacedByTerm) {
            if (this.replacedBy == null) {
                this.replacedBy = new ArrayList();
            }
            this.replacedBy.add(replacedByTerm);
            return (B)this.self();
        }

        @Generated
        public B replacedBy(Collection<? extends GlossaryTerm> replacedBy) {
            if (replacedBy == null) {
                throw new NullPointerException("replacedBy cannot be null");
            }
            if (this.replacedBy == null) {
                this.replacedBy = new ArrayList();
            }
            this.replacedBy.addAll(replacedBy);
            return (B)this.self();
        }

        @Generated
        public B clearReplacedBy() {
            if (this.replacedBy != null) {
                this.replacedBy.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B validValue(GlossaryTerm validValue) {
            if (this.validValues == null) {
                this.validValues = new ArrayList();
            }
            this.validValues.add(validValue);
            return (B)this.self();
        }

        @Generated
        public B validValues(Collection<? extends GlossaryTerm> validValues) {
            if (validValues == null) {
                throw new NullPointerException("validValues cannot be null");
            }
            if (this.validValues == null) {
                this.validValues = new ArrayList();
            }
            this.validValues.addAll(validValues);
            return (B)this.self();
        }

        @Generated
        public B clearValidValues() {
            if (this.validValues != null) {
                this.validValues.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B replacementTerm(GlossaryTerm replacementTerm) {
            if (this.replacementTerms == null) {
                this.replacementTerms = new ArrayList();
            }
            this.replacementTerms.add(replacementTerm);
            return (B)this.self();
        }

        @Generated
        public B replacementTerms(Collection<? extends GlossaryTerm> replacementTerms) {
            if (replacementTerms == null) {
                throw new NullPointerException("replacementTerms cannot be null");
            }
            if (this.replacementTerms == null) {
                this.replacementTerms = new ArrayList();
            }
            this.replacementTerms.addAll(replacementTerms);
            return (B)this.self();
        }

        @Generated
        public B clearReplacementTerms() {
            if (this.replacementTerms != null) {
                this.replacementTerms.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B seeAlsoOne(GlossaryTerm seeAlsoOne) {
            if (this.seeAlso == null) {
                this.seeAlso = new ArrayList();
            }
            this.seeAlso.add(seeAlsoOne);
            return (B)this.self();
        }

        @Generated
        public B seeAlso(Collection<? extends GlossaryTerm> seeAlso) {
            if (seeAlso == null) {
                throw new NullPointerException("seeAlso cannot be null");
            }
            if (this.seeAlso == null) {
                this.seeAlso = new ArrayList();
            }
            this.seeAlso.addAll(seeAlso);
            return (B)this.self();
        }

        @Generated
        public B clearSeeAlso() {
            if (this.seeAlso != null) {
                this.seeAlso.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B translatedTerm(GlossaryTerm translatedTerm) {
            if (this.translatedTerms == null) {
                this.translatedTerms = new ArrayList();
            }
            this.translatedTerms.add(translatedTerm);
            return (B)this.self();
        }

        @Generated
        public B translatedTerms(Collection<? extends GlossaryTerm> translatedTerms) {
            if (translatedTerms == null) {
                throw new NullPointerException("translatedTerms cannot be null");
            }
            if (this.translatedTerms == null) {
                this.translatedTerms = new ArrayList();
            }
            this.translatedTerms.addAll(translatedTerms);
            return (B)this.self();
        }

        @Generated
        public B clearTranslatedTerms() {
            if (this.translatedTerms != null) {
                this.translatedTerms.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B isATerm(GlossaryTerm isATerm) {
            if (this.isA == null) {
                this.isA = new ArrayList();
            }
            this.isA.add(isATerm);
            return (B)this.self();
        }

        @Generated
        public B isA(Collection<? extends GlossaryTerm> isA) {
            if (isA == null) {
                throw new NullPointerException("isA cannot be null");
            }
            if (this.isA == null) {
                this.isA = new ArrayList();
            }
            this.isA.addAll(isA);
            return (B)this.self();
        }

        @Generated
        public B clearIsA() {
            if (this.isA != null) {
                this.isA.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B anchor(Glossary anchor) {
            this.anchor = anchor;
            return (B)this.self();
        }

        @Generated
        public B antonym(GlossaryTerm antonym) {
            if (this.antonyms == null) {
                this.antonyms = new ArrayList();
            }
            this.antonyms.add(antonym);
            return (B)this.self();
        }

        @Generated
        public B antonyms(Collection<? extends GlossaryTerm> antonyms) {
            if (antonyms == null) {
                throw new NullPointerException("antonyms cannot be null");
            }
            if (this.antonyms == null) {
                this.antonyms = new ArrayList();
            }
            this.antonyms.addAll(antonyms);
            return (B)this.self();
        }

        @Generated
        public B clearAntonyms() {
            if (this.antonyms != null) {
                this.antonyms.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B assignedEntity(Asset assignedEntity) {
            if (this.assignedEntities == null) {
                this.assignedEntities = new ArrayList();
            }
            this.assignedEntities.add(assignedEntity);
            return (B)this.self();
        }

        @Generated
        public B assignedEntities(Collection<? extends Asset> assignedEntities) {
            if (assignedEntities == null) {
                throw new NullPointerException("assignedEntities cannot be null");
            }
            if (this.assignedEntities == null) {
                this.assignedEntities = new ArrayList();
            }
            this.assignedEntities.addAll(assignedEntities);
            return (B)this.self();
        }

        @Generated
        public B clearAssignedEntities() {
            if (this.assignedEntities != null) {
                this.assignedEntities.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B category(GlossaryCategory category) {
            if (this.categories == null) {
                this.categories = new ArrayList();
            }
            this.categories.add(category);
            return (B)this.self();
        }

        @Generated
        public B categories(Collection<? extends GlossaryCategory> categories) {
            if (categories == null) {
                throw new NullPointerException("categories cannot be null");
            }
            if (this.categories == null) {
                this.categories = new ArrayList();
            }
            this.categories.addAll(categories);
            return (B)this.self();
        }

        @Generated
        public B clearCategories() {
            if (this.categories != null) {
                this.categories.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B classify(GlossaryTerm classify) {
            if (this.classifies == null) {
                this.classifies = new ArrayList();
            }
            this.classifies.add(classify);
            return (B)this.self();
        }

        @Generated
        public B classifies(Collection<? extends GlossaryTerm> classifies) {
            if (classifies == null) {
                throw new NullPointerException("classifies cannot be null");
            }
            if (this.classifies == null) {
                this.classifies = new ArrayList();
            }
            this.classifies.addAll(classifies);
            return (B)this.self();
        }

        @Generated
        public B clearClassifies() {
            if (this.classifies != null) {
                this.classifies.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B preferredToTerm(GlossaryTerm preferredToTerm) {
            if (this.preferredToTerms == null) {
                this.preferredToTerms = new ArrayList();
            }
            this.preferredToTerms.add(preferredToTerm);
            return (B)this.self();
        }

        @Generated
        public B preferredToTerms(Collection<? extends GlossaryTerm> preferredToTerms) {
            if (preferredToTerms == null) {
                throw new NullPointerException("preferredToTerms cannot be null");
            }
            if (this.preferredToTerms == null) {
                this.preferredToTerms = new ArrayList();
            }
            this.preferredToTerms.addAll(preferredToTerms);
            return (B)this.self();
        }

        @Generated
        public B clearPreferredToTerms() {
            if (this.preferredToTerms != null) {
                this.preferredToTerms.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B preferredTerm(GlossaryTerm preferredTerm) {
            if (this.preferredTerms == null) {
                this.preferredTerms = new ArrayList();
            }
            this.preferredTerms.add(preferredTerm);
            return (B)this.self();
        }

        @Generated
        public B preferredTerms(Collection<? extends GlossaryTerm> preferredTerms) {
            if (preferredTerms == null) {
                throw new NullPointerException("preferredTerms cannot be null");
            }
            if (this.preferredTerms == null) {
                this.preferredTerms = new ArrayList();
            }
            this.preferredTerms.addAll(preferredTerms);
            return (B)this.self();
        }

        @Generated
        public B clearPreferredTerms() {
            if (this.preferredTerms != null) {
                this.preferredTerms.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "GlossaryTerm.GlossaryTermBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", shortDescription=" + this.shortDescription + ", longDescription=" + this.longDescription + ", examples=" + this.examples + ", abbreviation=" + this.abbreviation + ", usage=" + this.usage + ", additionalAttributes$key=" + this.additionalAttributes$key + ", additionalAttributes$value=" + this.additionalAttributes$value + ", translationTerms=" + this.translationTerms + ", validValuesFor=" + this.validValuesFor + ", synonyms=" + this.synonyms + ", replacedBy=" + this.replacedBy + ", validValues=" + this.validValues + ", replacementTerms=" + this.replacementTerms + ", seeAlso=" + this.seeAlso + ", translatedTerms=" + this.translatedTerms + ", isA=" + this.isA + ", anchor=" + this.anchor + ", antonyms=" + this.antonyms + ", assignedEntities=" + this.assignedEntities + ", categories=" + this.categories + ", classifies=" + this.classifies + ", preferredToTerms=" + this.preferredToTerms + ", preferredTerms=" + this.preferredTerms + ")";
        }
    }
}

