/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Catalog;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.List;
import lombok.Generated;

public class Insight
extends Catalog {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "Insight";
    String typeName;

    public static Insight refByGuid(String guid) {
        return ((InsightBuilder)Insight.builder().guid(guid)).build();
    }

    public static Insight refByQualifiedName(String qualifiedName) {
        return ((InsightBuilder)Insight.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static InsightBuilder<?, ?> updater(String qualifiedName, String name) {
        return (InsightBuilder)((InsightBuilder)Insight.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected InsightBuilder<?, ?> trimToRequired() {
        return Insight.updater(this.getQualifiedName(), this.getName());
    }

    public static Insight retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof Insight) {
            return (Insight)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a Insight.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static Insight retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof Insight) {
            return (Insight)entity;
        }
        throw new NotFoundException("No Insight found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static Insight removeDescription(String qualifiedName, String name) throws AtlanException {
        return (Insight)Asset.removeDescription(((InsightBuilder)Insight.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static Insight removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (Insight)Asset.removeUserDescription(((InsightBuilder)Insight.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static Insight removeOwners(String qualifiedName, String name) throws AtlanException {
        return (Insight)Asset.removeOwners(((InsightBuilder)Insight.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static Insight updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (Insight)Asset.updateCertificate(Insight.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static Insight removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (Insight)Asset.removeCertificate(((InsightBuilder)Insight.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static Insight updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (Insight)Asset.updateAnnouncement(Insight.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static Insight removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (Insight)Asset.removeAnnouncement(((InsightBuilder)Insight.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static Insight replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (Insight)Asset.replaceTerms(Insight.updater(qualifiedName, name), terms);
    }

    public static Insight appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (Insight)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static Insight removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (Insight)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected Insight(InsightBuilder<?, ?> b) {
        super((Catalog.CatalogBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : Insight.$default$typeName();
    }

    @Generated
    public static InsightBuilder<?, ?> builder() {
        return new InsightBuilderImpl();
    }

    @Generated
    public InsightBuilder<?, ?> toBuilder() {
        return new InsightBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Insight)) {
            return false;
        }
        Insight other = (Insight)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        return !(this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Insight;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class InsightBuilderImpl
    extends InsightBuilder<Insight, InsightBuilderImpl> {
        @Generated
        private InsightBuilderImpl() {
        }

        @Override
        @Generated
        protected InsightBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Insight build() {
            return new Insight(this);
        }
    }

    @Generated
    public static abstract class InsightBuilder<C extends Insight, B extends InsightBuilder<C, B>>
    extends Catalog.CatalogBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            InsightBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Insight instance, InsightBuilder<?, ?> b) {
            b.typeName(instance.typeName);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "Insight.InsightBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ")";
        }
    }
}

