/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.AbstractProcess;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Catalog;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.relations.UniqueAttributes;
import java.util.List;
import lombok.Generated;

public class LineageProcess
extends AbstractProcess {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "Process";
    String typeName;

    public static LineageProcess refByGuid(String guid) {
        return ((LineageProcessBuilder)LineageProcess.builder().guid(guid)).build();
    }

    public static LineageProcess refByQualifiedName(String qualifiedName) {
        return ((LineageProcessBuilder)LineageProcess.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static LineageProcessBuilder<?, ?> creator(String name, AtlanConnectorType connectorType, String connectionName, String connectionQualifiedName, List<Catalog> inputs, List<Catalog> outputs) {
        return (LineageProcessBuilder)((LineageProcessBuilder)((LineageProcessBuilder)((LineageProcessBuilder)((LineageProcessBuilder)((LineageProcessBuilder)((LineageProcessBuilder)LineageProcess.builder().qualifiedName(LineageProcess.generateQualifiedName(name, connectorType, connectionName, connectionQualifiedName, inputs, outputs, null))).name(name)).connectorType(connectorType)).connectionName(connectionName)).connectionQualifiedName(connectionQualifiedName)).inputs(inputs)).outputs(outputs);
    }

    public static LineageProcessBuilder<?, ?> updater(String qualifiedName, String name) {
        return (LineageProcessBuilder)((LineageProcessBuilder)LineageProcess.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected LineageProcessBuilder<?, ?> trimToRequired() {
        return LineageProcess.updater(this.getQualifiedName(), this.getName());
    }

    public static LineageProcess retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof LineageProcess) {
            return (LineageProcess)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a LineageProcess.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static LineageProcess retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof LineageProcess) {
            return (LineageProcess)entity;
        }
        throw new NotFoundException("No LineageProcess found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static LineageProcess removeDescription(String qualifiedName, String name) throws AtlanException {
        return (LineageProcess)Asset.removeDescription(((LineageProcessBuilder)LineageProcess.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static LineageProcess removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (LineageProcess)Asset.removeUserDescription(((LineageProcessBuilder)LineageProcess.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static LineageProcess removeOwners(String qualifiedName, String name) throws AtlanException {
        return (LineageProcess)Asset.removeOwners(((LineageProcessBuilder)LineageProcess.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static LineageProcess updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (LineageProcess)Asset.updateCertificate(LineageProcess.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static LineageProcess removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (LineageProcess)Asset.removeCertificate(((LineageProcessBuilder)LineageProcess.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static LineageProcess updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (LineageProcess)Asset.updateAnnouncement(LineageProcess.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static LineageProcess removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (LineageProcess)Asset.removeAnnouncement(((LineageProcessBuilder)LineageProcess.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static LineageProcess replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (LineageProcess)Asset.replaceTerms(LineageProcess.updater(qualifiedName, name), terms);
    }

    public static LineageProcess appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (LineageProcess)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static LineageProcess removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (LineageProcess)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected LineageProcess(LineageProcessBuilder<?, ?> b) {
        super((AbstractProcess.AbstractProcessBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : LineageProcess.$default$typeName();
    }

    @Generated
    public static LineageProcessBuilder<?, ?> builder() {
        return new LineageProcessBuilderImpl();
    }

    @Generated
    public LineageProcessBuilder<?, ?> toBuilder() {
        return new LineageProcessBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LineageProcess)) {
            return false;
        }
        LineageProcess other = (LineageProcess)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        return !(this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LineageProcess;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class LineageProcessBuilderImpl
    extends LineageProcessBuilder<LineageProcess, LineageProcessBuilderImpl> {
        @Generated
        private LineageProcessBuilderImpl() {
        }

        @Override
        @Generated
        protected LineageProcessBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public LineageProcess build() {
            return new LineageProcess(this);
        }
    }

    @Generated
    public static abstract class LineageProcessBuilder<C extends LineageProcess, B extends LineageProcessBuilder<C, B>>
    extends AbstractProcess.AbstractProcessBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            LineageProcessBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(LineageProcess instance, LineageProcessBuilder<?, ?> b) {
            b.typeName(instance.typeName);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "LineageProcess.LineageProcessBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ")";
        }
    }
}

