/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Resource;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.LinkIconType;
import com.atlan.model.relations.UniqueAttributes;
import java.util.UUID;
import lombok.Generated;

public class Link
extends Resource {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "Link";
    String typeName;
    @Attribute
    String icon;
    @Attribute
    LinkIconType iconType;
    @Attribute
    Asset asset;

    public static Link refByGuid(String guid) {
        return ((LinkBuilder)Link.builder().guid(guid)).build();
    }

    public static Link refByQualifiedName(String qualifiedName) {
        return ((LinkBuilder)Link.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static LinkBuilder<?, ?> creator(Asset reference, String title, String url) {
        return ((LinkBuilder)((LinkBuilder)((LinkBuilder)Link.builder().qualifiedName(Link.generateQualifiedName())).name(title)).link(url)).asset(reference);
    }

    public static LinkBuilder<?, ?> updater(String qualifiedName, String name) {
        return (LinkBuilder)((LinkBuilder)Link.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected LinkBuilder<?, ?> trimToRequired() {
        return Link.updater(this.getQualifiedName(), this.getName());
    }

    private static String generateQualifiedName() {
        return UUID.randomUUID().toString();
    }

    public static Link retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof Link) {
            return (Link)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a Link.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static Link retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof Link) {
            return (Link)entity;
        }
        throw new NotFoundException("No Link found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static Link removeDescription(String qualifiedName, String name) throws AtlanException {
        return (Link)Asset.removeDescription(((LinkBuilder)Link.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static Link removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (Link)Asset.removeUserDescription(((LinkBuilder)Link.builder().qualifiedName(qualifiedName)).name(name));
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected Link(LinkBuilder<?, ?> b) {
        super((Resource.ResourceBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : Link.$default$typeName();
        this.icon = b.icon;
        this.iconType = b.iconType;
        this.asset = b.asset;
    }

    @Generated
    public static LinkBuilder<?, ?> builder() {
        return new LinkBuilderImpl();
    }

    @Generated
    public LinkBuilder<?, ?> toBuilder() {
        return new LinkBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getIcon() {
        return this.icon;
    }

    @Generated
    public LinkIconType getIconType() {
        return this.iconType;
    }

    @Generated
    public Asset getAsset() {
        return this.asset;
    }

    @Generated
    public void setIcon(String icon) {
        this.icon = icon;
    }

    @Generated
    public void setIconType(LinkIconType iconType) {
        this.iconType = iconType;
    }

    @Generated
    public void setAsset(Asset asset) {
        this.asset = asset;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Link)) {
            return false;
        }
        Link other = (Link)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$icon = this.getIcon();
        String other$icon = other.getIcon();
        if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
            return false;
        }
        LinkIconType this$iconType = this.getIconType();
        LinkIconType other$iconType = other.getIconType();
        if (this$iconType == null ? other$iconType != null : !this$iconType.equals(other$iconType)) {
            return false;
        }
        Asset this$asset = this.getAsset();
        Asset other$asset = other.getAsset();
        return !(this$asset == null ? other$asset != null : !((Object)this$asset).equals(other$asset));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Link;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $icon = this.getIcon();
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        LinkIconType $iconType = this.getIconType();
        result = result * 59 + ($iconType == null ? 43 : $iconType.hashCode());
        Asset $asset = this.getAsset();
        result = result * 59 + ($asset == null ? 43 : ((Object)$asset).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class LinkBuilderImpl
    extends LinkBuilder<Link, LinkBuilderImpl> {
        @Generated
        private LinkBuilderImpl() {
        }

        @Override
        @Generated
        protected LinkBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public Link build() {
            return new Link(this);
        }
    }

    @Generated
    public static abstract class LinkBuilder<C extends Link, B extends LinkBuilder<C, B>>
    extends Resource.ResourceBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String icon;
        @Generated
        private LinkIconType iconType;
        @Generated
        private Asset asset;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            LinkBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(Link instance, LinkBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.icon(instance.icon);
            b.iconType(instance.iconType);
            b.asset(instance.asset);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B icon(String icon) {
            this.icon = icon;
            return (B)this.self();
        }

        @Generated
        public B iconType(LinkIconType iconType) {
            this.iconType = iconType;
            return (B)this.self();
        }

        @Generated
        public B asset(Asset asset) {
            this.asset = asset;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "Link.LinkBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", icon=" + this.icon + ", iconType=" + this.iconType + ", asset=" + this.asset + ")";
        }
    }
}

