/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.Looker;
import com.atlan.model.assets.LookerFolder;
import com.atlan.model.assets.LookerLook;
import com.atlan.model.assets.LookerTile;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class LookerDashboard
extends Looker {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "LookerDashboard";
    String typeName;
    @Attribute
    String folderName;
    @Attribute
    Integer sourceUserId;
    @Attribute
    Integer sourceViewCount;
    @Attribute
    Integer sourceMetadataId;
    @Attribute
    Integer sourcelastUpdaterId;
    @Attribute
    Long sourceLastAccessedAt;
    @Attribute
    Long sourceLastViewedAt;
    @Attribute
    SortedSet<LookerTile> tiles;
    @Attribute
    SortedSet<LookerLook> looks;
    @Attribute
    LookerFolder folder;

    public static LookerDashboard refByGuid(String guid) {
        return ((LookerDashboardBuilder)LookerDashboard.builder().guid(guid)).build();
    }

    public static LookerDashboard refByQualifiedName(String qualifiedName) {
        return ((LookerDashboardBuilder)LookerDashboard.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static LookerDashboardBuilder<?, ?> updater(String qualifiedName, String name) {
        return (LookerDashboardBuilder)((LookerDashboardBuilder)LookerDashboard.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected LookerDashboardBuilder<?, ?> trimToRequired() {
        return LookerDashboard.updater(this.getQualifiedName(), this.getName());
    }

    public static LookerDashboard retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof LookerDashboard) {
            return (LookerDashboard)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a LookerDashboard.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static LookerDashboard retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof LookerDashboard) {
            return (LookerDashboard)entity;
        }
        throw new NotFoundException("No LookerDashboard found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static LookerDashboard removeDescription(String qualifiedName, String name) throws AtlanException {
        return (LookerDashboard)Asset.removeDescription(((LookerDashboardBuilder)LookerDashboard.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static LookerDashboard removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (LookerDashboard)Asset.removeUserDescription(((LookerDashboardBuilder)LookerDashboard.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static LookerDashboard removeOwners(String qualifiedName, String name) throws AtlanException {
        return (LookerDashboard)Asset.removeOwners(((LookerDashboardBuilder)LookerDashboard.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static LookerDashboard updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (LookerDashboard)Asset.updateCertificate(LookerDashboard.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static LookerDashboard removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (LookerDashboard)Asset.removeCertificate(((LookerDashboardBuilder)LookerDashboard.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static LookerDashboard updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (LookerDashboard)Asset.updateAnnouncement(LookerDashboard.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static LookerDashboard removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (LookerDashboard)Asset.removeAnnouncement(((LookerDashboardBuilder)LookerDashboard.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static LookerDashboard replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (LookerDashboard)Asset.replaceTerms(LookerDashboard.updater(qualifiedName, name), terms);
    }

    public static LookerDashboard appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (LookerDashboard)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static LookerDashboard removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (LookerDashboard)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected LookerDashboard(LookerDashboardBuilder<?, ?> b) {
        super((Looker.LookerBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : LookerDashboard.$default$typeName();
        this.folderName = b.folderName;
        this.sourceUserId = b.sourceUserId;
        this.sourceViewCount = b.sourceViewCount;
        this.sourceMetadataId = b.sourceMetadataId;
        this.sourcelastUpdaterId = b.sourcelastUpdaterId;
        this.sourceLastAccessedAt = b.sourceLastAccessedAt;
        this.sourceLastViewedAt = b.sourceLastViewedAt;
        SortedSet<LookerTile> tiles = new TreeSet<LookerTile>();
        if (b.tiles != null) {
            tiles.addAll(b.tiles);
        }
        tiles = Collections.unmodifiableSortedSet(tiles);
        this.tiles = tiles;
        SortedSet<LookerLook> looks = new TreeSet<LookerLook>();
        if (b.looks != null) {
            looks.addAll(b.looks);
        }
        looks = Collections.unmodifiableSortedSet(looks);
        this.looks = looks;
        this.folder = b.folder;
    }

    @Generated
    public static LookerDashboardBuilder<?, ?> builder() {
        return new LookerDashboardBuilderImpl();
    }

    @Generated
    public LookerDashboardBuilder<?, ?> toBuilder() {
        return new LookerDashboardBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getFolderName() {
        return this.folderName;
    }

    @Generated
    public Integer getSourceUserId() {
        return this.sourceUserId;
    }

    @Generated
    public Integer getSourceViewCount() {
        return this.sourceViewCount;
    }

    @Generated
    public Integer getSourceMetadataId() {
        return this.sourceMetadataId;
    }

    @Generated
    public Integer getSourcelastUpdaterId() {
        return this.sourcelastUpdaterId;
    }

    @Generated
    public Long getSourceLastAccessedAt() {
        return this.sourceLastAccessedAt;
    }

    @Generated
    public Long getSourceLastViewedAt() {
        return this.sourceLastViewedAt;
    }

    @Generated
    public SortedSet<LookerTile> getTiles() {
        return this.tiles;
    }

    @Generated
    public SortedSet<LookerLook> getLooks() {
        return this.looks;
    }

    @Generated
    public LookerFolder getFolder() {
        return this.folder;
    }

    @Generated
    public void setFolderName(String folderName) {
        this.folderName = folderName;
    }

    @Generated
    public void setSourceUserId(Integer sourceUserId) {
        this.sourceUserId = sourceUserId;
    }

    @Generated
    public void setSourceViewCount(Integer sourceViewCount) {
        this.sourceViewCount = sourceViewCount;
    }

    @Generated
    public void setSourceMetadataId(Integer sourceMetadataId) {
        this.sourceMetadataId = sourceMetadataId;
    }

    @Generated
    public void setSourcelastUpdaterId(Integer sourcelastUpdaterId) {
        this.sourcelastUpdaterId = sourcelastUpdaterId;
    }

    @Generated
    public void setSourceLastAccessedAt(Long sourceLastAccessedAt) {
        this.sourceLastAccessedAt = sourceLastAccessedAt;
    }

    @Generated
    public void setSourceLastViewedAt(Long sourceLastViewedAt) {
        this.sourceLastViewedAt = sourceLastViewedAt;
    }

    @Generated
    public void setTiles(SortedSet<LookerTile> tiles) {
        this.tiles = tiles;
    }

    @Generated
    public void setLooks(SortedSet<LookerLook> looks) {
        this.looks = looks;
    }

    @Generated
    public void setFolder(LookerFolder folder) {
        this.folder = folder;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LookerDashboard)) {
            return false;
        }
        LookerDashboard other = (LookerDashboard)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$sourceUserId = this.getSourceUserId();
        Integer other$sourceUserId = other.getSourceUserId();
        if (this$sourceUserId == null ? other$sourceUserId != null : !((Object)this$sourceUserId).equals(other$sourceUserId)) {
            return false;
        }
        Integer this$sourceViewCount = this.getSourceViewCount();
        Integer other$sourceViewCount = other.getSourceViewCount();
        if (this$sourceViewCount == null ? other$sourceViewCount != null : !((Object)this$sourceViewCount).equals(other$sourceViewCount)) {
            return false;
        }
        Integer this$sourceMetadataId = this.getSourceMetadataId();
        Integer other$sourceMetadataId = other.getSourceMetadataId();
        if (this$sourceMetadataId == null ? other$sourceMetadataId != null : !((Object)this$sourceMetadataId).equals(other$sourceMetadataId)) {
            return false;
        }
        Integer this$sourcelastUpdaterId = this.getSourcelastUpdaterId();
        Integer other$sourcelastUpdaterId = other.getSourcelastUpdaterId();
        if (this$sourcelastUpdaterId == null ? other$sourcelastUpdaterId != null : !((Object)this$sourcelastUpdaterId).equals(other$sourcelastUpdaterId)) {
            return false;
        }
        Long this$sourceLastAccessedAt = this.getSourceLastAccessedAt();
        Long other$sourceLastAccessedAt = other.getSourceLastAccessedAt();
        if (this$sourceLastAccessedAt == null ? other$sourceLastAccessedAt != null : !((Object)this$sourceLastAccessedAt).equals(other$sourceLastAccessedAt)) {
            return false;
        }
        Long this$sourceLastViewedAt = this.getSourceLastViewedAt();
        Long other$sourceLastViewedAt = other.getSourceLastViewedAt();
        if (this$sourceLastViewedAt == null ? other$sourceLastViewedAt != null : !((Object)this$sourceLastViewedAt).equals(other$sourceLastViewedAt)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$folderName = this.getFolderName();
        String other$folderName = other.getFolderName();
        if (this$folderName == null ? other$folderName != null : !this$folderName.equals(other$folderName)) {
            return false;
        }
        SortedSet<LookerTile> this$tiles = this.getTiles();
        SortedSet<LookerTile> other$tiles = other.getTiles();
        if (this$tiles == null ? other$tiles != null : !this$tiles.equals(other$tiles)) {
            return false;
        }
        SortedSet<LookerLook> this$looks = this.getLooks();
        SortedSet<LookerLook> other$looks = other.getLooks();
        if (this$looks == null ? other$looks != null : !this$looks.equals(other$looks)) {
            return false;
        }
        LookerFolder this$folder = this.getFolder();
        LookerFolder other$folder = other.getFolder();
        return !(this$folder == null ? other$folder != null : !((Object)this$folder).equals(other$folder));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LookerDashboard;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $sourceUserId = this.getSourceUserId();
        result = result * 59 + ($sourceUserId == null ? 43 : ((Object)$sourceUserId).hashCode());
        Integer $sourceViewCount = this.getSourceViewCount();
        result = result * 59 + ($sourceViewCount == null ? 43 : ((Object)$sourceViewCount).hashCode());
        Integer $sourceMetadataId = this.getSourceMetadataId();
        result = result * 59 + ($sourceMetadataId == null ? 43 : ((Object)$sourceMetadataId).hashCode());
        Integer $sourcelastUpdaterId = this.getSourcelastUpdaterId();
        result = result * 59 + ($sourcelastUpdaterId == null ? 43 : ((Object)$sourcelastUpdaterId).hashCode());
        Long $sourceLastAccessedAt = this.getSourceLastAccessedAt();
        result = result * 59 + ($sourceLastAccessedAt == null ? 43 : ((Object)$sourceLastAccessedAt).hashCode());
        Long $sourceLastViewedAt = this.getSourceLastViewedAt();
        result = result * 59 + ($sourceLastViewedAt == null ? 43 : ((Object)$sourceLastViewedAt).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $folderName = this.getFolderName();
        result = result * 59 + ($folderName == null ? 43 : $folderName.hashCode());
        SortedSet<LookerTile> $tiles = this.getTiles();
        result = result * 59 + ($tiles == null ? 43 : $tiles.hashCode());
        SortedSet<LookerLook> $looks = this.getLooks();
        result = result * 59 + ($looks == null ? 43 : $looks.hashCode());
        LookerFolder $folder = this.getFolder();
        result = result * 59 + ($folder == null ? 43 : ((Object)$folder).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class LookerDashboardBuilderImpl
    extends LookerDashboardBuilder<LookerDashboard, LookerDashboardBuilderImpl> {
        @Generated
        private LookerDashboardBuilderImpl() {
        }

        @Override
        @Generated
        protected LookerDashboardBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public LookerDashboard build() {
            return new LookerDashboard(this);
        }
    }

    @Generated
    public static abstract class LookerDashboardBuilder<C extends LookerDashboard, B extends LookerDashboardBuilder<C, B>>
    extends Looker.LookerBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String folderName;
        @Generated
        private Integer sourceUserId;
        @Generated
        private Integer sourceViewCount;
        @Generated
        private Integer sourceMetadataId;
        @Generated
        private Integer sourcelastUpdaterId;
        @Generated
        private Long sourceLastAccessedAt;
        @Generated
        private Long sourceLastViewedAt;
        @Generated
        private ArrayList<LookerTile> tiles;
        @Generated
        private ArrayList<LookerLook> looks;
        @Generated
        private LookerFolder folder;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            LookerDashboardBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(LookerDashboard instance, LookerDashboardBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.folderName(instance.folderName);
            b.sourceUserId(instance.sourceUserId);
            b.sourceViewCount(instance.sourceViewCount);
            b.sourceMetadataId(instance.sourceMetadataId);
            b.sourcelastUpdaterId(instance.sourcelastUpdaterId);
            b.sourceLastAccessedAt(instance.sourceLastAccessedAt);
            b.sourceLastViewedAt(instance.sourceLastViewedAt);
            b.tiles(instance.tiles == null ? Collections.emptySortedSet() : instance.tiles);
            b.looks(instance.looks == null ? Collections.emptySortedSet() : instance.looks);
            b.folder(instance.folder);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B folderName(String folderName) {
            this.folderName = folderName;
            return (B)this.self();
        }

        @Generated
        public B sourceUserId(Integer sourceUserId) {
            this.sourceUserId = sourceUserId;
            return (B)this.self();
        }

        @Generated
        public B sourceViewCount(Integer sourceViewCount) {
            this.sourceViewCount = sourceViewCount;
            return (B)this.self();
        }

        @Generated
        public B sourceMetadataId(Integer sourceMetadataId) {
            this.sourceMetadataId = sourceMetadataId;
            return (B)this.self();
        }

        @Generated
        public B sourcelastUpdaterId(Integer sourcelastUpdaterId) {
            this.sourcelastUpdaterId = sourcelastUpdaterId;
            return (B)this.self();
        }

        @Generated
        public B sourceLastAccessedAt(Long sourceLastAccessedAt) {
            this.sourceLastAccessedAt = sourceLastAccessedAt;
            return (B)this.self();
        }

        @Generated
        public B sourceLastViewedAt(Long sourceLastViewedAt) {
            this.sourceLastViewedAt = sourceLastViewedAt;
            return (B)this.self();
        }

        @Generated
        public B tile(LookerTile tile) {
            if (this.tiles == null) {
                this.tiles = new ArrayList();
            }
            this.tiles.add(tile);
            return (B)this.self();
        }

        @Generated
        public B tiles(Collection<? extends LookerTile> tiles) {
            if (tiles == null) {
                throw new NullPointerException("tiles cannot be null");
            }
            if (this.tiles == null) {
                this.tiles = new ArrayList();
            }
            this.tiles.addAll(tiles);
            return (B)this.self();
        }

        @Generated
        public B clearTiles() {
            if (this.tiles != null) {
                this.tiles.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B look(LookerLook look) {
            if (this.looks == null) {
                this.looks = new ArrayList();
            }
            this.looks.add(look);
            return (B)this.self();
        }

        @Generated
        public B looks(Collection<? extends LookerLook> looks) {
            if (looks == null) {
                throw new NullPointerException("looks cannot be null");
            }
            if (this.looks == null) {
                this.looks = new ArrayList();
            }
            this.looks.addAll(looks);
            return (B)this.self();
        }

        @Generated
        public B clearLooks() {
            if (this.looks != null) {
                this.looks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B folder(LookerFolder folder) {
            this.folder = folder;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "LookerDashboard.LookerDashboardBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", folderName=" + this.folderName + ", sourceUserId=" + this.sourceUserId + ", sourceViewCount=" + this.sourceViewCount + ", sourceMetadataId=" + this.sourceMetadataId + ", sourcelastUpdaterId=" + this.sourcelastUpdaterId + ", sourceLastAccessedAt=" + this.sourceLastAccessedAt + ", sourceLastViewedAt=" + this.sourceLastViewedAt + ", tiles=" + this.tiles + ", looks=" + this.looks + ", folder=" + this.folder + ")";
        }
    }
}

