/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.Looker;
import com.atlan.model.assets.LookerField;
import com.atlan.model.assets.LookerModel;
import com.atlan.model.assets.LookerProject;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class LookerExplore
extends Looker {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "LookerExplore";
    String typeName;
    @Attribute
    String projectName;
    @Attribute
    String modelName;
    @Attribute
    String sourceConnectionName;
    @Attribute
    String viewName;
    @Attribute
    String sqlTableName;
    @Attribute
    LookerProject project;
    @Attribute
    LookerModel model;
    @Attribute
    SortedSet<LookerField> fields;

    public static LookerExplore refByGuid(String guid) {
        return ((LookerExploreBuilder)LookerExplore.builder().guid(guid)).build();
    }

    public static LookerExplore refByQualifiedName(String qualifiedName) {
        return ((LookerExploreBuilder)LookerExplore.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static LookerExploreBuilder<?, ?> updater(String qualifiedName, String name) {
        return (LookerExploreBuilder)((LookerExploreBuilder)LookerExplore.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected LookerExploreBuilder<?, ?> trimToRequired() {
        return LookerExplore.updater(this.getQualifiedName(), this.getName());
    }

    public static LookerExplore retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof LookerExplore) {
            return (LookerExplore)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a LookerExplore.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static LookerExplore retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof LookerExplore) {
            return (LookerExplore)entity;
        }
        throw new NotFoundException("No LookerExplore found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static LookerExplore removeDescription(String qualifiedName, String name) throws AtlanException {
        return (LookerExplore)Asset.removeDescription(((LookerExploreBuilder)LookerExplore.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static LookerExplore removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (LookerExplore)Asset.removeUserDescription(((LookerExploreBuilder)LookerExplore.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static LookerExplore removeOwners(String qualifiedName, String name) throws AtlanException {
        return (LookerExplore)Asset.removeOwners(((LookerExploreBuilder)LookerExplore.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static LookerExplore updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (LookerExplore)Asset.updateCertificate(LookerExplore.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static LookerExplore removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (LookerExplore)Asset.removeCertificate(((LookerExploreBuilder)LookerExplore.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static LookerExplore updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (LookerExplore)Asset.updateAnnouncement(LookerExplore.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static LookerExplore removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (LookerExplore)Asset.removeAnnouncement(((LookerExploreBuilder)LookerExplore.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static LookerExplore replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (LookerExplore)Asset.replaceTerms(LookerExplore.updater(qualifiedName, name), terms);
    }

    public static LookerExplore appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (LookerExplore)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static LookerExplore removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (LookerExplore)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected LookerExplore(LookerExploreBuilder<?, ?> b) {
        super((Looker.LookerBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : LookerExplore.$default$typeName();
        this.projectName = b.projectName;
        this.modelName = b.modelName;
        this.sourceConnectionName = b.sourceConnectionName;
        this.viewName = b.viewName;
        this.sqlTableName = b.sqlTableName;
        this.project = b.project;
        this.model = b.model;
        SortedSet<LookerField> fields = new TreeSet<LookerField>();
        if (b.fields != null) {
            fields.addAll(b.fields);
        }
        fields = Collections.unmodifiableSortedSet(fields);
        this.fields = fields;
    }

    @Generated
    public static LookerExploreBuilder<?, ?> builder() {
        return new LookerExploreBuilderImpl();
    }

    @Generated
    public LookerExploreBuilder<?, ?> toBuilder() {
        return new LookerExploreBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getProjectName() {
        return this.projectName;
    }

    @Generated
    public String getModelName() {
        return this.modelName;
    }

    @Generated
    public String getSourceConnectionName() {
        return this.sourceConnectionName;
    }

    @Generated
    public String getViewName() {
        return this.viewName;
    }

    @Generated
    public String getSqlTableName() {
        return this.sqlTableName;
    }

    @Generated
    public LookerProject getProject() {
        return this.project;
    }

    @Generated
    public LookerModel getModel() {
        return this.model;
    }

    @Generated
    public SortedSet<LookerField> getFields() {
        return this.fields;
    }

    @Generated
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Generated
    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    @Generated
    public void setSourceConnectionName(String sourceConnectionName) {
        this.sourceConnectionName = sourceConnectionName;
    }

    @Generated
    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    @Generated
    public void setSqlTableName(String sqlTableName) {
        this.sqlTableName = sqlTableName;
    }

    @Generated
    public void setProject(LookerProject project) {
        this.project = project;
    }

    @Generated
    public void setModel(LookerModel model) {
        this.model = model;
    }

    @Generated
    public void setFields(SortedSet<LookerField> fields) {
        this.fields = fields;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LookerExplore)) {
            return false;
        }
        LookerExplore other = (LookerExplore)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$projectName = this.getProjectName();
        String other$projectName = other.getProjectName();
        if (this$projectName == null ? other$projectName != null : !this$projectName.equals(other$projectName)) {
            return false;
        }
        String this$modelName = this.getModelName();
        String other$modelName = other.getModelName();
        if (this$modelName == null ? other$modelName != null : !this$modelName.equals(other$modelName)) {
            return false;
        }
        String this$sourceConnectionName = this.getSourceConnectionName();
        String other$sourceConnectionName = other.getSourceConnectionName();
        if (this$sourceConnectionName == null ? other$sourceConnectionName != null : !this$sourceConnectionName.equals(other$sourceConnectionName)) {
            return false;
        }
        String this$viewName = this.getViewName();
        String other$viewName = other.getViewName();
        if (this$viewName == null ? other$viewName != null : !this$viewName.equals(other$viewName)) {
            return false;
        }
        String this$sqlTableName = this.getSqlTableName();
        String other$sqlTableName = other.getSqlTableName();
        if (this$sqlTableName == null ? other$sqlTableName != null : !this$sqlTableName.equals(other$sqlTableName)) {
            return false;
        }
        LookerProject this$project = this.getProject();
        LookerProject other$project = other.getProject();
        if (this$project == null ? other$project != null : !((Object)this$project).equals(other$project)) {
            return false;
        }
        LookerModel this$model = this.getModel();
        LookerModel other$model = other.getModel();
        if (this$model == null ? other$model != null : !((Object)this$model).equals(other$model)) {
            return false;
        }
        SortedSet<LookerField> this$fields = this.getFields();
        SortedSet<LookerField> other$fields = other.getFields();
        return !(this$fields == null ? other$fields != null : !this$fields.equals(other$fields));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LookerExplore;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $projectName = this.getProjectName();
        result = result * 59 + ($projectName == null ? 43 : $projectName.hashCode());
        String $modelName = this.getModelName();
        result = result * 59 + ($modelName == null ? 43 : $modelName.hashCode());
        String $sourceConnectionName = this.getSourceConnectionName();
        result = result * 59 + ($sourceConnectionName == null ? 43 : $sourceConnectionName.hashCode());
        String $viewName = this.getViewName();
        result = result * 59 + ($viewName == null ? 43 : $viewName.hashCode());
        String $sqlTableName = this.getSqlTableName();
        result = result * 59 + ($sqlTableName == null ? 43 : $sqlTableName.hashCode());
        LookerProject $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : ((Object)$project).hashCode());
        LookerModel $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : ((Object)$model).hashCode());
        SortedSet<LookerField> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : $fields.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class LookerExploreBuilderImpl
    extends LookerExploreBuilder<LookerExplore, LookerExploreBuilderImpl> {
        @Generated
        private LookerExploreBuilderImpl() {
        }

        @Override
        @Generated
        protected LookerExploreBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public LookerExplore build() {
            return new LookerExplore(this);
        }
    }

    @Generated
    public static abstract class LookerExploreBuilder<C extends LookerExplore, B extends LookerExploreBuilder<C, B>>
    extends Looker.LookerBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String projectName;
        @Generated
        private String modelName;
        @Generated
        private String sourceConnectionName;
        @Generated
        private String viewName;
        @Generated
        private String sqlTableName;
        @Generated
        private LookerProject project;
        @Generated
        private LookerModel model;
        @Generated
        private ArrayList<LookerField> fields;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            LookerExploreBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(LookerExplore instance, LookerExploreBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.projectName(instance.projectName);
            b.modelName(instance.modelName);
            b.sourceConnectionName(instance.sourceConnectionName);
            b.viewName(instance.viewName);
            b.sqlTableName(instance.sqlTableName);
            b.project(instance.project);
            b.model(instance.model);
            b.fields(instance.fields == null ? Collections.emptySortedSet() : instance.fields);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B projectName(String projectName) {
            this.projectName = projectName;
            return (B)this.self();
        }

        @Generated
        public B modelName(String modelName) {
            this.modelName = modelName;
            return (B)this.self();
        }

        @Generated
        public B sourceConnectionName(String sourceConnectionName) {
            this.sourceConnectionName = sourceConnectionName;
            return (B)this.self();
        }

        @Generated
        public B viewName(String viewName) {
            this.viewName = viewName;
            return (B)this.self();
        }

        @Generated
        public B sqlTableName(String sqlTableName) {
            this.sqlTableName = sqlTableName;
            return (B)this.self();
        }

        @Generated
        public B project(LookerProject project) {
            this.project = project;
            return (B)this.self();
        }

        @Generated
        public B model(LookerModel model) {
            this.model = model;
            return (B)this.self();
        }

        @Generated
        public B field(LookerField field) {
            if (this.fields == null) {
                this.fields = new ArrayList();
            }
            this.fields.add(field);
            return (B)this.self();
        }

        @Generated
        public B fields(Collection<? extends LookerField> fields) {
            if (fields == null) {
                throw new NullPointerException("fields cannot be null");
            }
            if (this.fields == null) {
                this.fields = new ArrayList();
            }
            this.fields.addAll(fields);
            return (B)this.self();
        }

        @Generated
        public B clearFields() {
            if (this.fields != null) {
                this.fields.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "LookerExplore.LookerExploreBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", projectName=" + this.projectName + ", modelName=" + this.modelName + ", sourceConnectionName=" + this.sourceConnectionName + ", viewName=" + this.viewName + ", sqlTableName=" + this.sqlTableName + ", project=" + this.project + ", model=" + this.model + ", fields=" + this.fields + ")";
        }
    }
}

