/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.Looker;
import com.atlan.model.assets.LookerExplore;
import com.atlan.model.assets.LookerModel;
import com.atlan.model.assets.LookerProject;
import com.atlan.model.assets.LookerView;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.List;
import lombok.Generated;

public class LookerField
extends Looker {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "LookerField";
    String typeName;
    @Attribute
    String projectName;
    @Attribute
    String lookerExploreQualifiedName;
    @Attribute
    String lookerViewQualifiedName;
    @Attribute
    String modelName;
    @Attribute
    String sourceDefinition;
    @Attribute
    String lookerFieldDataType;
    @Attribute
    Integer lookerTimesUsed;
    @Attribute
    LookerView view;
    @Attribute
    LookerExplore explore;
    @Attribute
    LookerProject project;
    @Attribute
    LookerModel model;

    public static LookerField refByGuid(String guid) {
        return ((LookerFieldBuilder)LookerField.builder().guid(guid)).build();
    }

    public static LookerField refByQualifiedName(String qualifiedName) {
        return ((LookerFieldBuilder)LookerField.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static LookerFieldBuilder<?, ?> updater(String qualifiedName, String name) {
        return (LookerFieldBuilder)((LookerFieldBuilder)LookerField.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected LookerFieldBuilder<?, ?> trimToRequired() {
        return LookerField.updater(this.getQualifiedName(), this.getName());
    }

    public static LookerField retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof LookerField) {
            return (LookerField)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a LookerField.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static LookerField retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof LookerField) {
            return (LookerField)entity;
        }
        throw new NotFoundException("No LookerField found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static LookerField removeDescription(String qualifiedName, String name) throws AtlanException {
        return (LookerField)Asset.removeDescription(((LookerFieldBuilder)LookerField.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static LookerField removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (LookerField)Asset.removeUserDescription(((LookerFieldBuilder)LookerField.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static LookerField removeOwners(String qualifiedName, String name) throws AtlanException {
        return (LookerField)Asset.removeOwners(((LookerFieldBuilder)LookerField.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static LookerField updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (LookerField)Asset.updateCertificate(LookerField.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static LookerField removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (LookerField)Asset.removeCertificate(((LookerFieldBuilder)LookerField.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static LookerField updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (LookerField)Asset.updateAnnouncement(LookerField.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static LookerField removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (LookerField)Asset.removeAnnouncement(((LookerFieldBuilder)LookerField.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static LookerField replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (LookerField)Asset.replaceTerms(LookerField.updater(qualifiedName, name), terms);
    }

    public static LookerField appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (LookerField)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static LookerField removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (LookerField)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected LookerField(LookerFieldBuilder<?, ?> b) {
        super((Looker.LookerBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : LookerField.$default$typeName();
        this.projectName = b.projectName;
        this.lookerExploreQualifiedName = b.lookerExploreQualifiedName;
        this.lookerViewQualifiedName = b.lookerViewQualifiedName;
        this.modelName = b.modelName;
        this.sourceDefinition = b.sourceDefinition;
        this.lookerFieldDataType = b.lookerFieldDataType;
        this.lookerTimesUsed = b.lookerTimesUsed;
        this.view = b.view;
        this.explore = b.explore;
        this.project = b.project;
        this.model = b.model;
    }

    @Generated
    public static LookerFieldBuilder<?, ?> builder() {
        return new LookerFieldBuilderImpl();
    }

    @Generated
    public LookerFieldBuilder<?, ?> toBuilder() {
        return new LookerFieldBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getProjectName() {
        return this.projectName;
    }

    @Generated
    public String getLookerExploreQualifiedName() {
        return this.lookerExploreQualifiedName;
    }

    @Generated
    public String getLookerViewQualifiedName() {
        return this.lookerViewQualifiedName;
    }

    @Generated
    public String getModelName() {
        return this.modelName;
    }

    @Generated
    public String getSourceDefinition() {
        return this.sourceDefinition;
    }

    @Generated
    public String getLookerFieldDataType() {
        return this.lookerFieldDataType;
    }

    @Generated
    public Integer getLookerTimesUsed() {
        return this.lookerTimesUsed;
    }

    @Generated
    public LookerView getView() {
        return this.view;
    }

    @Generated
    public LookerExplore getExplore() {
        return this.explore;
    }

    @Generated
    public LookerProject getProject() {
        return this.project;
    }

    @Generated
    public LookerModel getModel() {
        return this.model;
    }

    @Generated
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Generated
    public void setLookerExploreQualifiedName(String lookerExploreQualifiedName) {
        this.lookerExploreQualifiedName = lookerExploreQualifiedName;
    }

    @Generated
    public void setLookerViewQualifiedName(String lookerViewQualifiedName) {
        this.lookerViewQualifiedName = lookerViewQualifiedName;
    }

    @Generated
    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    @Generated
    public void setSourceDefinition(String sourceDefinition) {
        this.sourceDefinition = sourceDefinition;
    }

    @Generated
    public void setLookerFieldDataType(String lookerFieldDataType) {
        this.lookerFieldDataType = lookerFieldDataType;
    }

    @Generated
    public void setLookerTimesUsed(Integer lookerTimesUsed) {
        this.lookerTimesUsed = lookerTimesUsed;
    }

    @Generated
    public void setView(LookerView view) {
        this.view = view;
    }

    @Generated
    public void setExplore(LookerExplore explore) {
        this.explore = explore;
    }

    @Generated
    public void setProject(LookerProject project) {
        this.project = project;
    }

    @Generated
    public void setModel(LookerModel model) {
        this.model = model;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LookerField)) {
            return false;
        }
        LookerField other = (LookerField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$lookerTimesUsed = this.getLookerTimesUsed();
        Integer other$lookerTimesUsed = other.getLookerTimesUsed();
        if (this$lookerTimesUsed == null ? other$lookerTimesUsed != null : !((Object)this$lookerTimesUsed).equals(other$lookerTimesUsed)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$projectName = this.getProjectName();
        String other$projectName = other.getProjectName();
        if (this$projectName == null ? other$projectName != null : !this$projectName.equals(other$projectName)) {
            return false;
        }
        String this$lookerExploreQualifiedName = this.getLookerExploreQualifiedName();
        String other$lookerExploreQualifiedName = other.getLookerExploreQualifiedName();
        if (this$lookerExploreQualifiedName == null ? other$lookerExploreQualifiedName != null : !this$lookerExploreQualifiedName.equals(other$lookerExploreQualifiedName)) {
            return false;
        }
        String this$lookerViewQualifiedName = this.getLookerViewQualifiedName();
        String other$lookerViewQualifiedName = other.getLookerViewQualifiedName();
        if (this$lookerViewQualifiedName == null ? other$lookerViewQualifiedName != null : !this$lookerViewQualifiedName.equals(other$lookerViewQualifiedName)) {
            return false;
        }
        String this$modelName = this.getModelName();
        String other$modelName = other.getModelName();
        if (this$modelName == null ? other$modelName != null : !this$modelName.equals(other$modelName)) {
            return false;
        }
        String this$sourceDefinition = this.getSourceDefinition();
        String other$sourceDefinition = other.getSourceDefinition();
        if (this$sourceDefinition == null ? other$sourceDefinition != null : !this$sourceDefinition.equals(other$sourceDefinition)) {
            return false;
        }
        String this$lookerFieldDataType = this.getLookerFieldDataType();
        String other$lookerFieldDataType = other.getLookerFieldDataType();
        if (this$lookerFieldDataType == null ? other$lookerFieldDataType != null : !this$lookerFieldDataType.equals(other$lookerFieldDataType)) {
            return false;
        }
        LookerView this$view = this.getView();
        LookerView other$view = other.getView();
        if (this$view == null ? other$view != null : !((Object)this$view).equals(other$view)) {
            return false;
        }
        LookerExplore this$explore = this.getExplore();
        LookerExplore other$explore = other.getExplore();
        if (this$explore == null ? other$explore != null : !((Object)this$explore).equals(other$explore)) {
            return false;
        }
        LookerProject this$project = this.getProject();
        LookerProject other$project = other.getProject();
        if (this$project == null ? other$project != null : !((Object)this$project).equals(other$project)) {
            return false;
        }
        LookerModel this$model = this.getModel();
        LookerModel other$model = other.getModel();
        return !(this$model == null ? other$model != null : !((Object)this$model).equals(other$model));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LookerField;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $lookerTimesUsed = this.getLookerTimesUsed();
        result = result * 59 + ($lookerTimesUsed == null ? 43 : ((Object)$lookerTimesUsed).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $projectName = this.getProjectName();
        result = result * 59 + ($projectName == null ? 43 : $projectName.hashCode());
        String $lookerExploreQualifiedName = this.getLookerExploreQualifiedName();
        result = result * 59 + ($lookerExploreQualifiedName == null ? 43 : $lookerExploreQualifiedName.hashCode());
        String $lookerViewQualifiedName = this.getLookerViewQualifiedName();
        result = result * 59 + ($lookerViewQualifiedName == null ? 43 : $lookerViewQualifiedName.hashCode());
        String $modelName = this.getModelName();
        result = result * 59 + ($modelName == null ? 43 : $modelName.hashCode());
        String $sourceDefinition = this.getSourceDefinition();
        result = result * 59 + ($sourceDefinition == null ? 43 : $sourceDefinition.hashCode());
        String $lookerFieldDataType = this.getLookerFieldDataType();
        result = result * 59 + ($lookerFieldDataType == null ? 43 : $lookerFieldDataType.hashCode());
        LookerView $view = this.getView();
        result = result * 59 + ($view == null ? 43 : ((Object)$view).hashCode());
        LookerExplore $explore = this.getExplore();
        result = result * 59 + ($explore == null ? 43 : ((Object)$explore).hashCode());
        LookerProject $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : ((Object)$project).hashCode());
        LookerModel $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : ((Object)$model).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class LookerFieldBuilderImpl
    extends LookerFieldBuilder<LookerField, LookerFieldBuilderImpl> {
        @Generated
        private LookerFieldBuilderImpl() {
        }

        @Override
        @Generated
        protected LookerFieldBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public LookerField build() {
            return new LookerField(this);
        }
    }

    @Generated
    public static abstract class LookerFieldBuilder<C extends LookerField, B extends LookerFieldBuilder<C, B>>
    extends Looker.LookerBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String projectName;
        @Generated
        private String lookerExploreQualifiedName;
        @Generated
        private String lookerViewQualifiedName;
        @Generated
        private String modelName;
        @Generated
        private String sourceDefinition;
        @Generated
        private String lookerFieldDataType;
        @Generated
        private Integer lookerTimesUsed;
        @Generated
        private LookerView view;
        @Generated
        private LookerExplore explore;
        @Generated
        private LookerProject project;
        @Generated
        private LookerModel model;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            LookerFieldBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(LookerField instance, LookerFieldBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.projectName(instance.projectName);
            b.lookerExploreQualifiedName(instance.lookerExploreQualifiedName);
            b.lookerViewQualifiedName(instance.lookerViewQualifiedName);
            b.modelName(instance.modelName);
            b.sourceDefinition(instance.sourceDefinition);
            b.lookerFieldDataType(instance.lookerFieldDataType);
            b.lookerTimesUsed(instance.lookerTimesUsed);
            b.view(instance.view);
            b.explore(instance.explore);
            b.project(instance.project);
            b.model(instance.model);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B projectName(String projectName) {
            this.projectName = projectName;
            return (B)this.self();
        }

        @Generated
        public B lookerExploreQualifiedName(String lookerExploreQualifiedName) {
            this.lookerExploreQualifiedName = lookerExploreQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B lookerViewQualifiedName(String lookerViewQualifiedName) {
            this.lookerViewQualifiedName = lookerViewQualifiedName;
            return (B)this.self();
        }

        @Generated
        public B modelName(String modelName) {
            this.modelName = modelName;
            return (B)this.self();
        }

        @Generated
        public B sourceDefinition(String sourceDefinition) {
            this.sourceDefinition = sourceDefinition;
            return (B)this.self();
        }

        @Generated
        public B lookerFieldDataType(String lookerFieldDataType) {
            this.lookerFieldDataType = lookerFieldDataType;
            return (B)this.self();
        }

        @Generated
        public B lookerTimesUsed(Integer lookerTimesUsed) {
            this.lookerTimesUsed = lookerTimesUsed;
            return (B)this.self();
        }

        @Generated
        public B view(LookerView view) {
            this.view = view;
            return (B)this.self();
        }

        @Generated
        public B explore(LookerExplore explore) {
            this.explore = explore;
            return (B)this.self();
        }

        @Generated
        public B project(LookerProject project) {
            this.project = project;
            return (B)this.self();
        }

        @Generated
        public B model(LookerModel model) {
            this.model = model;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "LookerField.LookerFieldBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", projectName=" + this.projectName + ", lookerExploreQualifiedName=" + this.lookerExploreQualifiedName + ", lookerViewQualifiedName=" + this.lookerViewQualifiedName + ", modelName=" + this.modelName + ", sourceDefinition=" + this.sourceDefinition + ", lookerFieldDataType=" + this.lookerFieldDataType + ", lookerTimesUsed=" + this.lookerTimesUsed + ", view=" + this.view + ", explore=" + this.explore + ", project=" + this.project + ", model=" + this.model + ")";
        }
    }
}

