/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.Looker;
import com.atlan.model.assets.LookerDashboard;
import com.atlan.model.assets.LookerLook;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class LookerFolder
extends Looker {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "LookerFolder";
    String typeName;
    @Attribute
    Integer sourceContentMetadataId;
    @Attribute
    Integer sourceCreatorId;
    @Attribute
    Integer sourceChildCount;
    @Attribute
    Integer sourceParentID;
    @Attribute
    SortedSet<LookerLook> looks;
    @Attribute
    SortedSet<LookerDashboard> dashboards;

    public static LookerFolder refByGuid(String guid) {
        return ((LookerFolderBuilder)LookerFolder.builder().guid(guid)).build();
    }

    public static LookerFolder refByQualifiedName(String qualifiedName) {
        return ((LookerFolderBuilder)LookerFolder.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static LookerFolderBuilder<?, ?> updater(String qualifiedName, String name) {
        return (LookerFolderBuilder)((LookerFolderBuilder)LookerFolder.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected LookerFolderBuilder<?, ?> trimToRequired() {
        return LookerFolder.updater(this.getQualifiedName(), this.getName());
    }

    public static LookerFolder retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof LookerFolder) {
            return (LookerFolder)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a LookerFolder.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static LookerFolder retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof LookerFolder) {
            return (LookerFolder)entity;
        }
        throw new NotFoundException("No LookerFolder found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static LookerFolder removeDescription(String qualifiedName, String name) throws AtlanException {
        return (LookerFolder)Asset.removeDescription(((LookerFolderBuilder)LookerFolder.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static LookerFolder removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (LookerFolder)Asset.removeUserDescription(((LookerFolderBuilder)LookerFolder.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static LookerFolder removeOwners(String qualifiedName, String name) throws AtlanException {
        return (LookerFolder)Asset.removeOwners(((LookerFolderBuilder)LookerFolder.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static LookerFolder updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (LookerFolder)Asset.updateCertificate(LookerFolder.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static LookerFolder removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (LookerFolder)Asset.removeCertificate(((LookerFolderBuilder)LookerFolder.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static LookerFolder updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (LookerFolder)Asset.updateAnnouncement(LookerFolder.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static LookerFolder removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (LookerFolder)Asset.removeAnnouncement(((LookerFolderBuilder)LookerFolder.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static LookerFolder replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (LookerFolder)Asset.replaceTerms(LookerFolder.updater(qualifiedName, name), terms);
    }

    public static LookerFolder appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (LookerFolder)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static LookerFolder removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (LookerFolder)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected LookerFolder(LookerFolderBuilder<?, ?> b) {
        super((Looker.LookerBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : LookerFolder.$default$typeName();
        this.sourceContentMetadataId = b.sourceContentMetadataId;
        this.sourceCreatorId = b.sourceCreatorId;
        this.sourceChildCount = b.sourceChildCount;
        this.sourceParentID = b.sourceParentID;
        SortedSet<LookerLook> looks = new TreeSet<LookerLook>();
        if (b.looks != null) {
            looks.addAll(b.looks);
        }
        looks = Collections.unmodifiableSortedSet(looks);
        this.looks = looks;
        SortedSet<LookerDashboard> dashboards = new TreeSet<LookerDashboard>();
        if (b.dashboards != null) {
            dashboards.addAll(b.dashboards);
        }
        dashboards = Collections.unmodifiableSortedSet(dashboards);
        this.dashboards = dashboards;
    }

    @Generated
    public static LookerFolderBuilder<?, ?> builder() {
        return new LookerFolderBuilderImpl();
    }

    @Generated
    public LookerFolderBuilder<?, ?> toBuilder() {
        return new LookerFolderBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public Integer getSourceContentMetadataId() {
        return this.sourceContentMetadataId;
    }

    @Generated
    public Integer getSourceCreatorId() {
        return this.sourceCreatorId;
    }

    @Generated
    public Integer getSourceChildCount() {
        return this.sourceChildCount;
    }

    @Generated
    public Integer getSourceParentID() {
        return this.sourceParentID;
    }

    @Generated
    public SortedSet<LookerLook> getLooks() {
        return this.looks;
    }

    @Generated
    public SortedSet<LookerDashboard> getDashboards() {
        return this.dashboards;
    }

    @Generated
    public void setSourceContentMetadataId(Integer sourceContentMetadataId) {
        this.sourceContentMetadataId = sourceContentMetadataId;
    }

    @Generated
    public void setSourceCreatorId(Integer sourceCreatorId) {
        this.sourceCreatorId = sourceCreatorId;
    }

    @Generated
    public void setSourceChildCount(Integer sourceChildCount) {
        this.sourceChildCount = sourceChildCount;
    }

    @Generated
    public void setSourceParentID(Integer sourceParentID) {
        this.sourceParentID = sourceParentID;
    }

    @Generated
    public void setLooks(SortedSet<LookerLook> looks) {
        this.looks = looks;
    }

    @Generated
    public void setDashboards(SortedSet<LookerDashboard> dashboards) {
        this.dashboards = dashboards;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LookerFolder)) {
            return false;
        }
        LookerFolder other = (LookerFolder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$sourceContentMetadataId = this.getSourceContentMetadataId();
        Integer other$sourceContentMetadataId = other.getSourceContentMetadataId();
        if (this$sourceContentMetadataId == null ? other$sourceContentMetadataId != null : !((Object)this$sourceContentMetadataId).equals(other$sourceContentMetadataId)) {
            return false;
        }
        Integer this$sourceCreatorId = this.getSourceCreatorId();
        Integer other$sourceCreatorId = other.getSourceCreatorId();
        if (this$sourceCreatorId == null ? other$sourceCreatorId != null : !((Object)this$sourceCreatorId).equals(other$sourceCreatorId)) {
            return false;
        }
        Integer this$sourceChildCount = this.getSourceChildCount();
        Integer other$sourceChildCount = other.getSourceChildCount();
        if (this$sourceChildCount == null ? other$sourceChildCount != null : !((Object)this$sourceChildCount).equals(other$sourceChildCount)) {
            return false;
        }
        Integer this$sourceParentID = this.getSourceParentID();
        Integer other$sourceParentID = other.getSourceParentID();
        if (this$sourceParentID == null ? other$sourceParentID != null : !((Object)this$sourceParentID).equals(other$sourceParentID)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<LookerLook> this$looks = this.getLooks();
        SortedSet<LookerLook> other$looks = other.getLooks();
        if (this$looks == null ? other$looks != null : !this$looks.equals(other$looks)) {
            return false;
        }
        SortedSet<LookerDashboard> this$dashboards = this.getDashboards();
        SortedSet<LookerDashboard> other$dashboards = other.getDashboards();
        return !(this$dashboards == null ? other$dashboards != null : !this$dashboards.equals(other$dashboards));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LookerFolder;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $sourceContentMetadataId = this.getSourceContentMetadataId();
        result = result * 59 + ($sourceContentMetadataId == null ? 43 : ((Object)$sourceContentMetadataId).hashCode());
        Integer $sourceCreatorId = this.getSourceCreatorId();
        result = result * 59 + ($sourceCreatorId == null ? 43 : ((Object)$sourceCreatorId).hashCode());
        Integer $sourceChildCount = this.getSourceChildCount();
        result = result * 59 + ($sourceChildCount == null ? 43 : ((Object)$sourceChildCount).hashCode());
        Integer $sourceParentID = this.getSourceParentID();
        result = result * 59 + ($sourceParentID == null ? 43 : ((Object)$sourceParentID).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<LookerLook> $looks = this.getLooks();
        result = result * 59 + ($looks == null ? 43 : $looks.hashCode());
        SortedSet<LookerDashboard> $dashboards = this.getDashboards();
        result = result * 59 + ($dashboards == null ? 43 : $dashboards.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class LookerFolderBuilderImpl
    extends LookerFolderBuilder<LookerFolder, LookerFolderBuilderImpl> {
        @Generated
        private LookerFolderBuilderImpl() {
        }

        @Override
        @Generated
        protected LookerFolderBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public LookerFolder build() {
            return new LookerFolder(this);
        }
    }

    @Generated
    public static abstract class LookerFolderBuilder<C extends LookerFolder, B extends LookerFolderBuilder<C, B>>
    extends Looker.LookerBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private Integer sourceContentMetadataId;
        @Generated
        private Integer sourceCreatorId;
        @Generated
        private Integer sourceChildCount;
        @Generated
        private Integer sourceParentID;
        @Generated
        private ArrayList<LookerLook> looks;
        @Generated
        private ArrayList<LookerDashboard> dashboards;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            LookerFolderBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(LookerFolder instance, LookerFolderBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.sourceContentMetadataId(instance.sourceContentMetadataId);
            b.sourceCreatorId(instance.sourceCreatorId);
            b.sourceChildCount(instance.sourceChildCount);
            b.sourceParentID(instance.sourceParentID);
            b.looks(instance.looks == null ? Collections.emptySortedSet() : instance.looks);
            b.dashboards(instance.dashboards == null ? Collections.emptySortedSet() : instance.dashboards);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B sourceContentMetadataId(Integer sourceContentMetadataId) {
            this.sourceContentMetadataId = sourceContentMetadataId;
            return (B)this.self();
        }

        @Generated
        public B sourceCreatorId(Integer sourceCreatorId) {
            this.sourceCreatorId = sourceCreatorId;
            return (B)this.self();
        }

        @Generated
        public B sourceChildCount(Integer sourceChildCount) {
            this.sourceChildCount = sourceChildCount;
            return (B)this.self();
        }

        @Generated
        public B sourceParentID(Integer sourceParentID) {
            this.sourceParentID = sourceParentID;
            return (B)this.self();
        }

        @Generated
        public B look(LookerLook look) {
            if (this.looks == null) {
                this.looks = new ArrayList();
            }
            this.looks.add(look);
            return (B)this.self();
        }

        @Generated
        public B looks(Collection<? extends LookerLook> looks) {
            if (looks == null) {
                throw new NullPointerException("looks cannot be null");
            }
            if (this.looks == null) {
                this.looks = new ArrayList();
            }
            this.looks.addAll(looks);
            return (B)this.self();
        }

        @Generated
        public B clearLooks() {
            if (this.looks != null) {
                this.looks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B dashboard(LookerDashboard dashboard) {
            if (this.dashboards == null) {
                this.dashboards = new ArrayList();
            }
            this.dashboards.add(dashboard);
            return (B)this.self();
        }

        @Generated
        public B dashboards(Collection<? extends LookerDashboard> dashboards) {
            if (dashboards == null) {
                throw new NullPointerException("dashboards cannot be null");
            }
            if (this.dashboards == null) {
                this.dashboards = new ArrayList();
            }
            this.dashboards.addAll(dashboards);
            return (B)this.self();
        }

        @Generated
        public B clearDashboards() {
            if (this.dashboards != null) {
                this.dashboards.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "LookerFolder.LookerFolderBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", sourceContentMetadataId=" + this.sourceContentMetadataId + ", sourceCreatorId=" + this.sourceCreatorId + ", sourceChildCount=" + this.sourceChildCount + ", sourceParentID=" + this.sourceParentID + ", looks=" + this.looks + ", dashboards=" + this.dashboards + ")";
        }
    }
}

