/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.Looker;
import com.atlan.model.assets.LookerDashboard;
import com.atlan.model.assets.LookerFolder;
import com.atlan.model.assets.LookerModel;
import com.atlan.model.assets.LookerQuery;
import com.atlan.model.assets.LookerTile;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.List;
import lombok.Generated;

public class LookerLook
extends Looker {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "LookerLook";
    String typeName;
    @Attribute
    String folderName;
    @Attribute
    Integer sourceUserId;
    @Attribute
    Integer sourceViewCount;
    @Attribute
    Integer sourcelastUpdaterId;
    @Attribute
    Long sourceLastAccessedAt;
    @Attribute
    Long sourceLastViewedAt;
    @Attribute
    Integer sourceContentMetadataId;
    @Attribute
    Integer sourceQueryId;
    @Attribute
    String modelName;
    @Attribute
    LookerFolder folder;
    @Attribute
    LookerQuery query;
    @Attribute
    LookerTile tile;
    @Attribute
    LookerModel model;
    @Attribute
    LookerDashboard dashboard;

    public static LookerLook refByGuid(String guid) {
        return ((LookerLookBuilder)LookerLook.builder().guid(guid)).build();
    }

    public static LookerLook refByQualifiedName(String qualifiedName) {
        return ((LookerLookBuilder)LookerLook.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static LookerLookBuilder<?, ?> updater(String qualifiedName, String name) {
        return (LookerLookBuilder)((LookerLookBuilder)LookerLook.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected LookerLookBuilder<?, ?> trimToRequired() {
        return LookerLook.updater(this.getQualifiedName(), this.getName());
    }

    public static LookerLook retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof LookerLook) {
            return (LookerLook)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a LookerLook.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static LookerLook retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof LookerLook) {
            return (LookerLook)entity;
        }
        throw new NotFoundException("No LookerLook found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static LookerLook removeDescription(String qualifiedName, String name) throws AtlanException {
        return (LookerLook)Asset.removeDescription(((LookerLookBuilder)LookerLook.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static LookerLook removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (LookerLook)Asset.removeUserDescription(((LookerLookBuilder)LookerLook.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static LookerLook removeOwners(String qualifiedName, String name) throws AtlanException {
        return (LookerLook)Asset.removeOwners(((LookerLookBuilder)LookerLook.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static LookerLook updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (LookerLook)Asset.updateCertificate(LookerLook.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static LookerLook removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (LookerLook)Asset.removeCertificate(((LookerLookBuilder)LookerLook.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static LookerLook updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (LookerLook)Asset.updateAnnouncement(LookerLook.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static LookerLook removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (LookerLook)Asset.removeAnnouncement(((LookerLookBuilder)LookerLook.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static LookerLook replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (LookerLook)Asset.replaceTerms(LookerLook.updater(qualifiedName, name), terms);
    }

    public static LookerLook appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (LookerLook)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static LookerLook removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (LookerLook)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected LookerLook(LookerLookBuilder<?, ?> b) {
        super((Looker.LookerBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : LookerLook.$default$typeName();
        this.folderName = b.folderName;
        this.sourceUserId = b.sourceUserId;
        this.sourceViewCount = b.sourceViewCount;
        this.sourcelastUpdaterId = b.sourcelastUpdaterId;
        this.sourceLastAccessedAt = b.sourceLastAccessedAt;
        this.sourceLastViewedAt = b.sourceLastViewedAt;
        this.sourceContentMetadataId = b.sourceContentMetadataId;
        this.sourceQueryId = b.sourceQueryId;
        this.modelName = b.modelName;
        this.folder = b.folder;
        this.query = b.query;
        this.tile = b.tile;
        this.model = b.model;
        this.dashboard = b.dashboard;
    }

    @Generated
    public static LookerLookBuilder<?, ?> builder() {
        return new LookerLookBuilderImpl();
    }

    @Generated
    public LookerLookBuilder<?, ?> toBuilder() {
        return new LookerLookBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getFolderName() {
        return this.folderName;
    }

    @Generated
    public Integer getSourceUserId() {
        return this.sourceUserId;
    }

    @Generated
    public Integer getSourceViewCount() {
        return this.sourceViewCount;
    }

    @Generated
    public Integer getSourcelastUpdaterId() {
        return this.sourcelastUpdaterId;
    }

    @Generated
    public Long getSourceLastAccessedAt() {
        return this.sourceLastAccessedAt;
    }

    @Generated
    public Long getSourceLastViewedAt() {
        return this.sourceLastViewedAt;
    }

    @Generated
    public Integer getSourceContentMetadataId() {
        return this.sourceContentMetadataId;
    }

    @Generated
    public Integer getSourceQueryId() {
        return this.sourceQueryId;
    }

    @Generated
    public String getModelName() {
        return this.modelName;
    }

    @Generated
    public LookerFolder getFolder() {
        return this.folder;
    }

    @Generated
    public LookerQuery getQuery() {
        return this.query;
    }

    @Generated
    public LookerTile getTile() {
        return this.tile;
    }

    @Generated
    public LookerModel getModel() {
        return this.model;
    }

    @Generated
    public LookerDashboard getDashboard() {
        return this.dashboard;
    }

    @Generated
    public void setFolderName(String folderName) {
        this.folderName = folderName;
    }

    @Generated
    public void setSourceUserId(Integer sourceUserId) {
        this.sourceUserId = sourceUserId;
    }

    @Generated
    public void setSourceViewCount(Integer sourceViewCount) {
        this.sourceViewCount = sourceViewCount;
    }

    @Generated
    public void setSourcelastUpdaterId(Integer sourcelastUpdaterId) {
        this.sourcelastUpdaterId = sourcelastUpdaterId;
    }

    @Generated
    public void setSourceLastAccessedAt(Long sourceLastAccessedAt) {
        this.sourceLastAccessedAt = sourceLastAccessedAt;
    }

    @Generated
    public void setSourceLastViewedAt(Long sourceLastViewedAt) {
        this.sourceLastViewedAt = sourceLastViewedAt;
    }

    @Generated
    public void setSourceContentMetadataId(Integer sourceContentMetadataId) {
        this.sourceContentMetadataId = sourceContentMetadataId;
    }

    @Generated
    public void setSourceQueryId(Integer sourceQueryId) {
        this.sourceQueryId = sourceQueryId;
    }

    @Generated
    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    @Generated
    public void setFolder(LookerFolder folder) {
        this.folder = folder;
    }

    @Generated
    public void setQuery(LookerQuery query) {
        this.query = query;
    }

    @Generated
    public void setTile(LookerTile tile) {
        this.tile = tile;
    }

    @Generated
    public void setModel(LookerModel model) {
        this.model = model;
    }

    @Generated
    public void setDashboard(LookerDashboard dashboard) {
        this.dashboard = dashboard;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LookerLook)) {
            return false;
        }
        LookerLook other = (LookerLook)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$sourceUserId = this.getSourceUserId();
        Integer other$sourceUserId = other.getSourceUserId();
        if (this$sourceUserId == null ? other$sourceUserId != null : !((Object)this$sourceUserId).equals(other$sourceUserId)) {
            return false;
        }
        Integer this$sourceViewCount = this.getSourceViewCount();
        Integer other$sourceViewCount = other.getSourceViewCount();
        if (this$sourceViewCount == null ? other$sourceViewCount != null : !((Object)this$sourceViewCount).equals(other$sourceViewCount)) {
            return false;
        }
        Integer this$sourcelastUpdaterId = this.getSourcelastUpdaterId();
        Integer other$sourcelastUpdaterId = other.getSourcelastUpdaterId();
        if (this$sourcelastUpdaterId == null ? other$sourcelastUpdaterId != null : !((Object)this$sourcelastUpdaterId).equals(other$sourcelastUpdaterId)) {
            return false;
        }
        Long this$sourceLastAccessedAt = this.getSourceLastAccessedAt();
        Long other$sourceLastAccessedAt = other.getSourceLastAccessedAt();
        if (this$sourceLastAccessedAt == null ? other$sourceLastAccessedAt != null : !((Object)this$sourceLastAccessedAt).equals(other$sourceLastAccessedAt)) {
            return false;
        }
        Long this$sourceLastViewedAt = this.getSourceLastViewedAt();
        Long other$sourceLastViewedAt = other.getSourceLastViewedAt();
        if (this$sourceLastViewedAt == null ? other$sourceLastViewedAt != null : !((Object)this$sourceLastViewedAt).equals(other$sourceLastViewedAt)) {
            return false;
        }
        Integer this$sourceContentMetadataId = this.getSourceContentMetadataId();
        Integer other$sourceContentMetadataId = other.getSourceContentMetadataId();
        if (this$sourceContentMetadataId == null ? other$sourceContentMetadataId != null : !((Object)this$sourceContentMetadataId).equals(other$sourceContentMetadataId)) {
            return false;
        }
        Integer this$sourceQueryId = this.getSourceQueryId();
        Integer other$sourceQueryId = other.getSourceQueryId();
        if (this$sourceQueryId == null ? other$sourceQueryId != null : !((Object)this$sourceQueryId).equals(other$sourceQueryId)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$folderName = this.getFolderName();
        String other$folderName = other.getFolderName();
        if (this$folderName == null ? other$folderName != null : !this$folderName.equals(other$folderName)) {
            return false;
        }
        String this$modelName = this.getModelName();
        String other$modelName = other.getModelName();
        if (this$modelName == null ? other$modelName != null : !this$modelName.equals(other$modelName)) {
            return false;
        }
        LookerFolder this$folder = this.getFolder();
        LookerFolder other$folder = other.getFolder();
        if (this$folder == null ? other$folder != null : !((Object)this$folder).equals(other$folder)) {
            return false;
        }
        LookerQuery this$query = this.getQuery();
        LookerQuery other$query = other.getQuery();
        if (this$query == null ? other$query != null : !((Object)this$query).equals(other$query)) {
            return false;
        }
        LookerTile this$tile = this.getTile();
        LookerTile other$tile = other.getTile();
        if (this$tile == null ? other$tile != null : !((Object)this$tile).equals(other$tile)) {
            return false;
        }
        LookerModel this$model = this.getModel();
        LookerModel other$model = other.getModel();
        if (this$model == null ? other$model != null : !((Object)this$model).equals(other$model)) {
            return false;
        }
        LookerDashboard this$dashboard = this.getDashboard();
        LookerDashboard other$dashboard = other.getDashboard();
        return !(this$dashboard == null ? other$dashboard != null : !((Object)this$dashboard).equals(other$dashboard));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LookerLook;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $sourceUserId = this.getSourceUserId();
        result = result * 59 + ($sourceUserId == null ? 43 : ((Object)$sourceUserId).hashCode());
        Integer $sourceViewCount = this.getSourceViewCount();
        result = result * 59 + ($sourceViewCount == null ? 43 : ((Object)$sourceViewCount).hashCode());
        Integer $sourcelastUpdaterId = this.getSourcelastUpdaterId();
        result = result * 59 + ($sourcelastUpdaterId == null ? 43 : ((Object)$sourcelastUpdaterId).hashCode());
        Long $sourceLastAccessedAt = this.getSourceLastAccessedAt();
        result = result * 59 + ($sourceLastAccessedAt == null ? 43 : ((Object)$sourceLastAccessedAt).hashCode());
        Long $sourceLastViewedAt = this.getSourceLastViewedAt();
        result = result * 59 + ($sourceLastViewedAt == null ? 43 : ((Object)$sourceLastViewedAt).hashCode());
        Integer $sourceContentMetadataId = this.getSourceContentMetadataId();
        result = result * 59 + ($sourceContentMetadataId == null ? 43 : ((Object)$sourceContentMetadataId).hashCode());
        Integer $sourceQueryId = this.getSourceQueryId();
        result = result * 59 + ($sourceQueryId == null ? 43 : ((Object)$sourceQueryId).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $folderName = this.getFolderName();
        result = result * 59 + ($folderName == null ? 43 : $folderName.hashCode());
        String $modelName = this.getModelName();
        result = result * 59 + ($modelName == null ? 43 : $modelName.hashCode());
        LookerFolder $folder = this.getFolder();
        result = result * 59 + ($folder == null ? 43 : ((Object)$folder).hashCode());
        LookerQuery $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : ((Object)$query).hashCode());
        LookerTile $tile = this.getTile();
        result = result * 59 + ($tile == null ? 43 : ((Object)$tile).hashCode());
        LookerModel $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : ((Object)$model).hashCode());
        LookerDashboard $dashboard = this.getDashboard();
        result = result * 59 + ($dashboard == null ? 43 : ((Object)$dashboard).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class LookerLookBuilderImpl
    extends LookerLookBuilder<LookerLook, LookerLookBuilderImpl> {
        @Generated
        private LookerLookBuilderImpl() {
        }

        @Override
        @Generated
        protected LookerLookBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public LookerLook build() {
            return new LookerLook(this);
        }
    }

    @Generated
    public static abstract class LookerLookBuilder<C extends LookerLook, B extends LookerLookBuilder<C, B>>
    extends Looker.LookerBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String folderName;
        @Generated
        private Integer sourceUserId;
        @Generated
        private Integer sourceViewCount;
        @Generated
        private Integer sourcelastUpdaterId;
        @Generated
        private Long sourceLastAccessedAt;
        @Generated
        private Long sourceLastViewedAt;
        @Generated
        private Integer sourceContentMetadataId;
        @Generated
        private Integer sourceQueryId;
        @Generated
        private String modelName;
        @Generated
        private LookerFolder folder;
        @Generated
        private LookerQuery query;
        @Generated
        private LookerTile tile;
        @Generated
        private LookerModel model;
        @Generated
        private LookerDashboard dashboard;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            LookerLookBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(LookerLook instance, LookerLookBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.folderName(instance.folderName);
            b.sourceUserId(instance.sourceUserId);
            b.sourceViewCount(instance.sourceViewCount);
            b.sourcelastUpdaterId(instance.sourcelastUpdaterId);
            b.sourceLastAccessedAt(instance.sourceLastAccessedAt);
            b.sourceLastViewedAt(instance.sourceLastViewedAt);
            b.sourceContentMetadataId(instance.sourceContentMetadataId);
            b.sourceQueryId(instance.sourceQueryId);
            b.modelName(instance.modelName);
            b.folder(instance.folder);
            b.query(instance.query);
            b.tile(instance.tile);
            b.model(instance.model);
            b.dashboard(instance.dashboard);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B folderName(String folderName) {
            this.folderName = folderName;
            return (B)this.self();
        }

        @Generated
        public B sourceUserId(Integer sourceUserId) {
            this.sourceUserId = sourceUserId;
            return (B)this.self();
        }

        @Generated
        public B sourceViewCount(Integer sourceViewCount) {
            this.sourceViewCount = sourceViewCount;
            return (B)this.self();
        }

        @Generated
        public B sourcelastUpdaterId(Integer sourcelastUpdaterId) {
            this.sourcelastUpdaterId = sourcelastUpdaterId;
            return (B)this.self();
        }

        @Generated
        public B sourceLastAccessedAt(Long sourceLastAccessedAt) {
            this.sourceLastAccessedAt = sourceLastAccessedAt;
            return (B)this.self();
        }

        @Generated
        public B sourceLastViewedAt(Long sourceLastViewedAt) {
            this.sourceLastViewedAt = sourceLastViewedAt;
            return (B)this.self();
        }

        @Generated
        public B sourceContentMetadataId(Integer sourceContentMetadataId) {
            this.sourceContentMetadataId = sourceContentMetadataId;
            return (B)this.self();
        }

        @Generated
        public B sourceQueryId(Integer sourceQueryId) {
            this.sourceQueryId = sourceQueryId;
            return (B)this.self();
        }

        @Generated
        public B modelName(String modelName) {
            this.modelName = modelName;
            return (B)this.self();
        }

        @Generated
        public B folder(LookerFolder folder) {
            this.folder = folder;
            return (B)this.self();
        }

        @Generated
        public B query(LookerQuery query) {
            this.query = query;
            return (B)this.self();
        }

        @Generated
        public B tile(LookerTile tile) {
            this.tile = tile;
            return (B)this.self();
        }

        @Generated
        public B model(LookerModel model) {
            this.model = model;
            return (B)this.self();
        }

        @Generated
        public B dashboard(LookerDashboard dashboard) {
            this.dashboard = dashboard;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "LookerLook.LookerLookBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", folderName=" + this.folderName + ", sourceUserId=" + this.sourceUserId + ", sourceViewCount=" + this.sourceViewCount + ", sourcelastUpdaterId=" + this.sourcelastUpdaterId + ", sourceLastAccessedAt=" + this.sourceLastAccessedAt + ", sourceLastViewedAt=" + this.sourceLastViewedAt + ", sourceContentMetadataId=" + this.sourceContentMetadataId + ", sourceQueryId=" + this.sourceQueryId + ", modelName=" + this.modelName + ", folder=" + this.folder + ", query=" + this.query + ", tile=" + this.tile + ", model=" + this.model + ", dashboard=" + this.dashboard + ")";
        }
    }
}

