/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.Looker;
import com.atlan.model.assets.LookerExplore;
import com.atlan.model.assets.LookerField;
import com.atlan.model.assets.LookerLook;
import com.atlan.model.assets.LookerProject;
import com.atlan.model.assets.LookerQuery;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class LookerModel
extends Looker {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "LookerModel";
    String typeName;
    @Attribute
    String projectName;
    @Attribute
    SortedSet<LookerExplore> explores;
    @Attribute
    LookerProject project;
    @Attribute
    SortedSet<LookerField> fields;
    @Attribute
    LookerLook look;
    @Attribute
    SortedSet<LookerQuery> queries;

    public static LookerModel refByGuid(String guid) {
        return ((LookerModelBuilder)LookerModel.builder().guid(guid)).build();
    }

    public static LookerModel refByQualifiedName(String qualifiedName) {
        return ((LookerModelBuilder)LookerModel.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static LookerModelBuilder<?, ?> updater(String qualifiedName, String name) {
        return (LookerModelBuilder)((LookerModelBuilder)LookerModel.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected LookerModelBuilder<?, ?> trimToRequired() {
        return LookerModel.updater(this.getQualifiedName(), this.getName());
    }

    public static LookerModel retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof LookerModel) {
            return (LookerModel)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a LookerModel.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static LookerModel retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof LookerModel) {
            return (LookerModel)entity;
        }
        throw new NotFoundException("No LookerModel found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static LookerModel removeDescription(String qualifiedName, String name) throws AtlanException {
        return (LookerModel)Asset.removeDescription(((LookerModelBuilder)LookerModel.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static LookerModel removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (LookerModel)Asset.removeUserDescription(((LookerModelBuilder)LookerModel.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static LookerModel removeOwners(String qualifiedName, String name) throws AtlanException {
        return (LookerModel)Asset.removeOwners(((LookerModelBuilder)LookerModel.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static LookerModel updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (LookerModel)Asset.updateCertificate(LookerModel.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static LookerModel removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (LookerModel)Asset.removeCertificate(((LookerModelBuilder)LookerModel.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static LookerModel updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (LookerModel)Asset.updateAnnouncement(LookerModel.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static LookerModel removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (LookerModel)Asset.removeAnnouncement(((LookerModelBuilder)LookerModel.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static LookerModel replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (LookerModel)Asset.replaceTerms(LookerModel.updater(qualifiedName, name), terms);
    }

    public static LookerModel appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (LookerModel)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static LookerModel removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (LookerModel)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected LookerModel(LookerModelBuilder<?, ?> b) {
        super((Looker.LookerBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : LookerModel.$default$typeName();
        this.projectName = b.projectName;
        SortedSet<LookerExplore> explores = new TreeSet<LookerExplore>();
        if (b.explores != null) {
            explores.addAll(b.explores);
        }
        explores = Collections.unmodifiableSortedSet(explores);
        this.explores = explores;
        this.project = b.project;
        SortedSet<LookerField> fields = new TreeSet<LookerField>();
        if (b.fields != null) {
            fields.addAll(b.fields);
        }
        fields = Collections.unmodifiableSortedSet(fields);
        this.fields = fields;
        this.look = b.look;
        SortedSet<LookerQuery> queries = new TreeSet<LookerQuery>();
        if (b.queries != null) {
            queries.addAll(b.queries);
        }
        queries = Collections.unmodifiableSortedSet(queries);
        this.queries = queries;
    }

    @Generated
    public static LookerModelBuilder<?, ?> builder() {
        return new LookerModelBuilderImpl();
    }

    @Generated
    public LookerModelBuilder<?, ?> toBuilder() {
        return new LookerModelBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getProjectName() {
        return this.projectName;
    }

    @Generated
    public SortedSet<LookerExplore> getExplores() {
        return this.explores;
    }

    @Generated
    public LookerProject getProject() {
        return this.project;
    }

    @Generated
    public SortedSet<LookerField> getFields() {
        return this.fields;
    }

    @Generated
    public LookerLook getLook() {
        return this.look;
    }

    @Generated
    public SortedSet<LookerQuery> getQueries() {
        return this.queries;
    }

    @Generated
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Generated
    public void setExplores(SortedSet<LookerExplore> explores) {
        this.explores = explores;
    }

    @Generated
    public void setProject(LookerProject project) {
        this.project = project;
    }

    @Generated
    public void setFields(SortedSet<LookerField> fields) {
        this.fields = fields;
    }

    @Generated
    public void setLook(LookerLook look) {
        this.look = look;
    }

    @Generated
    public void setQueries(SortedSet<LookerQuery> queries) {
        this.queries = queries;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LookerModel)) {
            return false;
        }
        LookerModel other = (LookerModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$projectName = this.getProjectName();
        String other$projectName = other.getProjectName();
        if (this$projectName == null ? other$projectName != null : !this$projectName.equals(other$projectName)) {
            return false;
        }
        SortedSet<LookerExplore> this$explores = this.getExplores();
        SortedSet<LookerExplore> other$explores = other.getExplores();
        if (this$explores == null ? other$explores != null : !this$explores.equals(other$explores)) {
            return false;
        }
        LookerProject this$project = this.getProject();
        LookerProject other$project = other.getProject();
        if (this$project == null ? other$project != null : !((Object)this$project).equals(other$project)) {
            return false;
        }
        SortedSet<LookerField> this$fields = this.getFields();
        SortedSet<LookerField> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !this$fields.equals(other$fields)) {
            return false;
        }
        LookerLook this$look = this.getLook();
        LookerLook other$look = other.getLook();
        if (this$look == null ? other$look != null : !((Object)this$look).equals(other$look)) {
            return false;
        }
        SortedSet<LookerQuery> this$queries = this.getQueries();
        SortedSet<LookerQuery> other$queries = other.getQueries();
        return !(this$queries == null ? other$queries != null : !this$queries.equals(other$queries));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LookerModel;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $projectName = this.getProjectName();
        result = result * 59 + ($projectName == null ? 43 : $projectName.hashCode());
        SortedSet<LookerExplore> $explores = this.getExplores();
        result = result * 59 + ($explores == null ? 43 : $explores.hashCode());
        LookerProject $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : ((Object)$project).hashCode());
        SortedSet<LookerField> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : $fields.hashCode());
        LookerLook $look = this.getLook();
        result = result * 59 + ($look == null ? 43 : ((Object)$look).hashCode());
        SortedSet<LookerQuery> $queries = this.getQueries();
        result = result * 59 + ($queries == null ? 43 : $queries.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class LookerModelBuilderImpl
    extends LookerModelBuilder<LookerModel, LookerModelBuilderImpl> {
        @Generated
        private LookerModelBuilderImpl() {
        }

        @Override
        @Generated
        protected LookerModelBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public LookerModel build() {
            return new LookerModel(this);
        }
    }

    @Generated
    public static abstract class LookerModelBuilder<C extends LookerModel, B extends LookerModelBuilder<C, B>>
    extends Looker.LookerBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String projectName;
        @Generated
        private ArrayList<LookerExplore> explores;
        @Generated
        private LookerProject project;
        @Generated
        private ArrayList<LookerField> fields;
        @Generated
        private LookerLook look;
        @Generated
        private ArrayList<LookerQuery> queries;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            LookerModelBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(LookerModel instance, LookerModelBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.projectName(instance.projectName);
            b.explores(instance.explores == null ? Collections.emptySortedSet() : instance.explores);
            b.project(instance.project);
            b.fields(instance.fields == null ? Collections.emptySortedSet() : instance.fields);
            b.look(instance.look);
            b.queries(instance.queries == null ? Collections.emptySortedSet() : instance.queries);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B projectName(String projectName) {
            this.projectName = projectName;
            return (B)this.self();
        }

        @Generated
        public B explore(LookerExplore explore) {
            if (this.explores == null) {
                this.explores = new ArrayList();
            }
            this.explores.add(explore);
            return (B)this.self();
        }

        @Generated
        public B explores(Collection<? extends LookerExplore> explores) {
            if (explores == null) {
                throw new NullPointerException("explores cannot be null");
            }
            if (this.explores == null) {
                this.explores = new ArrayList();
            }
            this.explores.addAll(explores);
            return (B)this.self();
        }

        @Generated
        public B clearExplores() {
            if (this.explores != null) {
                this.explores.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B project(LookerProject project) {
            this.project = project;
            return (B)this.self();
        }

        @Generated
        public B field(LookerField field) {
            if (this.fields == null) {
                this.fields = new ArrayList();
            }
            this.fields.add(field);
            return (B)this.self();
        }

        @Generated
        public B fields(Collection<? extends LookerField> fields) {
            if (fields == null) {
                throw new NullPointerException("fields cannot be null");
            }
            if (this.fields == null) {
                this.fields = new ArrayList();
            }
            this.fields.addAll(fields);
            return (B)this.self();
        }

        @Generated
        public B clearFields() {
            if (this.fields != null) {
                this.fields.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B look(LookerLook look) {
            this.look = look;
            return (B)this.self();
        }

        @Generated
        public B query(LookerQuery query) {
            if (this.queries == null) {
                this.queries = new ArrayList();
            }
            this.queries.add(query);
            return (B)this.self();
        }

        @Generated
        public B queries(Collection<? extends LookerQuery> queries) {
            if (queries == null) {
                throw new NullPointerException("queries cannot be null");
            }
            if (this.queries == null) {
                this.queries = new ArrayList();
            }
            this.queries.addAll(queries);
            return (B)this.self();
        }

        @Generated
        public B clearQueries() {
            if (this.queries != null) {
                this.queries.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "LookerModel.LookerModelBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", projectName=" + this.projectName + ", explores=" + this.explores + ", project=" + this.project + ", fields=" + this.fields + ", look=" + this.look + ", queries=" + this.queries + ")";
        }
    }
}

