/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.Looker;
import com.atlan.model.assets.LookerExplore;
import com.atlan.model.assets.LookerField;
import com.atlan.model.assets.LookerModel;
import com.atlan.model.assets.LookerView;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class LookerProject
extends Looker {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "LookerProject";
    String typeName;
    @Attribute
    SortedSet<LookerModel> models;
    @Attribute
    SortedSet<LookerExplore> explores;
    @Attribute
    SortedSet<LookerField> fields;
    @Attribute
    SortedSet<LookerView> views;

    public static LookerProject refByGuid(String guid) {
        return ((LookerProjectBuilder)LookerProject.builder().guid(guid)).build();
    }

    public static LookerProject refByQualifiedName(String qualifiedName) {
        return ((LookerProjectBuilder)LookerProject.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static LookerProjectBuilder<?, ?> updater(String qualifiedName, String name) {
        return (LookerProjectBuilder)((LookerProjectBuilder)LookerProject.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected LookerProjectBuilder<?, ?> trimToRequired() {
        return LookerProject.updater(this.getQualifiedName(), this.getName());
    }

    public static LookerProject retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof LookerProject) {
            return (LookerProject)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a LookerProject.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static LookerProject retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof LookerProject) {
            return (LookerProject)entity;
        }
        throw new NotFoundException("No LookerProject found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static LookerProject removeDescription(String qualifiedName, String name) throws AtlanException {
        return (LookerProject)Asset.removeDescription(((LookerProjectBuilder)LookerProject.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static LookerProject removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (LookerProject)Asset.removeUserDescription(((LookerProjectBuilder)LookerProject.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static LookerProject removeOwners(String qualifiedName, String name) throws AtlanException {
        return (LookerProject)Asset.removeOwners(((LookerProjectBuilder)LookerProject.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static LookerProject updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (LookerProject)Asset.updateCertificate(LookerProject.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static LookerProject removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (LookerProject)Asset.removeCertificate(((LookerProjectBuilder)LookerProject.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static LookerProject updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (LookerProject)Asset.updateAnnouncement(LookerProject.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static LookerProject removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (LookerProject)Asset.removeAnnouncement(((LookerProjectBuilder)LookerProject.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static LookerProject replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (LookerProject)Asset.replaceTerms(LookerProject.updater(qualifiedName, name), terms);
    }

    public static LookerProject appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (LookerProject)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static LookerProject removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (LookerProject)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected LookerProject(LookerProjectBuilder<?, ?> b) {
        super((Looker.LookerBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : LookerProject.$default$typeName();
        SortedSet<LookerModel> models = new TreeSet<LookerModel>();
        if (b.models != null) {
            models.addAll(b.models);
        }
        models = Collections.unmodifiableSortedSet(models);
        this.models = models;
        SortedSet<LookerExplore> explores = new TreeSet<LookerExplore>();
        if (b.explores != null) {
            explores.addAll(b.explores);
        }
        explores = Collections.unmodifiableSortedSet(explores);
        this.explores = explores;
        SortedSet<LookerField> fields = new TreeSet<LookerField>();
        if (b.fields != null) {
            fields.addAll(b.fields);
        }
        fields = Collections.unmodifiableSortedSet(fields);
        this.fields = fields;
        SortedSet<LookerView> views = new TreeSet<LookerView>();
        if (b.views != null) {
            views.addAll(b.views);
        }
        views = Collections.unmodifiableSortedSet(views);
        this.views = views;
    }

    @Generated
    public static LookerProjectBuilder<?, ?> builder() {
        return new LookerProjectBuilderImpl();
    }

    @Generated
    public LookerProjectBuilder<?, ?> toBuilder() {
        return new LookerProjectBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public SortedSet<LookerModel> getModels() {
        return this.models;
    }

    @Generated
    public SortedSet<LookerExplore> getExplores() {
        return this.explores;
    }

    @Generated
    public SortedSet<LookerField> getFields() {
        return this.fields;
    }

    @Generated
    public SortedSet<LookerView> getViews() {
        return this.views;
    }

    @Generated
    public void setModels(SortedSet<LookerModel> models) {
        this.models = models;
    }

    @Generated
    public void setExplores(SortedSet<LookerExplore> explores) {
        this.explores = explores;
    }

    @Generated
    public void setFields(SortedSet<LookerField> fields) {
        this.fields = fields;
    }

    @Generated
    public void setViews(SortedSet<LookerView> views) {
        this.views = views;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LookerProject)) {
            return false;
        }
        LookerProject other = (LookerProject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<LookerModel> this$models = this.getModels();
        SortedSet<LookerModel> other$models = other.getModels();
        if (this$models == null ? other$models != null : !this$models.equals(other$models)) {
            return false;
        }
        SortedSet<LookerExplore> this$explores = this.getExplores();
        SortedSet<LookerExplore> other$explores = other.getExplores();
        if (this$explores == null ? other$explores != null : !this$explores.equals(other$explores)) {
            return false;
        }
        SortedSet<LookerField> this$fields = this.getFields();
        SortedSet<LookerField> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !this$fields.equals(other$fields)) {
            return false;
        }
        SortedSet<LookerView> this$views = this.getViews();
        SortedSet<LookerView> other$views = other.getViews();
        return !(this$views == null ? other$views != null : !this$views.equals(other$views));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LookerProject;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<LookerModel> $models = this.getModels();
        result = result * 59 + ($models == null ? 43 : $models.hashCode());
        SortedSet<LookerExplore> $explores = this.getExplores();
        result = result * 59 + ($explores == null ? 43 : $explores.hashCode());
        SortedSet<LookerField> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : $fields.hashCode());
        SortedSet<LookerView> $views = this.getViews();
        result = result * 59 + ($views == null ? 43 : $views.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class LookerProjectBuilderImpl
    extends LookerProjectBuilder<LookerProject, LookerProjectBuilderImpl> {
        @Generated
        private LookerProjectBuilderImpl() {
        }

        @Override
        @Generated
        protected LookerProjectBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public LookerProject build() {
            return new LookerProject(this);
        }
    }

    @Generated
    public static abstract class LookerProjectBuilder<C extends LookerProject, B extends LookerProjectBuilder<C, B>>
    extends Looker.LookerBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private ArrayList<LookerModel> models;
        @Generated
        private ArrayList<LookerExplore> explores;
        @Generated
        private ArrayList<LookerField> fields;
        @Generated
        private ArrayList<LookerView> views;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            LookerProjectBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(LookerProject instance, LookerProjectBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.models(instance.models == null ? Collections.emptySortedSet() : instance.models);
            b.explores(instance.explores == null ? Collections.emptySortedSet() : instance.explores);
            b.fields(instance.fields == null ? Collections.emptySortedSet() : instance.fields);
            b.views(instance.views == null ? Collections.emptySortedSet() : instance.views);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B model(LookerModel model) {
            if (this.models == null) {
                this.models = new ArrayList();
            }
            this.models.add(model);
            return (B)this.self();
        }

        @Generated
        public B models(Collection<? extends LookerModel> models) {
            if (models == null) {
                throw new NullPointerException("models cannot be null");
            }
            if (this.models == null) {
                this.models = new ArrayList();
            }
            this.models.addAll(models);
            return (B)this.self();
        }

        @Generated
        public B clearModels() {
            if (this.models != null) {
                this.models.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B explore(LookerExplore explore) {
            if (this.explores == null) {
                this.explores = new ArrayList();
            }
            this.explores.add(explore);
            return (B)this.self();
        }

        @Generated
        public B explores(Collection<? extends LookerExplore> explores) {
            if (explores == null) {
                throw new NullPointerException("explores cannot be null");
            }
            if (this.explores == null) {
                this.explores = new ArrayList();
            }
            this.explores.addAll(explores);
            return (B)this.self();
        }

        @Generated
        public B clearExplores() {
            if (this.explores != null) {
                this.explores.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B field(LookerField field) {
            if (this.fields == null) {
                this.fields = new ArrayList();
            }
            this.fields.add(field);
            return (B)this.self();
        }

        @Generated
        public B fields(Collection<? extends LookerField> fields) {
            if (fields == null) {
                throw new NullPointerException("fields cannot be null");
            }
            if (this.fields == null) {
                this.fields = new ArrayList();
            }
            this.fields.addAll(fields);
            return (B)this.self();
        }

        @Generated
        public B clearFields() {
            if (this.fields != null) {
                this.fields.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B view(LookerView view) {
            if (this.views == null) {
                this.views = new ArrayList();
            }
            this.views.add(view);
            return (B)this.self();
        }

        @Generated
        public B views(Collection<? extends LookerView> views) {
            if (views == null) {
                throw new NullPointerException("views cannot be null");
            }
            if (this.views == null) {
                this.views = new ArrayList();
            }
            this.views.addAll(views);
            return (B)this.self();
        }

        @Generated
        public B clearViews() {
            if (this.views != null) {
                this.views.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "LookerProject.LookerProjectBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", models=" + this.models + ", explores=" + this.explores + ", fields=" + this.fields + ", views=" + this.views + ")";
        }
    }
}

