/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.Looker;
import com.atlan.model.assets.LookerLook;
import com.atlan.model.assets.LookerModel;
import com.atlan.model.assets.LookerTile;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class LookerQuery
extends Looker {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "LookerQuery";
    String typeName;
    @Attribute
    String sourceDefinition;
    @Attribute
    String sourceDefinitionDatabase;
    @Attribute
    String sourceDefinitionSchema;
    @Attribute
    SortedSet<String> fields;
    @Attribute
    SortedSet<LookerTile> tiles;
    @Attribute
    SortedSet<LookerLook> looks;
    @Attribute
    LookerModel model;

    public static LookerQuery refByGuid(String guid) {
        return ((LookerQueryBuilder)LookerQuery.builder().guid(guid)).build();
    }

    public static LookerQuery refByQualifiedName(String qualifiedName) {
        return ((LookerQueryBuilder)LookerQuery.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static LookerQueryBuilder<?, ?> updater(String qualifiedName, String name) {
        return (LookerQueryBuilder)((LookerQueryBuilder)LookerQuery.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected LookerQueryBuilder<?, ?> trimToRequired() {
        return LookerQuery.updater(this.getQualifiedName(), this.getName());
    }

    public static LookerQuery retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof LookerQuery) {
            return (LookerQuery)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a LookerQuery.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static LookerQuery retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof LookerQuery) {
            return (LookerQuery)entity;
        }
        throw new NotFoundException("No LookerQuery found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static LookerQuery removeDescription(String qualifiedName, String name) throws AtlanException {
        return (LookerQuery)Asset.removeDescription(((LookerQueryBuilder)LookerQuery.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static LookerQuery removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (LookerQuery)Asset.removeUserDescription(((LookerQueryBuilder)LookerQuery.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static LookerQuery removeOwners(String qualifiedName, String name) throws AtlanException {
        return (LookerQuery)Asset.removeOwners(((LookerQueryBuilder)LookerQuery.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static LookerQuery updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (LookerQuery)Asset.updateCertificate(LookerQuery.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static LookerQuery removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (LookerQuery)Asset.removeCertificate(((LookerQueryBuilder)LookerQuery.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static LookerQuery updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (LookerQuery)Asset.updateAnnouncement(LookerQuery.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static LookerQuery removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (LookerQuery)Asset.removeAnnouncement(((LookerQueryBuilder)LookerQuery.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static LookerQuery replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (LookerQuery)Asset.replaceTerms(LookerQuery.updater(qualifiedName, name), terms);
    }

    public static LookerQuery appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (LookerQuery)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static LookerQuery removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (LookerQuery)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected LookerQuery(LookerQueryBuilder<?, ?> b) {
        super((Looker.LookerBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : LookerQuery.$default$typeName();
        this.sourceDefinition = b.sourceDefinition;
        this.sourceDefinitionDatabase = b.sourceDefinitionDatabase;
        this.sourceDefinitionSchema = b.sourceDefinitionSchema;
        SortedSet<String> fields = new TreeSet<String>();
        if (b.fields != null) {
            fields.addAll(b.fields);
        }
        fields = Collections.unmodifiableSortedSet(fields);
        this.fields = fields;
        SortedSet<LookerTile> tiles = new TreeSet<LookerTile>();
        if (b.tiles != null) {
            tiles.addAll(b.tiles);
        }
        tiles = Collections.unmodifiableSortedSet(tiles);
        this.tiles = tiles;
        SortedSet<LookerLook> looks = new TreeSet<LookerLook>();
        if (b.looks != null) {
            looks.addAll(b.looks);
        }
        looks = Collections.unmodifiableSortedSet(looks);
        this.looks = looks;
        this.model = b.model;
    }

    @Generated
    public static LookerQueryBuilder<?, ?> builder() {
        return new LookerQueryBuilderImpl();
    }

    @Generated
    public LookerQueryBuilder<?, ?> toBuilder() {
        return new LookerQueryBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getSourceDefinition() {
        return this.sourceDefinition;
    }

    @Generated
    public String getSourceDefinitionDatabase() {
        return this.sourceDefinitionDatabase;
    }

    @Generated
    public String getSourceDefinitionSchema() {
        return this.sourceDefinitionSchema;
    }

    @Generated
    public SortedSet<String> getFields() {
        return this.fields;
    }

    @Generated
    public SortedSet<LookerTile> getTiles() {
        return this.tiles;
    }

    @Generated
    public SortedSet<LookerLook> getLooks() {
        return this.looks;
    }

    @Generated
    public LookerModel getModel() {
        return this.model;
    }

    @Generated
    public void setSourceDefinition(String sourceDefinition) {
        this.sourceDefinition = sourceDefinition;
    }

    @Generated
    public void setSourceDefinitionDatabase(String sourceDefinitionDatabase) {
        this.sourceDefinitionDatabase = sourceDefinitionDatabase;
    }

    @Generated
    public void setSourceDefinitionSchema(String sourceDefinitionSchema) {
        this.sourceDefinitionSchema = sourceDefinitionSchema;
    }

    @Generated
    public void setFields(SortedSet<String> fields) {
        this.fields = fields;
    }

    @Generated
    public void setTiles(SortedSet<LookerTile> tiles) {
        this.tiles = tiles;
    }

    @Generated
    public void setLooks(SortedSet<LookerLook> looks) {
        this.looks = looks;
    }

    @Generated
    public void setModel(LookerModel model) {
        this.model = model;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LookerQuery)) {
            return false;
        }
        LookerQuery other = (LookerQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$sourceDefinition = this.getSourceDefinition();
        String other$sourceDefinition = other.getSourceDefinition();
        if (this$sourceDefinition == null ? other$sourceDefinition != null : !this$sourceDefinition.equals(other$sourceDefinition)) {
            return false;
        }
        String this$sourceDefinitionDatabase = this.getSourceDefinitionDatabase();
        String other$sourceDefinitionDatabase = other.getSourceDefinitionDatabase();
        if (this$sourceDefinitionDatabase == null ? other$sourceDefinitionDatabase != null : !this$sourceDefinitionDatabase.equals(other$sourceDefinitionDatabase)) {
            return false;
        }
        String this$sourceDefinitionSchema = this.getSourceDefinitionSchema();
        String other$sourceDefinitionSchema = other.getSourceDefinitionSchema();
        if (this$sourceDefinitionSchema == null ? other$sourceDefinitionSchema != null : !this$sourceDefinitionSchema.equals(other$sourceDefinitionSchema)) {
            return false;
        }
        SortedSet<String> this$fields = this.getFields();
        SortedSet<String> other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !this$fields.equals(other$fields)) {
            return false;
        }
        SortedSet<LookerTile> this$tiles = this.getTiles();
        SortedSet<LookerTile> other$tiles = other.getTiles();
        if (this$tiles == null ? other$tiles != null : !this$tiles.equals(other$tiles)) {
            return false;
        }
        SortedSet<LookerLook> this$looks = this.getLooks();
        SortedSet<LookerLook> other$looks = other.getLooks();
        if (this$looks == null ? other$looks != null : !this$looks.equals(other$looks)) {
            return false;
        }
        LookerModel this$model = this.getModel();
        LookerModel other$model = other.getModel();
        return !(this$model == null ? other$model != null : !((Object)this$model).equals(other$model));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LookerQuery;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $sourceDefinition = this.getSourceDefinition();
        result = result * 59 + ($sourceDefinition == null ? 43 : $sourceDefinition.hashCode());
        String $sourceDefinitionDatabase = this.getSourceDefinitionDatabase();
        result = result * 59 + ($sourceDefinitionDatabase == null ? 43 : $sourceDefinitionDatabase.hashCode());
        String $sourceDefinitionSchema = this.getSourceDefinitionSchema();
        result = result * 59 + ($sourceDefinitionSchema == null ? 43 : $sourceDefinitionSchema.hashCode());
        SortedSet<String> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : $fields.hashCode());
        SortedSet<LookerTile> $tiles = this.getTiles();
        result = result * 59 + ($tiles == null ? 43 : $tiles.hashCode());
        SortedSet<LookerLook> $looks = this.getLooks();
        result = result * 59 + ($looks == null ? 43 : $looks.hashCode());
        LookerModel $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : ((Object)$model).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class LookerQueryBuilderImpl
    extends LookerQueryBuilder<LookerQuery, LookerQueryBuilderImpl> {
        @Generated
        private LookerQueryBuilderImpl() {
        }

        @Override
        @Generated
        protected LookerQueryBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public LookerQuery build() {
            return new LookerQuery(this);
        }
    }

    @Generated
    public static abstract class LookerQueryBuilder<C extends LookerQuery, B extends LookerQueryBuilder<C, B>>
    extends Looker.LookerBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String sourceDefinition;
        @Generated
        private String sourceDefinitionDatabase;
        @Generated
        private String sourceDefinitionSchema;
        @Generated
        private ArrayList<String> fields;
        @Generated
        private ArrayList<LookerTile> tiles;
        @Generated
        private ArrayList<LookerLook> looks;
        @Generated
        private LookerModel model;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            LookerQueryBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(LookerQuery instance, LookerQueryBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.sourceDefinition(instance.sourceDefinition);
            b.sourceDefinitionDatabase(instance.sourceDefinitionDatabase);
            b.sourceDefinitionSchema(instance.sourceDefinitionSchema);
            b.fields(instance.fields == null ? Collections.emptySortedSet() : instance.fields);
            b.tiles(instance.tiles == null ? Collections.emptySortedSet() : instance.tiles);
            b.looks(instance.looks == null ? Collections.emptySortedSet() : instance.looks);
            b.model(instance.model);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B sourceDefinition(String sourceDefinition) {
            this.sourceDefinition = sourceDefinition;
            return (B)this.self();
        }

        @Generated
        public B sourceDefinitionDatabase(String sourceDefinitionDatabase) {
            this.sourceDefinitionDatabase = sourceDefinitionDatabase;
            return (B)this.self();
        }

        @Generated
        public B sourceDefinitionSchema(String sourceDefinitionSchema) {
            this.sourceDefinitionSchema = sourceDefinitionSchema;
            return (B)this.self();
        }

        @Generated
        public B field(String field) {
            if (this.fields == null) {
                this.fields = new ArrayList();
            }
            this.fields.add(field);
            return (B)this.self();
        }

        @Generated
        public B fields(Collection<? extends String> fields) {
            if (fields == null) {
                throw new NullPointerException("fields cannot be null");
            }
            if (this.fields == null) {
                this.fields = new ArrayList();
            }
            this.fields.addAll(fields);
            return (B)this.self();
        }

        @Generated
        public B clearFields() {
            if (this.fields != null) {
                this.fields.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B tile(LookerTile tile) {
            if (this.tiles == null) {
                this.tiles = new ArrayList();
            }
            this.tiles.add(tile);
            return (B)this.self();
        }

        @Generated
        public B tiles(Collection<? extends LookerTile> tiles) {
            if (tiles == null) {
                throw new NullPointerException("tiles cannot be null");
            }
            if (this.tiles == null) {
                this.tiles = new ArrayList();
            }
            this.tiles.addAll(tiles);
            return (B)this.self();
        }

        @Generated
        public B clearTiles() {
            if (this.tiles != null) {
                this.tiles.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B look(LookerLook look) {
            if (this.looks == null) {
                this.looks = new ArrayList();
            }
            this.looks.add(look);
            return (B)this.self();
        }

        @Generated
        public B looks(Collection<? extends LookerLook> looks) {
            if (looks == null) {
                throw new NullPointerException("looks cannot be null");
            }
            if (this.looks == null) {
                this.looks = new ArrayList();
            }
            this.looks.addAll(looks);
            return (B)this.self();
        }

        @Generated
        public B clearLooks() {
            if (this.looks != null) {
                this.looks.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B model(LookerModel model) {
            this.model = model;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "LookerQuery.LookerQueryBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", sourceDefinition=" + this.sourceDefinition + ", sourceDefinitionDatabase=" + this.sourceDefinitionDatabase + ", sourceDefinitionSchema=" + this.sourceDefinitionSchema + ", fields=" + this.fields + ", tiles=" + this.tiles + ", looks=" + this.looks + ", model=" + this.model + ")";
        }
    }
}

