/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.Looker;
import com.atlan.model.assets.LookerDashboard;
import com.atlan.model.assets.LookerLook;
import com.atlan.model.assets.LookerQuery;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.List;
import lombok.Generated;

public class LookerTile
extends Looker {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "LookerTile";
    String typeName;
    @Attribute
    String lookmlLinkId;
    @Attribute
    String mergeResultId;
    @Attribute
    String noteText;
    @Attribute
    Integer queryID;
    @Attribute
    Integer resultMakerID;
    @Attribute
    String subtitleText;
    @Attribute
    Integer lookId;
    @Attribute
    LookerQuery query;
    @Attribute
    LookerLook look;
    @Attribute
    LookerDashboard dashboard;

    public static LookerTile refByGuid(String guid) {
        return ((LookerTileBuilder)LookerTile.builder().guid(guid)).build();
    }

    public static LookerTile refByQualifiedName(String qualifiedName) {
        return ((LookerTileBuilder)LookerTile.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static LookerTileBuilder<?, ?> updater(String qualifiedName, String name) {
        return (LookerTileBuilder)((LookerTileBuilder)LookerTile.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected LookerTileBuilder<?, ?> trimToRequired() {
        return LookerTile.updater(this.getQualifiedName(), this.getName());
    }

    public static LookerTile retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof LookerTile) {
            return (LookerTile)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a LookerTile.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static LookerTile retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof LookerTile) {
            return (LookerTile)entity;
        }
        throw new NotFoundException("No LookerTile found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static LookerTile removeDescription(String qualifiedName, String name) throws AtlanException {
        return (LookerTile)Asset.removeDescription(((LookerTileBuilder)LookerTile.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static LookerTile removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (LookerTile)Asset.removeUserDescription(((LookerTileBuilder)LookerTile.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static LookerTile removeOwners(String qualifiedName, String name) throws AtlanException {
        return (LookerTile)Asset.removeOwners(((LookerTileBuilder)LookerTile.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static LookerTile updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (LookerTile)Asset.updateCertificate(LookerTile.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static LookerTile removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (LookerTile)Asset.removeCertificate(((LookerTileBuilder)LookerTile.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static LookerTile updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (LookerTile)Asset.updateAnnouncement(LookerTile.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static LookerTile removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (LookerTile)Asset.removeAnnouncement(((LookerTileBuilder)LookerTile.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static LookerTile replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (LookerTile)Asset.replaceTerms(LookerTile.updater(qualifiedName, name), terms);
    }

    public static LookerTile appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (LookerTile)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static LookerTile removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (LookerTile)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected LookerTile(LookerTileBuilder<?, ?> b) {
        super((Looker.LookerBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : LookerTile.$default$typeName();
        this.lookmlLinkId = b.lookmlLinkId;
        this.mergeResultId = b.mergeResultId;
        this.noteText = b.noteText;
        this.queryID = b.queryID;
        this.resultMakerID = b.resultMakerID;
        this.subtitleText = b.subtitleText;
        this.lookId = b.lookId;
        this.query = b.query;
        this.look = b.look;
        this.dashboard = b.dashboard;
    }

    @Generated
    public static LookerTileBuilder<?, ?> builder() {
        return new LookerTileBuilderImpl();
    }

    @Generated
    public LookerTileBuilder<?, ?> toBuilder() {
        return new LookerTileBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getLookmlLinkId() {
        return this.lookmlLinkId;
    }

    @Generated
    public String getMergeResultId() {
        return this.mergeResultId;
    }

    @Generated
    public String getNoteText() {
        return this.noteText;
    }

    @Generated
    public Integer getQueryID() {
        return this.queryID;
    }

    @Generated
    public Integer getResultMakerID() {
        return this.resultMakerID;
    }

    @Generated
    public String getSubtitleText() {
        return this.subtitleText;
    }

    @Generated
    public Integer getLookId() {
        return this.lookId;
    }

    @Generated
    public LookerQuery getQuery() {
        return this.query;
    }

    @Generated
    public LookerLook getLook() {
        return this.look;
    }

    @Generated
    public LookerDashboard getDashboard() {
        return this.dashboard;
    }

    @Generated
    public void setLookmlLinkId(String lookmlLinkId) {
        this.lookmlLinkId = lookmlLinkId;
    }

    @Generated
    public void setMergeResultId(String mergeResultId) {
        this.mergeResultId = mergeResultId;
    }

    @Generated
    public void setNoteText(String noteText) {
        this.noteText = noteText;
    }

    @Generated
    public void setQueryID(Integer queryID) {
        this.queryID = queryID;
    }

    @Generated
    public void setResultMakerID(Integer resultMakerID) {
        this.resultMakerID = resultMakerID;
    }

    @Generated
    public void setSubtitleText(String subtitleText) {
        this.subtitleText = subtitleText;
    }

    @Generated
    public void setLookId(Integer lookId) {
        this.lookId = lookId;
    }

    @Generated
    public void setQuery(LookerQuery query) {
        this.query = query;
    }

    @Generated
    public void setLook(LookerLook look) {
        this.look = look;
    }

    @Generated
    public void setDashboard(LookerDashboard dashboard) {
        this.dashboard = dashboard;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LookerTile)) {
            return false;
        }
        LookerTile other = (LookerTile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$queryID = this.getQueryID();
        Integer other$queryID = other.getQueryID();
        if (this$queryID == null ? other$queryID != null : !((Object)this$queryID).equals(other$queryID)) {
            return false;
        }
        Integer this$resultMakerID = this.getResultMakerID();
        Integer other$resultMakerID = other.getResultMakerID();
        if (this$resultMakerID == null ? other$resultMakerID != null : !((Object)this$resultMakerID).equals(other$resultMakerID)) {
            return false;
        }
        Integer this$lookId = this.getLookId();
        Integer other$lookId = other.getLookId();
        if (this$lookId == null ? other$lookId != null : !((Object)this$lookId).equals(other$lookId)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$lookmlLinkId = this.getLookmlLinkId();
        String other$lookmlLinkId = other.getLookmlLinkId();
        if (this$lookmlLinkId == null ? other$lookmlLinkId != null : !this$lookmlLinkId.equals(other$lookmlLinkId)) {
            return false;
        }
        String this$mergeResultId = this.getMergeResultId();
        String other$mergeResultId = other.getMergeResultId();
        if (this$mergeResultId == null ? other$mergeResultId != null : !this$mergeResultId.equals(other$mergeResultId)) {
            return false;
        }
        String this$noteText = this.getNoteText();
        String other$noteText = other.getNoteText();
        if (this$noteText == null ? other$noteText != null : !this$noteText.equals(other$noteText)) {
            return false;
        }
        String this$subtitleText = this.getSubtitleText();
        String other$subtitleText = other.getSubtitleText();
        if (this$subtitleText == null ? other$subtitleText != null : !this$subtitleText.equals(other$subtitleText)) {
            return false;
        }
        LookerQuery this$query = this.getQuery();
        LookerQuery other$query = other.getQuery();
        if (this$query == null ? other$query != null : !((Object)this$query).equals(other$query)) {
            return false;
        }
        LookerLook this$look = this.getLook();
        LookerLook other$look = other.getLook();
        if (this$look == null ? other$look != null : !((Object)this$look).equals(other$look)) {
            return false;
        }
        LookerDashboard this$dashboard = this.getDashboard();
        LookerDashboard other$dashboard = other.getDashboard();
        return !(this$dashboard == null ? other$dashboard != null : !((Object)this$dashboard).equals(other$dashboard));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LookerTile;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $queryID = this.getQueryID();
        result = result * 59 + ($queryID == null ? 43 : ((Object)$queryID).hashCode());
        Integer $resultMakerID = this.getResultMakerID();
        result = result * 59 + ($resultMakerID == null ? 43 : ((Object)$resultMakerID).hashCode());
        Integer $lookId = this.getLookId();
        result = result * 59 + ($lookId == null ? 43 : ((Object)$lookId).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $lookmlLinkId = this.getLookmlLinkId();
        result = result * 59 + ($lookmlLinkId == null ? 43 : $lookmlLinkId.hashCode());
        String $mergeResultId = this.getMergeResultId();
        result = result * 59 + ($mergeResultId == null ? 43 : $mergeResultId.hashCode());
        String $noteText = this.getNoteText();
        result = result * 59 + ($noteText == null ? 43 : $noteText.hashCode());
        String $subtitleText = this.getSubtitleText();
        result = result * 59 + ($subtitleText == null ? 43 : $subtitleText.hashCode());
        LookerQuery $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : ((Object)$query).hashCode());
        LookerLook $look = this.getLook();
        result = result * 59 + ($look == null ? 43 : ((Object)$look).hashCode());
        LookerDashboard $dashboard = this.getDashboard();
        result = result * 59 + ($dashboard == null ? 43 : ((Object)$dashboard).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class LookerTileBuilderImpl
    extends LookerTileBuilder<LookerTile, LookerTileBuilderImpl> {
        @Generated
        private LookerTileBuilderImpl() {
        }

        @Override
        @Generated
        protected LookerTileBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public LookerTile build() {
            return new LookerTile(this);
        }
    }

    @Generated
    public static abstract class LookerTileBuilder<C extends LookerTile, B extends LookerTileBuilder<C, B>>
    extends Looker.LookerBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String lookmlLinkId;
        @Generated
        private String mergeResultId;
        @Generated
        private String noteText;
        @Generated
        private Integer queryID;
        @Generated
        private Integer resultMakerID;
        @Generated
        private String subtitleText;
        @Generated
        private Integer lookId;
        @Generated
        private LookerQuery query;
        @Generated
        private LookerLook look;
        @Generated
        private LookerDashboard dashboard;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            LookerTileBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(LookerTile instance, LookerTileBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.lookmlLinkId(instance.lookmlLinkId);
            b.mergeResultId(instance.mergeResultId);
            b.noteText(instance.noteText);
            b.queryID(instance.queryID);
            b.resultMakerID(instance.resultMakerID);
            b.subtitleText(instance.subtitleText);
            b.lookId(instance.lookId);
            b.query(instance.query);
            b.look(instance.look);
            b.dashboard(instance.dashboard);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B lookmlLinkId(String lookmlLinkId) {
            this.lookmlLinkId = lookmlLinkId;
            return (B)this.self();
        }

        @Generated
        public B mergeResultId(String mergeResultId) {
            this.mergeResultId = mergeResultId;
            return (B)this.self();
        }

        @Generated
        public B noteText(String noteText) {
            this.noteText = noteText;
            return (B)this.self();
        }

        @Generated
        public B queryID(Integer queryID) {
            this.queryID = queryID;
            return (B)this.self();
        }

        @Generated
        public B resultMakerID(Integer resultMakerID) {
            this.resultMakerID = resultMakerID;
            return (B)this.self();
        }

        @Generated
        public B subtitleText(String subtitleText) {
            this.subtitleText = subtitleText;
            return (B)this.self();
        }

        @Generated
        public B lookId(Integer lookId) {
            this.lookId = lookId;
            return (B)this.self();
        }

        @Generated
        public B query(LookerQuery query) {
            this.query = query;
            return (B)this.self();
        }

        @Generated
        public B look(LookerLook look) {
            this.look = look;
            return (B)this.self();
        }

        @Generated
        public B dashboard(LookerDashboard dashboard) {
            this.dashboard = dashboard;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "LookerTile.LookerTileBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", lookmlLinkId=" + this.lookmlLinkId + ", mergeResultId=" + this.mergeResultId + ", noteText=" + this.noteText + ", queryID=" + this.queryID + ", resultMakerID=" + this.resultMakerID + ", subtitleText=" + this.subtitleText + ", lookId=" + this.lookId + ", query=" + this.query + ", look=" + this.look + ", dashboard=" + this.dashboard + ")";
        }
    }
}

