/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.Looker;
import com.atlan.model.assets.LookerField;
import com.atlan.model.assets.LookerProject;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class LookerView
extends Looker {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "LookerView";
    String typeName;
    @Attribute
    String projectName;
    @Attribute
    LookerProject project;
    @Attribute
    SortedSet<LookerField> fields;

    public static LookerView refByGuid(String guid) {
        return ((LookerViewBuilder)LookerView.builder().guid(guid)).build();
    }

    public static LookerView refByQualifiedName(String qualifiedName) {
        return ((LookerViewBuilder)LookerView.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static LookerViewBuilder<?, ?> updater(String qualifiedName, String name) {
        return (LookerViewBuilder)((LookerViewBuilder)LookerView.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected LookerViewBuilder<?, ?> trimToRequired() {
        return LookerView.updater(this.getQualifiedName(), this.getName());
    }

    public static LookerView retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof LookerView) {
            return (LookerView)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a LookerView.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static LookerView retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof LookerView) {
            return (LookerView)entity;
        }
        throw new NotFoundException("No LookerView found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static LookerView removeDescription(String qualifiedName, String name) throws AtlanException {
        return (LookerView)Asset.removeDescription(((LookerViewBuilder)LookerView.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static LookerView removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (LookerView)Asset.removeUserDescription(((LookerViewBuilder)LookerView.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static LookerView removeOwners(String qualifiedName, String name) throws AtlanException {
        return (LookerView)Asset.removeOwners(((LookerViewBuilder)LookerView.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static LookerView updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (LookerView)Asset.updateCertificate(LookerView.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static LookerView removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (LookerView)Asset.removeCertificate(((LookerViewBuilder)LookerView.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static LookerView updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (LookerView)Asset.updateAnnouncement(LookerView.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static LookerView removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (LookerView)Asset.removeAnnouncement(((LookerViewBuilder)LookerView.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static LookerView replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (LookerView)Asset.replaceTerms(LookerView.updater(qualifiedName, name), terms);
    }

    public static LookerView appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (LookerView)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static LookerView removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (LookerView)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected LookerView(LookerViewBuilder<?, ?> b) {
        super((Looker.LookerBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : LookerView.$default$typeName();
        this.projectName = b.projectName;
        this.project = b.project;
        SortedSet<LookerField> fields = new TreeSet<LookerField>();
        if (b.fields != null) {
            fields.addAll(b.fields);
        }
        fields = Collections.unmodifiableSortedSet(fields);
        this.fields = fields;
    }

    @Generated
    public static LookerViewBuilder<?, ?> builder() {
        return new LookerViewBuilderImpl();
    }

    @Generated
    public LookerViewBuilder<?, ?> toBuilder() {
        return new LookerViewBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getProjectName() {
        return this.projectName;
    }

    @Generated
    public LookerProject getProject() {
        return this.project;
    }

    @Generated
    public SortedSet<LookerField> getFields() {
        return this.fields;
    }

    @Generated
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Generated
    public void setProject(LookerProject project) {
        this.project = project;
    }

    @Generated
    public void setFields(SortedSet<LookerField> fields) {
        this.fields = fields;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LookerView)) {
            return false;
        }
        LookerView other = (LookerView)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$projectName = this.getProjectName();
        String other$projectName = other.getProjectName();
        if (this$projectName == null ? other$projectName != null : !this$projectName.equals(other$projectName)) {
            return false;
        }
        LookerProject this$project = this.getProject();
        LookerProject other$project = other.getProject();
        if (this$project == null ? other$project != null : !((Object)this$project).equals(other$project)) {
            return false;
        }
        SortedSet<LookerField> this$fields = this.getFields();
        SortedSet<LookerField> other$fields = other.getFields();
        return !(this$fields == null ? other$fields != null : !this$fields.equals(other$fields));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LookerView;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $projectName = this.getProjectName();
        result = result * 59 + ($projectName == null ? 43 : $projectName.hashCode());
        LookerProject $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : ((Object)$project).hashCode());
        SortedSet<LookerField> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : $fields.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class LookerViewBuilderImpl
    extends LookerViewBuilder<LookerView, LookerViewBuilderImpl> {
        @Generated
        private LookerViewBuilderImpl() {
        }

        @Override
        @Generated
        protected LookerViewBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public LookerView build() {
            return new LookerView(this);
        }
    }

    @Generated
    public static abstract class LookerViewBuilder<C extends LookerView, B extends LookerViewBuilder<C, B>>
    extends Looker.LookerBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String projectName;
        @Generated
        private LookerProject project;
        @Generated
        private ArrayList<LookerField> fields;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            LookerViewBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(LookerView instance, LookerViewBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.projectName(instance.projectName);
            b.project(instance.project);
            b.fields(instance.fields == null ? Collections.emptySortedSet() : instance.fields);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B projectName(String projectName) {
            this.projectName = projectName;
            return (B)this.self();
        }

        @Generated
        public B project(LookerProject project) {
            this.project = project;
            return (B)this.self();
        }

        @Generated
        public B field(LookerField field) {
            if (this.fields == null) {
                this.fields = new ArrayList();
            }
            this.fields.add(field);
            return (B)this.self();
        }

        @Generated
        public B fields(Collection<? extends LookerField> fields) {
            if (fields == null) {
                throw new NullPointerException("fields cannot be null");
            }
            if (this.fields == null) {
                this.fields = new ArrayList();
            }
            this.fields.addAll(fields);
            return (B)this.self();
        }

        @Generated
        public B clearFields() {
            if (this.fields != null) {
                this.fields.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "LookerView.LookerViewBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", projectName=" + this.projectName + ", project=" + this.project + ", fields=" + this.fields + ")";
        }
    }
}

