/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.Column;
import com.atlan.model.assets.Connection;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.SQL;
import com.atlan.model.assets.Schema;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.enums.AtlanConnectorType;
import com.atlan.model.relations.UniqueAttributes;
import com.atlan.util.StringUtils;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class MaterializedView
extends SQL {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "MaterialisedView";
    String typeName;
    @Attribute
    String refreshMode;
    @Attribute
    String refreshMethod;
    @Attribute
    String staleness;
    @Attribute
    Long staleSinceDate;
    @Attribute
    Long columnCount;
    @Attribute
    Long rowCount;
    @Attribute
    Long sizeBytes;
    @Attribute
    Boolean isQueryPreview;
    @Attribute
    Map<String, String> queryPreviewConfig;
    @Attribute
    String alias;
    @Attribute
    Boolean isTemporary;
    @Attribute
    String definition;
    @Attribute
    @JsonProperty(value="atlanSchema")
    Schema schema;
    @Attribute
    SortedSet<Column> columns;

    public static MaterializedView refByGuid(String guid) {
        return ((MaterializedViewBuilder)MaterializedView.builder().guid(guid)).build();
    }

    public static MaterializedView refByQualifiedName(String qualifiedName) {
        return ((MaterializedViewBuilder)MaterializedView.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static MaterializedViewBuilder<?, ?> creator(String name, String schemaQualifiedName) {
        String[] tokens = schemaQualifiedName.split("/");
        AtlanConnectorType connectorType = Connection.getConnectorTypeFromQualifiedName(tokens);
        String schemaName = StringUtils.getNameFromQualifiedName(schemaQualifiedName);
        String databaseQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(schemaQualifiedName);
        String databaseName = StringUtils.getNameFromQualifiedName(databaseQualifiedName);
        String connectionQualifiedName = StringUtils.getParentQualifiedNameFromQualifiedName(databaseQualifiedName);
        return (MaterializedViewBuilder)((MaterializedViewBuilder)((MaterializedViewBuilder)((SQL.SQLBuilder)((MaterializedViewBuilder)((MaterializedViewBuilder)((MaterializedViewBuilder)((MaterializedViewBuilder)((MaterializedViewBuilder)MaterializedView.builder().name(name)).qualifiedName(schemaQualifiedName + "/" + name)).connectorType(connectorType)).schemaName(schemaName)).schemaQualifiedName(schemaQualifiedName)).schema(Schema.refByQualifiedName(schemaQualifiedName))).databaseName(databaseName)).databaseQualifiedName(databaseQualifiedName)).connectionQualifiedName(connectionQualifiedName);
    }

    public static MaterializedViewBuilder<?, ?> updater(String qualifiedName, String name) {
        return (MaterializedViewBuilder)((MaterializedViewBuilder)MaterializedView.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected MaterializedViewBuilder<?, ?> trimToRequired() {
        return MaterializedView.updater(this.getQualifiedName(), this.getName());
    }

    public static MaterializedView retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof MaterializedView) {
            return (MaterializedView)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a MaterializedView.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static MaterializedView retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof MaterializedView) {
            return (MaterializedView)entity;
        }
        throw new NotFoundException("No MaterializedView found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static MaterializedView removeDescription(String qualifiedName, String name) throws AtlanException {
        return (MaterializedView)Asset.removeDescription(((MaterializedViewBuilder)MaterializedView.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static MaterializedView removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (MaterializedView)Asset.removeUserDescription(((MaterializedViewBuilder)MaterializedView.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static MaterializedView removeOwners(String qualifiedName, String name) throws AtlanException {
        return (MaterializedView)Asset.removeOwners(((MaterializedViewBuilder)MaterializedView.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static MaterializedView updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (MaterializedView)Asset.updateCertificate(MaterializedView.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static MaterializedView removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (MaterializedView)Asset.removeCertificate(((MaterializedViewBuilder)MaterializedView.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static MaterializedView updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (MaterializedView)Asset.updateAnnouncement(MaterializedView.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static MaterializedView removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (MaterializedView)Asset.removeAnnouncement(((MaterializedViewBuilder)MaterializedView.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static MaterializedView replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (MaterializedView)Asset.replaceTerms(MaterializedView.updater(qualifiedName, name), terms);
    }

    public static MaterializedView appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (MaterializedView)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static MaterializedView removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (MaterializedView)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected MaterializedView(MaterializedViewBuilder<?, ?> b) {
        super((SQL.SQLBuilder<?, ?>)b);
        Map<Object, Object> queryPreviewConfig;
        this.typeName = b.typeName$set ? b.typeName$value : MaterializedView.$default$typeName();
        this.refreshMode = b.refreshMode;
        this.refreshMethod = b.refreshMethod;
        this.staleness = b.staleness;
        this.staleSinceDate = b.staleSinceDate;
        this.columnCount = b.columnCount;
        this.rowCount = b.rowCount;
        this.sizeBytes = b.sizeBytes;
        this.isQueryPreview = b.isQueryPreview;
        switch (b.queryPreviewConfig$key == null ? 0 : b.queryPreviewConfig$key.size()) {
            case 0: {
                queryPreviewConfig = Collections.emptyMap();
                break;
            }
            case 1: {
                queryPreviewConfig = Collections.singletonMap(b.queryPreviewConfig$key.get(0), b.queryPreviewConfig$value.get(0));
                break;
            }
            default: {
                queryPreviewConfig = new LinkedHashMap(b.queryPreviewConfig$key.size() < 0x40000000 ? 1 + b.queryPreviewConfig$key.size() + (b.queryPreviewConfig$key.size() - 3) / 3 : Integer.MAX_VALUE);
                for (int $i = 0; $i < b.queryPreviewConfig$key.size(); ++$i) {
                    queryPreviewConfig.put(b.queryPreviewConfig$key.get($i), b.queryPreviewConfig$value.get($i));
                }
                queryPreviewConfig = Collections.unmodifiableMap(queryPreviewConfig);
            }
        }
        this.queryPreviewConfig = queryPreviewConfig;
        this.alias = b.alias;
        this.isTemporary = b.isTemporary;
        this.definition = b.definition;
        this.schema = b.schema;
        SortedSet<Column> columns = new TreeSet<Column>();
        if (b.columns != null) {
            columns.addAll(b.columns);
        }
        columns = Collections.unmodifiableSortedSet(columns);
        this.columns = columns;
    }

    @Generated
    public static MaterializedViewBuilder<?, ?> builder() {
        return new MaterializedViewBuilderImpl();
    }

    @Generated
    public MaterializedViewBuilder<?, ?> toBuilder() {
        return new MaterializedViewBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getRefreshMode() {
        return this.refreshMode;
    }

    @Generated
    public String getRefreshMethod() {
        return this.refreshMethod;
    }

    @Generated
    public String getStaleness() {
        return this.staleness;
    }

    @Generated
    public Long getStaleSinceDate() {
        return this.staleSinceDate;
    }

    @Generated
    public Long getColumnCount() {
        return this.columnCount;
    }

    @Generated
    public Long getRowCount() {
        return this.rowCount;
    }

    @Generated
    public Long getSizeBytes() {
        return this.sizeBytes;
    }

    @Generated
    public Boolean getIsQueryPreview() {
        return this.isQueryPreview;
    }

    @Generated
    public Map<String, String> getQueryPreviewConfig() {
        return this.queryPreviewConfig;
    }

    @Generated
    public String getAlias() {
        return this.alias;
    }

    @Generated
    public Boolean getIsTemporary() {
        return this.isTemporary;
    }

    @Generated
    public String getDefinition() {
        return this.definition;
    }

    @Generated
    public Schema getSchema() {
        return this.schema;
    }

    @Generated
    public SortedSet<Column> getColumns() {
        return this.columns;
    }

    @Generated
    public void setRefreshMode(String refreshMode) {
        this.refreshMode = refreshMode;
    }

    @Generated
    public void setRefreshMethod(String refreshMethod) {
        this.refreshMethod = refreshMethod;
    }

    @Generated
    public void setStaleness(String staleness) {
        this.staleness = staleness;
    }

    @Generated
    public void setStaleSinceDate(Long staleSinceDate) {
        this.staleSinceDate = staleSinceDate;
    }

    @Generated
    public void setColumnCount(Long columnCount) {
        this.columnCount = columnCount;
    }

    @Generated
    public void setRowCount(Long rowCount) {
        this.rowCount = rowCount;
    }

    @Generated
    public void setSizeBytes(Long sizeBytes) {
        this.sizeBytes = sizeBytes;
    }

    @Generated
    public void setIsQueryPreview(Boolean isQueryPreview) {
        this.isQueryPreview = isQueryPreview;
    }

    @Generated
    public void setQueryPreviewConfig(Map<String, String> queryPreviewConfig) {
        this.queryPreviewConfig = queryPreviewConfig;
    }

    @Generated
    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Generated
    public void setIsTemporary(Boolean isTemporary) {
        this.isTemporary = isTemporary;
    }

    @Generated
    public void setDefinition(String definition) {
        this.definition = definition;
    }

    @JsonProperty(value="atlanSchema")
    @Generated
    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    @Generated
    public void setColumns(SortedSet<Column> columns) {
        this.columns = columns;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MaterializedView)) {
            return false;
        }
        MaterializedView other = (MaterializedView)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$staleSinceDate = this.getStaleSinceDate();
        Long other$staleSinceDate = other.getStaleSinceDate();
        if (this$staleSinceDate == null ? other$staleSinceDate != null : !((Object)this$staleSinceDate).equals(other$staleSinceDate)) {
            return false;
        }
        Long this$columnCount = this.getColumnCount();
        Long other$columnCount = other.getColumnCount();
        if (this$columnCount == null ? other$columnCount != null : !((Object)this$columnCount).equals(other$columnCount)) {
            return false;
        }
        Long this$rowCount = this.getRowCount();
        Long other$rowCount = other.getRowCount();
        if (this$rowCount == null ? other$rowCount != null : !((Object)this$rowCount).equals(other$rowCount)) {
            return false;
        }
        Long this$sizeBytes = this.getSizeBytes();
        Long other$sizeBytes = other.getSizeBytes();
        if (this$sizeBytes == null ? other$sizeBytes != null : !((Object)this$sizeBytes).equals(other$sizeBytes)) {
            return false;
        }
        Boolean this$isQueryPreview = this.getIsQueryPreview();
        Boolean other$isQueryPreview = other.getIsQueryPreview();
        if (this$isQueryPreview == null ? other$isQueryPreview != null : !((Object)this$isQueryPreview).equals(other$isQueryPreview)) {
            return false;
        }
        Boolean this$isTemporary = this.getIsTemporary();
        Boolean other$isTemporary = other.getIsTemporary();
        if (this$isTemporary == null ? other$isTemporary != null : !((Object)this$isTemporary).equals(other$isTemporary)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$refreshMode = this.getRefreshMode();
        String other$refreshMode = other.getRefreshMode();
        if (this$refreshMode == null ? other$refreshMode != null : !this$refreshMode.equals(other$refreshMode)) {
            return false;
        }
        String this$refreshMethod = this.getRefreshMethod();
        String other$refreshMethod = other.getRefreshMethod();
        if (this$refreshMethod == null ? other$refreshMethod != null : !this$refreshMethod.equals(other$refreshMethod)) {
            return false;
        }
        String this$staleness = this.getStaleness();
        String other$staleness = other.getStaleness();
        if (this$staleness == null ? other$staleness != null : !this$staleness.equals(other$staleness)) {
            return false;
        }
        Map<String, String> this$queryPreviewConfig = this.getQueryPreviewConfig();
        Map<String, String> other$queryPreviewConfig = other.getQueryPreviewConfig();
        if (this$queryPreviewConfig == null ? other$queryPreviewConfig != null : !((Object)this$queryPreviewConfig).equals(other$queryPreviewConfig)) {
            return false;
        }
        String this$alias = this.getAlias();
        String other$alias = other.getAlias();
        if (this$alias == null ? other$alias != null : !this$alias.equals(other$alias)) {
            return false;
        }
        String this$definition = this.getDefinition();
        String other$definition = other.getDefinition();
        if (this$definition == null ? other$definition != null : !this$definition.equals(other$definition)) {
            return false;
        }
        Schema this$schema = this.getSchema();
        Schema other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !((Object)this$schema).equals(other$schema)) {
            return false;
        }
        SortedSet<Column> this$columns = this.getColumns();
        SortedSet<Column> other$columns = other.getColumns();
        return !(this$columns == null ? other$columns != null : !this$columns.equals(other$columns));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MaterializedView;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $staleSinceDate = this.getStaleSinceDate();
        result = result * 59 + ($staleSinceDate == null ? 43 : ((Object)$staleSinceDate).hashCode());
        Long $columnCount = this.getColumnCount();
        result = result * 59 + ($columnCount == null ? 43 : ((Object)$columnCount).hashCode());
        Long $rowCount = this.getRowCount();
        result = result * 59 + ($rowCount == null ? 43 : ((Object)$rowCount).hashCode());
        Long $sizeBytes = this.getSizeBytes();
        result = result * 59 + ($sizeBytes == null ? 43 : ((Object)$sizeBytes).hashCode());
        Boolean $isQueryPreview = this.getIsQueryPreview();
        result = result * 59 + ($isQueryPreview == null ? 43 : ((Object)$isQueryPreview).hashCode());
        Boolean $isTemporary = this.getIsTemporary();
        result = result * 59 + ($isTemporary == null ? 43 : ((Object)$isTemporary).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $refreshMode = this.getRefreshMode();
        result = result * 59 + ($refreshMode == null ? 43 : $refreshMode.hashCode());
        String $refreshMethod = this.getRefreshMethod();
        result = result * 59 + ($refreshMethod == null ? 43 : $refreshMethod.hashCode());
        String $staleness = this.getStaleness();
        result = result * 59 + ($staleness == null ? 43 : $staleness.hashCode());
        Map<String, String> $queryPreviewConfig = this.getQueryPreviewConfig();
        result = result * 59 + ($queryPreviewConfig == null ? 43 : ((Object)$queryPreviewConfig).hashCode());
        String $alias = this.getAlias();
        result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
        String $definition = this.getDefinition();
        result = result * 59 + ($definition == null ? 43 : $definition.hashCode());
        Schema $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : ((Object)$schema).hashCode());
        SortedSet<Column> $columns = this.getColumns();
        result = result * 59 + ($columns == null ? 43 : $columns.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class MaterializedViewBuilderImpl
    extends MaterializedViewBuilder<MaterializedView, MaterializedViewBuilderImpl> {
        @Generated
        private MaterializedViewBuilderImpl() {
        }

        @Override
        @Generated
        protected MaterializedViewBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public MaterializedView build() {
            return new MaterializedView(this);
        }
    }

    @Generated
    public static abstract class MaterializedViewBuilder<C extends MaterializedView, B extends MaterializedViewBuilder<C, B>>
    extends SQL.SQLBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String refreshMode;
        @Generated
        private String refreshMethod;
        @Generated
        private String staleness;
        @Generated
        private Long staleSinceDate;
        @Generated
        private Long columnCount;
        @Generated
        private Long rowCount;
        @Generated
        private Long sizeBytes;
        @Generated
        private Boolean isQueryPreview;
        @Generated
        private ArrayList<String> queryPreviewConfig$key;
        @Generated
        private ArrayList<String> queryPreviewConfig$value;
        @Generated
        private String alias;
        @Generated
        private Boolean isTemporary;
        @Generated
        private String definition;
        @Generated
        private Schema schema;
        @Generated
        private ArrayList<Column> columns;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            MaterializedViewBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(MaterializedView instance, MaterializedViewBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.refreshMode(instance.refreshMode);
            b.refreshMethod(instance.refreshMethod);
            b.staleness(instance.staleness);
            b.staleSinceDate(instance.staleSinceDate);
            b.columnCount(instance.columnCount);
            b.rowCount(instance.rowCount);
            b.sizeBytes(instance.sizeBytes);
            b.isQueryPreview(instance.isQueryPreview);
            b.queryPreviewConfig(instance.queryPreviewConfig == null ? Collections.emptyMap() : instance.queryPreviewConfig);
            b.alias(instance.alias);
            b.isTemporary(instance.isTemporary);
            b.definition(instance.definition);
            b.schema(instance.schema);
            b.columns(instance.columns == null ? Collections.emptySortedSet() : instance.columns);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B refreshMode(String refreshMode) {
            this.refreshMode = refreshMode;
            return (B)this.self();
        }

        @Generated
        public B refreshMethod(String refreshMethod) {
            this.refreshMethod = refreshMethod;
            return (B)this.self();
        }

        @Generated
        public B staleness(String staleness) {
            this.staleness = staleness;
            return (B)this.self();
        }

        @Generated
        public B staleSinceDate(Long staleSinceDate) {
            this.staleSinceDate = staleSinceDate;
            return (B)this.self();
        }

        @Generated
        public B columnCount(Long columnCount) {
            this.columnCount = columnCount;
            return (B)this.self();
        }

        @Generated
        public B rowCount(Long rowCount) {
            this.rowCount = rowCount;
            return (B)this.self();
        }

        @Generated
        public B sizeBytes(Long sizeBytes) {
            this.sizeBytes = sizeBytes;
            return (B)this.self();
        }

        @Generated
        public B isQueryPreview(Boolean isQueryPreview) {
            this.isQueryPreview = isQueryPreview;
            return (B)this.self();
        }

        @Generated
        public B putQueryPreviewConfig(String putQueryPreviewConfigKey, String putQueryPreviewConfigValue) {
            if (this.queryPreviewConfig$key == null) {
                this.queryPreviewConfig$key = new ArrayList();
                this.queryPreviewConfig$value = new ArrayList();
            }
            this.queryPreviewConfig$key.add(putQueryPreviewConfigKey);
            this.queryPreviewConfig$value.add(putQueryPreviewConfigValue);
            return (B)this.self();
        }

        @Generated
        public B queryPreviewConfig(Map<? extends String, ? extends String> queryPreviewConfig) {
            if (queryPreviewConfig == null) {
                throw new NullPointerException("queryPreviewConfig cannot be null");
            }
            if (this.queryPreviewConfig$key == null) {
                this.queryPreviewConfig$key = new ArrayList();
                this.queryPreviewConfig$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : queryPreviewConfig.entrySet()) {
                this.queryPreviewConfig$key.add($lombokEntry.getKey());
                this.queryPreviewConfig$value.add($lombokEntry.getValue());
            }
            return (B)this.self();
        }

        @Generated
        public B clearQueryPreviewConfig() {
            if (this.queryPreviewConfig$key != null) {
                this.queryPreviewConfig$key.clear();
                this.queryPreviewConfig$value.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B alias(String alias) {
            this.alias = alias;
            return (B)this.self();
        }

        @Generated
        public B isTemporary(Boolean isTemporary) {
            this.isTemporary = isTemporary;
            return (B)this.self();
        }

        @Generated
        public B definition(String definition) {
            this.definition = definition;
            return (B)this.self();
        }

        @JsonProperty(value="atlanSchema")
        @Generated
        public B schema(Schema schema) {
            this.schema = schema;
            return (B)this.self();
        }

        @Generated
        public B column(Column column) {
            if (this.columns == null) {
                this.columns = new ArrayList();
            }
            this.columns.add(column);
            return (B)this.self();
        }

        @Generated
        public B columns(Collection<? extends Column> columns) {
            if (columns == null) {
                throw new NullPointerException("columns cannot be null");
            }
            if (this.columns == null) {
                this.columns = new ArrayList();
            }
            this.columns.addAll(columns);
            return (B)this.self();
        }

        @Generated
        public B clearColumns() {
            if (this.columns != null) {
                this.columns.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "MaterializedView.MaterializedViewBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", refreshMode=" + this.refreshMode + ", refreshMethod=" + this.refreshMethod + ", staleness=" + this.staleness + ", staleSinceDate=" + this.staleSinceDate + ", columnCount=" + this.columnCount + ", rowCount=" + this.rowCount + ", sizeBytes=" + this.sizeBytes + ", isQueryPreview=" + this.isQueryPreview + ", queryPreviewConfig$key=" + this.queryPreviewConfig$key + ", queryPreviewConfig$value=" + this.queryPreviewConfig$value + ", alias=" + this.alias + ", isTemporary=" + this.isTemporary + ", definition=" + this.definition + ", schema=" + this.schema + ", columns=" + this.columns + ")";
        }
    }
}

