/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.Metabase;
import com.atlan.model.assets.MetabaseDashboard;
import com.atlan.model.assets.MetabaseQuestion;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class MetabaseCollection
extends Metabase {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "MetabaseCollection";
    String typeName;
    @Attribute
    String metabaseSlug;
    @Attribute
    String metabaseColor;
    @Attribute
    String metabaseNamespace;
    @Attribute
    Boolean metabaseIsPersonalCollection;
    @Attribute
    SortedSet<MetabaseDashboard> metabaseDashboards;
    @Attribute
    SortedSet<MetabaseQuestion> metabaseQuestions;

    public static MetabaseCollection refByGuid(String guid) {
        return ((MetabaseCollectionBuilder)MetabaseCollection.builder().guid(guid)).build();
    }

    public static MetabaseCollection refByQualifiedName(String qualifiedName) {
        return ((MetabaseCollectionBuilder)MetabaseCollection.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static MetabaseCollectionBuilder<?, ?> updater(String qualifiedName, String name) {
        return (MetabaseCollectionBuilder)((MetabaseCollectionBuilder)MetabaseCollection.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected MetabaseCollectionBuilder<?, ?> trimToRequired() {
        return MetabaseCollection.updater(this.getQualifiedName(), this.getName());
    }

    public static MetabaseCollection retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof MetabaseCollection) {
            return (MetabaseCollection)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a MetabaseCollection.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static MetabaseCollection retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof MetabaseCollection) {
            return (MetabaseCollection)entity;
        }
        throw new NotFoundException("No MetabaseCollection found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static MetabaseCollection removeDescription(String qualifiedName, String name) throws AtlanException {
        return (MetabaseCollection)Asset.removeDescription(((MetabaseCollectionBuilder)MetabaseCollection.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static MetabaseCollection removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (MetabaseCollection)Asset.removeUserDescription(((MetabaseCollectionBuilder)MetabaseCollection.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static MetabaseCollection removeOwners(String qualifiedName, String name) throws AtlanException {
        return (MetabaseCollection)Asset.removeOwners(((MetabaseCollectionBuilder)MetabaseCollection.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static MetabaseCollection updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (MetabaseCollection)Asset.updateCertificate(MetabaseCollection.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static MetabaseCollection removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (MetabaseCollection)Asset.removeCertificate(((MetabaseCollectionBuilder)MetabaseCollection.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static MetabaseCollection updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (MetabaseCollection)Asset.updateAnnouncement(MetabaseCollection.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static MetabaseCollection removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (MetabaseCollection)Asset.removeAnnouncement(((MetabaseCollectionBuilder)MetabaseCollection.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static MetabaseCollection replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (MetabaseCollection)Asset.replaceTerms(MetabaseCollection.updater(qualifiedName, name), terms);
    }

    public static MetabaseCollection appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (MetabaseCollection)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static MetabaseCollection removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (MetabaseCollection)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected MetabaseCollection(MetabaseCollectionBuilder<?, ?> b) {
        super((Metabase.MetabaseBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : MetabaseCollection.$default$typeName();
        this.metabaseSlug = b.metabaseSlug;
        this.metabaseColor = b.metabaseColor;
        this.metabaseNamespace = b.metabaseNamespace;
        this.metabaseIsPersonalCollection = b.metabaseIsPersonalCollection;
        SortedSet<MetabaseDashboard> metabaseDashboards = new TreeSet<MetabaseDashboard>();
        if (b.metabaseDashboards != null) {
            metabaseDashboards.addAll(b.metabaseDashboards);
        }
        metabaseDashboards = Collections.unmodifiableSortedSet(metabaseDashboards);
        this.metabaseDashboards = metabaseDashboards;
        SortedSet<MetabaseQuestion> metabaseQuestions = new TreeSet<MetabaseQuestion>();
        if (b.metabaseQuestions != null) {
            metabaseQuestions.addAll(b.metabaseQuestions);
        }
        metabaseQuestions = Collections.unmodifiableSortedSet(metabaseQuestions);
        this.metabaseQuestions = metabaseQuestions;
    }

    @Generated
    public static MetabaseCollectionBuilder<?, ?> builder() {
        return new MetabaseCollectionBuilderImpl();
    }

    @Generated
    public MetabaseCollectionBuilder<?, ?> toBuilder() {
        return new MetabaseCollectionBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public String getMetabaseSlug() {
        return this.metabaseSlug;
    }

    @Generated
    public String getMetabaseColor() {
        return this.metabaseColor;
    }

    @Generated
    public String getMetabaseNamespace() {
        return this.metabaseNamespace;
    }

    @Generated
    public Boolean getMetabaseIsPersonalCollection() {
        return this.metabaseIsPersonalCollection;
    }

    @Generated
    public SortedSet<MetabaseDashboard> getMetabaseDashboards() {
        return this.metabaseDashboards;
    }

    @Generated
    public SortedSet<MetabaseQuestion> getMetabaseQuestions() {
        return this.metabaseQuestions;
    }

    @Generated
    public void setMetabaseSlug(String metabaseSlug) {
        this.metabaseSlug = metabaseSlug;
    }

    @Generated
    public void setMetabaseColor(String metabaseColor) {
        this.metabaseColor = metabaseColor;
    }

    @Generated
    public void setMetabaseNamespace(String metabaseNamespace) {
        this.metabaseNamespace = metabaseNamespace;
    }

    @Generated
    public void setMetabaseIsPersonalCollection(Boolean metabaseIsPersonalCollection) {
        this.metabaseIsPersonalCollection = metabaseIsPersonalCollection;
    }

    @Generated
    public void setMetabaseDashboards(SortedSet<MetabaseDashboard> metabaseDashboards) {
        this.metabaseDashboards = metabaseDashboards;
    }

    @Generated
    public void setMetabaseQuestions(SortedSet<MetabaseQuestion> metabaseQuestions) {
        this.metabaseQuestions = metabaseQuestions;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetabaseCollection)) {
            return false;
        }
        MetabaseCollection other = (MetabaseCollection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$metabaseIsPersonalCollection = this.getMetabaseIsPersonalCollection();
        Boolean other$metabaseIsPersonalCollection = other.getMetabaseIsPersonalCollection();
        if (this$metabaseIsPersonalCollection == null ? other$metabaseIsPersonalCollection != null : !((Object)this$metabaseIsPersonalCollection).equals(other$metabaseIsPersonalCollection)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$metabaseSlug = this.getMetabaseSlug();
        String other$metabaseSlug = other.getMetabaseSlug();
        if (this$metabaseSlug == null ? other$metabaseSlug != null : !this$metabaseSlug.equals(other$metabaseSlug)) {
            return false;
        }
        String this$metabaseColor = this.getMetabaseColor();
        String other$metabaseColor = other.getMetabaseColor();
        if (this$metabaseColor == null ? other$metabaseColor != null : !this$metabaseColor.equals(other$metabaseColor)) {
            return false;
        }
        String this$metabaseNamespace = this.getMetabaseNamespace();
        String other$metabaseNamespace = other.getMetabaseNamespace();
        if (this$metabaseNamespace == null ? other$metabaseNamespace != null : !this$metabaseNamespace.equals(other$metabaseNamespace)) {
            return false;
        }
        SortedSet<MetabaseDashboard> this$metabaseDashboards = this.getMetabaseDashboards();
        SortedSet<MetabaseDashboard> other$metabaseDashboards = other.getMetabaseDashboards();
        if (this$metabaseDashboards == null ? other$metabaseDashboards != null : !this$metabaseDashboards.equals(other$metabaseDashboards)) {
            return false;
        }
        SortedSet<MetabaseQuestion> this$metabaseQuestions = this.getMetabaseQuestions();
        SortedSet<MetabaseQuestion> other$metabaseQuestions = other.getMetabaseQuestions();
        return !(this$metabaseQuestions == null ? other$metabaseQuestions != null : !this$metabaseQuestions.equals(other$metabaseQuestions));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MetabaseCollection;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $metabaseIsPersonalCollection = this.getMetabaseIsPersonalCollection();
        result = result * 59 + ($metabaseIsPersonalCollection == null ? 43 : ((Object)$metabaseIsPersonalCollection).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $metabaseSlug = this.getMetabaseSlug();
        result = result * 59 + ($metabaseSlug == null ? 43 : $metabaseSlug.hashCode());
        String $metabaseColor = this.getMetabaseColor();
        result = result * 59 + ($metabaseColor == null ? 43 : $metabaseColor.hashCode());
        String $metabaseNamespace = this.getMetabaseNamespace();
        result = result * 59 + ($metabaseNamespace == null ? 43 : $metabaseNamespace.hashCode());
        SortedSet<MetabaseDashboard> $metabaseDashboards = this.getMetabaseDashboards();
        result = result * 59 + ($metabaseDashboards == null ? 43 : $metabaseDashboards.hashCode());
        SortedSet<MetabaseQuestion> $metabaseQuestions = this.getMetabaseQuestions();
        result = result * 59 + ($metabaseQuestions == null ? 43 : $metabaseQuestions.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class MetabaseCollectionBuilderImpl
    extends MetabaseCollectionBuilder<MetabaseCollection, MetabaseCollectionBuilderImpl> {
        @Generated
        private MetabaseCollectionBuilderImpl() {
        }

        @Override
        @Generated
        protected MetabaseCollectionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public MetabaseCollection build() {
            return new MetabaseCollection(this);
        }
    }

    @Generated
    public static abstract class MetabaseCollectionBuilder<C extends MetabaseCollection, B extends MetabaseCollectionBuilder<C, B>>
    extends Metabase.MetabaseBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private String metabaseSlug;
        @Generated
        private String metabaseColor;
        @Generated
        private String metabaseNamespace;
        @Generated
        private Boolean metabaseIsPersonalCollection;
        @Generated
        private ArrayList<MetabaseDashboard> metabaseDashboards;
        @Generated
        private ArrayList<MetabaseQuestion> metabaseQuestions;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            MetabaseCollectionBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(MetabaseCollection instance, MetabaseCollectionBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.metabaseSlug(instance.metabaseSlug);
            b.metabaseColor(instance.metabaseColor);
            b.metabaseNamespace(instance.metabaseNamespace);
            b.metabaseIsPersonalCollection(instance.metabaseIsPersonalCollection);
            b.metabaseDashboards(instance.metabaseDashboards == null ? Collections.emptySortedSet() : instance.metabaseDashboards);
            b.metabaseQuestions(instance.metabaseQuestions == null ? Collections.emptySortedSet() : instance.metabaseQuestions);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B metabaseSlug(String metabaseSlug) {
            this.metabaseSlug = metabaseSlug;
            return (B)this.self();
        }

        @Generated
        public B metabaseColor(String metabaseColor) {
            this.metabaseColor = metabaseColor;
            return (B)this.self();
        }

        @Generated
        public B metabaseNamespace(String metabaseNamespace) {
            this.metabaseNamespace = metabaseNamespace;
            return (B)this.self();
        }

        @Generated
        public B metabaseIsPersonalCollection(Boolean metabaseIsPersonalCollection) {
            this.metabaseIsPersonalCollection = metabaseIsPersonalCollection;
            return (B)this.self();
        }

        @Generated
        public B metabaseDashboard(MetabaseDashboard metabaseDashboard) {
            if (this.metabaseDashboards == null) {
                this.metabaseDashboards = new ArrayList();
            }
            this.metabaseDashboards.add(metabaseDashboard);
            return (B)this.self();
        }

        @Generated
        public B metabaseDashboards(Collection<? extends MetabaseDashboard> metabaseDashboards) {
            if (metabaseDashboards == null) {
                throw new NullPointerException("metabaseDashboards cannot be null");
            }
            if (this.metabaseDashboards == null) {
                this.metabaseDashboards = new ArrayList();
            }
            this.metabaseDashboards.addAll(metabaseDashboards);
            return (B)this.self();
        }

        @Generated
        public B clearMetabaseDashboards() {
            if (this.metabaseDashboards != null) {
                this.metabaseDashboards.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B metabaseQuestion(MetabaseQuestion metabaseQuestion) {
            if (this.metabaseQuestions == null) {
                this.metabaseQuestions = new ArrayList();
            }
            this.metabaseQuestions.add(metabaseQuestion);
            return (B)this.self();
        }

        @Generated
        public B metabaseQuestions(Collection<? extends MetabaseQuestion> metabaseQuestions) {
            if (metabaseQuestions == null) {
                throw new NullPointerException("metabaseQuestions cannot be null");
            }
            if (this.metabaseQuestions == null) {
                this.metabaseQuestions = new ArrayList();
            }
            this.metabaseQuestions.addAll(metabaseQuestions);
            return (B)this.self();
        }

        @Generated
        public B clearMetabaseQuestions() {
            if (this.metabaseQuestions != null) {
                this.metabaseQuestions.clear();
            }
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "MetabaseCollection.MetabaseCollectionBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", metabaseSlug=" + this.metabaseSlug + ", metabaseColor=" + this.metabaseColor + ", metabaseNamespace=" + this.metabaseNamespace + ", metabaseIsPersonalCollection=" + this.metabaseIsPersonalCollection + ", metabaseDashboards=" + this.metabaseDashboards + ", metabaseQuestions=" + this.metabaseQuestions + ")";
        }
    }
}

