/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.Metabase;
import com.atlan.model.assets.MetabaseCollection;
import com.atlan.model.assets.MetabaseQuestion;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class MetabaseDashboard
extends Metabase {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "MetabaseDashboard";
    String typeName;
    @Attribute
    Long metabaseQuestionCount;
    @Attribute
    SortedSet<MetabaseQuestion> metabaseQuestions;
    @Attribute
    MetabaseCollection metabaseCollection;

    public static MetabaseDashboard refByGuid(String guid) {
        return ((MetabaseDashboardBuilder)MetabaseDashboard.builder().guid(guid)).build();
    }

    public static MetabaseDashboard refByQualifiedName(String qualifiedName) {
        return ((MetabaseDashboardBuilder)MetabaseDashboard.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static MetabaseDashboardBuilder<?, ?> updater(String qualifiedName, String name) {
        return (MetabaseDashboardBuilder)((MetabaseDashboardBuilder)MetabaseDashboard.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected MetabaseDashboardBuilder<?, ?> trimToRequired() {
        return MetabaseDashboard.updater(this.getQualifiedName(), this.getName());
    }

    public static MetabaseDashboard retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof MetabaseDashboard) {
            return (MetabaseDashboard)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a MetabaseDashboard.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static MetabaseDashboard retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof MetabaseDashboard) {
            return (MetabaseDashboard)entity;
        }
        throw new NotFoundException("No MetabaseDashboard found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static MetabaseDashboard removeDescription(String qualifiedName, String name) throws AtlanException {
        return (MetabaseDashboard)Asset.removeDescription(((MetabaseDashboardBuilder)MetabaseDashboard.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static MetabaseDashboard removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (MetabaseDashboard)Asset.removeUserDescription(((MetabaseDashboardBuilder)MetabaseDashboard.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static MetabaseDashboard removeOwners(String qualifiedName, String name) throws AtlanException {
        return (MetabaseDashboard)Asset.removeOwners(((MetabaseDashboardBuilder)MetabaseDashboard.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static MetabaseDashboard updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (MetabaseDashboard)Asset.updateCertificate(MetabaseDashboard.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static MetabaseDashboard removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (MetabaseDashboard)Asset.removeCertificate(((MetabaseDashboardBuilder)MetabaseDashboard.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static MetabaseDashboard updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (MetabaseDashboard)Asset.updateAnnouncement(MetabaseDashboard.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static MetabaseDashboard removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (MetabaseDashboard)Asset.removeAnnouncement(((MetabaseDashboardBuilder)MetabaseDashboard.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static MetabaseDashboard replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (MetabaseDashboard)Asset.replaceTerms(MetabaseDashboard.updater(qualifiedName, name), terms);
    }

    public static MetabaseDashboard appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (MetabaseDashboard)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static MetabaseDashboard removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (MetabaseDashboard)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected MetabaseDashboard(MetabaseDashboardBuilder<?, ?> b) {
        super((Metabase.MetabaseBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : MetabaseDashboard.$default$typeName();
        this.metabaseQuestionCount = b.metabaseQuestionCount;
        SortedSet<MetabaseQuestion> metabaseQuestions = new TreeSet<MetabaseQuestion>();
        if (b.metabaseQuestions != null) {
            metabaseQuestions.addAll(b.metabaseQuestions);
        }
        metabaseQuestions = Collections.unmodifiableSortedSet(metabaseQuestions);
        this.metabaseQuestions = metabaseQuestions;
        this.metabaseCollection = b.metabaseCollection;
    }

    @Generated
    public static MetabaseDashboardBuilder<?, ?> builder() {
        return new MetabaseDashboardBuilderImpl();
    }

    @Generated
    public MetabaseDashboardBuilder<?, ?> toBuilder() {
        return new MetabaseDashboardBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public Long getMetabaseQuestionCount() {
        return this.metabaseQuestionCount;
    }

    @Generated
    public SortedSet<MetabaseQuestion> getMetabaseQuestions() {
        return this.metabaseQuestions;
    }

    @Generated
    public MetabaseCollection getMetabaseCollection() {
        return this.metabaseCollection;
    }

    @Generated
    public void setMetabaseQuestionCount(Long metabaseQuestionCount) {
        this.metabaseQuestionCount = metabaseQuestionCount;
    }

    @Generated
    public void setMetabaseQuestions(SortedSet<MetabaseQuestion> metabaseQuestions) {
        this.metabaseQuestions = metabaseQuestions;
    }

    @Generated
    public void setMetabaseCollection(MetabaseCollection metabaseCollection) {
        this.metabaseCollection = metabaseCollection;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetabaseDashboard)) {
            return false;
        }
        MetabaseDashboard other = (MetabaseDashboard)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$metabaseQuestionCount = this.getMetabaseQuestionCount();
        Long other$metabaseQuestionCount = other.getMetabaseQuestionCount();
        if (this$metabaseQuestionCount == null ? other$metabaseQuestionCount != null : !((Object)this$metabaseQuestionCount).equals(other$metabaseQuestionCount)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        SortedSet<MetabaseQuestion> this$metabaseQuestions = this.getMetabaseQuestions();
        SortedSet<MetabaseQuestion> other$metabaseQuestions = other.getMetabaseQuestions();
        if (this$metabaseQuestions == null ? other$metabaseQuestions != null : !this$metabaseQuestions.equals(other$metabaseQuestions)) {
            return false;
        }
        MetabaseCollection this$metabaseCollection = this.getMetabaseCollection();
        MetabaseCollection other$metabaseCollection = other.getMetabaseCollection();
        return !(this$metabaseCollection == null ? other$metabaseCollection != null : !((Object)this$metabaseCollection).equals(other$metabaseCollection));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MetabaseDashboard;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $metabaseQuestionCount = this.getMetabaseQuestionCount();
        result = result * 59 + ($metabaseQuestionCount == null ? 43 : ((Object)$metabaseQuestionCount).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        SortedSet<MetabaseQuestion> $metabaseQuestions = this.getMetabaseQuestions();
        result = result * 59 + ($metabaseQuestions == null ? 43 : $metabaseQuestions.hashCode());
        MetabaseCollection $metabaseCollection = this.getMetabaseCollection();
        result = result * 59 + ($metabaseCollection == null ? 43 : ((Object)$metabaseCollection).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class MetabaseDashboardBuilderImpl
    extends MetabaseDashboardBuilder<MetabaseDashboard, MetabaseDashboardBuilderImpl> {
        @Generated
        private MetabaseDashboardBuilderImpl() {
        }

        @Override
        @Generated
        protected MetabaseDashboardBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public MetabaseDashboard build() {
            return new MetabaseDashboard(this);
        }
    }

    @Generated
    public static abstract class MetabaseDashboardBuilder<C extends MetabaseDashboard, B extends MetabaseDashboardBuilder<C, B>>
    extends Metabase.MetabaseBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private Long metabaseQuestionCount;
        @Generated
        private ArrayList<MetabaseQuestion> metabaseQuestions;
        @Generated
        private MetabaseCollection metabaseCollection;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            MetabaseDashboardBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(MetabaseDashboard instance, MetabaseDashboardBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.metabaseQuestionCount(instance.metabaseQuestionCount);
            b.metabaseQuestions(instance.metabaseQuestions == null ? Collections.emptySortedSet() : instance.metabaseQuestions);
            b.metabaseCollection(instance.metabaseCollection);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B metabaseQuestionCount(Long metabaseQuestionCount) {
            this.metabaseQuestionCount = metabaseQuestionCount;
            return (B)this.self();
        }

        @Generated
        public B metabaseQuestion(MetabaseQuestion metabaseQuestion) {
            if (this.metabaseQuestions == null) {
                this.metabaseQuestions = new ArrayList();
            }
            this.metabaseQuestions.add(metabaseQuestion);
            return (B)this.self();
        }

        @Generated
        public B metabaseQuestions(Collection<? extends MetabaseQuestion> metabaseQuestions) {
            if (metabaseQuestions == null) {
                throw new NullPointerException("metabaseQuestions cannot be null");
            }
            if (this.metabaseQuestions == null) {
                this.metabaseQuestions = new ArrayList();
            }
            this.metabaseQuestions.addAll(metabaseQuestions);
            return (B)this.self();
        }

        @Generated
        public B clearMetabaseQuestions() {
            if (this.metabaseQuestions != null) {
                this.metabaseQuestions.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B metabaseCollection(MetabaseCollection metabaseCollection) {
            this.metabaseCollection = metabaseCollection;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "MetabaseDashboard.MetabaseDashboardBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", metabaseQuestionCount=" + this.metabaseQuestionCount + ", metabaseQuestions=" + this.metabaseQuestions + ", metabaseCollection=" + this.metabaseCollection + ")";
        }
    }
}

