/*
 * Decompiled with CFR 0.152.
 */
package com.atlan.model.assets;

import com.atlan.exception.AtlanException;
import com.atlan.exception.NotFoundException;
import com.atlan.model.assets.Asset;
import com.atlan.model.assets.Attribute;
import com.atlan.model.assets.GlossaryTerm;
import com.atlan.model.assets.Metabase;
import com.atlan.model.assets.MetabaseCollection;
import com.atlan.model.assets.MetabaseDashboard;
import com.atlan.model.core.Entity;
import com.atlan.model.enums.AtlanAnnouncementType;
import com.atlan.model.enums.AtlanCertificateStatus;
import com.atlan.model.relations.UniqueAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import lombok.Generated;

public class MetabaseQuestion
extends Metabase {
    private static final long serialVersionUID = 2L;
    public static final String TYPE_NAME = "MetabaseQuestion";
    String typeName;
    @Attribute
    Long metabaseDashboardCount;
    @Attribute
    String metabaseQueryType;
    @Attribute
    String metabaseQuery;
    @Attribute
    SortedSet<MetabaseDashboard> metabaseDashboards;
    @Attribute
    MetabaseCollection metabaseCollection;

    public static MetabaseQuestion refByGuid(String guid) {
        return ((MetabaseQuestionBuilder)MetabaseQuestion.builder().guid(guid)).build();
    }

    public static MetabaseQuestion refByQualifiedName(String qualifiedName) {
        return ((MetabaseQuestionBuilder)MetabaseQuestion.builder().uniqueAttributes((UniqueAttributes)((UniqueAttributes.UniqueAttributesBuilder)UniqueAttributes.builder().qualifiedName(qualifiedName)).build())).build();
    }

    public static MetabaseQuestionBuilder<?, ?> updater(String qualifiedName, String name) {
        return (MetabaseQuestionBuilder)((MetabaseQuestionBuilder)MetabaseQuestion.builder().qualifiedName(qualifiedName)).name(name);
    }

    protected MetabaseQuestionBuilder<?, ?> trimToRequired() {
        return MetabaseQuestion.updater(this.getQualifiedName(), this.getName());
    }

    public static MetabaseQuestion retrieveByGuid(String guid) throws AtlanException {
        Entity entity = Entity.retrieveFull(guid);
        if (entity == null) {
            throw new NotFoundException("No entity found with GUID: " + guid, "ATLAN_JAVA_CLIENT-404-001", 404, null);
        }
        if (entity instanceof MetabaseQuestion) {
            return (MetabaseQuestion)entity;
        }
        throw new NotFoundException("Entity with GUID " + guid + " is not a MetabaseQuestion.", "ATLAN_JAVA_CLIENT-404-002", 404, null);
    }

    public static MetabaseQuestion retrieveByQualifiedName(String qualifiedName) throws AtlanException {
        Entity entity = Entity.retrieveFull(TYPE_NAME, qualifiedName);
        if (entity instanceof MetabaseQuestion) {
            return (MetabaseQuestion)entity;
        }
        throw new NotFoundException("No MetabaseQuestion found with qualifiedName: " + qualifiedName, "ATLAN_JAVA_CLIENT-404-003", 404, null);
    }

    public static boolean restore(String qualifiedName) throws AtlanException {
        return Asset.restore(TYPE_NAME, qualifiedName);
    }

    public static MetabaseQuestion removeDescription(String qualifiedName, String name) throws AtlanException {
        return (MetabaseQuestion)Asset.removeDescription(((MetabaseQuestionBuilder)MetabaseQuestion.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static MetabaseQuestion removeUserDescription(String qualifiedName, String name) throws AtlanException {
        return (MetabaseQuestion)Asset.removeUserDescription(((MetabaseQuestionBuilder)MetabaseQuestion.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static MetabaseQuestion removeOwners(String qualifiedName, String name) throws AtlanException {
        return (MetabaseQuestion)Asset.removeOwners(((MetabaseQuestionBuilder)MetabaseQuestion.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static MetabaseQuestion updateCertificate(String qualifiedName, AtlanCertificateStatus certificate, String message) throws AtlanException {
        return (MetabaseQuestion)Asset.updateCertificate(MetabaseQuestion.builder(), TYPE_NAME, qualifiedName, certificate, message);
    }

    public static MetabaseQuestion removeCertificate(String qualifiedName, String name) throws AtlanException {
        return (MetabaseQuestion)Asset.removeCertificate(((MetabaseQuestionBuilder)MetabaseQuestion.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static MetabaseQuestion updateAnnouncement(String qualifiedName, AtlanAnnouncementType type, String title, String message) throws AtlanException {
        return (MetabaseQuestion)Asset.updateAnnouncement(MetabaseQuestion.builder(), TYPE_NAME, qualifiedName, type, title, message);
    }

    public static MetabaseQuestion removeAnnouncement(String qualifiedName, String name) throws AtlanException {
        return (MetabaseQuestion)Asset.removeAnnouncement(((MetabaseQuestionBuilder)MetabaseQuestion.builder().qualifiedName(qualifiedName)).name(name));
    }

    public static void addClassifications(String qualifiedName, List<String> classificationNames) throws AtlanException {
        Asset.addClassifications(TYPE_NAME, qualifiedName, classificationNames);
    }

    public static void removeClassification(String qualifiedName, String classificationName) throws AtlanException {
        Asset.removeClassification(TYPE_NAME, qualifiedName, classificationName);
    }

    public static MetabaseQuestion replaceTerms(String qualifiedName, String name, List<GlossaryTerm> terms) throws AtlanException {
        return (MetabaseQuestion)Asset.replaceTerms(MetabaseQuestion.updater(qualifiedName, name), terms);
    }

    public static MetabaseQuestion appendTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (MetabaseQuestion)Asset.appendTerms(TYPE_NAME, qualifiedName, terms);
    }

    public static MetabaseQuestion removeTerms(String qualifiedName, List<GlossaryTerm> terms) throws AtlanException {
        return (MetabaseQuestion)Asset.removeTerms(TYPE_NAME, qualifiedName, terms);
    }

    @Generated
    private static String $default$typeName() {
        return TYPE_NAME;
    }

    @Generated
    protected MetabaseQuestion(MetabaseQuestionBuilder<?, ?> b) {
        super((Metabase.MetabaseBuilder<?, ?>)b);
        this.typeName = b.typeName$set ? b.typeName$value : MetabaseQuestion.$default$typeName();
        this.metabaseDashboardCount = b.metabaseDashboardCount;
        this.metabaseQueryType = b.metabaseQueryType;
        this.metabaseQuery = b.metabaseQuery;
        SortedSet<MetabaseDashboard> metabaseDashboards = new TreeSet<MetabaseDashboard>();
        if (b.metabaseDashboards != null) {
            metabaseDashboards.addAll(b.metabaseDashboards);
        }
        metabaseDashboards = Collections.unmodifiableSortedSet(metabaseDashboards);
        this.metabaseDashboards = metabaseDashboards;
        this.metabaseCollection = b.metabaseCollection;
    }

    @Generated
    public static MetabaseQuestionBuilder<?, ?> builder() {
        return new MetabaseQuestionBuilderImpl();
    }

    @Generated
    public MetabaseQuestionBuilder<?, ?> toBuilder() {
        return new MetabaseQuestionBuilderImpl().$fillValuesFrom(this);
    }

    @Generated
    public Long getMetabaseDashboardCount() {
        return this.metabaseDashboardCount;
    }

    @Generated
    public String getMetabaseQueryType() {
        return this.metabaseQueryType;
    }

    @Generated
    public String getMetabaseQuery() {
        return this.metabaseQuery;
    }

    @Generated
    public SortedSet<MetabaseDashboard> getMetabaseDashboards() {
        return this.metabaseDashboards;
    }

    @Generated
    public MetabaseCollection getMetabaseCollection() {
        return this.metabaseCollection;
    }

    @Generated
    public void setMetabaseDashboardCount(Long metabaseDashboardCount) {
        this.metabaseDashboardCount = metabaseDashboardCount;
    }

    @Generated
    public void setMetabaseQueryType(String metabaseQueryType) {
        this.metabaseQueryType = metabaseQueryType;
    }

    @Generated
    public void setMetabaseQuery(String metabaseQuery) {
        this.metabaseQuery = metabaseQuery;
    }

    @Generated
    public void setMetabaseDashboards(SortedSet<MetabaseDashboard> metabaseDashboards) {
        this.metabaseDashboards = metabaseDashboards;
    }

    @Generated
    public void setMetabaseCollection(MetabaseCollection metabaseCollection) {
        this.metabaseCollection = metabaseCollection;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetabaseQuestion)) {
            return false;
        }
        MetabaseQuestion other = (MetabaseQuestion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Long this$metabaseDashboardCount = this.getMetabaseDashboardCount();
        Long other$metabaseDashboardCount = other.getMetabaseDashboardCount();
        if (this$metabaseDashboardCount == null ? other$metabaseDashboardCount != null : !((Object)this$metabaseDashboardCount).equals(other$metabaseDashboardCount)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$metabaseQueryType = this.getMetabaseQueryType();
        String other$metabaseQueryType = other.getMetabaseQueryType();
        if (this$metabaseQueryType == null ? other$metabaseQueryType != null : !this$metabaseQueryType.equals(other$metabaseQueryType)) {
            return false;
        }
        String this$metabaseQuery = this.getMetabaseQuery();
        String other$metabaseQuery = other.getMetabaseQuery();
        if (this$metabaseQuery == null ? other$metabaseQuery != null : !this$metabaseQuery.equals(other$metabaseQuery)) {
            return false;
        }
        SortedSet<MetabaseDashboard> this$metabaseDashboards = this.getMetabaseDashboards();
        SortedSet<MetabaseDashboard> other$metabaseDashboards = other.getMetabaseDashboards();
        if (this$metabaseDashboards == null ? other$metabaseDashboards != null : !this$metabaseDashboards.equals(other$metabaseDashboards)) {
            return false;
        }
        MetabaseCollection this$metabaseCollection = this.getMetabaseCollection();
        MetabaseCollection other$metabaseCollection = other.getMetabaseCollection();
        return !(this$metabaseCollection == null ? other$metabaseCollection != null : !((Object)this$metabaseCollection).equals(other$metabaseCollection));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MetabaseQuestion;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Long $metabaseDashboardCount = this.getMetabaseDashboardCount();
        result = result * 59 + ($metabaseDashboardCount == null ? 43 : ((Object)$metabaseDashboardCount).hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $metabaseQueryType = this.getMetabaseQueryType();
        result = result * 59 + ($metabaseQueryType == null ? 43 : $metabaseQueryType.hashCode());
        String $metabaseQuery = this.getMetabaseQuery();
        result = result * 59 + ($metabaseQuery == null ? 43 : $metabaseQuery.hashCode());
        SortedSet<MetabaseDashboard> $metabaseDashboards = this.getMetabaseDashboards();
        result = result * 59 + ($metabaseDashboards == null ? 43 : $metabaseDashboards.hashCode());
        MetabaseCollection $metabaseCollection = this.getMetabaseCollection();
        result = result * 59 + ($metabaseCollection == null ? 43 : ((Object)$metabaseCollection).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    private static final class MetabaseQuestionBuilderImpl
    extends MetabaseQuestionBuilder<MetabaseQuestion, MetabaseQuestionBuilderImpl> {
        @Generated
        private MetabaseQuestionBuilderImpl() {
        }

        @Override
        @Generated
        protected MetabaseQuestionBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public MetabaseQuestion build() {
            return new MetabaseQuestion(this);
        }
    }

    @Generated
    public static abstract class MetabaseQuestionBuilder<C extends MetabaseQuestion, B extends MetabaseQuestionBuilder<C, B>>
    extends Metabase.MetabaseBuilder<C, B> {
        @Generated
        private boolean typeName$set;
        @Generated
        private String typeName$value;
        @Generated
        private Long metabaseDashboardCount;
        @Generated
        private String metabaseQueryType;
        @Generated
        private String metabaseQuery;
        @Generated
        private ArrayList<MetabaseDashboard> metabaseDashboards;
        @Generated
        private MetabaseCollection metabaseCollection;

        @Override
        @Generated
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            MetabaseQuestionBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        @Generated
        private static void $fillValuesFromInstanceIntoBuilder(MetabaseQuestion instance, MetabaseQuestionBuilder<?, ?> b) {
            b.typeName(instance.typeName);
            b.metabaseDashboardCount(instance.metabaseDashboardCount);
            b.metabaseQueryType(instance.metabaseQueryType);
            b.metabaseQuery(instance.metabaseQuery);
            b.metabaseDashboards(instance.metabaseDashboards == null ? Collections.emptySortedSet() : instance.metabaseDashboards);
            b.metabaseCollection(instance.metabaseCollection);
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public B typeName(String typeName) {
            this.typeName$value = typeName;
            this.typeName$set = true;
            return (B)this.self();
        }

        @Generated
        public B metabaseDashboardCount(Long metabaseDashboardCount) {
            this.metabaseDashboardCount = metabaseDashboardCount;
            return (B)this.self();
        }

        @Generated
        public B metabaseQueryType(String metabaseQueryType) {
            this.metabaseQueryType = metabaseQueryType;
            return (B)this.self();
        }

        @Generated
        public B metabaseQuery(String metabaseQuery) {
            this.metabaseQuery = metabaseQuery;
            return (B)this.self();
        }

        @Generated
        public B metabaseDashboard(MetabaseDashboard metabaseDashboard) {
            if (this.metabaseDashboards == null) {
                this.metabaseDashboards = new ArrayList();
            }
            this.metabaseDashboards.add(metabaseDashboard);
            return (B)this.self();
        }

        @Generated
        public B metabaseDashboards(Collection<? extends MetabaseDashboard> metabaseDashboards) {
            if (metabaseDashboards == null) {
                throw new NullPointerException("metabaseDashboards cannot be null");
            }
            if (this.metabaseDashboards == null) {
                this.metabaseDashboards = new ArrayList();
            }
            this.metabaseDashboards.addAll(metabaseDashboards);
            return (B)this.self();
        }

        @Generated
        public B clearMetabaseDashboards() {
            if (this.metabaseDashboards != null) {
                this.metabaseDashboards.clear();
            }
            return (B)this.self();
        }

        @Generated
        public B metabaseCollection(MetabaseCollection metabaseCollection) {
            this.metabaseCollection = metabaseCollection;
            return (B)this.self();
        }

        @Override
        @Generated
        public String toString() {
            return "MetabaseQuestion.MetabaseQuestionBuilder(super=" + super.toString() + ", typeName$value=" + this.typeName$value + ", metabaseDashboardCount=" + this.metabaseDashboardCount + ", metabaseQueryType=" + this.metabaseQueryType + ", metabaseQuery=" + this.metabaseQuery + ", metabaseDashboards=" + this.metabaseDashboards + ", metabaseCollection=" + this.metabaseCollection + ")";
        }
    }
}

